procedure helpinit ;
var
   j   : byte ;
begin
   for j := 1 to 10 do hstr[j] := '' ;
end ;


procedure sethelp(n:byte) ;
begin
   helpinit ;
   case n of
      1 : begin    { line # }
                        {1234567890123456789012345678901234567890}
             hstr[1] := 'Enter the BBS line or "node" number that' ;
             hstr[2] := 'this configuration profile will be used' ;
             hstr[3] := 'for.  For example, if you are running a' ;
             hstr[4] := 'single-line system, this should be set' ;
             hstr[5] := 'to "1".  On multi-line systems, this' ;
             hstr[6] := 'should be set to the appropriate line or' ;
             hstr[7] := 'node number being used with this' ;
             hstr[8] := 'profile.' ;
          end ;
      2 : begin    { bbs name }
             hstr[1] := 'Use this field to enter your BBS name.' ;
             hstr[2] := 'The name entered here should match the' ;
             hstr[3] := 'BBS name you write on your registration' ;
             hstr[4] := 'form.  This name is used for validating' ;
             hstr[5] := 'registration numbers and should be the' ;
             hstr[6] := 'same for each profile you create.' ;
          end ;
      3 : begin    { sysop name }
             hstr[1] := 'Use this field to enter your Sysop' ;
             hstr[2] := 'name.  The name entered here should' ;
             hstr[3] := 'match the Sysop name you write on your' ;
             hstr[4] := 'registration form.  This name is used' ;
             hstr[5] := 'for validating registration numbers and' ;
             hstr[6] := 'should be the same for each profile you' ;
             hstr[7] := 'create.' ;
          end ;
      4 : begin    { dropfile type }
             hstr[1] := 'Pressing the SPACEBAR on your keyboard' ;
             hstr[2] := 'toggles this setting between the two' ;
             hstr[3] := 'supported drop file types.  The two' ;
             hstr[4] := 'formats supported are the DOOR.SYS and' ;
             hstr[5] := 'DORINFOx.DEF drop files.  Press SPACEBAR' ;
             hstr[6] := 'to select the drop file your BBS or' ;
             hstr[7] := 'conversion program generates.' ;
          end ;
      5 : begin    { drop file path }
             hstr[1] := 'Enter the full path of the location' ;
             hstr[2] := 'where the door should find the drop file' ;
             hstr[3] := 'used for this configuration profile.' ;
             hstr[4] := 'For example, if you''re running Wildcat!' ;
             hstr[5] := 'multi-line, you might enter:' ;
             hstr[6] := '   ' ;
             hstr[7] := 'C:\WC30\WCWORK\NODE1\' ;
             hstr[8] := '   ' ;
             hstr[9] := 'A trailing backslash will be added to' ;
             hstr[10]:= 'the path, if necessary.' ;
          end ;
      6 : begin    { comm driver }
             hstr[1] := 'This product supports the use of an' ;
             hstr[2] := 'installed FOSSIL driver or its own,' ;
             hstr[3] := 'internal communications driver called' ;
             hstr[4] := 'an ASYNC ENGINE.  Press SPACEBAR to' ;
             hstr[5] := 'select the appropriate driver.' ;
             hstr[6] := '   ' ;
             hstr[7] := 'NOTE: The "Comm. Port Name", "Comm.' ;
             hstr[8] := 'Port Address", "IRQ Number" and "Locked' ;
             hstr[9] := 'Baud" fields may only be changed when' ;
             hstr[10]:= 'the ASYNC ENGINE driver is selected.' ;
          end ;
      7 : begin    { comm port name }
             hstr[1] := 'Use the SPACEBAR to toggle the name of' ;
             hstr[2] := 'the communications port to be used by' ;
             hstr[3] := 'this configuration profile.  Valid' ;
             hstr[4] := 'selections are COM1 through COM8.  When' ;
             hstr[5] := 'selecting COM1 through COM4, the default' ;
             hstr[6] := 'port address and IRQ number is assigned' ;
             hstr[7] := 'automatically but may still be edited.' ;
          end ;
      8 : begin    { comm port address }
             hstr[1] := 'This field is used to specify the base' ;
             hstr[2] := 'memory address of the communications' ;
             hstr[3] := 'port.  In most cases, the default base' ;
             hstr[4] := 'address is correct.  However, in cases' ;
             hstr[5] := 'where non-standard port assignments are' ;
             hstr[6] := 'used, a HEX port address may be entered.' ;
             hstr[7] := 'When entering an address, DO NOT proceed' ;
             hstr[8] := 'it with a "$" character.  For example,' ;
             hstr[9] := 'entering a value of 03F8 for COM1' ;
             hstr[10]:= 'specifies a base address of 03F8h.' ;
          end ;
      9 : begin    { IRQ number }
             hstr[1] := 'Enter the interrupt request line number' ;
             hstr[2] := 'in this field.  In most cases, the' ;
             hstr[3] := 'default assignments are correct.  In' ;
             hstr[4] := 'cases where non-standard port assign-' ;
             hstr[5] := 'ments are used, this setting may be' ;
             hstr[6] := 'edited.  Care should be taken to enter' ;
             hstr[7] := 'the correct IRQ number for successful' ;
             hstr[8] := 'program operation.' ;
          end ;
      10: begin    { Locked baud rate }
             hstr[1] := 'If your system uses a constant, or' ;
             hstr[2] := '"locked" baud rate from your computer' ;
             hstr[3] := 'to your modem, enter the baud rate here.' ;
             hstr[4] := 'If this field is set to a value other' ;
             hstr[5] := 'than 0, the door program will lock the' ;
             hstr[6] := 'baud rate at the rate specified.  When' ;
             hstr[7] := 'set to 0, the caller''s actual connect' ;
             hstr[8] := 'rate will be used.' ;
          end ;
      11: begin    { Registation # }
             hstr[1] := 'After registering this program, you will' ;
             hstr[2] := 'receive a registration key number used' ;
             hstr[3] := 'to acknowledge your registration.  Enter' ;
             hstr[4] := 'this number here.  It is important to' ;
             hstr[5] := 'note that the BBS and Sysop names must' ;
             hstr[6] := 'match those supplied on your registra-' ;
             hstr[7] := 'tion form in order for the key to' ;
             hstr[8] := 'function properly.' ;
          end ;
      12: begin    { Adopted by }
             hstr[1] := 'Use this field to enter the name of an' ;
             hstr[2] := 'individual who may have adopted' ;
             hstr[3] := '(registered) this door program for you.' ;
             hstr[4] := 'For example, if "Joe User" funded the' ;
             hstr[5] := 'program registration, you could enter' ;
             hstr[6] := '"Joe User" here and appropriate credit' ;
             hstr[7] := 'will be displayed each time the door' ;
             hstr[8] := 'program is loaded.' ;
          end ;
      13: begin    { Multiline operations }
             hstr[1] := 'Use this field to specify whether multi-' ;
             hstr[2] := 'line file sharing routines should be' ;
             hstr[3] := 'used during program operation.  Pressing' ;
             hstr[4] := 'SPACEBAR toggles this setting.' ;
             hstr[5] := '   ' ;
             hstr[6] := 'NOTE:  When set to MULTI-LINE, program' ;
             hstr[7] := 'execution may slow slightly due to' ;
             hstr[8] := 'increased program overhead.' ;
          end ;
      14: begin    { comm drive }
             hstr[1] := 'In multi-line configurations, a special' ;
             hstr[2] := 'semaphore file may be used to pass' ;
             hstr[3] := 'information between "nodes".  Ideally,' ;
             hstr[4] := 'this should be a RAM disk/directory for' ;
             hstr[5] := 'optimum performance.  The directory you' ;
             hstr[6] := 'specify here (if any) MUST exist or the' ;
             hstr[7] := 'program will not operate.  The default' ;
             hstr[8] := 'is to use the current directory.' ;
             hstr[9] := '   ' ;
             hstr[10]:= 'Example:  G:\TEMP\' ;
          end ;
      15: begin    { Text bulletin }
             hstr[1] := 'Each time the door program is executed,' ;
             hstr[2] := 'a top scores listing may be generated' ;
             hstr[3] := 'using the path and filename specified' ;
             hstr[4] := 'here.  For example, to create an ASCII' ;
             hstr[5] := 'text top scores listing called BULL6.BBS' ;
             hstr[6] := 'in the C:\WC30\BULLS directory, you' ;
             hstr[7] := 'would enter:' ;
             hstr[8] := '   ' ;
             hstr[9] := 'C:\WC30\BULLS\BULL6.BBS' ;
          end ;
      16: begin    { ANSI bulletin }
             hstr[1] := 'Each time the door program is executed,' ;
             hstr[2] := 'a top scores listing may be generated' ;
             hstr[3] := 'using the path and filename specified' ;
             hstr[4] := 'here.  For example, to create an ANSI' ;
             hstr[5] := 'color top scores file called BULL6.SCR' ;
             hstr[6] := 'in the C:\WC30\BULLS directory, you' ;
             hstr[7] := 'would enter:' ;
             hstr[8] := '   ' ;
             hstr[9] := 'C:\WC30\BULLS\BULL6.SCR' ;
          end ;
      17: begin    { GAME SETTINGS START HERE  - Snoop mode }
             hstr[1] := 'With this field you may specify whether' ;
             hstr[2] := 'or not "Snoop Mode" will be used.  While' ;
             hstr[3] := 'Snoop is enabled, all characters echoed' ;
             hstr[4] := 'to the modem are also echoed to the' ;
             hstr[5] := 'local console display.  When Snoop is' ;
             hstr[6] := 'disabled, only informational messages' ;
             hstr[7] := 'and errors are displayed on the local' ;
             hstr[8] := 'display.' ;
             hstr[9] := '   ' ;
             hstr[10]:= 'Pressing SPACEBAR toggles this setting.' ;
          end ;
      18: begin    { can players use handles? }
             hstr[1] := 'You can configure the game to allow' ;
             hstr[2] := 'players to select a handle or "alias"' ;
             hstr[3] := 'when entering the game as a new player.' ;
             hstr[4] := 'When set to NO, players are logged into' ;
             hstr[5] := 'the game using their current BBS log-on' ;
             hstr[6] := 'name.' ;
             hstr[7] := '   ' ;
             hstr[8] := 'Pressing SPACEBAR toggles this setting.' ;
          end ;
      19: begin    { games players may participate in }
             hstr[1] := 'Using this setting, you can define the' ;
             hstr[2] := 'total number of games that each player' ;
             hstr[3] := 'is allowed to participate in at any given' ;
             hstr[4] := 'time.  For example, a setting of 5' ;
             hstr[5] := 'specifies that each player may partici-' ;
             hstr[6] := 'pate in up to 5 games at any given time.' ;
             hstr[7] := '   ' ;
             hstr[8] := 'Valid entries are 1 to 10.' ;
          end ;
      20: begin    { games players may start }
             hstr[1] := 'This setting is used to define the number' ;
             hstr[2] := 'of new games each player may start during' ;
             hstr[3] := 'any "game duration" period.  For example,' ;
             hstr[4] := 'if the game duration setting (specified' ;
             hstr[5] := 'below) is set to 10 days, then this' ;
             hstr[6] := 'setting would be used to define the number' ;
             hstr[7] := 'of games each player could start every 10' ;
             hstr[8] := 'days.' ;
             hstr[9] := '   ' ;
             hstr[10]:= 'Valid entries are 1 to 10.' ;
          end ;
      21: begin    { turns per game per day }
             hstr[1] := 'This setting is used to define the' ;
             hstr[2] := 'number of turns a player may take' ;
             hstr[3] := 'per day, per game.  For example, when' ;
             hstr[4] := 'set to 10, players are allowed to take' ;
             hstr[5] := '10 turns per day in each game they are' ;
             hstr[6] := 'participating in.' ;
             hstr[7] := '   ' ;
             hstr[8] := 'Valid entries are 1 to 25.' ;
          end ;
      22: begin    { Game Duration }
             hstr[1] := 'This setting is used to define the' ;
             hstr[2] := 'number of days each game will last.' ;
             hstr[3] := 'For example, if set to 7, each game' ;
             hstr[4] := 'started by a player will last for 7' ;
             hstr[5] := 'days before being removed by the program' ;
             hstr[6] := 'Maintenance Agent.  When games are' ;
             hstr[7] := 'configured to require more than one' ;
             hstr[8] := 'player to commence play, games with less' ;
             hstr[9] := 'than this number will not be removed by' ;
             hstr[10]:= 'the Maintenance Agent.  (1 to 99 days.)' ;
          end ;
      23: begin    { player required to start }
             hstr[1] := 'With this setting, you can specify the' ;
             hstr[2] := 'number of players that are required to' ;
             hstr[3] := 'join a game before play commences.  For' ;
             hstr[4] := 'example, if set to 2, game play will not' ;
             hstr[5] := 'be permitted in any game before it has' ;
             hstr[6] := '2 players participating in it.' ;
             hstr[7] := '   ' ;
             hstr[8] := 'Valid entries are 1 to 8.' ;
          end ;
      24: begin    { max dart throws }
             hstr[1] := 'When players land on space number 26' ;
             hstr[2] := '(Al''s Bar), they may throw the number of' ;
             hstr[3] := 'of "bar darts" specified here.  Each' ;
             hstr[4] := 'throw of the dart adds to the player''s' ;
             hstr[5] := 'dart score for that game as well as the' ;
             hstr[6] := 'player''s cash on hand.' ;
             hstr[7] := '   ' ;
             hstr[8] := 'Valid entries are 1 to 10.' ;
          end ;
      25: begin
             hstr[1] := 'When players land on space number 22' ;
             hstr[2] := '(Casino), they may gamble the number' ;
             hstr[3] := 'of times specified here.  Each time' ;
             hstr[4] := 'a player gambles, an amount of the' ;
             hstr[5] := 'player''s cash on hand may be wagered' ;
             hstr[6] := 'against the toss of a coin at 2 to 1' ;
             hstr[7] := 'odds.' ;
             hstr[8] := '   ' ;
             hstr[9] := 'Valid entries are 1 to 10.' ;
          end ;
      26: begin
             hstr[1] := 'This field represents the purchase  ' ;
             hstr[2] := 'price for this property.  When this' ;
             hstr[3] := 'value is changed, all subsequent games' ;
             hstr[4] := 'started will be assigned the new value.' ;
             hstr[5] := '   ' ;
             hstr[6] := 'Valid entries are 1 to 9999.' ;
          end ;
      27: begin
             hstr[1] := 'This field represents the rental price' ;
             hstr[2] := 'for this property.  When this value is' ;
             hstr[3] := 'changed, all subsequent games started';
             hstr[4] := 'will be assigned the new value.' ;
             hstr[5] := '   ' ;
             hstr[6] := 'Valid entries are 1 to 9999.' ;
          end ;
      28: begin
             hstr[1] := 'Use this field to determine whether or' ;
             hstr[2] := 'not players may restrict access to games' ;
             hstr[3] := 'they start.  When set to YES, players' ;
             hstr[4] := 'are allowed to specify the number of' ;
             hstr[5] := 'players that may participate in the game.' ;
             hstr[6] := 'They may also password-protect the game' ;
             hstr[7] := 'in which case, other players will be' ;
             hstr[8] := 'required to enter the password in order' ;
             hstr[9] := 'to join the game.' ;
          end ;
      29: begin
             hstr[1] := 'This field specifies the number of days' ;
             hstr[2] := 'a player may be inactive (not enter the' ;
             hstr[3] := 'game) before being deleted during the' ;
             hstr[4] := 'maintenance routines.  Valid entries are' ;
             hstr[5] := '7 to 255 (default = 30).' ;
          end ;
      30: begin
             hstr[1] := 'Pressing SPACEBAR toggles this setting' ;
             hstr[2] := 'between YES and NO.  When set to YES,' ;
             hstr[3] := 'it is possible to enter a Dungeon when' ;
             hstr[4] := 'landing on Lookout Point.  When set to' ;
             hstr[5] := 'NO, this capability is disabled.' ;
          end ;
   end ; {case}
end ;


procedure showhelp(n:byte) ;
var
   j,howmany  : integer ;
   topy,boty  : integer ;
   c          : integer ;
   ch         : char ;
begin
   offcursor ;
   sethelp(n) ;
   howmany := 0 ;
   for j := 1 to 10 do begin
      if hstr[j] <> '' then inc(howmany) ;
   end ;
   topy := half(23 - howmany) ;
   boty := topy + (howmany+3) ;
   c := topy+1 ;
   GrowMkWin(18,topy,63,boty,15,1,6) ;
   writeat(22,topy,0,6,' Press any key to continue ') ;
   for j := 1 to howmany do begin
      writeat(21,c+j,15,1,hstr[j]);
   end ;
   ch := getkey ;
   RmWin ;
   oncursor ;
end ;




