json = require "scripts/avatar_json"
lzstring = require "scripts/avatar_lzstring"

vga_colours = {0, 4, 2, 6, 1, 5, 3, 7, 8, 12, 10, 14, 9, 13, 11, 15}

function is_disallowed(ch)
    if ch == "<" or ch == ">" or ch == ":" or ch == "\"" or ch == "/" or ch == "\\" or ch == "|" or ch == "?" or ch == "*" or ch == "'" or ch == "." or ch == "(" or ch == ")" or ch == "@" then
	return true
    end
    return false
end

function string:split(delimiter)
    local result = { }
    local from  = 1
    local delim_from, delim_to = string.find( self, delimiter, from  )
    while delim_from do
      table.insert( result, string.sub( self, from , delim_from-1 ) )
      from  = delim_to + 1
      delim_from, delim_to = string.find( self, delimiter, from  )
    end
    table.insert( result, string.sub( self, from  ) )
    return result
end

local function get_timezone()
    local now = os.time()
    return os.difftime(now, os.time(os.date("!*t", now)))
end

local function get_tzoffset(timezone)
    local h, m = math.modf(timezone / 3600)
    return string.format("%+.4d", 100 * h + 60 * m)
  end

function export_message(msgbase, bindata)
    local subject = bbs_get_bbs_name()
    local to = "SBBS User Avatars"
    local from = bbs_get_sysop_name()

    local msg = ""

    msg = msg .. "Timestamp: " .. os.date("%a %b %d %Y %H:%M:%S GMT") .. get_tzoffset(get_timezone()) .. "\n"
    msg = msg .. "json-begin\n"
    msg = msg .. "{\n"
    if bindata == "disabled" then
        msg = msg .. "\"disabled\": [\n"
    else   
        msg = msg .. "\"" .. lzstring.compressToBase64(bindata) .. "\": [\n"
    end
    msg = msg .. "  \"" .. bbs_get_username() .. "\"\n"
    msg = msg .. "  ]\n"
    msg = msg .. "}\n"
    msg = msg .. "json-end\n"

    bbs_post_message(msgbase, to, from, subject, msg)
end

function import_messages(msgbase)
    local msgbase_sanitized = ""

    for i = 1, #msgbase do
        local c = msgbase:sub(i,i)
        if c == '\\' or c == '/' then
            msgbase_sanitized = msgbase_sanitized .. '_'
        else
            msgbase_sanitized = msgbase_sanitized .. c
        end
    end

    local lastreadfile = bbs_get_data_path() .. "/avatar_" .. msgbase_sanitized .. "-lr.dat";
    local file = io.open(lastreadfile, "r");
    local lastread  = 0

    if (file ~= nil) then
        io.input(file);
        lastread = io.read("*n");
        io.close(file);
    end

    local nxt_msg = lastread + 1;

    while (nxt_msg ~= 0) do 
        local sender;
        local recipient;
        local subject;
        local msgtext;

        nxt_msg, recipient, sender, subject, msgtext = bbs_get_message(msgbase, nxt_msg);

        if (nxt_msg ~= 0) then
	        lastread = nxt_msg;
	        nxt_msg = nxt_msg + 1;
        end

        if (recipient == "SBBS User Avatars") then 
            local orig = bbs_get_message_detail(msgbase, lastread, "ORIGINADDR")
            if subject ~= bbs_get_bbs_name() then
                lines = msgtext:split("\r")
                local jsond = ""
                local begin = false

                for i = 1, #lines do
                    if lines[i] == "json-end" then
                        begin = false
                    end

                    if begin == true then
                        jsond = jsond .. lines[i]
                    end
                    
                    if lines[i] == "json-begin" then
                        begin = true
                    end
                end

                local status, jsonp = pcall(json.decode, jsond)

                if status == true then
                    for k, v in pairs(jsonp) do
                        if k ~= nil and v ~= nil then
                            if k ~= "disabled" then
                                local stat2, bdat = pcall(lzstring.decompressFromBase64, k)
                                if stat2 == true then
                                    local users = v

                                    for i = 1, #users do
                                        if users[i]:sub(1, 4) ~= "md5:" then
                                            local sanitized_username = ""

                                            for j = 1, #users[i] do
                                                if is_disallowed(users[i]:sub(j,j)) then
                                                    sanitized_username = sanitized_username .. '_'
                                                else
                                                    sanitized_username = sanitized_username .. users[i]:sub(j,j):lower()
                                                end
                                            end


                                            local newfilename = bbs_get_data_path() .. "/avatars/imported/"
                                            if orig ~= "" then
                                                if orig:sub(-2) == ".0" then
                                                    orig = orig:sub(1, #orig - 2)
                                                end
                                        
                                                local sanitized_orig = ""
                                                for j = 1, #orig do
                                                    local ch = orig:sub(j,j)
                                                    if is_disallowed(ch) then
                                                        sanitized_orig = sanitized_orig .. "_"
                                                    else
                                                        sanitized_orig = sanitized_orig .. ch
                                                    end
                                                end
                                                newfilename = newfilename .. sanitized_orig .. "." .. sanitized_username .. ".bin"
                                            else 
                                                newfilename = newfilename .. sanitized_username .. ".bin"
                                            end



                                            local file = io.open(newfilename, "wb")
                                            if file ~= nil then
                                                for i = 1, #bdat do
                                                    local c = bdat:sub(i,i)
                                                    file:write(c)
                                                end
                                                file:close()
                                            end
                                        end
                                    end
                                end
                            else
                                local users = v

                                for i = 1, #users do
                                    if users[i]:sub(1, 4) ~= "md5:" then
                                        local sanitized_username = ""

                                        for j = 1, #users[i] do
                                            if is_disallowed(users[i]:sub(j,j)) then
                                                sanitized_username = sanitized_username .. '_'
                                            else
                                                sanitized_username = sanitized_username .. users[i]:sub(j,j):lower()
                                            end
                                        end


                                        local newfilename = bbs_get_data_path() .. "/avatars/imported/" .. sanitized_username .. ".bin"
                                        os.remove(newfilename)
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end
    end

    file = io.open(lastreadfile, "w");
    io.output(file);
    io.write(lastread);
    io.close(file);
end

function convert_ansi_to_bin(ansidata, do_sauce)
    local bindata = {}
    local binat = 1
    local cur_colour = 7
    local cur_bgcolour = 0
    local cur_bold = 0
    local stage = 0
    local params = {}
    local param_at = 1
    local width = 0
    local height = 1
    for i = 1, #ansidata do
        local c = ansidata:sub(i,i)
        
        if c == '\027' and stage == 0 then
            stage = 1
        elseif stage == 0 and c ~= '\r' then
            if c ~= '\n' then
                bindata[binat] = string.byte(c)
                bindata[binat + 1] = cur_colour | (cur_bgcolour << 4)
                binat = binat + 2
                width = width + 1
            else
                for j = width, 9 do
                    bindata[binat] = string.byte(" ")
                    bindata[binat + 1] = cur_colour | (cur_bgcolour << 4)
                    binat = binat + 2
                end
                width = 10
            end
            if width == 10 then
                width = 0
                height = height + 1
            end
        elseif c == '[' and stage == 1 then
            stage = 2
            param_at = 0
        elseif stage == 1 then
            stage = 0
        elseif string.byte(c) >= 48 and string.byte(c) <= 57 and stage == 2 then
            if (param_at == 0) then 
                param_at = 1
                params[param_at] = 0
            end
            params[param_at] = params[param_at] * 10 + string.byte(c) - 48
        elseif c == ';' and stage == 2 then
            param_at = param_at + 1
            params[param_at] = 0
        elseif stage == 2 then
            stage = 3
        end

        if stage == 3 then
            if c == 'm' then
                for j = 1, param_at do
                    if params[j] == 0 then
                        cur_colour = 7
                        cur_bgcolour = 0
                        cur_bold = 0
                    elseif params[j] == 1 then
                        cur_bold = 1
                    elseif params[j] == 30 then
                        cur_colour = 0
                    elseif params[j] == 31 then
                        cur_colour = 4
                    elseif params[j] == 32 then
                        cur_colour = 2
                    elseif params[j] == 33 then
                        cur_colour = 6
                    elseif params[j] == 34 then
                        cur_colour = 1
                    elseif params[j] == 35 then
                        cur_colour = 5
                    elseif params[j] == 36 then
                        cur_colour = 3
                    elseif params[j] == 37 then
                        cur_colour = 7
                    elseif params[j] == 40 then
                        cur_bgcolour = 0
                    elseif params[j] == 41 then
                        cur_bgcolour = 4
                    elseif params[j] == 42 then
                        cur_bgcolour = 2
                    elseif params[j] == 43 then
                        cur_bgcolour = 6
                    elseif params[j] == 44 then
                        cur_bgcolour = 1
                    elseif params[j] == 45 then
                        cur_bgcolour = 5
                    elseif params[j] == 46 then
                        cur_bgcolour = 3
                    elseif params[j] == 47 then
                        cur_bgcolour = 7
                    end
                end
                if cur_bold == 1 then
                    cur_colour = cur_colour + 8
                end
            end
            param_at = 0
            stage = 0
        end
    end

    for i = height, 6 do
        for j = 1, 10 do
            bindata[binat] = string.byte(" ")
            bindata[binat + 1] = cur_colour | (cur_bgcolour << 4)
            binat = binat + 2
        end
    end
        

    if do_sauce == true then
        -- TODO: Add SAUCE
        bindata[binat] = 0x1a
        binat = binat + 1
        bindata[binat] = string.byte("S")
        binat = binat + 1
        bindata[binat] = string.byte("A")
        binat = binat + 1
        bindata[binat] = string.byte("U")
        binat = binat + 1
        bindata[binat] = string.byte("C")
        binat = binat + 1
        bindata[binat] = string.byte("E")
        binat = binat + 1
        bindata[binat] = string.byte("0")
        binat = binat + 1
        bindata[binat] = string.byte("0")

        for i = 1, 35 do
            binat = binat + 1
            bindata[binat] = string.byte(' ')
        end
        for i = 1, 20 do
            binat = binat + 1
            bindata[binat] = string.byte(' ')
        end
        for i = 1, 20 do
            binat = binat + 1
            bindata[binat] = string.byte(' ')
        end

        local date = os.date("%Y%m%d")

        for i = 1, 8 do
            binat = binat + 1
            bindata[binat] = string.byte(date:sub(i,i))
        end
        for i = 1, 4 do
            binat = binat + 1
            bindata[binat] = 0
        end
        binat = binat + 1
        bindata[binat] = 5

        binat = binat + 1
        bindata[binat] = 0x5

        -- TInfo1
        binat = binat + 1
        bindata[binat] = 0
        binat = binat + 1
        bindata[binat] = 0

        -- Tinfo2
        binat = binat + 1
        bindata[binat] = 0
        binat = binat + 1
        bindata[binat] = 0

        -- Tinfo3
        binat = binat + 1
        bindata[binat] = 0
        binat = binat + 1
        bindata[binat] = 0

        -- Tinfo4
        binat = binat + 1
        bindata[binat] = 0
        binat = binat + 1
        bindata[binat] = 0

        -- No of Comments
        binat = binat + 1
        bindata[binat] = 0

        -- Tflags
        binat = binat + 1
        bindata[binat] = 0
        
        -- TInfoS
        binat = binat + 1
        bindata[binat] = string.byte("I")
        binat = binat + 1
        bindata[binat] = string.byte("B")
        binat = binat + 1
        bindata[binat] = string.byte("M")
        binat = binat + 1
        bindata[binat] = string.byte(" ")
        binat = binat + 1
        bindata[binat] = string.byte("V")
        binat = binat + 1
        bindata[binat] = string.byte("G")
        binat = binat + 1
        bindata[binat] = string.byte("A")

        for i = 8, 22 do
            binat = binat + 1
            bindata[binat] = 0
        end

    end
    return bindata
end

function convert_bin_to_ansi(binary)
    local count = 1
    local last_colour = -1
    local last_bgcolour = 0
    local str = ""
    local width = 1
    for i = 1, 60 do
        local colour = binary[count + 1] & 0x0F
        local bgcolour = (binary[count + 1] & 0xF0) >> 4
        local character = binary[count]
        if (bgcolour > 7) then
            bgcolour = bgcolour - 8
        end        
        if last_colour ~= colour or last_bgcolour ~= bgcolour then
            if colour > 7 then
                str = str .. string.format("\027[1;3%d;4%dm%c", vga_colours[colour - 8 + 1], vga_colours[bgcolour + 1], character)
            else
                str = str .. string.format("\027[0;3%d;4%dm%c", vga_colours[colour + 1], vga_colours[bgcolour + 1], character)
            end

            last_colour = colour
            last_bgcolour = bgcolour
        else 
            str = str .. string.char(character)
        end

        if width == 10 then
            width = 1
            str = str .. "\n"
        else 
            width = width + 1
        end

        count = count + 2
    end

    return str
end

function load_avatar_offset(collection, offset) 
    local filename = bbs_get_data_path() .. "/avatars/" .. collection .. ".bin" 
    local file = io.open(filename, "rb")

    local value = ""

    if file ~= nil then
        local start = offset * 120
        if start > 0 then
            file:seek("set", start)
        end
        local bytes = {}

        for i = 1, 120 do
            local b = file:read(1)
            if b == nil or string.byte(b) == 0x1a then
                return ""
            end
            bytes[i] = string.byte(b)
        end
    
        file:close()
        value = convert_bin_to_ansi(bytes)
    end

    return value
end

function display_avatar_offset(avatar, y, x)
    local table = avatar:split("\n")
    y = y - 1
    for count = 1, 6 do
        if count <= #table then
            bbs_write_string(string.format("\027[%d;%dH%s", count + y, x, table[count]))
        end
    end
end

function get_external_avatar(msgfile, mid, from)
    local sanitized_username = ""
    local value = ""

    for j = 1, #from do
        if is_disallowed(from:sub(j,j)) then
            sanitized_username = sanitized_username .. '_'
        else
            sanitized_username = sanitized_username .. from:sub(j,j):lower()
        end
    end

    local newfilename = bbs_get_data_path() .. "/avatars/imported/"
    local orig = bbs_get_message_detail(msgfile, mid, "ORIGINADDR")
    if orig ~= "" then
        if orig:sub(-2) == ".0" then
            orig = orig:sub(1, #orig - 2)
        end
        local sanitized_orig = ""
        for j = 1, #orig do
            local ch = orig:sub(j,j)
            if is_disallowed(ch) then
                sanitized_orig = sanitized_orig .. "_"
            else
                sanitized_orig = sanitized_orig .. ch
            end
        end
        newfilename = newfilename .. sanitized_orig .. "." .. sanitized_username .. ".bin"
    else 
        newfilename = newfilename .. sanitized_username .. ".bin"
    end
    local file = io.open(newfilename, "rb")
    if file ~= nil then
        local bytes = {}

        for i = 1, 120 do
            local b = file:read(1)
            if b == nil or string.byte(b) == 0x1a then
                return ""
            end
            bytes[i] = string.byte(b)
        end
    
        file:close()
        value = convert_bin_to_ansi(bytes)
    else
        value = ""
    end
    return value       
end
