#include <stdio.h>
#if defined(WIN32) || defined(_MSC_VER)
#include <winsock2.h>
#define strcasecmp stricmp
#else
#include <termios.h>
#include <signal.h>
#include <unistd.h>
#endif
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include "MagiDoor.h"


#if defined(WIN32) || defined(_MSC_VER)
#define PATH_SEP '\\'
#else
#define PATH_SEP '/'
#endif


MDDoorControl_t mdcontrol;

#if defined(WIN32) || defined(_MSC_VER)
#else
struct termios ttysave;
#endif

time_t mdtimeout;
time_t mdtimeremaining;

static void md_cfg_read_line(char *buffer, int len, FILE *fptr) {
    fgets(buffer, len, fptr);
    if (buffer[strlen(buffer) - 1] == '\n') {
        buffer[strlen(buffer) - 1] = '\0';
    }
    if (buffer[strlen(buffer) - 1] == '\r') {
        buffer[strlen(buffer) - 1] = '\0';
    }    
}

int read_door32(const char *dropfile) {
    FILE *fptr;
    char buffer[256];
    char *ptr1;

    fptr = fopen(dropfile, "r");
    if (!fptr) {
        return -1;
    }

	md_cfg_read_line(buffer, 256, fptr); // com type
    md_cfg_read_line(buffer, 256, fptr); // socket handle
    mdcontrol.socket = strtol(buffer, NULL, 10);
    md_cfg_read_line(buffer, 256, fptr); // baud rate
    md_cfg_read_line(buffer, 256, fptr); // BBS ID
    md_cfg_read_line(buffer, 256, fptr); // User record pos (1 based)
    md_cfg_read_line(buffer, 256, fptr); // User's real name
    ptr1 = strrchr(buffer, ' ');
    if (ptr1 != NULL) {
        *ptr1 = '\0';
        ptr1++;
        strncpy(mdcontrol.user_firstname, buffer, 32);
        strncpy(mdcontrol.user_lastname, ptr1, 32);
    } else {
        strncpy(mdcontrol.user_firstname, buffer, 32);
        memset(mdcontrol.user_lastname, '\0', 32);
    }
    md_cfg_read_line(buffer, 256, fptr); // User's handle
    strncpy(mdcontrol.user_alias, buffer, 32);

    md_cfg_read_line(buffer, 256, fptr); // User's sec level
    mdcontrol.user_seclevel = strtol(buffer, NULL, 10);
 
    md_cfg_read_line(buffer, 256, fptr); // time left (minutes)
    mdcontrol.user_timeleft = strtol(buffer, NULL, 10) * 60;

    md_cfg_read_line(buffer, 256, fptr); // emulation
    md_cfg_read_line(buffer, 256, fptr); // node no
    
    mdcontrol.node = strtol(buffer, NULL, 10);

    return 0;
}

int read_doorsys(const char *dropfile) {
    FILE *fptr;
    char buffer[256];
    char *ptr1;

    fptr = fopen(dropfile, "r");
    if (!fptr) {
        return -1;
    }
    
    md_cfg_read_line(buffer, 256, fptr); // Comport
    md_cfg_read_line(buffer, 256, fptr); // Ebaud
    md_cfg_read_line(buffer, 256, fptr); // data bits
    md_cfg_read_line(buffer, 256, fptr); // node number
    mdcontrol.node = strtol(buffer, NULL, 10);

    md_cfg_read_line(buffer, 256, fptr); // Lbaud
    md_cfg_read_line(buffer, 256, fptr); // Screen Display
    md_cfg_read_line(buffer, 256, fptr); // Printer On
    md_cfg_read_line(buffer, 256, fptr); // Page Bell
    md_cfg_read_line(buffer, 256, fptr); // Caller alarm
    md_cfg_read_line(buffer, 256, fptr); // User Name
    ptr1 = strrchr(buffer, ' ');
    if (ptr1 != NULL) {
        *ptr1 = '\0';
        ptr1++;
        strncpy(mdcontrol.user_firstname, buffer, 32);
        strncpy(mdcontrol.user_lastname, ptr1, 32);
    } else {
        strncpy(mdcontrol.user_firstname, buffer, 32);
        memset(mdcontrol.user_lastname, '\0', 32);
    }
    md_cfg_read_line(buffer, 256, fptr); // Location
    strncpy(mdcontrol.user_location, buffer, 32);

    md_cfg_read_line(buffer, 256, fptr); // voice phone
    md_cfg_read_line(buffer, 256, fptr); // data phone
    md_cfg_read_line(buffer, 256, fptr); // password
    md_cfg_read_line(buffer, 256, fptr); // sec level
    mdcontrol.user_seclevel = strtol(buffer, NULL, 10);

    md_cfg_read_line(buffer, 256, fptr); // calls
    md_cfg_read_line(buffer, 256, fptr); // last login
    md_cfg_read_line(buffer, 256, fptr); // time left (seconds)
    mdcontrol.user_timeleft = strtol(buffer, NULL, 10);

    md_cfg_read_line(buffer, 256, fptr); // time left (minutes)
    md_cfg_read_line(buffer, 256, fptr); // graphics
    md_cfg_read_line(buffer, 256, fptr); // screen len
    md_cfg_read_line(buffer, 256, fptr); // usermode
    md_cfg_read_line(buffer, 256, fptr); // extra 1
    md_cfg_read_line(buffer, 256, fptr); // extra 2
    md_cfg_read_line(buffer, 256, fptr); // expiry date
    md_cfg_read_line(buffer, 256, fptr); // rec num
    md_cfg_read_line(buffer, 256, fptr); // protocol
    md_cfg_read_line(buffer, 256, fptr); // uploads
    md_cfg_read_line(buffer, 256, fptr); // downloads
    md_cfg_read_line(buffer, 256, fptr); // Lim down k
    md_cfg_read_line(buffer, 256, fptr); // Lim down k2
    md_cfg_read_line(buffer, 256, fptr); // DOB
    md_cfg_read_line(buffer, 256, fptr); // User Base
    md_cfg_read_line(buffer, 256, fptr); // Message Base
    md_cfg_read_line(buffer, 256, fptr); // Sysop Name
    strncpy(mdcontrol.sysop_name, buffer, 32);

    md_cfg_read_line(buffer, 256, fptr); // Handle
    strncpy(mdcontrol.user_alias, buffer, 32);

    md_cfg_read_line(buffer, 256, fptr); // Next Event
    md_cfg_read_line(buffer, 256, fptr); // Error Free
    md_cfg_read_line(buffer, 256, fptr); // Always N
    md_cfg_read_line(buffer, 256, fptr); // Always Y
    md_cfg_read_line(buffer, 256, fptr); // Def Colour
    md_cfg_read_line(buffer, 256, fptr); // Always 0
    md_cfg_read_line(buffer, 256, fptr); // Last Login 2
    md_cfg_read_line(buffer, 256, fptr); // Time Login
    md_cfg_read_line(buffer, 256, fptr); // Last Login Time
    md_cfg_read_line(buffer, 256, fptr); // Max Integer
    md_cfg_read_line(buffer, 256, fptr); // Downs today
    md_cfg_read_line(buffer, 256, fptr); // Upload K
    md_cfg_read_line(buffer, 256, fptr); // Download K
    md_cfg_read_line(buffer, 256, fptr); // Comment
    md_cfg_read_line(buffer, 256, fptr); // Always 0
    md_cfg_read_line(buffer, 256, fptr); // posted

    fclose(fptr);

    return 0;
}

#if !defined(WIN32) && !defined(_MSC_VER)

void md_sighuphandler(int i)
{
    md_exit(-1);
}

#endif


void md_exit(int exitcode) {
    if (mdcontrol.socket == -1) {
#if !defined(WIN32) && !defined(_MSC_VER)
         tcsetattr(STDIN_FILENO, TCSANOW, &ttysave);
#endif
    } else {
        // nothing
    }
    exit(exitcode);
}

void md_init(const char *dropfile, int socket) {
    char *filename = strrchr(dropfile, PATH_SEP);
#if !defined(WIN32) && !defined(_MSC_VER)
    struct termios ttystate;
    signal(SIGHUP, &md_sighuphandler);

#endif
    int ret = -1;

    mdcontrol.socket = socket;

    if (filename == NULL) {
        filename = (char *)dropfile;
    } else {
        filename++;
    }

    if (strcasecmp(filename, "door.sys") == 0) {
        ret = read_doorsys(dropfile);
    } else if (strcasecmp(filename, "door32.sys") == 0) {
        ret = read_door32(dropfile);
    } else {
        fprintf(stderr, "Unsupported dropfile: %s\n", filename);
        exit(-1);
    }

    if (ret == -1) {
        fprintf(stderr, "Unable to open dropfile: %s\n", dropfile);
        exit(-1);
    }

    if (mdcontrol.socket == -1) {
#if !defined(WIN32) && !defined(_MSC_VER)
        tcgetattr(STDIN_FILENO, &ttystate);
        ttysave = ttystate;

	    ttystate.c_lflag &= ~(ICANON | ISIG | IEXTEN | ECHO);
	    ttystate.c_iflag &= ~(BRKINT | ICRNL | IGNBRK | IGNCR | INLCR | INPCK | ISTRIP | IXON | PARMRK);
	    ttystate.c_oflag &= ~OPOST;
	    ttystate.c_cc[VMIN] = 1;
	    ttystate.c_cc[VTIME] = 0;

        tcsetattr(STDIN_FILENO, TCSANOW, &ttystate);
#endif
    } else {
#if defined(WIN32) || defined(_MSC_VER)
        WSADATA wsa;

        WSAStartup(WINSOCK_VERSION, &wsa);
#endif        
    }
    mdtimeremaining = time(NULL) + mdcontrol.user_timeleft;
    mdtimeout = time(NULL) + 900;
    return;
}
