/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* timeslice.c - Give time slices to OS */

#ifdef __OS2__
#  define INCL_DOS
#  include <os2.h>
#elif defined (__NT__)
#  include <windows.h>
#elif defined (__linux__)
#  include <unistd.h>
#else
#  include <dos.h>
#endif

#include <string.h>
#include <time.h>

#include "os.h"
#include "output.h"
#include "modem.h"
#include "userbase.h"
#include "bbs_func.h"
#include "nodes.h"
#include "language.h"
#include "logfile.h"

time_t last_tim,last_min;
static int timer = 0;

int inactivity,told_inactivity;

#if !defined (__linux__) && !defined (__OS2__) && !defined (__NT__)

#define OS_MSDOS     0  /* MS-DOS */
#define OS_OS2       1  /* IBM OS/2 */
#define OS_WINDOWS   2  /* Microsoft Windows */
#define OS_DESQVIEW  3  /* Quarterdeck DESQview */
#define OS_DBLDOS    4  /* DoubleDOS */
#define OS_NETWARE   5  /* Novell Netware */

int opsys_id = OS_MSDOS;

int opsysDetect(void)
{
    union REGS regs;

    /* detect DESQview */
#ifdef __386__
    regs.w.ax = 0x2B01;
    regs.w.cx = 0x4445;
    regs.w.dx = 0x5351;
    int386(0x21, &regs, &regs);
#else
    regs.x.ax = 0x2B01;
    regs.x.cx = 0x4445;
    regs.x.dx = 0x5351;
    int86(0x21, &regs, &regs);
#endif
    if (regs.h.al != 0xFF)
    {
        opsys_id = OS_DESQVIEW;
        return opsys_id;
    }

    /* detect OS/2 */
    regs.h.ah = 0x30;
#ifdef __386__
    int386(0x21, &regs, &regs);
#else
    int86(0x21, &regs, &regs);
#endif
    if (regs.h.al >= 10)
    {
        opsys_id = OS_OS2;
        return opsys_id;
    }

    /* detect Windows */
#ifdef __386__
    regs.w.ax = 0x160A;
    int386(0x2F, &regs, &regs);
    if (regs.w.ax == 0)
    {
        opsys_id = OS_WINDOWS;
        return opsys_id;
    }
    if (regs.w.ax == 0)
#else
    regs.x.ax = 0x160A;
    int86(0x2F, &regs, &regs);
    if (regs.x.ax == 0)
#endif
    {
        opsys_id = OS_WINDOWS;
        return opsys_id;
    }

    /* must be MS-DOS */
    opsys_id = OS_MSDOS;
    return opsys_id;
}
#endif

void init_timer(void)
{
    last_tim = time(NULL);
    last_min = last_tim;
    timer = 1;
    inactivity = 0;
    told_inactivity = 0;
}

void give_timeslice(void)
{
    time_t _tim;

#ifdef __OS2__
    DosSleep(1);
#elif defined (__NT__)
    Sleep(1);
#elif defined (__linux__)
    //select();
#else
    union REGS regs;
    switch (opsys_id)
    {
        case OS_MSDOS:
            /*
#ifdef __386__
            int386(0x28, &regs, &regs);
#else
            int86(0x28, &regs, &regs);
#endif
            */
            break;

        case OS_OS2:
        case OS_WINDOWS:
#ifdef __386__
            regs.w.ax = 0x1680;
            int386(0x2F, &regs, &regs);
#else
            regs.x.ax = 0x1680;
            int86(0x2F, &regs, &regs);
#endif
            break;

        case OS_DESQVIEW:
#ifdef __386__
            regs.w.ax = 0x1000;
            int386(0x15, &regs, &regs);
#else
            regs.x.ax = 0x1000;
            int86(0x15, &regs, &regs);
#endif
            break;

        case OS_DBLDOS:
#ifdef __386__
            regs.w.ax = 0xEE01;
            int386(0x21, &regs, &regs);
#else
            regs.x.ax = 0xEE01;
            int86(0x21, &regs, &regs);
#endif
            break;

        case OS_NETWARE:
#ifdef __386__
            regs.w.bx = 0x000A;
            int386(0x7A, &regs, &regs);
#else
            regs.x.bx = 0x000A;
            int86(0x7A, &regs, &regs);
#endif
            break;
    }
#endif

    if (!timer) return; /* last_tim hasn't been set yet */

    _tim = time(NULL);
    if (_tim != last_tim)
    {
        /* (over) a second since last check */
        inactivity += _tim-last_tim;
        if (told_inactivity > 0 && inactivity-told_inactivity > 20)
        {
            write_log("Inactivity hangup");
            output(lang[LANG_INACTIVITY_NOW]);
            sleep(2);
            carrier = 0;
        }
        if (inactivity > 280 && told_inactivity == 0)
        {
            output(lang[LANG_INACTIVITY_SOON]);
            told_inactivity = inactivity;
        }

        if (_tim-last_min >= 60)
        {
            /* (over) a minute since last check */
            user.TodayMinutes += (_tim-last_min)/60;
            user.TotalMinutes += (_tim-last_min)/60;
            time_left -= (_tim-last_min)/60;
            if (time_left == 30) send_nodetext("\001""30 minutes time left",nodenum);
            if (time_left == 15) send_nodetext("\001""15 minutes time left",nodenum);
            if (time_left == 5) output("\r\n5 minutes time left\r\n");
            if (time_left == 2) output("\r\n2 minutes time left\r\n");
            if (time_left == 1) output("\r\n1 minute time left\r\n");
            if (time_left <= 0)
            {
                output(lang[LANG_TIMEOUT]);
                write_log("User time limit exceeded");
                sleep(2);
                carrier = 0;
            }
            last_min = _tim;
        }

        last_tim = _tim;
    }
}
