/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* showfile.c - Display file */

#include <stdio.h>
#include <string.h>

#include "config.h"
#include "files.h"
#include "logfile.h"
#include "output.h"
#include "language.h"

#define FILE_BUFFER_SIZE 512

void show_file(char *fname)
{
    char buffer[FILE_BUFFER_SIZE+1];
    int F;

    if (fname[0] == SLASH)
        F = FileOpen(fname, O_RDONLY | O_BINARY, SH_DENYNO);
    else
    {
        sprintf(buffer, "%s%s", user_lang.ansipath, fname);
        F = FileOpen(buffer, O_RDONLY | O_BINARY, SH_DENYNO);
    }

    if (F == -1)
    {
        output("\r\nFile not found.\r\n");
        write_log("File not found: '%s'", fname[0] == SLASH ? fname : buffer);
        return;
    }

    output("@MON@");
    while (_fgets(buffer, FILE_BUFFER_SIZE, F) != NULL)
    {
        output(buffer);
        if (!output("\r\n")) break;
    }
    output("@MOFF@");

    FileClose(F);
}
