/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* setup.c - Change settings */

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "os.h"
#include "output.h"
#include "ask_str.h"
#include "bbs_func.h"
#include "config.h"
#include "userbase.h"
#include "showfile.h"
#include "language.h"
#include "menutype.h"

unsigned char ask_key(char *text, char *file, char **parms)
{
    char str[2];

    str[0] = '\0'; if (!ask_string(text, str, 1, 0, parms)) return '\0';
    if (str[0] == '\0') return '\0';
    if (str[0] == '?')
    {
        show_file(file);
        str[0] = 1;
    }

    return str[0];
}

void edit_setup(char *data)
{
    char *strp, str[256], str2[80];
    int num;
    PROTO_REC *proto;
    LANG_REC *language;
    PACKER_REC *packer;

    strp = strchr(data, ' ');
    if (strp != NULL)
        *strp++ = '\0';
    else
        strp = parms;

    if (stricmp(data,"lines") == 0)
    {
        /* Number of lines on screen */
        sprintf(str, "%d", user.ScreenLen);
        do
        {
            if (!ask_string(lang[LANG_SCREEN_LENGTH], str, 3, 0, &strp)) return;
            if (str[0] == '\0') return;
        }
        while (sscanf(str, "%d", &num) != 1 || num < 10 || num > 99);
        user.ScreenLen = (unsigned char) num;
        if (wherey > user.ScreenLen) wherex = user.ScreenLen;
        return;
    }

    if (stricmp(data,"cols") == 0)
    {
        /* Number of chars per row */
        sprintf(str,"%d",user.ScreenWidth);
        do
        {
            if (!ask_string(lang[LANG_SCREEN_WIDTH], str, 3, 0, &strp)) return;
            if (str[0] == '\0') return;
        }
        while (str[0] == 1 || (sscanf(str,"%d",&num) != 1 && num >= 70 && num <= 200));
        user.ScreenWidth = (unsigned char) num;
        if (wherex > user.ScreenWidth) wherex = user.ScreenWidth;
        return;
    }

    if (stricmp(data,"alias") == 0)
    {
        /* Ask alias */
        if (!ask_string(lang[LANG_ASK_ALIAS], usrsub.alias, sizeof(usrsub.alias)-1, 0, &strp)) return;

        return;
    }

    if (stricmp(data,"protocol") == 0)
    {
        /* Protocol */
        proto = NULL;
        while (proto == NULL)
        {
            /* Ask protocol */
            str[0] = ask_key(lang[LANG_ASK_PROTOCOL], "protos.ans", &strp);
            if (str[0] == '\0') return;

            proto = firstproto;
            while (proto != NULL)
            {
                if (toupper(str[0]) == toupper(proto->key))
                {
                    memcpy(&user_proto, proto, sizeof(user_proto));
                    break;
                }
                proto = proto->next;
            }
        }

        user.Protocol = (char) toupper(str[0]);
        return;
    }

    if (stricmp(data, "vt100key") == 0)
    {
        /* VT100 keyboard */
        if (yes_no(lang[LANG_ASK_VTKEYB], 0, &strp))
            user.Attrib1 |= USER_ATTRIB_VT100_KEYB;
        else
            user.Attrib1 &= ~USER_ATTRIB_VT100_KEYB;
        return;
    }

    if (stricmp(data,"packer") == 0)
    {
        /* Packer */
        packer = NULL;
        while (packer == NULL)
        {
            str[0] = ask_key(lang[LANG_ASK_PACKER], "packers.ans", &strp);
            if (str[0] == '\0') return;

            packer = firstpacker;
            while (packer != NULL)
            {
                if (toupper(str[0]) == toupper(packer->key))
                {
                    memcpy(&user_packer, packer, sizeof(user_packer));
                    break;
                }
                packer = packer->next;
            }
        }

        user.Packer = (char) toupper(str[0]);
        return;
    }

    if (stricmp(data,"language") == 0)
    {
        /* Language */
        language = NULL;
        while (language == NULL)
        {
            str[0] = ask_key(lang[LANG_ASK_LANGUAGE], "langs.ans", &strp);
            if (str[0] == '\0') return;

            language = firstlang;
            while (language != NULL)
            {
                if (toupper(str[0]) == toupper(language->key))
                {
                    memcpy(&user_lang, language, sizeof(user_lang));
                    break;
                }
                language = language->next;
            }
        }

        close_language();
        read_language(language->fname);

        user.Language = (char) toupper(str[0]);
        return;
    }

    if (stricmp(data,"charset") == 0)
    {
        /* Charset */
        do
        {
            str[0] = ask_key(lang[LANG_ASK_CHARSET], "charset.ans", &strp);
            if (str[0] == '\0') return;
        }
        while (toupper(str[0]) != 'I' && toupper(str[0]) != 'L');

        user.CharSet = (char) toupper(str[0]);
        load_charset(user.CharSet);

        // n configgi fileeseen
        if (user.CharSet == 'I')
            strcpy(current_charset,"IBM-PC");
        else if (user.CharSet == 'L')
            strcpy(current_charset,"Latin-1");
        else current_charset[0] = '\0';
        return;
    }

    if (stricmp(data,"terminal") == 0)
    {
        /* Terminal emulation */
        do
        {
            str[0] = ask_key(lang[LANG_ASK_TERMEMU], "emul.ans", &strp);
            if (str[0] == '\0') return;
        }
        while (toupper(str[0]) != 'D' && toupper(str[0]) != 'A' && toupper(str[0]) != 'C');

        switch (toupper(str[0]))
        {
            case 'D':
                user.Emulation = USER_EMULATION_ANSI;
                break;
            case 'A':
                user.Emulation = USER_EMULATION_ANSI_X364;
                break;
            case 'C':
                user.Emulation = USER_EMULATION_ASCII;
                break;
        }
        if (user.Emulation == USER_EMULATION_ASCII)
            strcpy(current_emulation,"ASCII");
        else if (user.Emulation == USER_EMULATION_ANSI)
            strcpy(current_emulation,"Dummy-ANSI");
        else if (user.Emulation == USER_EMULATION_ANSI_X364)
            strcpy(current_emulation,"ANSI X3.64");
        else current_emulation[0] = '\0';
        return;
    }

    if (stricmp(data,"address") == 0)
    {
        /* Address information */

        /* Ask city */
        if (!ask_string(lang[LANG_ASK_CITY], usrsub.city, sizeof(usrsub.city)-1, 0, &strp)) return;

        output(lang[LANG_ASK_ADDR]);
        /* Ask home address */
        do
        {
            if (!ask_string(lang[LANG_ASK_ADDR_1], usrsub.address1, sizeof(usrsub.address1)-1, 0, &strp)) return;
        } while (usrsub.address1[0] == '\0');

        /* Ask 2nd line */
        if (!ask_string(lang[LANG_ASK_ADDR_2], usrsub.address2, sizeof(usrsub.address2)-1, 0, &strp)) return;

        if (usrsub.address2[0] != '\0')
            if (!ask_string(lang[LANG_ASK_ADDR_3], usrsub.address3, sizeof(usrsub.address3)-1, 0, &strp)) return;

        /* Ask voice phone number */
        do
        {
            if (!ask_string(lang[LANG_ASK_VOICE], usrsub.voice, sizeof(usrsub.voice)-1, 0, &strp)) return;
        } while (usrsub.voice[0] == '\0');

        if (*strp == '\0' && strp != parms) strp = parms;

        /* Ask data phone number */
        do
        {
            if (!ask_string(lang[LANG_ASK_DATA], usrsub.data, sizeof(usrsub.data)-1, 0, &strp)) return;
        } while (usrsub.data[0] == '\0');
    }

    if (stricmp(data,"password") == 0)
    {
        for (;;)
        {
            /* Ask password */
            str2[0] = '\0';
            do
            {
                if (!ask_string(lang[LANG_ASK_PASSWORD], str2, sizeof(usrsub.password)-1, '.', &strp)) return;
            } while (str2[0] == '\0');

            /* Ask password again */
            str[0] = '\0';
            do
            {
                if (!ask_string(lang[LANG_PW_AGAIN], str, sizeof(usrsub.password)-1, '.', &strp)) return;
            } while (str[0] == '\0');

            num = stricmp(str, str2);
            if (num == 0)
            {
                strcpy(usrsub.password, str);
                break;
            }

            output(lang[LANG_PWCHG_WRONG]);
        }
    }
}
