/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

#ifndef __MODEM_H
#define __MODEM_H

#ifdef __OS2__
#  include <os2.h>
#endif
#ifdef __NT__
typedef int HFILE;
#endif

#include "os.h"

#if defined (__linux__) || defined (__DOS__)
typedef int HFILE;
#endif

#if !defined (__DOS__) || defined  (__386__)
#  define REALLY_FAR
#else
#  define REALLY_FAR _far
#endif

extern HFILE hCom; /* Com port handle */
extern int carrier; /* Carrier from last check (set 1 to force quit) */
extern int real_carrier; /* Carrier from last check (don't touch!) */
extern char devname[MAX_NAME_LEN]; /* Device name */
extern int reqx, reqy; /* Response to esc[2n command */
extern unsigned char mdm_waiting;

#ifdef __OS2__
extern int block_thread; /* 1 = Disable COM threads for a while */
#endif

#ifdef __linux__
int tty_raw(void);
int tty_old(void);
#endif

#ifdef __DOS__
int init_modem(int com, unsigned long bpsrate);
#else
int init_modem(unsigned long handle, char *device); /* Initialize modem */
#endif
void deinit_modem(void);                /* Deinitialize modem */

int wait_modem(void);                   /* Wait for input max. 1 sec */

#ifdef __DOS__
int mdm_dataout(void REALLY_FAR *data, int size); /* Output data block to modem */
int mdm_dataout_nowait(void REALLY_FAR *data, int size); /* Output data - no wait */
int mdm_strout(char REALLY_FAR *data);  /* Output string to modem */
int mdm_datain(void REALLY_FAR *data, int size); /* Input data from modem */
#else
int mdm_dataout(void *data, int size);  /* Output data block to modem */
int mdm_dataout_nowait(void *data, int size); /* Output data - no wait */
int mdm_strout(char *data);             /* Output string to modem */
int mdm_datain(void *data, int size);  /* Input data from modem */
#endif
int mdm_chrout(char chr);               /* Output character to modem */

void flush_transmit(void);

int mdm_kbhit(void);                    /* Data available from modem */
int mdm_getch(void);                    /* Read & translate character from modem */
unsigned char mdm_charin(void);         /* Read character from modem */

void modem_setdtr(int dtr_on);          /* Set DTR ON/OFF */

int carr_det(void);                     /* Carrier */

#endif
