/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* mdm_os2.c - OS/2 modem handling */

#define COMM_RECEIVE_BUFFER_SIZE 16384
#define COMM_TRANSMIT_BUFFER_SIZE 16384

#define INCL_DOS
#define INCL_DOSDEVIOCTL
#define INCL_DOSPROCESS
#define INCL_DOSSEMAPHORES

#include <os2.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <process.h>

#include "os.h"
#include "modem.h"
#include "output.h"
#include "timeslic.h"
#include "userbase.h"

HFILE hCom;
char devname[MAX_NAME_LEN];
int real_carrier, carrier = 1;
int end_thread; /* 1 = lopeta threadi */
int block_thread; /* 1 = l anna threadin tehd mitn */

static HMTX r_mutex,t_mutex;

static char r_buf[COMM_RECEIVE_BUFFER_SIZE];
static int r_head,r_tail;

static char t_buf[COMM_TRANSMIT_BUFFER_SIZE];
static int t_head,t_tail;

static TID r_TID, t_TID;

VOID APIENTRY receive_thread (ULONG parm)
{
    ULONG BytesRead;
    char Char;

    while (!end_thread)
    {
        while (block_thread) DosSleep(1);
        DosRead(hCom,(PVOID) &Char,1,&BytesRead);
        if (BytesRead)
        {
            while (DosRequestMutexSem(r_mutex,SEM_INDEFINITE_WAIT) != 0) ;

            while (r_head+1 == r_tail || (r_head == COMM_RECEIVE_BUFFER_SIZE-1 && r_tail == 0))
            {
                /* Bufferi tynn */
                DosReleaseMutexSem(r_mutex);
                DosSleep(10);
                while (DosRequestMutexSem(r_mutex,SEM_INDEFINITE_WAIT) != 0) ;
            }

            r_buf[r_head++] = Char;
            if (r_head == COMM_RECEIVE_BUFFER_SIZE) r_head = 0;

            DosReleaseMutexSem(r_mutex);
        }
        else
        {
            DosSleep(1);
        }
    }

    parm = parm;
}

VOID APIENTRY transmit_thread (ULONG parm)
{
    ULONG BytesWritten;
    int num;

    while (!end_thread)
    {
        while (block_thread) DosSleep(1);
        if (t_head != t_tail)
        {
            while (DosRequestMutexSem(t_mutex,SEM_INDEFINITE_WAIT) != 0) ;

            num = t_head-t_tail;
            if (num < 0) num = COMM_TRANSMIT_BUFFER_SIZE-t_tail;
            DosWrite(hCom,t_buf+t_tail,num,&BytesWritten);

            t_tail += BytesWritten;
            if (t_tail >= COMM_TRANSMIT_BUFFER_SIZE)
                t_tail -= COMM_TRANSMIT_BUFFER_SIZE;

            DosReleaseMutexSem(t_mutex);
        }
        else
        {
            DosSleep(1);
        }
    }

    parm = parm;
}

int make_semaphore(char *name, HMTX *mutex)
{
    int tries;
    char str[256];

    tries = 10;
    while (tries > 0)
    {
        sprintf(str,"\\SEM32\\%s.%d.%lu", name, (int) hCom, time(NULL));
        if (DosCreateMutexSem(str,mutex,0,FALSE) == 0) return 1;
        tries--;
        DosSleep(500);
    }
    return 0;
}

/* Initialize modem */
int init_modem(unsigned long handle, char *device)
{
    DCBINFO iDcbinfo;
    ULONG ulPinout,ulDinout;

    strcpy(devname, device);
    if (handle == 0 && device[0] != '\0')
    {
        /* Open device */
        //hCom = DosOpen(device, O_RDWR);
        if (hCom == -1) return 0;
    }
    else
    {
        hCom = (HFILE) handle;
    }

    r_head = 0; r_tail = 0;
    t_head = 0; t_tail = 0;
    carrier = 1;
    real_carrier = 1;

    if (hCom == 0) return 1;

    /* Lue DCB infot */
    ulPinout = 0;
    ulDinout = sizeof(iDcbinfo);
    if (DosDevIOCtl(hCom,IOCTL_ASYNC,ASYNC_GETDCBINFO,NULL,0,
                    &ulPinout, &iDcbinfo, sizeof(iDcbinfo),&ulDinout) == 0)
    {
        /* Aseta odotusajat */
        iDcbinfo.fbTimeout = ~(MODE_NO_WRITE_TIMEOUT | MODE_NOWAIT_READ_TIMEOUT);
        iDcbinfo.fbTimeout = MODE_WAIT_READ_TIMEOUT;
        iDcbinfo.usWriteTimeout = 100; /* 1 sek */
        iDcbinfo.usReadTimeout = 100; /* 1 sek */

        /* Handshake */
        iDcbinfo.fbCtlHndShake |= MODE_DTR_CONTROL;

        /* CTS/RTS */
        iDcbinfo.fbCtlHndShake |= MODE_CTS_HANDSHAKE;
        iDcbinfo.fbFlowReplace |= MODE_RTS_HANDSHAKE;
        iDcbinfo.fbFlowReplace &= ~MODE_RTS_CONTROL;
        iDcbinfo.fbFlowReplace &= ~(MODE_AUTO_TRANSMIT | MODE_AUTO_RECEIVE);

        iDcbinfo.bErrorReplacementChar = 0;
        iDcbinfo.bBreakReplacementChar = 0;
        iDcbinfo.bXONChar = 0x11;
        iDcbinfo.bXOFFChar = 0x13;

        DosDevIOCtl(hCom,IOCTL_ASYNC,ASYNC_SETDCBINFO,&iDcbinfo,
                    sizeof(iDcbinfo),&ulPinout,NULL,0,&ulDinout);
    }

    if (!make_semaphore("bbs_receive",&r_mutex)) return 0;

    if (!make_semaphore("bbs_transmit",&t_mutex))
    {
        DosCloseMutexSem(r_mutex);
        return 0;
    }

    /* Threadi COM portin lukemiseen */
    end_thread = 0; block_thread = 0;
    if (DosCreateThread(&r_TID, receive_thread, 0, 0, 4096) != 0)
    {
        DosCloseMutexSem(r_mutex);
        DosCloseMutexSem(t_mutex);
        return 0;
    }

    /* Threadi COM portin kirjoittamiseen */
    if (DosCreateThread(&t_TID, transmit_thread, 0, 0, 4096) != 0)
    {
        end_thread = 1;
        DosCloseMutexSem(r_mutex);
        DosCloseMutexSem(t_mutex);
        return 0;
    }

    /* Threadien priorityt */
    DosSetPriority(2,3,1,r_TID);
    DosSetPriority(2,3,2,t_TID);

    modem_setdtr(1);

    return 1;
}

void deinit_modem(void)
{
    if (hCom == 0) return;

    end_thread = 1;
    DosCloseMutexSem(r_mutex);
    DosCloseMutexSem(t_mutex);
}

void modem_setdtr(int dtr_on)
{
    MODEMSTATUS ModemStat;
    UINT Data;

    if (hCom == 0) return;

    ModemStat.fbModemOn = dtr_on ? DTR_ON : 0;
    ModemStat.fbModemOff = dtr_on ? 255 : DTR_OFF;
    DosDevIOCtl (hCom, IOCTL_ASYNC, ASYNC_SETMODEMCTRL, &ModemStat,
                 sizeof (ModemStat), NULL, &Data, sizeof (Data), NULL);
}

int mdm_kbhit(void)
{
    if (hCom == 0) return 0;

    return r_head != r_tail;
}

int wait_modem(void)
{
    int num;

    if (hCom == 0) return 0;

    for (num = 0; num < 10; num++)
    {
        if (r_head != r_tail) return 1;
        usleep(100000);
    }

    return 0;
}

int mdm_datain(void *data, int size)
{
    char *buf = data;
    int readed;

    if (r_head == r_tail || hCom == 0) return 0;

    while (DosRequestMutexSem(r_mutex,SEM_INDEFINITE_WAIT) != 0) ;

    readed = 0;
    while (r_head != r_tail && readed < size)
    {
        *buf++ = r_buf[r_tail++];
        if (r_tail == COMM_RECEIVE_BUFFER_SIZE) r_tail = 0;
        readed++;
    }

    DosReleaseMutexSem(r_mutex);

    return readed;
}

unsigned char mdm_charin(void)
{
    unsigned char chr;

    if (mdm_waiting) return 1;
    if (r_head == r_tail || hCom == 0) return 0;

    while (DosRequestMutexSem(r_mutex,SEM_INDEFINITE_WAIT) != 0) ;

    chr = r_buf[r_tail++];
    if (r_tail == COMM_RECEIVE_BUFFER_SIZE) r_tail = 0;

    DosReleaseMutexSem(r_mutex);

    return chr;
}

int mdm_dataout(void *data, int size)
{
    char *cdata = data;
    unsigned written;

    if (hCom == 0) return 1;

    while (DosRequestMutexSem(t_mutex,SEM_INDEFINITE_WAIT) != 0) ;
    written = 0;
    while (written < size)
    {
        while (t_head+1 == t_tail || (t_head == COMM_TRANSMIT_BUFFER_SIZE-1 && t_tail == 0))
        {
            DosReleaseMutexSem(t_mutex);
            DosSleep(10);
            while (DosRequestMutexSem(t_mutex,SEM_INDEFINITE_WAIT) != 0) ;
        }
        t_buf[t_head++] = *cdata++;
        if (t_head == COMM_TRANSMIT_BUFFER_SIZE) t_head = 0;
        written++;
    }
    DosReleaseMutexSem(t_mutex);

    return 1;
}

int mdm_dataout_nowait(void *data, int size)
{
    char *cdata = data;
    unsigned written;

    if (hCom == 0) return 1;

    while (DosRequestMutexSem(t_mutex,SEM_INDEFINITE_WAIT) != 0) ;
    written = 0;
    while (written < size)
    {
        if (t_head+1 == t_tail || (t_head == COMM_TRANSMIT_BUFFER_SIZE-1 && t_tail == 0))
        {
            /* Buffer full */
            break;
        }
        t_buf[t_head++] = *cdata++;
        if (t_head == COMM_TRANSMIT_BUFFER_SIZE) t_head = 0;
        written++;
    }
    DosReleaseMutexSem(t_mutex);

    return 1;
}

void flush_transmit(void)
{
    if (hCom == 0) return;

    while (t_head != t_tail) DosSleep(1);
}

int mdm_strout(char *data)
{
    if (hCom == 0) return 1;

    return mdm_dataout(data,strlen(data));
}

int mdm_chrout(char chr)
{
    if (hCom == 0) return 1;

    return mdm_dataout(&chr,1);
}

int carr_det(void)
{
    BYTE instat;

    if (hCom == 0) return 1;

    if (!carrier) return 0;

    if (DosDevIOCtl (hCom, IOCTL_ASYNC, ASYNC_GETMODEMINPUT,
                     NULL, 0, NULL, &instat, sizeof(instat), NULL) != 0)
        return 0;

    real_carrier = carrier = (instat & DCD_ON) > 0;
    return carrier;
}
