/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* fsearch.c - Filebase handler for newfiles and file searching */

#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>

#include "os.h"
#include "files.h"
#include "ask_str.h"
#include "nodes.h"
#include "fareas.h"
#include "fsearch.h"
#include "output.h"
#include "userbase.h"
#include "filelist.h"
#include "bbs_func.h"
#include "logfile.h"
#include "config.h"
#include "language.h"

#define FDAT_BUF_SIZE 1024              /* FILES.BBS or DESCRIPT.ION read buffer size */

FILE_BUF *Fbase;                        /* Filebase file handle */
FILE_BUF *fs_Fdat;                      /* Filebase data text file handle */
FILEBASE_REC *baserec;                  /* Filebase record */
char *fb_fname;                         /* File name after record */

unsigned long fbase_pos;                /* Filebase's position */

static char *fdat_buf;                  /* fs_Fdat buffer */

/* Open filebase */
int open_filebase(char *file)
{
    char str[256];

    sprintf(str,"%s.idx",file);
    Fbase = FileBufOpen(str, O_RDWR | O_BINARY, SH_DENYNO);
    if (Fbase == NULL) return 0;

    sprintf(str,"%s.dat",file);
    fs_Fdat = FileBufOpen(str, O_RDONLY | O_BINARY, SH_DENYNO);
    if (fs_Fdat == NULL)
    {
        FileBufClose(Fbase);
        return 0;
    }

    fbase_pos = 0;

    return 1;
}

void close_filebase(void)
{
    FileBufClose(Fbase);
    FileBufClose(fs_Fdat);
}

static unsigned long fbase_record_pos;

/* Read record from filebase */
int read_filebase_record(unsigned long record)
{
    if (record == 0)
    {
        printf("read_filebase_record() : record == 0 ?? This should NEVER happen!\n");
        write_log("read_filebase_record() : record == 0 ?? This should NEVER happen!");
        return 0;
    }

    if (fbase_pos == record) return 1;

    if (record == 1 || fbase_pos == 0)
    {
        /* First record */
        fbase_pos = 1;
        FileBufSeek(Fbase, 0, SEEK_SET);
        if (FileBufRead(Fbase, (void **) &baserec, sizeof(FILEBASE_REC)+256) < (int) sizeof(FILEBASE_REC))
        {
            fbase_pos = 0;
            return 0;
        }
        fbase_record_pos = 0;
    }

    /* Find the right position */
    while (record < fbase_pos)
    {
        if (baserec->PrevRec == (unsigned long) -1) { fbase_pos = 0; return 0; }
        FileBufSeek(Fbase,baserec->PrevRec,SEEK_SET);
        fbase_record_pos = baserec->PrevRec;
        if (FileBufRead(Fbase, (void **) &baserec, sizeof(FILEBASE_REC)+256) < (int) sizeof(FILEBASE_REC))
        {
            fbase_pos = 0;
            fbase_record_pos = 0xffffffff;
            return 0;
        }
        fbase_pos--;
    }

    while (record > fbase_pos)
    {
        if ((baserec->NextRec == 0) && (fbase_pos > 0)) { fbase_pos = 0; return 0; }
        FileBufSeek(Fbase, baserec->NextRec, SEEK_SET);
        fbase_record_pos = baserec->NextRec;
        if (FileBufRead(Fbase, (void **) &baserec, sizeof(FILEBASE_REC)+256) < (int) sizeof(FILEBASE_REC))
        {
            fbase_pos = 0;
            fbase_record_pos = 0xffffffff;
            return 0;
        }
        fbase_pos++;
    }

    /* Read file name */
    fb_fname = ((char *) baserec)+sizeof(FILEBASE_REC);

    return 1;
}

/* Read record from filebase */
int increase_filebase_downs(char *fname)
{
    unsigned long num;

    num = 1;
    while (read_filebase_record(num) != 0)
    {
        if (stricmp(fb_fname,fname) == 0) { num = 0xffffffff; break; }
        num++;
    }
    if (num != 0xffffffff)
    {
        /* Not found */
        return 1;
    }

    baserec->Downloads++;

    /* Write record. */
    if (!FileLock(Fbase->handle))
    {
        write_log("increase_filebase_downs() : Can't lock file: %s"SSLASH"%s.idx", data_path, filebase_name);
        return 2;
    }
    FileBufSeek(Fbase, fbase_record_pos, SEEK_SET);
    FileBufWrite(Fbase, baserec, sizeof(FILEBASE_REC));
    FileUnlock(Fbase->handle);

    return 0;
}

/* Search file */
int search_file(char *searchname)
{
    char *strp,history[256],old_area[256],*desc,*data;
    unsigned long rec,fa_rec;
    int found,lines,num;
    struct tm *tmbuf;

    /* Update node file */
    noderec.doing = DOING_FILE_SEARCH;
    update_nodefile(0);

    output("\r\n");

    npos = 0;
    lines = 1;
    found = 0;
    old_area[0] = '\0';
    for (rec=1; read_filebase_record(rec) != 0; rec++)
    {
        /* Don't display private files */
        if (baserec->Flags & FBASE_FLAGS_PRIVATE && !in_group("sysop")) continue;

        strp = strrchr(fb_fname,SLASH);
        if (strp == NULL) continue;

        if (compare_filenames(strp+1,searchname) == 1)
        {
            strp = strrchr(fb_fname,SLASH);
            if (strp != NULL)
            {
                *strp = '\0';
                if (strcmp(old_area,fb_fname) != 0)
                {
                    fa_rec = search_path(fb_fname);
                    if (fa_rec == 0 || /* Path not found */
                        (farea.flags & FAREA_FLAG_READ_RIGHTS) == 0) /* No read rights */
                    {
                        *strp = SLASH;
                        continue;
                    }
                    strcpy(old_area,fb_fname);

                    output("\r\n");
                    lines++; if (check_more(&lines,-1,0) == 0) return 0;
                    output(lang[LANG_SEARCH_FAREA_NAME],get_history(fa_rec,history));
                    lines++; if (check_more(&lines,-1,0) == 0) return 0;
                    output(lang[LANG_SEARCH_FAREA_NAME2]);
                    lines++; if (check_more(&lines,-1,0) == 0) return 0;
                }
                *strp = SLASH;

                /* Display file header */
                tmbuf = localtime(&baserec->FileDate);
                frec.name = strp+1;
                frec.size = baserec->Size;
                frec.downs = baserec->Downloads;
                sprintf(frec.date,"%02d.%02d.%02d",
                        tmbuf->tm_mday,tmbuf->tm_mon+1,tmbuf->tm_year);
                strcpy(pos_fnames[npos], frec.name);
                positions[npos++] = lines;

                if (file_flagged(frec.name))
                    output("@X%c%c",lang[LANG_FILE_MORE_CONTROL][14],lang[LANG_FILE_MORE_CONTROL][15]);
                else
                    output("@X%c%c",lang[LANG_FILE_MORE_CONTROL][11],lang[LANG_FILE_MORE_CONTROL][12]);
                outtext(frec.name);
                output("@X%c%c", lang[LANG_FILE_MORE_CONTROL][17], lang[LANG_FILE_MORE_CONTROL][18]);

                if (strlen(strp+1) > 12)
                {
                    /* Long file name */
                    outtext("\r\n");
                    lines++;
                    if (check_more(&lines,-1,0) == 0) return 0;
                    output(lang[LANG_FILE_LIST_ENTRY]);
                }
                else
                {
                    for (num = strlen(frec.name); num < 13; num++) outchr(' ');
                    output(lang[LANG_FILE_LIST_ENTRY]);
                }

                /* Display file description */
                FileBufSeek(fs_Fdat,baserec->Ptr,SEEK_SET);
                FileBufRead(fs_Fdat,(void **) &data,8192);
                desc = data;
                strp = strstr(desc,"@_"); found = 0;
            __loop:
                num = disp_desc(&desc,strp,&lines,-1);
                if (!num) break;
                if (num == 2 && !found)
                {
                    outchr('\n'); lines++;
                    if (!check_more(&lines,-1,0)) break;
                }
                found = 1;
                if (desc != NULL && *desc != '\0')
                {
                    output(lang[LANG_DESCLINE_START]);
                    goto __loop;
                }
            }
        }
    }

    /* Update node file */
    noderec.doing = DOING_NOTHING;
    update_nodefile(0);

    if (!found)
    {
        /* No files found */
        output(lang[LANG_NO_FILES_FOUND]);
        return 0;
    }
    else if (lines > 1)
    {
        check_more(&lines,-1,1);
    }
    return 1;
}

int compare_description(char *text)
{
    /* No text? */
    if (baserec->Ptr == (unsigned long) -1) return 0;

    /* Read text to buffer */
    FileBufSeek(fs_Fdat,baserec->Ptr,SEEK_SET);
    FileBufRead(fs_Fdat,(void **) &fdat_buf,FDAT_BUF_SIZE);

    /* Compare */
    return stristr(fdat_buf,text) != NULL;
}

/* Keyword search */
int search_keyword(char *searchtext)
{
    char *strp,old_area[256],history[256],*desc,*data;
    unsigned long rec,fa_rec;
    int lines,found,num;
    struct tm *tmbuf;

    /* Update node file */
    noderec.doing = DOING_FILE_SEARCH;
    update_nodefile(0);

    output("\r\n");

    lines = 1; found = 0; old_area[0] = '\0'; npos = 0;
    for (rec=1; read_filebase_record(rec) != 0; rec++)
    {
        /* Don't display private files */
        if (baserec->Flags & FBASE_FLAGS_PRIVATE && !in_group("sysop")) continue;

        if (compare_description(searchtext) == 1)
        {
            strp = strrchr(fb_fname,SLASH);
            if (strp != NULL)
            {
                *strp = '\0';
                if (strcmp(old_area,fb_fname) != 0)
                {
                    fa_rec = search_path(fb_fname);
                    if (fa_rec == 0 || /* Path not found */
                        (farea.flags & FAREA_FLAG_READ_RIGHTS) == 0) /* No read rights */
                    {
                        *strp = SLASH;
                        continue;
                    }
                    strcpy(old_area,fb_fname);

                    output("\r\n");
                    lines++; if (check_more(&lines,-1,0) == 0) return 0;
                    output(lang[LANG_SEARCH_FAREA_NAME],get_history(fa_rec,history));
                    lines++; if (check_more(&lines,-1,0) == 0) return 0;
                    output(lang[LANG_SEARCH_FAREA_NAME2]);
                    lines++; if (check_more(&lines,-1,0) == 0) return 0;
                }
                *strp = SLASH;

                /* Display file header */
                tmbuf = localtime(&baserec->FileDate);
                frec.name = strp+1;
                frec.size = baserec->Size;
                frec.downs = baserec->Downloads;
                sprintf(frec.date,"%02d.%02d.%02d",
                        tmbuf->tm_mday,tmbuf->tm_mon+1,tmbuf->tm_year);
                strcpy(pos_fnames[npos], frec.name);
                positions[npos++] = lines;

                if (file_flagged(frec.name))
                    output("@X%c%c",lang[LANG_FILE_MORE_CONTROL][14],lang[LANG_FILE_MORE_CONTROL][15]);
                else
                    output("@X%c%c",lang[LANG_FILE_MORE_CONTROL][11],lang[LANG_FILE_MORE_CONTROL][12]);
                outtext(frec.name);
                output("@X%c%c", lang[LANG_FILE_MORE_CONTROL][17], lang[LANG_FILE_MORE_CONTROL][18]);

                if (strlen(strp+1) > 12)
                {
                    /* Long file name */
                    outtext("\r\n");
                    lines++;
                    if (check_more(&lines,-1,0) == 0) return 0;
                    output(lang[LANG_FILE_LIST_ENTRY_LONG]);
                }
                else
                {
                    for (num = strlen(frec.name); num < 13; num++) outchr(' ');
                    output(lang[LANG_FILE_LIST_ENTRY]);
                }

                /* Display file description */
                FileBufSeek(fs_Fdat,baserec->Ptr,SEEK_SET);
                FileBufRead(fs_Fdat,(void **) &data,8192);
                desc = data;
                strp = strstr(desc,"@_"); found = 0;
            __loop:
                num = disp_desc(&desc,strp,&lines,-1);
                if (!num) break;
                if (num == 2 && !found)
                {
                    outchr('\n'); lines++;
                    if (!check_more(&lines,-1,0)) break;
                }
                found = 1;
                if (desc != NULL && *desc != '\0')
                {
                    output(lang[LANG_DESCLINE_START]);
                    goto __loop;
                }
            }
        }
    }

    /* Update node file */
    noderec.doing = DOING_NOTHING;
    update_nodefile(0);

    if (!found)
    {
        /* No files found */
        output(lang[LANG_NO_FILES_FOUND]);
        return 0;
    }
    else if (lines > 1)
    {
        check_more(&lines,-1,1);
    }

    return 1;
}

/* Newfiles search */
int search_newfiles(time_t search_time)
{
    char *strp,history[256],old_area[256],*desc,*data;
    unsigned long rec,fa_rec;
    int found,lines,num;
    struct tm *tmbuf;

    /* Update node file */
    noderec.doing = DOING_NEWFILES;
    update_nodefile(0);

    output("\r\n");

    lines = 1; found = 0; old_area[0] = '\0'; npos = 0;
    for (rec=1; read_filebase_record(rec) != 0; rec++)
    {
        /* Don't display private files */
        if (baserec->Flags & FBASE_FLAGS_PRIVATE && !in_group("sysop")) continue;

        if (baserec->UlDate >= search_time || baserec->FileDate >= search_time)
        {
            strp = strrchr(fb_fname,SLASH);
            if (strp != NULL)
            {
                *strp = '\0';
                if (strcmp(old_area,fb_fname) != 0)
                {
                    fa_rec = search_path(fb_fname);
                    if (fa_rec == 0 || /* Path not found */
                        (farea.flags & FAREA_FLAG_READ_RIGHTS) == 0) /* No read rights */
                    {
                        *strp = SLASH;
                        continue;
                    }
                    strcpy(old_area,fb_fname);

                    output("\r\n");
                    lines++; if (check_more(&lines,-1,0) == 0) return 0;
                    output(lang[LANG_SEARCH_FAREA_NAME],get_history(fa_rec,history));
                    lines++; if (check_more(&lines,-1,0) == 0) return 0;
                    output(lang[LANG_SEARCH_FAREA_NAME2]);
                    lines++; if (check_more(&lines,-1,0) == 0) return 0;
                }
                *strp = SLASH;

                /* Display file header */
                tmbuf = localtime(&baserec->FileDate);
                frec.name = strp+1;
                frec.size = baserec->Size;
                frec.downs = baserec->Downloads;
                sprintf(frec.date,"%02d.%02d.%02d",
                        tmbuf->tm_mday,tmbuf->tm_mon+1,tmbuf->tm_year);
                strcpy(pos_fnames[npos], frec.name);
                positions[npos++] = lines;

                if (file_flagged(frec.name))
                    output("@X%c%c",lang[LANG_FILE_MORE_CONTROL][14],lang[LANG_FILE_MORE_CONTROL][15]);
                else
                    output("@X%c%c",lang[LANG_FILE_MORE_CONTROL][11],lang[LANG_FILE_MORE_CONTROL][12]);
                outtext(frec.name);
                output("@X%c%c", lang[LANG_FILE_MORE_CONTROL][17], lang[LANG_FILE_MORE_CONTROL][18]);

                if (strlen(strp+1) > 12)
                {
                    /* Long file name */
                    outtext("\r\n");
                    lines++;
                    if (check_more(&lines,-1,0) == 0) return 0;
                    output(lang[LANG_FILE_LIST_ENTRY_LONG]);
                }
                else
                {
                    for (num = strlen(frec.name); num < 13; num++) outchr(' ');
                    output(lang[LANG_FILE_LIST_ENTRY]);
                }

                /* Display file description */
                FileBufSeek(fs_Fdat,baserec->Ptr,SEEK_SET);
                FileBufRead(fs_Fdat,(void **) &data,8192);
                desc = data;
                strp = strstr(desc,"@_"); found = 0;
            __loop:
                num = disp_desc(&desc,strp,&lines,-1);
                if (!num) break;
                if (num == 2 && !found)
                {
                    outchr('\n'); lines++;
                    if (!check_more(&lines,-1,0)) break;
                }
                found = 1;
                if (desc != NULL && *desc != '\0')
                {
                    output(lang[LANG_DESCLINE_START]);
                    goto __loop;
                }
            }
        }
    }

    /* Update node file */
    noderec.doing = DOING_NOTHING;
    update_nodefile(0);

    if (!found)
    {
        /* No files found */
        output(lang[LANG_NO_FILES_FOUND]);
        return 0;
    }
    else if (lines > 1)
    {
        check_more(&lines,-1,1);
    }
    return 1;
}

void file_search(char *data)
{
    char str[256];

    str[0] = '\0'; if (!ask_string(lang[LANG_ASK_SEARCH_FILE], str, sizeof(str)-1, 0, &data)) return;
    if (str[0] == '\0') return;

    search_file(str);
}

void keyword_search(char *data)
{
    char str[256];

    str[0] = '\0'; if (!ask_string(lang[LANG_ASK_KEYSEARCH_FILE], str, sizeof(str)-1, 0, &data)) return;
    if (str[0] == '\0') return;

    strupr(str);
    search_keyword(str);
}

void newfiles_search(char *data)
{
    time_t _tim;
    struct tm *timp,tim;
    char str[20],*sp1,*sp2,*sp3;

    timp = localtime((time_t *) &user.LastFileChk);
    sprintf(str,"%02d.%02d.%02d",timp->tm_mday,timp->tm_mon+1,timp->tm_year);

    /* Ask time */
    _tim = 0;
    while (_tim == 0)
    {
        if (!ask_string(lang[LANG_ASK_SEARCH_NEW_FILES], str, 8, 0, &data)) return;
        if (str[0] == '\0') return;
        data[0] = '\0';

        /* Convert to time_t */
        memset(&tim,0,sizeof(tim));

        /* '.' -> ' ' */
        sp1 = strchr(str,'.');
        if (sp1 == NULL) continue;
        *sp1 = ' ';
        sp2 = strchr(str,'.');
        if (sp2 == NULL) { *sp1 = '.'; continue; }
        *sp2 = ' ';
        sp3 = strchr(str,'.');
        if (sp3 != NULL) { *sp1 = '.'; *sp2 = '.'; continue; }

        if (sscanf(str,"%d %d %d",&tim.tm_mday,&tim.tm_mon,&tim.tm_year) != 3)
        {
            *sp1 = '.'; *sp2 = '.'; *sp3 = '.';
            continue;
        }
        tim.tm_mon--;
        _tim = mktime(&tim);
    }

    search_newfiles(_tim);
    checked_newfiles = time(NULL);
}
