/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* download.c - Download files! */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#ifdef __linux__
#  include <signal.h>
#  include <sys/wait.h>
#endif

#include "os.h"
#include "memory.h"
#include "ask_str.h"
#include "bbs_func.h"
#include "logfile.h"
#include "download.h"
#include "lastcall.h"
#include "keyb.h"
#include "nodes.h"
#include "userbase.h"
#include "filelist.h"
#include "fsearch.h"
#include "timeslic.h"
#include "files.h"
#include "modem.h"
#include "output.h"
#include "fareas.h"
#include "config.h"
#include "language.h"
#include "setup.h"

#include "smodem.h"

#define DATA_BUF 8192

#ifdef __linux__
void execute_protocol(char *path, int usestd)
{
    char *arg[50],*strp;
    int pid,num;

    KbdDeInit();

    pid = fork();
    if (pid == -1)
    {
        output("\r\nCouldn't fork()! Out of memory??");
        write_log("execute_protocol() : Couldn't fork()! Out of memory??");
        KbdInit();
        return;
    }

    if (pid == 0)
    {
        /* Run protocol */
        arg[0] = path;
        num = 1;
        for (;;)
        {
            strp = strchr(arg[num-1],' ');
            if (strp == NULL) break;
            *strp = '\0';
            arg[num++] = strp+1;
        }
        arg[num] = NULL;
        if (usestd)
        {
            dup2(hCom, STDIN_FILENO);
            dup2(hCom, STDOUT_FILENO);
            dup2(hCom, STDERR_FILENO);
        }
        execvp(arg[0],&arg[0]);
    }

    while (waitpid(pid,NULL,WNOHANG) == 0)
    {
        if (!carr_det())
        {
            /* No carrier! */
            sleep(5);
            if (waitpid(pid,NULL,WNOHANG) == 0)
            {
                /* It can't kill itself, so we have to do the dirty job.. */
                kill(pid,SIGHUP);
            }
            break;
        }
        sleep(1);
        inactivity = 0; told_inactivity = 0; last_tim = last_min = time(NULL);
    }

    KbdInit();
}
#endif

unsigned process_dszlog(char *logfile)
{
    int F;
    char str[256],*strp;
    struct stat statbuf;
    unsigned old_farea;
    FLAG_REC *flagrec;
    PROTO_REC *proto;
    int files, incbase;

    /* Open DSZ log */
    F = FileOpen(logfile, O_RDONLY | O_BINARY, SH_DENYNO);
    if (F == -1) return 0;

    files = 0; incbase = 1;
    while (_fgets(str,sizeof(str),F) != NULL)
    {
        proto = firstproto;
        while (proto != NULL)
        {
            if (str[0] == proto->dlchar) break;
            proto = proto->next;
        }

        if (proto != NULL)
        {
            /* Strip off trailing spaces */
            strp = str+strlen(str);
            while (*(strp-1) == ' ' && strp > str) strp--;
            if (strp == str) continue;
            *strp = '\0';

            /* Search file name position */
            while (*strp != ' ' && strp > str) strp--;
            if (strp == str) continue;
            while (*strp == ' ' && strp > str) strp--;
            if (strp == str) continue;
            *(strp+1) = '\0';
            while (*strp != ' ' && strp > str) strp--;
            if (strp == str) continue;
            strp++;

            /* Found name, get size of it.. */
            if (stat(strp,&statbuf) != 0) statbuf.st_size = 0;

            /* Update file download counter */
            flagrec = flagged_record(strp);
            if (incbase) incbase = increase_filebase_downs(strp) != 2;
            if (flagrec != NULL)
            {
                old_farea = current_farea;
                if (read_farea_record(flagrec->farea) != 0)
                {
                    /* Path found, update counter.... */
                    add_dl_counter(flagrec->origname);
                }
                read_farea_record(old_farea);

                /* Remove it from flagged files */
                sprintf(str,"/tmp/%s",flagrec->fname);
                delete_file(str);
            }

            /* Update user statistics */
            user.DownloadBytes += statbuf.st_size;
            user.DownloadFiles++;
            user.TodayDownloadBytes += statbuf.st_size;
            user.TodayDownloadFiles++;
            files++;
        }
    }
    FileClose(F);

    /* Remove DSZ log */
    remove(logfile);

    return files;
}

int download_files(char *__parms)
{
    FILE *Flist;
    int Fdes;
    char parms[256],path[MAX_PATH_LEN],another[256],old_history[256], old_path[MAX_PATH_LEN];
    char *strp,*strp2,*parmsp,*data;
    unsigned long total_bytes;
    unsigned total_files,slen,cpsrate,ret;
    int retval;
    struct stat statbuf;
    FLAG_REC *flagrec;
    PROTO_REC *proto;

    /* Get protocol */
    retval = 0;
    while (retval < 2)
    {
        retval++;
        proto = firstproto;
        while (proto != NULL)
        {
            if (toupper(user.Protocol) == toupper(proto->key))
            {
                break;
            }
            proto = proto->next;
        }
        if (proto == NULL && retval == 1) edit_setup("protocol");
    }
    if (proto == NULL) return 0;

    strcpy(parms,__parms);
    if (hCom != 0)
    {
        sprintf(path,"%s"SSLASH"download.lst",hold_farea.path);
        Flist = fopen(path, "w+b");
        if (Flist == NULL)
        {
            parms[0] = '\0';
            return 0;
        }
    }
    else
    {
        Flist = NULL;
    }

    strcpy(old_history,farea_history);

    strp = strchr(parms,' ');
    if (strp != NULL) *strp = '\0';

    conv_macros(parms,path);
    strcpy(parms,path);

    parmsp = strrchr(parms,'/');
    if (parmsp == NULL)
    {
        parmsp = parms;
    }
    else
    {
        /* Path found from names */
        *parmsp = '\0';
        if (parmsp != parms)
        {
            select_farea(parms);
        }
        else
        {
            select_farea("/");
        }
        parmsp++;
    }

    if (select_farea(parmsp) == 1)
    {
        if (strp == NULL)
        {
            *parmsp = '\0';
        }
        else
        {
            parmsp = strp+1;
        }
    }

    if (*parmsp == '\0' && stricmp(farea_history,"/tmp") != 0)
    {
        output(lang[LANG_NO_FILES_SPECIFIED]);
        return 0;
    }

    total_files = 0;
    total_bytes = 0;
    output("\r\n");

    sprintf(path,"%s"SSLASH"descript.ion",farea.path);
    Fdes = FileOpen(path, O_RDONLY | O_BINARY, SH_DENYNO);
    if (Fdes == -1)
    {
        if (hCom != 0) fclose(Flist);
        parms[0] = '\0';
        if (old_history[0] != '\0') select_farea(old_history);
        return 0;
    }

    data = (char *) _malloc(DATA_BUF);
    if (data == NULL)
    {
        output("\r\nNot enough memory!\r\n");
        FileClose(Fdes);
        if (old_history[0] != '\0') select_farea(old_history);
        sprintf(path,"%s"SSLASH"download.lst",hold_farea.path);
        remove(path);
        parms[0] = '\0';
        return 0;
    }

    retval = 2;
    while (_fgets(data,DATA_BUF,Fdes) != NULL)
    {
        /* Get file name */
        strp = strchr(data,' ');
        if (strp == data || data[0] == '\0') continue;

        if (strp != NULL) *strp = '\0';

        /* This is a file name, add to list */
        if (strp != NULL) strp = strstr(strp+1,"@_LINK=");
        if (strp == NULL)
        {
            /* File name */
            sprintf(path,"%s"SSLASH"%s",farea.path,data);
        }
        else
        {
            /* Link to a file */
            strp2 = strchr(strp+7,'@');
            if (strp2 == NULL || *(strp2-1) != '_')
            {
                /* File name */
                sprintf(path,"%s"SSLASH"%s",farea.path,data);
            }
            else
            {
                *(strp2-1) = '\0';
                strcpy(path,strp+7);
            }
        }

        /* Get name without path */
        strp = strrchr(path,SLASH);
        if (strp == NULL) strp = path; else strp++;

#ifdef __FILES_CASE_SENSITIVE__
        if (stat(path, &statbuf) != 0)
            search_ign_file(path);
#endif

        if (stat(path,&statbuf) == 0)
        {
            /* Exists.. */
            if (*parmsp == '\0' || compare_filenames(strp,parmsp) == 1)
            {
                output(lang[LANG_DL_FOUND],data);
                write_log("Downloading file: %s",path);
                total_files++;
                total_bytes += statbuf.st_size;
                if (hCom != 0)
                {
                    flagrec = first_flag;
                    while (flagrec != NULL)
                    {
                        if (stricmp(flagrec->fname,data) == 0 && stricmp(flagrec->fname,flagrec->origname) != 0)
                        {
                            /* File has been renamed. */
                            sprintf(another,"%s"SSLASH"%s",hold_farea.path,flagrec->fname);
                            copyfile(path,another);
                            strcpy(path,another);
                            break;
                        }
                        flagrec = flagrec->next;
                    }
                    fprintf(Flist,"%s\r\n",path);
                }
                else
                {
                    strcpy(another,path);

                    path[0] = '\0';
                    if (!ask_string("\r\nCopy file to path: ", path, sizeof(path)-1, 0, NULL)) break;
                    if (path[0] == '\0')
                    {
                        /* Aborted. */
                        output("\r\nAborted!");
                        retval = 0;
                    }
                    else
                    {
                        slen = strlen(path);
                        if (path[slen-1] != SLASH)
                        {
                            path[slen] = SLASH;
                            path[slen+1] = '\0';
                        }
                        strcat(path,data);
                        if (copyfile(another,path) == 0)
                        {
                            output("\r\nFAILED!!!");
                            retval = 0;
                        }
                        else
                        {
                            current_lastrec.done_flags |= DONE_DOWNLOAD;
                            if (retval == 2) retval = 1;
                        }
                    }
                }
            }
        }
    }

    _free(data);
    FileClose(Fdes);

    if (old_history[0] != '\0') select_farea(old_history);

    if (hCom == 0)
    {
        sprintf(path,"%s"SSLASH"download.lst",hold_farea.path);
        remove(path);
        parms[0] = '\0';
        return retval;
    }

    fclose(Flist);

    if (total_files == 0)
    {
        output(lang[LANG_DL_NO_FILES_FOUND]);
        sprintf(path,"%s"SSLASH"download.lst",hold_farea.path);
        remove(path);
        parms[0] = '\0';
        return 0;
    }

    cpsrate = (unsigned) ((bpsrate/9)+(bpsrate/8-bpsrate/9)/2);
    num1 = total_files; num2 = total_bytes;
    num3 = total_bytes/cpsrate/60; num4 = (total_bytes/cpsrate)%60;
    output(lang[LANG_DL_TRANSFER]);

    if (total_bytes/cpsrate/60 > (unsigned) time_left)
    {
        /* Not enough time! */
        output(lang[LANG_DL_NOT_ENOUGH_TIME]);
        sprintf(path,"%s"SSLASH"download.lst",hold_farea.path);
        remove(path);
        parms[0] = '\0';
        return 0;
    }

    noderec.doing = DOING_DOWNLOAD;
    update_nodefile(0);

    old_path[0] = '\0';

    if (proto->bidir)
    {
        /* Create upload path if it doesn't exist */
        sprintf(path,"%s"SSLASH"upload",hold_farea.path);
        if (stat(path,&statbuf) != 0 && !mkpath(path))
        {
            output("Could not create upload path!\r\n");
            write_log("Could not create upload path '%s'",path);
            return 0;
        }
        getcwd(old_path, sizeof(old_path));
        change_dir(path);
    }

    /* Remove DSZ log */
    sprintf(path,"%s"SSLASH"dszlog",hold_farea.path);
    remove(path);

    if (carr_det())
    {
        output(lang[LANG_EXECUTING_PROTO]);
        if (proto->mode == PROTO_MODE_SMODEM)
        {
#ifdef BUILDIN_SMODEM
            write_log("Executing SModem");
            sprintf(path, "%s"SSLASH"dszlog", hold_farea.path);
            sprintf(another, "%s"SSLASH"download.lst", hold_farea.path);
            execute_smodem(path, another, bpsrate, 0);
#endif
        }
        else
        {
            conv_macros(proto->download, path);
            write_log("Executing %s: %s", proto->name, path);
            printf("Command line: '%s'\n", path);
            execute_protocol(path, proto->mode == PROTO_MODE_STDIO);
        }
        output("\r\n");
        usleep(300000);
        while (mdm_kbhit())
        {
            mdm_getch();
            usleep(100000);
        }
        inactivity = 0; told_inactivity = 0; last_tim = last_min = time(NULL);
    }

    /* Check uploaded files if bidirectional protocol used */
    if (proto->bidir)
    {
        change_dir(old_path);
        upload_files(0);
    }

    /* Remove files copied to hold */
    flagrec = first_flag;
    while (flagrec != NULL)
    {
        if (stricmp(flagrec->fname,flagrec->origname) != 0)
        {
            /* File has been renamed. */
            sprintf(path,"%s"SSLASH"%s",hold_farea.path,flagrec->fname);
            remove(path);
        }
        flagrec = flagrec->next;
    }

    /* Process DSZ log file */
    sprintf(path,"%s"SSLASH"dszlog", hold_farea.path);
    ret = process_dszlog(path);

    /* Display unsuccessfully transfered files */
    flagrec = first_flag;
    output("\r\n");
    while (flagrec != NULL)
    {
        if (compare_filenames(flagrec->fname, parmsp))
        {
            output(lang[LANG_TRANSFER_UNSUC], flagrec->fname);
            write_log("Transfer unsuccessful: %s", flagrec->fname);
        }
        flagrec = flagrec->next;
    }

    current_lastrec.done_flags |= DONE_DOWNLOAD;
    noderec.doing = DOING_NOTHING;
    update_nodefile(0);

    sprintf(path,"%s"SSLASH"download.lst",hold_farea.path);
    remove(path);
    parms[0] = '\0';

    return ret == total_files;
}
