/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* YAK configuration file */

#ifndef __CONFIG_H
#define __CONFIG_H

#define SOFTWARE_NAME "YAK"
#include "version.h"

#define QUOTE_MAX 7

#ifdef __linux__
#  define DEFAULT_CONFIG "/etc/yak.conf"
#else
#  define DEFAULT_CONFIG "yak.cfg"
#endif

extern char bbs_name[80];
extern char sysop_name[36];

/* For QWK packets */
extern char bbs_location[80];
extern char bbs_phone[80];
extern char first_sysop_name[80];

/* QWK/BW packet name */
extern char msg_packet_id[9];

/* Origin line */
extern char origin_line[80];

/* Tear lines */

/* Message written online */
extern char tear_line[80];
/* Blue Wave reply packet withouty told tear line */
extern char bw_tear[80];
/* QWK reply packet */
extern char qwk_tear[80];

/* Paths */
extern char shell[256];
extern char fareas_bbs[256];
extern char mareas_bbs[256];
extern char data_path[256];
extern char log_file[256];
extern char filebase_name[256];
extern char common_path[256];
extern char jam_base_file[256];
extern char concord_base[256];
extern char filemail_path[256];

typedef struct PACKER_REC
{
    struct PACKER_REC *next;

    char name[40];
    char id[30];
    char key;
    char *pack;
    char *unpack;
}
PACKER_REC;

#define PROTO_MODE_NORMAL 0 /* Normal protocol */
#define PROTO_MODE_STDIO  1 /* Protocol uses stdin and stdout */
#define PROTO_MODE_SMODEM 2 /* Build-in SModem */

typedef struct PROTO_REC
{
    struct PROTO_REC *next;

    int bidir;
    int efficiency;
    int mode;
    char name[40];
    char key;
    char *upload;
    char *download;
    char dlchar;
}
PROTO_REC;

typedef struct LANG_REC
{
    struct LANG_REC *next;

    char name[40];
    char key;
    char *fname;
    char *ansipath;
    char *menupath;
    char *mainmenu;
}
LANG_REC;

typedef struct NETADDR_REC
{
    struct NETADDR_REC *next;

    unsigned short zone, net, node, point;
}
NETADDR_REC;

typedef struct CHARSET_REC
{
    struct CHARSET_REC *next;

    char name[40];
    char key;
    char kludge[40];
    unsigned char intable[256];
    unsigned char outtable[256];
}
CHARSET_REC;

extern PACKER_REC *firstpacker;
extern PROTO_REC *firstproto;
extern LANG_REC *firstlang;
extern NETADDR_REC *firstnet;
extern CHARSET_REC *firstcharset;

extern PACKER_REC user_packer;
extern PROTO_REC user_proto;
extern LANG_REC user_lang;
extern CHARSET_REC user_charset;

extern char init_string[100];
extern char answer_string[100];
extern char ok_string[100];
extern char resp_ok[100];
extern char resp_ring[100];

extern int nodes;

/* See userbase.cpp for configuring time limits */

int read_config(char *fname);
void close_config(void);

#endif
