/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* ask_str.c - Ask string from user */

/* Todo: Command line history with up/down keys, delete, insert */

#include <stdio.h>
#include <string.h>

#include "keyb.h"
#include "modem.h"
#include "nodes.h"
#include "files.h"
#include "bbs_func.h"
#include "output.h"
#include "timeslic.h"
#include "userbase.h"
#include "logfile.h"
#include "config.h"
#include "menutype.h"

int ask_string(char *text, char *str, int len, char outchar, char **data)
{
    unsigned char ch;
    int quit, xpos, spos, hit, xstart, ystart, max, oldx;
    char nodefile[256];
    struct stat statrec;

    if (data != NULL && *data != NULL && **data != '\0' && **data != ';')
    {
        /* Take answer from parameters */
        take_data_param(nodefile, *data);
        if (nodefile[0] != '\n')
        {
            if (nodefile[0] != '\"')
                strcpy(str, nodefile);
            else
            {
                strcpy(str, nodefile+1); max = strlen(str)-1;
                if (max > 0 && str[max] == '"') str[max] = '\0';
            }
        }
        /* else ',' in command line, return default.. */
        if (*data == '\0' && *data != parms) *data = parms;
        return 2;
    }

    sprintf(nodefile,"%snodemsg.%d", common_path, nodenum);

    output(text);
    outtext(str);

    if (user.ScreenWidth < 70)
    {
        write_log("ask_str() : user.ScreenWidth < 70");
        user.ScreenWidth = 70;
    }
    if (user.ScreenLen < 10)
    {
        write_log("ask_str() : user.ScreenLen < 10");
        user.ScreenLen = 10;
    }

    quit = 0;
    xpos = spos = strlen(str); xstart = wherex; ystart = wherey;
    while (!quit)
    {
        /* Key pressed? */
        hit = mdm_kbhit();
        if (hit || kbhit())
        {
            /* Read character */
            ch = (unsigned char) (hit ? mdm_getch() : getch());

            switch (ch)
            {
                case 0:
                    ch = (unsigned char) (hit ? mdm_getch() : getch());
                    switch (ch)
                    {
                        case 'K':
                            /* Left */
                            if (xpos > 0 && outchar == 0)
                            {
                                xpos--;
                                if ((xstart+xpos-1)%(user.ScreenWidth-1) == user.ScreenWidth-2)
                                    output("@GOTO:%d,%d@", user.ScreenWidth-1, wherey-1);
                                else
                                    output("@LEFT@");
                            }
                            break;
                        case 'M':
                            /* Right */
                            if (xpos < spos && outchar == 0)
                            {
                                xpos++;
                                if ((xstart+xpos-1)%(user.ScreenWidth-1) == 0)
                                    outtext("\r\n");
                                else
                                    output("@RIGHT@");
                            }
                            break;
                        case 'G':
                            /* Home */
                            if (xpos != 0 && outchar == 0)
                            {
                                if (wherey == ystart)
                                    output("@LEFT:%d@", xpos);
                                else
                                    output("@GOTO:%d,%d@", xstart, ystart);
                                xpos = 0;
                            }
                            break;
                        case 'O':
                            /* End */
                            if (xpos != spos && outchar == 0)
                            {
                                if (spos+xstart <= user.ScreenWidth)
                                    output("@RIGHT:%d@", spos-xpos);
                                else
                                    output("@GOTO:%d,%d@", (spos+xstart)%(user.ScreenWidth-1), ystart+(spos+xstart)/(user.ScreenWidth-1));
                                xpos = spos;
                            }
                            break;
                        case 255:
                            /* After chat etc. redraw line */
                            output(text);
                            str[spos] = '\0'; outtext(str);
                            break;
                    }
                    break;
                case 8:
                    /* Backspace */
                    if (spos > 0)
                    {
                        output("\x08 \x08");
                        spos--; xpos--;
                    }
                    break;
                case 13:
                    /* Enter */
                    quit = 1;
                    break;
                case 26:
                    /* Ctrl-Z = abort line */
                    str[0] = 1;
                    spos = 1;
                    quit = 1;
                    break;
                case 27:
                    /* ESC */
                    break;
                default:
                    if (spos < len && ch >= 32)
                    {
                        memmove(str+xpos+1,str+xpos,spos-xpos+1);
                        str[xpos] = (char) ch;
                        if ((xstart+xpos-1)%(user.ScreenWidth-1) == 0)
                        {
                            if (wherey == user.ScreenLen) ystart--;
                            outtext("\r\n");
                        }
                        spos++; xpos++;
                        if (outchar == 0)
                        {
                            max = (xstart+xpos-1)/(user.ScreenWidth-1);
                            if (max != (xstart+spos-1)/(user.ScreenWidth-1))
                            {
                                max = user.ScreenWidth-xstart + max*(user.ScreenWidth-1);
                                oldx = xpos;
                                for (;;)
                                {
                                    if (max < spos)
                                    {
                                        ch = str[max];
                                        str[max] = '\0';
                                    }
                                    outtext(str+xpos-1);
                                    if (max < spos) str[max] = ch;

                                    xpos = max+1; max += user.ScreenWidth-1;
                                    if (max-(user.ScreenWidth-1) > spos) break;
                                    if (wherey == user.ScreenLen) ystart--;
                                    output("\r\n");
                                }
                                xpos = oldx;
                                output("@GOTO:%d,%d@", (xpos+xstart)%(user.ScreenWidth-1), ystart+(xpos+xstart)/(user.ScreenWidth-1));
                                break;
                            }
                            str[spos] = '\0'; outtext(str+xpos-1);
                            if (spos != xpos) output("@LEFT:%d@", spos-xpos);
                        }
                        else
                        {
                            outchr(outchar);
                        }
                    }
                    break;
            }
        }
        else
        {
            if (!carr_det()) return 0;

            if (stat(nodefile, &statrec) == 0 && statrec.st_size > 0)
            {
                /* Found node file! */
                if (display_nodefile(nodefile))
                {
                    /* Display line again */
                    output(text);
                    str[spos] = '\0'; outtext(str);
                    continue;
                }
            }
            give_timeslice();
        }
    }

    str[spos] = '\0';
    return 1;
}
