/*Copyright (C) 1998 Darren Braun
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *   Any comments or questions can be directed to darren@theboard.dyn.ml.org
 */

/*tbforum.c - File Directory Browser for theboard*/

#include<headers.h>
#include<tbforum.h>

extern struct tm *cur_time;
extern char graphmode;
extern int to_int_return;
extern struct user_dat user;
extern struct user_stat user2;
extern char temp_buf[4096];
extern time_t cur_rawtime;
extern time_t logon_time;
extern int orig_timeon;
extern char prompt_str[200][200];
extern int linenum;
extern int Node; 
extern struct tb_dat dat_main;
extern int dir_num, max_files;
extern char dir_file[80], file_list[20][80];
extern int time_limit[200];

key_t k_who;
key_t k_ask;
key_t k_yn;
key_t k_chat;
int qid_who;
int qid_ask;
int qid_yn;
int qid_chat;
int l_who;
int l_ask;
int l_yn;
int l_chat;
struct msg_yn s_yn;
struct msg_ask s_ask;
struct msg_who s_who;
struct msg_chat s_chat;

int chk_pl = 1, forum_num, total_ma, total_fa, total_ia;
char forum_name[80], forum_nameshort[80], forum_sysop[20], forum_intro[80], forum_file[80], forum_newscmd[80], forum_mesg[80], forum_news[80], forum_info[80], forum_user[80];
char msg_area[50][80], msg_names[50][80], file_area[50][80], file_names[50][80], info_names[20][80], info_files[20][80], forum_number[10];
struct stat cur_file;


int main(int ARGC, char *ARGV[])
{
   int end;
   time_t cur_time;
   k_yn = ftok(dat_main.root, 'a');
   k_ask = ftok(dat_main.root, 'b');
   k_who = ftok(dat_main.root, 'c');
   k_chat = ftok(dat_main.root, 'd');
   qid_yn = msgget(k_yn, 0);
   qid_ask = msgget(k_ask, 0);
   qid_who = msgget(k_who, 0);
   qid_chat = msgget(k_chat, 0);
   l_yn = (sizeof(s_yn) - sizeof(long));
   l_ask = (sizeof(s_ask) - sizeof(long));
   l_who = (sizeof(s_who) - sizeof(long));
   l_chat = (sizeof(s_chat) - sizeof(long));
   signal(SIGTERM,tbf_shutdown);
   signal(SIGHUP,tbf_shutdown);
   tbc_save_term();
   tbc_setup_term();
   /*Get working directory*/
   if(ARGC > 1){
      strcpy(forum_number, ARGV[1]);
      to_int(ARGV[1]);
      forum_num = to_int_return;
   }
   else{
      printf("TBForum Must be called with a forum number as a parameter\n");
      printf("%s", cnrm);
      tbc_reset_term();
      exit(1);
   }
   /*Read in variables*/
   read_vars();
   end = read_dirfile();
   if(end == -1){
      printf("Invalid Forum number\n");
      printf("%s", cnrm);
      tbc_reset_term();
      exit(1);
      
   }
   read_usetup();
   read_ustats();
   read_forum();
   /*Setup Time*/
   update_time();
   logon_time = cur_rawtime;
   end = get_daynum();
   if(end != user2.last_on){
      user2.last_on = end;
      user2.time_on = 0;
      orig_timeon = 0;
   }
   end = check_timeleft();
   if(end <= 0){
      disp_prompt(3);
      tbf_cleanup();
      return 0;
   }
   else{
      orig_timeon = user2.time_on;
   }

   /*Start file listing*/
   start_menu();
   /*Cleanup*/
   
   tbf_cleanup();
   return 0;
}

void tbf_shutdown(int sig){
   if(sig == SIGTERM || sig == SIGHUP){
      tbf_cleanup();
      exit(1);
   }
}


int tbf_cleanup(void){
   time_t cur_time;
   k_yn = ftok(dat_main.root, 'a');
   k_ask = ftok(dat_main.root, 'b');
   k_who = ftok(dat_main.root, 'c');
   k_chat = ftok(dat_main.root, 'd');
   qid_yn = msgget(k_yn, 0);
   qid_ask = msgget(k_ask, 0);
   qid_who = msgget(k_who, 0);
   qid_chat = msgget(k_chat, 0);
   l_yn = (sizeof(s_yn) - sizeof(long));
   l_ask = (sizeof(s_ask) - sizeof(long));
   l_who = (sizeof(s_who) - sizeof(long));
   l_chat = (sizeof(s_chat) - sizeof(long));
   s_ask.mtype = Node;
   s_ask.req = 6;
   strcpy(s_ask.name, user.login);
   strcpy(s_ask.activity, "Leaving Forum");
   msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
   write_ustats();
   printf("%s", cnrm);
   tbc_reset_term();
   return 0;
}


int start_menu(void){
   int quit = 0, quitb = 0, display = 1, display2 = 1, x = 17, y = 9, option = 1, timechk = 0, warned = 0, warned2 = 0;
   char temp, temp2[30], temp3[100], cmd_line[127];
   time_t cur_time;
   k_yn = ftok(dat_main.root, 'a');
   k_ask = ftok(dat_main.root, 'b');
   k_who = ftok(dat_main.root, 'c');
   k_chat = ftok(dat_main.root, 'd');
   qid_yn = msgget(k_yn, 0);
   qid_ask = msgget(k_ask, 0);
   qid_who = msgget(k_who, 0);
   qid_chat = msgget(k_chat, 0);
   l_yn = (sizeof(s_yn) - sizeof(long));
   l_ask = (sizeof(s_ask) - sizeof(long));
   l_who = (sizeof(s_who) - sizeof(long));
   l_chat = (sizeof(s_chat) - sizeof(long));
   s_ask.mtype = Node;
   s_ask.req = 6;
   strcpy(s_ask.name, user.login);
   strcpy(s_ask.activity, forum_name);
   msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
   scrcolor('3');
   strcpy(temp2, "File Areas");
   while(!quit){
      if(display){
	 box_3d(10,3,60,16,1,1);
	 box_3d(30,4,20,3,1,0);
	 box_3d(15,8,20,3,1,0);
	 box_3d(15,11,20,3,1,0);
	 box_3d(15,14,20,3,1,0);
	 box_3d(45,8,20,3,1,0);
	 box_3d(45,11,20,3,1,0);
	 box_3d(45,14,20,3,1,0);
	 putcolor(0,'F');
	 ansipos(32,5);printf("%.16s", forum_name);
	 ansipos(17,9);printf("File Areas");
	 ansipos(17,12);printf("Message Areas");
	 ansipos(17,15);printf("Area Selection");
	 ansipos(47,9);printf("Forum News");
	 ansipos(47,12);printf("Forum Bulletins");
	 ansipos(47,15);printf("Forum Settings");
	 ansipos(31,17);printf("Press 'Q' to quit");
	 display = 0;
      }
      if(display2){
	 ansipos(x,y);
	 putcolor('3','F');
	 printf("%s",temp2);
	 display2 = 0;
      }
      update_timeon();
      timechk = check_timeleft();
      if(timechk == 5 && warned == 0){
	 disp_prompt(7);
	 tbc_newline();
	 warned = 1;
      }
      else if(timechk == 1 && warned2 == 0){
	 disp_prompt(7);
	 tbc_newline();
	 warned2 = 1;
      }
      else if(!timechk){
	 disp_prompt(8);
	 tbc_newline();
	 return 0;
      }
      temp = tolower(getchar());
      if(temp != EOF){
	 linenum = 1;
	 if(temp == 'a'){
	    ansipos(x,y);
	    putcolor('1','F');
	    printf("%s",temp2);
	    if(option == 2){
	       option = 1;
	       x = 17;
	       y = 9;
	       strcpy(temp2, "File Areas");
	    }
	    else if(option == 3){
	       option = 2;
	       x = 17;
	       y = 12;
	       strcpy(temp2, "Message Areas");
	    }
	    else if(option == 5){
	       option = 4;
	       x = 47;
	       y = 9;
	       strcpy(temp2, "Forum News");
	    }
	    else if(option == 6){
	       option = 5;
	       x = 47;
	       y = 12;
	       strcpy(temp2, "Forum Bulletins");
	    }
	    
	    display2 = 1;
	 }
	 if(temp == 'b'){
	    ansipos(x,y);
	    putcolor('1','F');
	    printf("%s",temp2);
	    if(option == 1){
	       option = 2;
	       x = 17;
	       y = 12;
	       strcpy(temp2, "Message Areas");
	    }
	    else if(option == 2){
	       option = 3;
	       x = 17;
	       y = 15;
	       strcpy(temp2, "Area Selection");
	    }
	    else if(option == 4){
	       option = 5;
	       x = 47;
	       y = 12;
	       strcpy(temp2, "Forum Bulletins");
	    }
	    else if(option == 5){
	       option = 6;
	       x = 47;
	       y = 15;
	       strcpy(temp2, "Forum Settings");
	    }
	    display2 = 1;
	 }
	 if(temp == 'c'){
	    ansipos(x,y);
	    putcolor('1','F');
	    printf("%s",temp2);
	    if(option == 1){
	       option = 4;
	       x = 47;
	       y = 9;
	       strcpy(temp2, "Forum News");
	    }
	    else if(option == 2){
	       option = 5;
	       x = 47;
	       y = 12;
	       strcpy(temp2, "Forum Bulletins");
	    }
	    else if(option == 3){
	       option = 6;
	       x = 47;
	       y = 15;
	       strcpy(temp2, "Forum Settings");
	    }
	    display2 = 1;
	 }
	 if(temp == 'd'){
	    ansipos(x,y);
	    putcolor('1','F');
	    printf("%s",temp2);
	    if(option == 4){
	       option = 1;
	       x = 17;
	       y = 9;
	       strcpy(temp2, "File Areas");
	    }
	    else if(option == 5){
	       option = 2;
	       x = 17;
	       y = 12;
	       strcpy(temp2, "Message Areas");
	    }
	    else if(option == 6){
	       option = 3;
	       x = 17;
	       y = 15;
	       strcpy(temp2, "Area Selection");
	    }
	    display2 = 1;
	 }
	 else if(temp == '\n'){
	    if(option == 1){
	       strcpy(temp3, forum_name);
	       strcat(temp3, " - File Areas");
	       s_ask.mtype = Node;
	       s_ask.req = 6;
	       strcpy(s_ask.name, user.login);
	       strcpy(s_ask.activity, temp3);
	       msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
	       tbf_filea();
	       s_ask.mtype = Node;
	       s_ask.req = 6;
	       strcpy(s_ask.name, user.login);
	       strcpy(s_ask.activity, forum_name);
	       msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
	       display = 1;
	       display2 = 1;
	    }
	    else if(option == 2){
	       strcpy(temp3, forum_name);
	       strcat(temp3, " - Message Areas");
	       s_ask.mtype = Node;
	       s_ask.req = 6;
	       strcpy(s_ask.name, user.login);
	       strcpy(s_ask.activity, temp3);
	       msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
	       strcpy(cmd_line, forum_newscmd);
	       strcat(cmd_line, " -f ");
	       strcat(cmd_line, user.homedir);
	       strcat(cmd_line, ".tb/forums/");
	       strcat(cmd_line, forum_nameshort);
	       strcat(cmd_line, "/newsrc");
	       scrcolor('0');
	       fflush(stdout);
	       system(cmd_line);
	       s_ask.mtype = Node;
	       s_ask.req = 6;
	       strcpy(s_ask.name, user.login);
	       strcpy(s_ask.activity, forum_name);
	       msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
	       scrcolor('3');
	       display = 1;
	       display2 = 1;
	    }
	    else if(option == 3){
	       tbf_areasel();
	       scrcolor('3');
	       display = 1;
	       display2 = 1;
	    }
	    else if(option == 4){
	       scrcolor('3');
	       putcolor(0,'F');
	       tbf_dispfile(forum_news);
	       tbf_wait();
	       scrcolor('3');
	       display = 1;
	       display2 = 1;
	    }
	    else if(option == 5){
	       tbf_bulletins();
	       display = 1;
	       display2 = 1;
	    }
	 }
	 else if(temp == '*' && (!(strcmp(user.login, forum_sysop)))){
	    strcpy(cmd_line, dat_main.bin);
	    strcat(cmd_line, "/tbfedit ");
	    strcat(cmd_line, forum_number);
	    write_ustats();
	    system(cmd_line);
	    read_ustats();
	    tbc_setup_term();
	    scrcolor('3');
	    display = 1;
	    display2 = 1;
	 }
	 else if(temp == 'q'){
	    ansipos(x,y);
	    putcolor('1','F');
	    printf("%s",temp2);
	    box_3d(25,10,30,5,3,1);
	    putcolor(0,'F');
	    ansipos(27,11);printf("Are you sure you want to");
	    ansipos(27,12);printf("leave the %.15s?", forum_name);
	    ansipos(35,13);printf("(Y)es/(N)o");
	    if(tbc_getyn()){
	       quit = 1;
	       continue;
	    }
	    else{
	       display = 1;
	       display2 = 1;
	    }
	 }
      }
   }
      
      
   return 0;
}


int read_forum(void){
   FILE *fp_forum, *fp_file, *fp_mesg, *fp_info, *fp_check;
   int quit = 0, quitb = 0, quitc = 0, end = 0, a = 0, b = 0, c = 0, line = 0;
   char temp[80], temp2[80], temp3[80], node_name[80], node_str[4];
   strcpy(node_name,ttyname(1));
   switch(node_name[8]){
    case 'S':
      switch(node_name[9]){
       case '1':
	 Node = 1;
	 strcpy(node_str, "1");
	 break;
       case '2':
	 strcpy(node_str, "2");
	 Node = 2;
	 break;
       case '3':
	 strcpy(node_str, "3");
	 Node = 3;
	 break;
       default:
	 return -1;
	 break;
      }
      break;
    case '1':
      strcpy(node_str, "4");
      Node = 4;
      break;
    case '2':
      strcpy(node_str, "5");
      Node = 5;
      break;
    case '3':
      strcpy(node_str, "6");
      Node = 6;
      break;
    case '4':
      strcpy(node_str, "7");
      Node = 7;
      break;
    case '5':
      strcpy(node_str, "8");
      Node = 8;
      break;
    case '6':
      strcpy(node_str, "9");
      Node = 9;
      break;
    case '7':
      strcpy(node_str, "10");
      Node = 10;
      break;
    case '8':
      strcpy(node_str, "11");
      Node = 11;
      break;
    case 'p':
      switch(node_name[9]){
       case '0':
         strcpy(node_str, "12");
	 Node = 12;
	 break;
       case '1':
         strcpy(node_str, "13");
	 Node = 13;
	 break;
       case '2':
         strcpy(node_str, "14");
	 Node = 14;
	 break;
       default:
	 return -1;
	 break;
      }
      break;
    default:
      return -1;
      break;
   }
   strcpy(temp3, dat_main.dat);
   strcat(temp3, "/forums.dat");
   fp_forum = fopen(temp3, "r");
   tbc_readline(fp_forum,forum_num,2);
   fclose(fp_forum);
   fp_forum = fopen(temp_buf, "r");
   strcpy(forum_name, "Null Forum");
   c = 1;
   quit = 0;
   while(!quit){
      end = tbc_readline(fp_forum,c,2);
      if(end == -1){
	 quit = 1;
	 continue;
      }
      c++;
      if(temp_buf[0] == '['){
	 if(!(strcmp(temp_buf, "[MISC]"))){
	    tbc_readline(fp_forum,c,2);
	    strcpy(forum_name, temp_buf);
	    c++;
	    tbc_readline(fp_forum,c,2);
	    strcpy(forum_nameshort, temp_buf);
	    c++;
	    tbc_readline(fp_forum,c,2);
	    strcpy(forum_sysop, temp_buf);
	    c++;
	    tbc_readline(fp_forum,c,2);
	    strcpy(forum_intro, temp_buf);
	    c++;
	    tbc_readline(fp_forum,c,2);
	    strcpy(forum_newscmd, temp_buf);
	    c++;
	    
	 }
	 if(!(strcmp(temp_buf, "[FILES]"))){
	    tbc_readline(fp_forum,c,2);
	    strcpy(forum_file, temp_buf);
	    c++;
	    tbc_readline(fp_forum,c,2);
	    strcpy(forum_mesg, temp_buf);
	    c++;
	    tbc_readline(fp_forum,c,2);
	    strcpy(forum_news, temp_buf);
	    c++;
	    tbc_readline(fp_forum,c,2);
	    strcpy(forum_info, temp_buf);
	    c++;
	    tbc_readline(fp_forum,c,2);
	    strcpy(forum_user, temp_buf);
	    c++;
	 }
      }
   }
   fclose(fp_forum);
   /*Read Info File Listing*/
   quit = 0;
   quitb = 0;
   a = 1;
   fp_info = fopen(forum_info, "r");
   while(!quit){
      end = tbc_readline(fp_info,a,2);
      if(end == -1){
	 quit = 1;
	 total_ia = a - 2;
	 continue;
      }
      if(temp_buf[0] == '\0' || temp_buf[0] == '#' || temp_buf[0] == ' ' || temp_buf[0] == '\n' ){
	 a++;
	 continue;
      }
      quitb = 0;
      b = 0;
      c = 0;
      while(!quitb){
	 if(temp_buf[c] == ':'){
	    info_names[a - 1][b] = '\0'; 
	    quitb = 1;
	    c++;
	    continue;
	 }
	 else{
	    info_names[a - 1][b] = temp_buf[c];
	    b++;
	    c++;
	 }
	 if(b >=75){
	    info_names[a - 1][b] = '\0';
	    quitb = 1;
	    continue;
	 }
	 
      }
      quitb = 0;
      b = 0;
      while(!quitb){
	 if(temp_buf[c] == ':' || temp_buf[c] == '\0' || temp_buf[c] == '\n'){
	    info_files[a - 1][b] = '\0'; 
	    quitb = 1;
	    continue;
	 }
	 else{
	    info_files[a - 1][b] = temp_buf[c];
	    b++;
	    c++;
	 }
	 if(b >=75){
	    info_files[a - 1][b] = '\0'; 
	    quitb = 1;
	    continue;
	 }
	 
      }
      a++;
      
   }
   /*Read Dir File Listing*/
   quit = 0;
   quitb = 0;
   a = 1;
   fp_file = fopen(forum_file, "r");
   while(!quit){
      end = tbc_readline(fp_file,a,2);
      if(end == -1){
	 quit = 1;
	 total_fa = a - 2;
	 continue;
      }
      if(temp_buf[0] == '\0' || temp_buf[0] == '#' || temp_buf[0] == ' ' || temp_buf[0] == '\n' ){
	 a++;
	 continue;
      }
      quitb = 0;
      b = 0;
      c = 0;
      while(!quitb){
	 if(temp_buf[c] == ':'){
	    file_names[a - 1][b] = '\0'; 
	    quitb = 1;
	    c++;
	    continue;
	 }
	 else{
	    file_names[a - 1][b] = temp_buf[c];
	    b++;
	    c++;
	 }
	 if(b >=75){
	    file_names[a - 1][b] = '\0';
	    quitb = 1;
	    continue;
	 }
	 
      }
      quitb = 0;
      b = 0;
      while(!quitb){
	 if(temp_buf[c] == ':' || temp_buf[c] == '\0' || temp_buf[c] == '\n'){
	    file_area[a - 1][b] = '\0'; 
	    quitb = 1;
	    continue;
	 }
	 else{
	    file_area[a - 1][b] = temp_buf[c];
	    b++;
	    c++;
	 }
	 if(b >=75){
	    file_area[a - 1][b] = '\0'; 
	    quitb = 1;
	    continue;
	 }
	 
      }
      a++;
      
   }
   fclose(fp_info);
   strcpy(temp, user.homedir);
   strcat(temp, ".tb");
   mkdir(temp, 0777);
   strcat(temp, "/forums");
   mkdir(temp, 0777);
   strcat(temp, "/");
   strcat(temp, forum_nameshort);
   mkdir(temp, 0777);
   strcpy(temp2, temp);
   strcat(temp2, "/newsrc");
   strcpy(temp3, dat_main.root);
   strcat(temp3, "/forums/");
   strcat(temp3, forum_nameshort);
   strcat(temp3, "/newsrc.default");
   fp_check = fopen(temp2, "r");
   if(!fp_check){
      copy_file(temp2, temp3);
   }
   else{
      fclose(fp_check);
   }
   return 0;
}


int start_listing(int dir_num)
{
   int quit = 0, quitb = 0, quitc = 0, end, a, b, c, d, e, f, g, display1 = 1, display2 = 1, display3 = 1, display4 = 1,dirsec = 10, ispub = 1;
   int line = 4, cur_file = 1, cur_page = 1, page[500], file_ypos[100], file_filepos[100], end_of_list = 0;
   char temp, dirname[60], hd_dir[80], temp2[80], temp3[100], cmd_line[256];
   time_t cur_time;
   FILE *fp_dir;
   k_yn = ftok(dat_main.root, 'a');
   k_ask = ftok(dat_main.root, 'b');
   k_who = ftok(dat_main.root, 'c');
   k_chat = ftok(dat_main.root, 'd');
   qid_yn = msgget(k_yn, 0);
   qid_ask = msgget(k_ask, 0);
   qid_who = msgget(k_who, 0);
   qid_chat = msgget(k_chat, 0);
   l_yn = (sizeof(s_yn) - sizeof(long));
   l_ask = (sizeof(s_ask) - sizeof(long));
   l_who = (sizeof(s_who) - sizeof(long));
   l_chat = (sizeof(s_chat) - sizeof(long));
   strcpy(temp2, file_area[dir_num]);
   strcat(temp2, "/.index");
   strcpy(hd_dir, file_area[dir_num]);
   strcat(hd_dir, "/");
   strcpy(dirname, file_names[dir_num]);
   fp_dir = fopen(temp2,"r");
   if(!fp_dir){
      box_3d(25,10,30,5,3,1);
      putcolor(0,'F');
      ansipos(29,11);printf("There are no Files in");
      ansipos(29,12);printf("   this  directory");
      ansipos(29,13);printf("    <Hit any Key>");
      tbc_getyn();
      return 1;
   }
   /*
   tbc_readline(fp_dir,1,2);
   strcpy(dirname,temp_buf);
   tbc_readline(fp_dir,2,2);
   strcpy(hd_dir,temp_buf);
   tbc_readline(fp_dir,3,2);
   if(!(strcmp(temp_buf, "YES"))){
      ispub = 1;
   }
   else{
      ispub = 0;
   }
   tbc_readline(fp_dir,4,2);
   to_int(temp_buf);
   dirsec = to_int_return;*/
   quit = 0;
   d = 1;
   cur_page = 1;
   page[cur_page] = 1;
   d = page[cur_page];
   while(!quit){
      if(display1){
	 box_3d(1,1,79,3,1,1);
	 box_3d(1,user.pagelen - 4,79,4,1,1);
	 a = (80 - strlen(dirname))/2;
	 ansipos(a,2);
	 putcolor('1','F');
	 printf("%s",dirname);
	 display1 = 0;
	 display2 = 1;
	 display3 = 1;
      }
      if(display2){
	 line = 4;
	 quitb = 0;
	 b = 0;
	 max_files = 0;
	 end = tbc_readline(fp_dir,d,2);
	 if(end == -1 || temp_buf[0] == '\n' || temp_buf[0] == '\0'){
	    end_of_list = 1;
	    quitb = 1;
	 }
	 while(!quitb){
	    d++;
	    for(c = 0;c < strlen(temp_buf); c++){
	       temp_buf[c] = temp_buf[c+1];
	    }
	    temp_buf[c] = '\0';
	    strcpy(file_list[max_files],temp_buf);
	    max_files++;
	    file_ypos[max_files] = line;
	    file_filepos[max_files] = d - 1;
	    quitc = 0;
	    e = 1;
	    while(!quitc){
	       end = tbc_read_line(fp_dir);
	       if(end == -1 || temp_buf[0] == '\n' || temp_buf[0] == '\0'){
		  end_of_list = 1;
		  quitc = 1;
		  quitb = 1;
		  continue;
	       }
	       if(temp_buf[0] == ':'){
		  quitc = 1;
		  continue;
	       }
	       else{
		  ansipos(1,line);
		  putcolor('3','B');
		  if(e == 1){
		     printf("%-34.34s%-45.45s",file_list[max_files - 1],temp_buf);
		     if(strlen(temp_buf) > 45){
			g = 45;
			for(f = 45;f < strlen(temp_buf); f++){
			   if(g >= 45){
			      line++;
			      ansipos(1,line);
			      printf("%-34.34s"," ");
			      g = 0;
			   }
			   printf("%c", temp_buf[f]);
			   g++;
			}
		     }
		  }
		  else{
		     printf("%-34.34s%-45.45s"," ",temp_buf);
		     if(strlen(temp_buf) > 45){
			g = 45;
			for(f = 45;f < strlen(temp_buf); f++){
			   if(g >= 45){
			      line++;
			      ansipos(1,line);
			      printf("%-34.34s"," ");
			      g = 0;
			   }
			   printf("%c", temp_buf[f]);
			   g++;
			}
		     }
		  }
		  line++;
		  
		  d++;
	       }
	       if(line >= user.pagelen - 4){
		  quitc = 1;
		  quitb = 1;
		  continue;
	       }
	       
	       e++;
	    }
	 }
	 while(line + 1 <= user.pagelen - 4){
	    ansipos(1,line);
	    putcolor('3','B');
	    printf("%-80s"," ");
	    line++;
	 }
	 ansipos(5,2);
	 putcolor('1','F');
	 printf("Files: %d",max_files);
	 page[cur_page + 1] = file_filepos[max_files];
	 d = page[cur_page];
	 display2 = 0;
	 
      }
      if(display3){
	 ansipos(7,user.pagelen - 3);
	 disp_prompt(55);
	 display3 = 0;
      }
      if(display4){
	 ansipos(25,user.pagelen - 2);
	 putcolor('1','C');
	 printf("%-40s"," ");
	 putcolor('1','F');
	 ansipos(70,user.pagelen - 3);
	 display4 = 0;
      }
      temp = tolower(getchar());
      if(temp == EOF){
	 display4 = 1;
      }
      else if(temp == 'q'){
	 quit = 1;
	 continue;
      }
      else if(temp == 'n'){
	 if(!end_of_list){
	    display2 = 1;
	    cur_page++;
	    d = page[cur_page];
	 }
	 else{
	    ansipos(30,user.pagelen - 2);
	    putcolor('1','C');
	    printf("Bottom of Listing");
	    continue;
	 }
	 continue;
      }
      else if(temp == 'p'){
	 if(cur_page <= 1){
	    ansipos(30,user.pagelen - 2);
	    putcolor('1','C');
	    printf("Top of Listing");
	 }
	 else{
	    end_of_list = 0;
	    cur_page--;
	    d = page[cur_page];
	    display2 = 1;
	 }
	 continue;
      }
      else if(temp == 'd'){
	 quitb = 0;
	 display1 = 1;
	 display2 = 1;
	 cur_file = 1;
	 if(max_files <= 0){
	    ansipos(30,user.pagelen - 2);
	    putcolor('1','C');
	    printf("No Files in Directory");
	    return 1;
	 }
	 while(!quitb){
	    if(display1){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('7','E');
	       printf("%-20s",file_list[cur_file - 1]);
	       display1 = 0;
	    }
	    temp = tolower(getchar());
	    if(temp == EOF){
	       display2 = 1;
	    }
	    else if(temp == 'q'){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       quitb = 1;
	       continue;
	    }
	    else if(temp == 'a' && cur_file > 1){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       cur_file--;
	       display1 = 1;
	    }
	    else if(temp == 'b' && cur_file < max_files){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       cur_file++;
	       display1 = 1;
	    }
	    else if(temp == '\n'){
	       strcpy(temp3, forum_name);
	       strcat(temp3, " - Downloading");
	       s_ask.mtype = Node;
	       s_ask.req = 6;
	       strcpy(s_ask.name, user.login);
	       strcpy(s_ask.activity, temp3);
	       msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
	       strcpy(cmd_line, "sz ");
	       strcat(cmd_line, hd_dir);
	       strcat(cmd_line, "/");
	       strcat(cmd_line, file_list[cur_file - 1]);
	       system(cmd_line);
	       strcpy(temp3, forum_name);
	       strcat(temp3, " - File Area");
	       s_ask.mtype = Node;
	       s_ask.req = 6;
	       strcpy(s_ask.name, user.login);
	       strcpy(s_ask.activity, temp3);
	       msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
	       time(&cur_time);
	       strcpy(temp3, user.login);
	       strcat(temp3, " just downloaded ");
	       strcat(temp3, file_list[cur_file-1]);
	       strcat(temp3, " from the ");
	       strcat(temp3, forum_name);
	       strcat(temp3, " at ");
	       strcat(temp3, ctime(&cur_time));
	       temp3[strlen(temp3) - 1] = '\0';
	       log_message(temp3,21);
	       tbf_wait();
	       display1 = 1;
	       display2 = 1;
	       quitb = 1;
	       continue;
	    }
	 }
	 
	 continue;
      }
      
      else if(temp == 'i'){
	 quitb = 0;
	 display1 = 1;
	 display2 = 1;
	 cur_file = 1;
	 if(max_files <= 0){
	    ansipos(30,user.pagelen - 2);
	    putcolor('1','C');
	    printf("No Files in Directory");
	    return 1;
	 }
	 while(!quitb){
	    if(display1){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('7','E');
	       printf("%-20s",file_list[cur_file - 1]);
	       display1 = 0;
	    }
	    temp = tolower(getchar());
	    if(temp == EOF){
	       display2 = 1;
	    }
	    else if(temp == 'q'){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       quitb = 1;
	       continue;
	    }
	    else if(temp == 'a' && cur_file > 1){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       cur_file--;
	       display1 = 1;
	    }
	    else if(temp == 'b' && cur_file < max_files){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       cur_file++;
	       display1 = 1;
	    }
	    else if(temp == '\n'){
	       ansipos(30,user.pagelen - 2);
	       putcolor('1','C');
	       printf("Not Completed Yet");
	    }
	    
	 }
	 continue;
      }
      
      else if(temp == 'v'){
	 quitb = 0;
	 display1 = 1;
	 display2 = 1;
	 cur_file = 1;
	 if(max_files <= 0){
	    ansipos(30,user.pagelen - 2);
	    putcolor('1','C');
	    printf("No Files in Directory");
	    return 1;
	 }
	 while(!quitb){
	    if(display1){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('7','E');
	       printf("%-20s",file_list[cur_file - 1]);
	       display1 = 0;
	    }
	    temp = tolower(getchar());
	    if(temp == EOF){
	       display2 = 1;
	    }
	    else if(temp == 'q'){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       quitb = 1;
	       continue;
	    }
	    else if(temp == 'a' && cur_file > 1){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       cur_file--;
	       display1 = 1;
	    }
	    else if(temp == 'b' && cur_file < max_files){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       cur_file++;
	       display1 = 1;
	    }
	    else if(temp == '\n'){
	       ansipos(30,user.pagelen - 2);
	       putcolor('1','C');
	       printf("Not Completed Yet");
	    }
	    
	 }
	 display1 = 0;
	 display2 = 0;
	 continue;
      }
      
      else if(temp == 't'){
	 quitb = 0;
	 display1 = 1;
	 display2 = 1;
	 cur_file = 1;
	 if(max_files <= 0){
	    ansipos(30,user.pagelen - 2);
	    putcolor('1','C');
	    printf("No Files in Directory");
	    return 1;
	 }
	 while(!quitb){
	    if(display1){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('7','E');
	       printf("%-20s",file_list[cur_file - 1]);
	       display1 = 0;
	    }
	    temp = tolower(getchar());
	    if(temp == EOF){
	       display2 = 1;
	    }
	    else if(temp == 'q'){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       quitb = 1;
	       continue;
	    }
	    else if(temp == 'a' && cur_file > 1){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       cur_file--;
	       display1 = 1;
	    }
	    else if(temp == 'b' && cur_file < max_files){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       cur_file++;
	       display1 = 1;
	    }
	    else if(temp == '\n'){
	       ansipos(30,user.pagelen - 2);
	       putcolor('1','C');
	       printf("Not Completed Yet");
	    }
	    else if(temp == ' '){
	       ansipos(30,user.pagelen - 2);
	       putcolor('1','C');
	       printf("Not Completed Yet");
	    }
	    
	 }
	 display1 = 0;
	 display2 = 0;
	 continue;
      }
      else{
	 ansipos(30,user.pagelen - 2);
	 putcolor('1','C');
	 printf("Command Not Found");
	 continue;
      }
	 
      
   }
   
   fclose(fp_dir);
   return 0;
}

int tbf_bulletins(void){
   int quit = 0, quitb = 0, x = 15, y = 5, a = 0, b = 0, display = 1, display2 = 1, timechk = 0, warned = 0, warned2 = 0, option = 1;
   char temp, temp2[80];
   strcpy(temp2, info_names[0]);
   while(!quit){
      if(display){
	 box_3d(10,3,60,16,1,1);
	 putcolor(0,'F');
	 for(a = 0; a < total_ia;a++){
	    ansipos(12,5 + a);printf("%d  %s", a + 1, info_names[a]);
	 }
	 ansipos(31,17);printf("Press 'Q' to quit");
	 display = 0;
      }
      if(display2){
	 ansipos(x,y);
	 putcolor('3','F');
	 printf("%s",temp2);
	 display2 = 0;
      }
      temp = tolower(getchar());
      if(temp != EOF){
	 linenum = 1;
	 if(temp == 'a'){
	    ansipos(x,y);
	    putcolor('1','F');
	    printf("%s",temp2);
	    if(option > 1){
	       option = option - 1;
	       y = y - 1;
	       strcpy(temp2, info_names[option - 1]);
	    }
	    display2 = 1;
	 }
	 if(temp == 'b'){
	    ansipos(x,y);
	    putcolor('1','F');
	    printf("%s",temp2);
	    if(option < total_ia){
	       option = option + 1;
	       y = y + 1;
	       strcpy(temp2, info_names[option - 1]);
	    }
	    display2 = 1;
	 }
	 else if(temp == '\n'){
	    scrcolor('3');
	    putcolor(0,'F');
	    tbf_dispfile(info_files[option - 1]);
	    tbf_wait();
	    scrcolor('3');
	    display = 1;
	    display2 = 1;
	 }
	 else if(temp == 'q'){
	    quit = 1;
	 }
      }
   }
   
   
   return 0;
}


int tbf_filea(void){
   int quit = 0, quitb = 0, x = 15, y = 5, a = 0, b = 0, display = 1, display2 = 1, timechk = 0, warned = 0, warned2 = 0, option = 1;
   char temp, temp2[80];
   strcpy(temp2, file_names[0]);
   while(!quit){
      if(display){
	 box_3d(10,3,60,16,1,1);
	 putcolor(0,'F');
	 for(a = 0; a < total_fa;a++){
	    ansipos(12,5 + a);printf("%d  %s", a + 1, file_names[a]);
	 }
	 ansipos(31,17);printf("Press 'Q' to quit");
	 display = 0;
      }
      if(display2){
	 ansipos(x,y);
	 putcolor('3','F');
	 printf("%s",temp2);
	 display2 = 0;
      }
      temp = tolower(getchar());
      if(temp != EOF){
	 linenum = 1;
	 if(temp == 'a'){
	    ansipos(x,y);
	    putcolor('1','F');
	    printf("%s",temp2);
	    if(option > 1){
	       option = option - 1;
	       y = y - 1;
	       strcpy(temp2, file_names[option - 1]);
	    }
	    display2 = 1;
	 }
	 if(temp == 'b'){
	    ansipos(x,y);
	    putcolor('1','F');
	    printf("%s",temp2);
	    if(option < total_fa){
	       option = option + 1;
	       y = y + 1;
	       strcpy(temp2, file_names[option - 1]);
	    }
	    display2 = 1;
	 }
	 else if(temp == '\n'){
	    start_listing(option - 1);
	    scrcolor('3');
	    display = 1;
	    display2 = 1;
	 }
	 else if(temp == 'q'){
	    quit = 1;
	 }
      }
   }
   
   
   return 0;
}


int tbf_areasel(void){
   int quit = 0, quitb = 0, x = 15, y = 5, a = 0, b = 0, display = 1, display2 = 1, timechk = 0, warned = 0, warned2 = 0, option = 1;
   int mast_line = 1, newsrc_line = 1, endoflist = 0, end = 0, subscribed = 0;
   char temp, temp2[80], temp3[80];
   FILE *fp_master, *fp_newsrc, *fp_newsrc_tmp;
   strcpy(temp2, dat_main.root);
   strcat(temp2, "/forums/");
   strcat(temp2, forum_nameshort);
   strcat(temp2, "/arealist");
   fp_master = fopen(temp2, "r");
   strcpy(temp2, user.homedir);
   strcat(temp2, ".tb/forums/");
   strcat(temp2, forum_nameshort);
   strcat(temp2, "/newsrc");
   fp_newsrc = fopen(temp2, "r+");
   if(!fp_master){
      printf("Did not load file %s", temp2);
      tbf_wait();
   }
   while(!quit){
      if(display){
	 box_3d(10,3,61,19,1,1);
	 putcolor(0,'F');
	 ansipos(13,20);
	 printf("(S)ubscribe (U)nsubscribe (N)ext Page (P)rev Page (Q)uit");
	 for(a = 0;a < 15; a++){
	    end = tbc_readline(fp_master,mast_line,2);
	    if(end == -1 || temp_buf[0] == '\n' || temp_buf[0] == '\0'){
	       mast_line = mast_line + 15 - a;
	       a = 16;
	       endoflist = 1;
	       continue;
	    }
	    ansipos(12,4+a);
	    printf("%2d) %.50s",a+1,temp_buf);
	    strcpy(temp2, temp_buf);
	    mast_line++;
	    quitb = 0;
	    subscribed = 0;
	    fseek(fp_newsrc, 0, SEEK_SET);
	    while(!quitb){
	       end = tbc_read_line(fp_newsrc);
	       if(end == -1 || temp_buf[0] == '\n' || temp_buf[0] == '\0'){
		  quitb = 1;
		  continue;
	       }
	       if(!strncmp(temp2, temp_buf, strlen(temp2))){
		  subscribed = 1;
		  quitb = 1;
		  ansipos(65,4+a);
		  printf("*");
		  continue;
	       }
	    }
	 }
	 display = 0;
      }
      temp = tolower(getchar());
      if(temp != EOF){
	 linenum = 1;
	 if(temp == 'n' && endoflist == 0){
	    display = 1;
	 }
	 else if(temp == 'p'){
	    if(mast_line <= 31){
	       if(mast_line >= 15){
		  endoflist = 0;
	       }
	       mast_line = 1;
	       display = 1;
	       continue;
	    }
	    mast_line = mast_line - 30;
	    endoflist = 0;
	    display = 1;
	 }
	 else if(temp == 's'){
	    display = 1;
	    mast_line = mast_line - 15;
	    ansipos(13,19);
	    putcolor(0,'E');
	    printf("Enter Area Number: ");
	    strcpy(temp2, "");
	    get_input(temp2,2,1,0,0,0,0);
	    to_int(temp2);
	    end = tbc_readline(fp_master,mast_line - 1 + to_int_return,2);
	    if(end == -1 || temp_buf[0] == '\n' || temp_buf[0] == '\0'){
	       continue;
	    }
	    else{
	       fseek(fp_newsrc, 0 , SEEK_END);
	       fputs(temp_buf, fp_newsrc);
	       fputc('\n', fp_newsrc);
	    }
	 }
	 else if(temp == 'u'){
	    display = 1;
	    mast_line = mast_line - 15;
	    ansipos(13,19);
	    putcolor(0,'E');
	    printf("Enter Area Number: ");
	    strcpy(temp2, "");
	    get_input(temp2,2,1,0,0,0,0);
	    to_int(temp2);
	    end = tbc_readline(fp_master,mast_line - 1 + to_int_return,2);
	    if(end == -1 || temp_buf[0] == '\n' || temp_buf[0] == '\0'){
	       continue;
	    }
	    else{
	       strcpy(temp2, user.homedir);
	       strcat(temp2, ".tb/forums/");
	       strcat(temp2, forum_nameshort);
	       strcat(temp2, "/newsrc.tmp");
	       fp_newsrc_tmp = fopen(temp2, "w");
	       if(!fp_newsrc_tmp){
		  continue;
	       }
	       quitb = 0;
	       newsrc_line = 1;
	       strcpy(temp2, temp_buf);
	       while(!quitb){
		  end = tbc_readline(fp_newsrc,newsrc_line,2);
		  if(end == -1 || temp_buf[0] == '\n' || temp_buf[0] == '\0'){
		     quitb = 1;
		     continue;
		  }
		  if(strncmp(temp2, temp_buf, strlen(temp2))){
		     fputs(temp_buf, fp_newsrc_tmp);
		     fputc('\n', fp_newsrc_tmp);
		  }
		  newsrc_line++;
		  
	       }
	       fclose(fp_newsrc);
	       fclose(fp_newsrc_tmp);
	       strcpy(temp2, user.homedir);
	       strcat(temp2, ".tb/forums/");
	       strcat(temp2, forum_nameshort);
	       strcpy(temp3, temp2);
	       strcat(temp3, "/newsrc.tmp");
	       strcat(temp2, "/newsrc");
	       unlink(temp2);
	       link(temp3, temp2);
	       unlink(temp3);
	       fp_newsrc = fopen(temp2, "r+");
	    }
	 }
	 else if(temp == 'q'){
	    quit = 1;
	 }
	 
      }
      
      
   }
   fclose(fp_master);
   fclose(fp_newsrc);
   return 0;
}


int tbf_more(void)
{
   int quit = 0;
   char ans;
   disp_prompt(8);
   while(!quit){
      ans = getchar();
      if(ans != EOF){
	 quit = 1;
      }
   }
   printf("\b\b\b\b\b\b\b\b\b\b\b");
   printf("           ");
   printf("\b\b\b\b\b\b\b\b\b\b\b");
   linenum = 1;
   if(ans == 'n' || ans == 'N'){
      return 0;
   }
   return 1;
}

int tbf_wait(void)
{
   int quit = 0;
   char ans;
   disp_prompt(7);
   while(!quit){
      ans = getchar();
      if(ans != EOF){
	 quit = 1;
      }
   }
   printf("\n");
   linenum = 1;
   return 0;
}


int tbf_dispfile(char filen[])
{
   int quit = 0, quitb = 0, a, b, cont;
   char fg, bg, temp, dispvar[32];
   FILE *fp_file;
   linenum = 1;
   fp_file = fopen(filen, "r");
   if(!fp_file){
      return 1;
   }
   fseek(fp_file,0,SEEK_SET);
   quit = 0;
   while(!quit){
      temp = fgetc(fp_file);
      if(temp == EOF){
	 quit = 1;
	 continue;
      }
      if(temp == '@'){
	 temp = fgetc(fp_file);
	 if(temp == 'X'){
	    temp = fgetc(fp_file);
	    bg = temp;
	    temp = fgetc(fp_file);
	    fg = temp;
	    putcolor(bg,fg);
	 }
	 else{
	    b = 0;
	    quitb = 0;
	    while(!quitb){
	       if(temp == '@'){
		  dispvar[b] = '\0';
		  quitb = 1;
		  continue;
	       }
	       else if(b >=30){
		  dispvar[b] = '\0';
		  printf("@5%s", dispvar);
		  quitb = 1;
		  continue;
	       }
	       else{
		  dispvar[b] = temp;
		  b++;
	       }
	       temp = fgetc(fp_file);
	       
	    }
	    if(!(strcmp(dispvar,"CLS"))){
	       clrscr();
	    }
	    else if(!(strcmp(dispvar,"FNAME"))){
	       printf("%s",user.fname);
	    }
	    else if(!(strcmp(dispvar,"LNAME"))){
	       printf("%s",user.lname);
	    }
	    else if(!(strcmp(dispvar,"ALLIAS"))){
	       printf("%s",user.allias);
	    }
	    else if(!(strcmp(dispvar,"LOGIN"))){
	       printf("%s",user.login);
	    }
	    else if(!(strcmp(dispvar,"MINLEFT"))){
	       printf("%d",check_timeleft());
	    }
	    else if(!(strcmp(dispvar,"TCALLS"))){
	       printf("%d",user2.total_calls);
	    }
	    
	 }
      }
      else{
	 printf("%c", temp);
	 if(temp == '\n'){
	    linenum++;
	    if(linenum >= user.pagelen && chk_pl == 1){
	       cont = tbf_more();
	       if(!cont){
		  quit = 1;
		  continue;
	       }
	    }
	 }
      }
   }
   fclose(fp_file);
   return 0;
}


