/*Copyright (C) 1998 Darren Braun
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *   Any comments or questions can be directed to darren@theboard.dyn.ml.org
 */

/*tbfedit.c - forum editor for The Board*/

#include<headers.h>
#include<tbfedit.h>


extern struct tm *cur_time;
extern char graphmode;
extern int to_int_return;
extern struct user_dat user;
extern struct user_stat user2;
extern char temp_buf[4096];
extern time_t cur_rawtime;
extern time_t logon_time;
extern int orig_timeon;
extern char prompt_str[200][200];
extern int linenum;
extern int Node; 
extern struct tb_dat dat_main;
extern int dir_num, max_files;
extern char dir_file[80], file_list[20][80];
extern int time_limit[200];

int chk_pl = 1, forum_num, total_ma, total_fa, total_ia;
char forum_name[80], forum_nameshort[80], forum_sysop[20], forum_intro[80], forum_file[80], forum_newscmd[80], forum_mesg[80], forum_news[80], forum_info[80], forum_user[80];
char msg_area[50][80], msg_names[50][80], file_area[50][80], file_names[50][80], info_names[20][80], info_files[20][80];
/*struct stat cur_file;*/
struct dirent *cur_file_ent;

int main(int ARGC, char *ARGV[])
{
   int end;
   signal(SIGTERM,tbf_shutdown);
   tbc_save_term();
   tbc_setup_term();
   /*Get working directory*/
   if(ARGC > 1){
      to_int(ARGV[1]);
      forum_num = to_int_return;
   }
   else{
      printf("TBFEdit Must be called with a forum number as a parameter\n");
      printf("%s", cnrm);
      tbc_reset_term();
      exit(1);
   }
   /*Read in variables*/
   read_vars();
   read_forum();
   end = read_dirfile();
   if(end == -1){
      printf("Invalid Forum number\n");
      printf("%s", cnrm);
      tbc_reset_term();
      exit(1);
      
   }
   read_usetup();
   read_ustats();
   read_forum();
   /*Setup Time*/

   /*Start file listing*/
   start_menu();
   /*Cleanup*/
   
   tbf_cleanup();
   return 0;
}


void tbf_shutdown(int sig){
   if(sig == SIGTERM || sig == SIGHUP){
      tbf_cleanup();
      exit(1);
   }
}



int tbf_cleanup(void){
   write_ustats();
   printf("%s", cnrm);
   tbc_reset_term();
   return 0;
}


int start_menu(void){
   int quit = 0, quitb = 0, display = 1, display2 = 1, x = 17, y = 9, option = 1, timechk = 0, warned = 0, warned2 = 0;
   char temp, temp2[30], cmd_line[127];
   scrcolor('3');
   strcpy(temp2, "Edit File Areas");
   while(!quit){
      if(display){
	 box_3d(10,3,60,16,1,1);
	 box_3d(30,4,20,3,1,0);
	 box_3d(15,8,22,3,1,0);
	 box_3d(15,11,22,3,1,0);
	 box_3d(15,14,22,3,1,0);
	 box_3d(43,8,22,3,1,0);
	 box_3d(43,11,22,3,1,0);
	 box_3d(43,14,22,3,1,0);
	 putcolor(0,'F');
	 ansipos(32,5);printf("%s", forum_name);
	 ansipos(17,9);printf("Edit File Areas");
	 ansipos(17,12);printf("Edit Message Areas");
	 ansipos(17,15);printf("N/A");
	 ansipos(47,9);printf("Edit News File");
	 ansipos(47,12);printf("Edit Bulletins");
	 ansipos(47,15);printf("N/A");
	 ansipos(31,17);printf("Press 'Q' to quit");
	 display = 0;
      }
      if(display2){
	 ansipos(x,y);
	 putcolor('3','F');
	 printf("%s",temp2);
	 display2 = 0;
      }
      update_timeon();
      timechk = check_timeleft();
      if(timechk == 5 && warned == 0){
	 disp_prompt(7);
	 tbc_newline();
	 warned = 1;
      }
      else if(timechk == 1 && warned2 == 0){
	 disp_prompt(7);
	 tbc_newline();
	 warned2 = 1;
      }
      else if(!timechk){
	 disp_prompt(8);
	 tbc_newline();
	 return 0;
      }
      temp = tolower(getchar());
      if(temp != EOF){
	 linenum = 1;
	 if(temp == 'a'){
	    ansipos(x,y);
	    putcolor('1','F');
	    printf("%s",temp2);
	    if(option == 2){
	       option = 1;
	       x = 17;
	       y = 9;
	       strcpy(temp2, "Edit File Areas");
	    }
	    else if(option == 3){
	       option = 2;
	       x = 17;
	       y = 12;
	       strcpy(temp2, "Edit Message Areas");
	    }
	    else if(option == 5){
	       option = 4;
	       x = 47;
	       y = 9;
	       strcpy(temp2, "Edit News File");
	    }
	    else if(option == 6){
	       option = 5;
	       x = 47;
	       y = 12;
	       strcpy(temp2, "Edit Bulletins");
	    }
	    
	    display2 = 1;
	 }
	 if(temp == 'b'){
	    ansipos(x,y);
	    putcolor('1','F');
	    printf("%s",temp2);
	    if(option == 1){
	       option = 2;
	       x = 17;
	       y = 12;
	       strcpy(temp2, "Edit Message Areas");
	    }
	    else if(option == 2){
	       option = 3;
	       x = 17;
	       y = 15;
	       strcpy(temp2, "N/A");
	    }
	    else if(option == 4){
	       option = 5;
	       x = 47;
	       y = 12;
	       strcpy(temp2, "Edit Bulletins");
	    }
	    else if(option == 5){
	       option = 6;
	       x = 47;
	       y = 15;
	       strcpy(temp2, "N/A");
	    }
	    display2 = 1;
	 }
	 if(temp == 'c'){
	    ansipos(x,y);
	    putcolor('1','F');
	    printf("%s",temp2);
	    if(option == 1){
	       option = 4;
	       x = 47;
	       y = 9;
	       strcpy(temp2, "Edit News File");
	    }
	    else if(option == 2){
	       option = 5;
	       x = 47;
	       y = 12;
	       strcpy(temp2, "Edit Bulletins");
	    }
	    else if(option == 3){
	       option = 6;
	       x = 47;
	       y = 15;
	       strcpy(temp2, "N/A");
	    }
	    display2 = 1;
	 }
	 if(temp == 'd'){
	    ansipos(x,y);
	    putcolor('1','F');
	    printf("%s",temp2);
	    if(option == 4){
	       option = 1;
	       x = 17;
	       y = 9;
	       strcpy(temp2, "Edit File Areas");
	    }
	    else if(option == 5){
	       option = 2;
	       x = 17;
	       y = 12;
	       strcpy(temp2, "Edit Message Areas");
	    }
	    else if(option == 6){
	       option = 3;
	       x = 17;
	       y = 15;
	       strcpy(temp2, "N/A");
	    }
	    display2 = 1;
	 }
	 else if(temp == '\n'){
	    if(option == 1){
	       tbf_filea();
	       display = 1;
	       display2 = 1;
	    }
	    else if(option == 4){
	       strcpy(cmd_line, "jed ");
	       strcat(cmd_line, forum_news);
	       system(cmd_line);
	       scrcolor('3');
	       display = 1;
	       display2 = 1;
	    }
	    else if(option == 5){
	       tbf_bulletins();
	       display = 1;
	       display2 = 1;
	    }
	 }
	 else if(temp == 'q'){
	    ansipos(x,y);
	    putcolor('1','F');
	    printf("%s",temp2);
	    box_3d(25,10,30,5,3,1);
	    putcolor(0,'F');
	    ansipos(27,11);printf("Are you sure you want to");
	    ansipos(27,12);printf(" quit the Forum Editor?");
	    ansipos(35,13);printf("(Y)es/(N)o");
	    if(tbc_getyn()){
	       quit = 1;
	       continue;
	    }
	    else{
	       display = 1;
	       display2 = 1;
	    }
	 }
      }
   }
   
   return 0;
}


int read_forum(void){
   FILE *fp_forum, *fp_file, *fp_mesg, *fp_info, *fp_check;
   int quit = 0, quitb = 0, quitc = 0, end = 0, a = 0, b = 0, c = 0, line = 0;
   char temp[80], temp2[80], temp3[80];
   strcpy(temp3, dat_main.dat);
   strcat(temp3, "/forums.dat");
   fp_forum = fopen(temp3, "r");
   tbc_readline(fp_forum,forum_num,2);
   fclose(fp_forum);
   fp_forum = fopen(temp_buf, "r");
   strcpy(forum_name, "Null Forum");
   c = 1;
   quit = 0;
   while(!quit){
      end = tbc_readline(fp_forum,c,2);
      if(end == -1){
	 quit = 1;
	 continue;
      }
      c++;
      if(temp_buf[0] == '['){
	 if(!(strcmp(temp_buf, "[MISC]"))){
	    tbc_readline(fp_forum,c,2);
	    strcpy(forum_name, temp_buf);
	    c++;
	    tbc_readline(fp_forum,c,2);
	    strcpy(forum_nameshort, temp_buf);
	    c++;
	    tbc_readline(fp_forum,c,2);
	    strcpy(forum_sysop, temp_buf);
	    c++;
	    tbc_readline(fp_forum,c,2);
	    strcpy(forum_intro, temp_buf);
	    c++;
	    tbc_readline(fp_forum,c,2);
	    strcpy(forum_newscmd, temp_buf);
	    c++;
	    
	 }
	 if(!(strcmp(temp_buf, "[FILES]"))){
	    tbc_readline(fp_forum,c,2);
	    strcpy(forum_file, temp_buf);
	    c++;
	    tbc_readline(fp_forum,c,2);
	    strcpy(forum_mesg, temp_buf);
	    c++;
	    tbc_readline(fp_forum,c,2);
	    strcpy(forum_news, temp_buf);
	    c++;
	    tbc_readline(fp_forum,c,2);
	    strcpy(forum_info, temp_buf);
	    c++;
	    tbc_readline(fp_forum,c,2);
	    strcpy(forum_user, temp_buf);
	    c++;
	 }
      }
   }
   fclose(fp_forum);
   /*Read Info File Listing*/
   quit = 0;
   quitb = 0;
   a = 1;
   fp_info = fopen(forum_info, "r");
   while(!quit){
      end = tbc_readline(fp_info,a,2);
      if(end == -1){
	 quit = 1;
	 total_ia = a - 2;
	 continue;
      }
      if(temp_buf[0] == '\0' || temp_buf[0] == '#' || temp_buf[0] == ' ' || temp_buf[0] == '\n' ){
	 a++;
	 continue;
      }
      quitb = 0;
      b = 0;
      c = 0;
      while(!quitb){
	 if(temp_buf[c] == ':'){
	    info_names[a - 1][b] = '\0'; 
	    quitb = 1;
	    c++;
	    continue;
	 }
	 else{
	    info_names[a - 1][b] = temp_buf[c];
	    b++;
	    c++;
	 }
	 if(b >=75){
	    info_names[a - 1][b] = '\0';
	    quitb = 1;
	    continue;
	 }
	 
      }
      quitb = 0;
      b = 0;
      while(!quitb){
	 if(temp_buf[c] == ':' || temp_buf[c] == '\0' || temp_buf[c] == '\n'){
	    info_files[a - 1][b] = '\0'; 
	    quitb = 1;
	    continue;
	 }
	 else{
	    info_files[a - 1][b] = temp_buf[c];
	    b++;
	    c++;
	 }
	 if(b >=75){
	    info_files[a - 1][b] = '\0'; 
	    quitb = 1;
	    continue;
	 }
	 
      }
      a++;
      
   }
   /*Read Dir File Listing*/
   quit = 0;
   quitb = 0;
   a = 1;
   fp_file = fopen(forum_file, "r");
   while(!quit){
      end = tbc_readline(fp_file,a,2);
      if(end == -1){
	 quit = 1;
	 total_fa = a - 2;
	 continue;
      }
      if(temp_buf[0] == '\0' || temp_buf[0] == '#' || temp_buf[0] == ' ' || temp_buf[0] == '\n' ){
	 a++;
	 continue;
      }
      quitb = 0;
      b = 0;
      c = 0;
      while(!quitb){
	 if(temp_buf[c] == ':'){
	    file_names[a - 1][b] = '\0'; 
	    quitb = 1;
	    c++;
	    continue;
	 }
	 else{
	    file_names[a - 1][b] = temp_buf[c];
	    b++;
	    c++;
	 }
	 if(b >=75){
	    file_names[a - 1][b] = '\0';
	    quitb = 1;
	    continue;
	 }
	 
      }
      quitb = 0;
      b = 0;
      while(!quitb){
	 if(temp_buf[c] == ':' || temp_buf[c] == '\0' || temp_buf[c] == '\n'){
	    file_area[a - 1][b] = '\0'; 
	    quitb = 1;
	    continue;
	 }
	 else{
	    file_area[a - 1][b] = temp_buf[c];
	    b++;
	    c++;
	 }
	 if(b >=75){
	    file_area[a - 1][b] = '\0'; 
	    quitb = 1;
	    continue;
	 }
	 
      }
      a++;
      
   }
   fclose(fp_info);
   strcpy(temp, user.homedir);
   strcat(temp, ".tb");
   mkdir(temp, 0777);
   strcat(temp, "/forums");
   mkdir(temp, 0777);
   strcat(temp, "/");
   strcat(temp, forum_nameshort);
   mkdir(temp, 0777);
   strcpy(temp2, temp);
   strcat(temp2, "/newsrc");
   strcpy(temp3, dat_main.root);
   strcat(temp3, "/forums/");
   strcat(temp3, forum_nameshort);
   strcat(temp3, "/newsrc.default");
   fp_check = fopen(temp2, "r");
   if(!fp_check){
      copy_file(temp2, temp3);
   }
   else{
      fclose(fp_check);
   }
   return 0;
}


int tbf_bulletins(void){
   int quit = 0, quitb = 0, x = 15, y = 5, a = 0, b = 0, display = 1, display2 = 1, timechk = 0, warned = 0, warned2 = 0, option = 1;
   char temp, temp2[80], cmd_line[127];
   strcpy(temp2, info_names[0]);
   while(!quit){
      if(display){
	 box_3d(10,3,60,16,1,1);
	 putcolor(0,'F');
	 for(a = 0; a < total_ia;a++){
	    ansipos(12,5 + a);printf("%d  %s", a + 1, info_names[a]);
	 }
	 ansipos(31,17);printf("Press 'Q' to quit");
	 display = 0;
      }
      if(display2){
	 ansipos(x,y);
	 putcolor('3','F');
	 printf("%s",temp2);
	 display2 = 0;
      }
      temp = tolower(getchar());
      if(temp != EOF){
	 linenum = 1;
	 if(temp == 'a'){
	    ansipos(x,y);
	    putcolor('1','F');
	    printf("%s",temp2);
	    if(option > 1){
	       option = option - 1;
	       y = y - 1;
	       strcpy(temp2, info_names[option - 1]);
	    }
	    display2 = 1;
	 }
	 if(temp == 'b'){
	    ansipos(x,y);
	    putcolor('1','F');
	    printf("%s",temp2);
	    if(option < total_ia){
	       option = option + 1;
	       y = y + 1;
	       strcpy(temp2, info_names[option - 1]);
	    }
	    display2 = 1;
	 }
	 else if(temp == '\n'){
	    strcpy(cmd_line, "jed ");
	    strcat(cmd_line, info_files[option - 1]);
	    system(cmd_line);
	    scrcolor('3');
	    display = 1;
	    display2 = 1;
	 }
	 else if(temp == 'q'){
	    quit = 1;
	 }
      }
   }
   
   
   return 0;
}


int tbf_filea(void){
   int quit = 0, quitb = 0, x = 15, y = 5, a = 0, b = 0, display = 1, display2 = 1, timechk = 0, warned = 0, warned2 = 0, option = 1;
   char temp, temp2[80];
   strcpy(temp2, file_names[0]);
   while(!quit){
      if(display){
	 box_3d(10,3,60,16,1,1);
	 putcolor(0,'F');
	 for(a = 0; a < total_fa;a++){
	    ansipos(12,5 + a);printf("%d  %s", a + 1, file_names[a]);
	 }
	 ansipos(21,17);printf(" (N)ew File Area  (R)emove File Area  (Q)uit");
	 display = 0;
      }
      if(display2){
	 ansipos(x,y);
	 putcolor('3','F');
	 printf("%s",temp2);
	 display2 = 0;
      }
      temp = tolower(getchar());
      if(temp != EOF){
	 linenum = 1;
	 if(temp == 'a'){
	    ansipos(x,y);
	    putcolor('1','F');
	    printf("%s",temp2);
	    if(option > 1){
	       option = option - 1;
	       y = y - 1;
	       strcpy(temp2, file_names[option - 1]);
	    }
	    display2 = 1;
	 }
	 if(temp == 'b'){
	    ansipos(x,y);
	    putcolor('1','F');
	    printf("%s",temp2);
	    if(option < total_fa){
	       option = option + 1;
	       y = y + 1;
	       strcpy(temp2, file_names[option - 1]);
	    }
	    display2 = 1;
	 }
	 else if(temp == '\n'){
	    tbf_filea_edit(option);
	    scrcolor('3');
	    display = 1;
	    display2 = 1;
	 }
	 else if(temp == 'r'){
	 }
	 else if(temp == 'n'){
	    tbf_add_filea();
	    
	 }
	 else if(temp == 'q'){
	    quit = 1;
	 }
      }
   }
   
   
   return 0;
}

int tbf_filea_edit(int area){
   int quit = 0, quitb = 0, quitc = 0, quitd = 0, end, a, b, c, d, e, f, g, display1 = 1, display2 = 1, display3 = 1, display4 = 1,dirsec = 10, ispub = 1;
   int line = 4, cur_file = 1, cur_page = 1, page[500], file_ypos[100], file_filepos[100], end_of_list = 0, match = 0;
   char temp, dirname[60], hd_dir[80], temp2[80], cmd_line[256], file_ext[10];
   DIR *cur_dir;
   FILE *fp_dir, *fp_desc, *fp_temp;
   strcpy(temp2, file_area[area - 1]);
   strcat(temp2, "/.index");
   strcpy(hd_dir, file_area[area - 1]);
   strcat(hd_dir, "/");
   strcpy(dirname, file_names[area - 1]);
   fp_dir = fopen(temp2,"r+");
   if(!fp_dir){
      fp_dir = fopen(temp2,"w");
      fclose(fp_dir);
      fp_dir = fopen(temp2,"r+");
   }
   clrscr();
   putcolor(0,'E');
   printf("Checking File Listing...Please Wait\n");
   putcolor(0,'F');
   cur_dir = opendir(hd_dir);
   while(cur_file_ent = readdir(cur_dir)){
      if(cur_file_ent->d_name[0] != '.'){
	 quitb = 0;
	 a = 1;
	 match = 0;
	 fseek(fp_dir, 0, SEEK_SET);
	 while(!quitb){
	    end = tbc_read_line(fp_dir);
	    if(end == -1){
	       quitb = 1;
	       continue;
	    }
	    if(temp_buf[0] == ':'){
	       for(b = 1; b <= strlen(temp_buf); b++){
		  temp2[b - 1] = temp_buf[b];
	       }
	       temp2[b - 1] = '\0';
	       if(!strcmp(temp2, cur_file_ent->d_name)){
		  match = 1;
	       }
	    }
	    a++;
	 }
	 if(!match){
	    fseek(fp_dir, 0, SEEK_END);
	    fputc(':', fp_dir);
	    fputs(cur_file_ent->d_name, fp_dir);
	    fputc('\n', fp_dir);
	    fputs("No Description", fp_dir);
	    fputc('\n', fp_dir);
	    printf("Adding %s to File Listing\n", cur_file_ent->d_name);
	 }
      }
      
   }
   tbf_wait();
   closedir(cur_dir);
   quit = 0;
   d = 1;
   cur_page = 1;
   page[cur_page] = 1;
   d = page[cur_page];
   while(!quit){
      if(display1){
	 box_3d(1,1,79,3,1,1);
	 box_3d(1,user.pagelen - 4,79,4,1,1);
	 a = (80 - strlen(dirname))/2;
	 ansipos(a,2);
	 putcolor('1','F');
	 printf("%s",dirname);
	 display1 = 0;
	 display2 = 1;
	 display3 = 1;
      }
      if(display2){
	 line = 4;
	 quitb = 0;
	 b = 0;
	 max_files = 0;
	 end = tbc_readline(fp_dir,d,2);
	 if(end == -1 || temp_buf[0] == '\n' || temp_buf[0] == '\0'){
	    end_of_list = 1;
	    quitb = 1;
	 }
	 while(!quitb){
	    d++;
	    if(temp_buf[0] == ':'){
	       for(c = 0;c < strlen(temp_buf); c++){
		  temp_buf[c] = temp_buf[c+1];
	       }
	       temp_buf[c] = '\0';
	       strcpy(file_list[max_files],temp_buf);
	       max_files++;
	       file_ypos[max_files] = line;
	       file_filepos[max_files] = d - 1;
	    }
	    quitc = 0;
	    e = 1;
	    while(!quitc){
	       end = tbc_read_line(fp_dir);
	       if(end == -1 || temp_buf[0] == '\n' || temp_buf[0] == '\0'){
		  end_of_list = 1;
		  quitc = 1;
		  quitb = 1;
		  continue;
	       }
	       if(temp_buf[0] == ':'){
		  quitc = 1;
		  continue;
	       }
	       else{
		  d++;
		  ansipos(1,line);
		  putcolor('3','B');
		  if(e == 1){
		     printf("%-34.34s%-45.45s",file_list[max_files - 1], temp_buf);
		     if(line >= user.pagelen - 4){
			quitc = 1;
			quitb = 1;
			continue;
		     }
		     if(strlen(temp_buf) > 45){
			g = 45;
			for(f = 45;f < strlen(temp_buf); f++){
			   if(g >= 45){
			      line++;
			      ansipos(1,line);
			      printf("%-34.34s"," ");
			      g = 0;
			   }
			   printf("%c", temp_buf[f]);
			   g++;
			   if(line >= user.pagelen - 4){
			      quitc = 1;
			      quitb = 1;
			      continue;
			   }
			}
		     }
		  }
		  else{
		     printf("%-34.34s%-45.45s"," ",temp_buf);
		     if(line >= user.pagelen - 4){
			quitc = 1;
			quitb = 1;
			continue;
		     }
		     if(strlen(temp_buf) > 45){
			g = 45;
			for(f = 45;f < strlen(temp_buf); f++){
			   if(g >= 45){
			      line++;
			      ansipos(1,line);
			      printf("%-34.34s"," ");
			      g = 0;
			   }
			   printf("%c", temp_buf[f]);
			   g++;
			   if(line >= user.pagelen - 4){
			      quitc = 1;
			      quitb = 1;
			      continue;
			   }
			}
		     }
		  }
		  line++;
		  
		  d++;
	       }
	       if(line >= user.pagelen - 4){
		  quitc = 1;
		  quitb = 1;
		  continue;
	       }
	       
	       e++;
	    }
	 }
	 while(line + 1 <= user.pagelen - 4){
	    ansipos(1,line);
	    putcolor('3','B');
	    printf("%-80s"," ");
	    line++;
	 }
	 ansipos(5,2);
	 putcolor('1','F');
	 printf("Files: %3d",max_files);
	 page[cur_page + 1] = file_filepos[max_files];
	 d = page[cur_page];
	 display2 = 0;
	 
      }
      if(display3){
	 ansipos(7,user.pagelen - 3);
	 disp_prompt(58);
	 display3 = 0;
      }
      if(display4){
	 ansipos(25,user.pagelen - 2);
	 putcolor('1','C');
	 printf("%-40s"," ");
	 putcolor('1','F');
	 ansipos(70,user.pagelen - 3);
	 display4 = 0;
      }
      temp = tolower(getchar());
      if(temp == EOF){
	 display4 = 1;
      }
      else if(temp == 'q'){
	 quit = 1;
	 continue;
      }
      else if(temp == 'd'){
	 quitb = 0;
	 display1 = 1;
	 display2 = 1;
	 cur_file = 1;
	 if(max_files <= 0){
	    ansipos(30,user.pagelen - 2);
	    putcolor('1','C');
	    printf("No Files in Directory");
	    return 1;
	 }
	 while(!quitb){
	    if(display1){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('7','E');
	       printf("%-20s",file_list[cur_file - 1]);
	       display1 = 0;
	    }
	    temp = tolower(getchar());
	    if(temp == EOF){
	       display2 = 1;
	    }
	    else if(temp == 'q'){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       quitb = 1;
	       continue;
	    }
	    else if(temp == 'a' && cur_file > 1){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       cur_file--;
	       display1 = 1;
	    }
	    else if(temp == 'b' && cur_file < max_files){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       cur_file++;
	       display1 = 1;
	    }
	    else if(temp == '\n'){
	       ansipos(30,user.pagelen - 2);
	       putcolor('1','C');
	       printf("Not Completed Yet");
	    }
	    
	 }
	 continue;
      }
      else if(temp == 'm'){
	 quitb = 0;
	 display1 = 1;
	 display2 = 1;
	 cur_file = 1;
	 if(max_files <= 0){
	    ansipos(30,user.pagelen - 2);
	    putcolor('1','C');
	    printf("No Files in Directory");
	    return 1;
	 }
	 while(!quitb){
	    if(display1){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('7','E');
	       printf("%-20s",file_list[cur_file - 1]);
	       display1 = 0;
	    }
	    temp = tolower(getchar());
	    if(temp == EOF){
	       display2 = 1;
	    }
	    else if(temp == 'q'){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       quitb = 1;
	       continue;
	    }
	    else if(temp == 'a' && cur_file > 1){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       cur_file--;
	       display1 = 1;
	    }
	    else if(temp == 'b' && cur_file < max_files){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       cur_file++;
	       display1 = 1;
	    }
	    else if(temp == '\n'){
	       ansipos(30,user.pagelen - 2);
	       putcolor('1','C');
	       printf("Not Completed Yet");
	    }
	    
	 }
	 continue;
      }
      else if(temp == 'c'){
	 quitb = 0;
	 display1 = 1;
	 display2 = 1;
	 cur_file = 1;
	 if(max_files <= 0){
	    ansipos(30,user.pagelen - 2);
	    putcolor('1','C');
	    printf("No Files in Directory");
	    return 1;
	 }
	 while(!quitb){
	    if(display1){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('7','E');
	       printf("%-20s",file_list[cur_file - 1]);
	       display1 = 0;
	    }
	    temp = tolower(getchar());
	    if(temp == EOF){
	       display2 = 1;
	    }
	    else if(temp == 'q'){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       quitb = 1;
	       continue;
	    }
	    else if(temp == 'a' && cur_file > 1){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       cur_file--;
	       display1 = 1;
	    }
	    else if(temp == 'b' && cur_file < max_files){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       cur_file++;
	       display1 = 1;
	    }
	    else if(temp == '\n'){
	       ansipos(30,user.pagelen - 2);
	       putcolor('1','C');
	       printf("Not Completed Yet");
	    }
	    
	 }
	 continue;
      }
      else if(temp == 'v'){
	 quitb = 0;
	 display1 = 1;
	 display2 = 1;
	 cur_file = 1;
	 if(max_files <= 0){
	    ansipos(30,user.pagelen - 2);
	    putcolor('1','C');
	    printf("No Files in Directory");
	    return 1;
	 }
	 while(!quitb){
	    if(display1){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('7','E');
	       printf("%-20s",file_list[cur_file - 1]);
	       display1 = 0;
	    }
	    temp = tolower(getchar());
	    if(temp == EOF){
	       display2 = 1;
	    }
	    else if(temp == 'q'){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       quitb = 1;
	       continue;
	    }
	    else if(temp == 'a' && cur_file > 1){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       cur_file--;
	       display1 = 1;
	    }
	    else if(temp == 'b' && cur_file < max_files){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       cur_file++;
	       display1 = 1;
	    }
	    else if(temp == '\n'){
	       if(strlen(file_list[cur_file - 1]) < 4){
		  strcpy(file_ext, file_list[cur_file - 1]);
	       }
	       else{
		  file_ext[0] = file_list[cur_file - 1][strlen(file_list[cur_file - 1]) - 4];
		  file_ext[1] = file_list[cur_file - 1][strlen(file_list[cur_file - 1]) - 3];
		  file_ext[2] = file_list[cur_file - 1][strlen(file_list[cur_file - 1]) - 2];
		  file_ext[3] = file_list[cur_file - 1][strlen(file_list[cur_file - 1]) - 1];
		  file_ext[4] = '\0';
	       }
	       strcpy(temp2, ttyname(1));
	       if(!strcmp(file_ext, ".gif")){
		  if(temp2[8] == 'S'){
		     ansipos(30,user.pagelen - 2);
		     putcolor('1','C');
		     printf("Can't View This Type of File Remotely");
		  }
		  else{
		     strcpy(cmd_line, "zgv ");
		     strcat(cmd_line, hd_dir);
		     strcat(cmd_line, file_list[cur_file - 1]);
		     system(cmd_line);
		  }
	       }
	       else if(!strcmp(file_ext, ".GIF")){
		  if(temp2[8] == 'S'){
		     ansipos(30,user.pagelen - 2);
		     putcolor('1','C');
		     printf("Can't View This Type of File Remotely");
		  }
		  else{
		     strcpy(cmd_line, "zgv ");
		     strcat(cmd_line, hd_dir);
		     strcat(cmd_line, file_list[cur_file - 1]);
		     system(cmd_line);
		  }
	       }
	       else if(!strcmp(file_ext, ".jpg")){
		  if(temp2[8] == 'S'){
		     ansipos(30,user.pagelen - 2);
		     putcolor('1','C');
		     printf("Can't View This Type of File Remotely");
		  }
		  else{
		     strcpy(cmd_line, "zgv ");
		     strcat(cmd_line, hd_dir);
		     strcat(cmd_line, file_list[cur_file - 1]);
		     system(cmd_line);
		  }
	       }
	       else if(!strcmp(file_ext, ".JPG")){
		  if(temp2[8] == 'S'){
		     ansipos(30,user.pagelen - 2);
		     putcolor('1','C');
		     printf("Can't View This Type of File Remotely");
		  }
		  else{
		     strcpy(cmd_line, "zgv ");
		     strcat(cmd_line, hd_dir);
		     strcat(cmd_line, file_list[cur_file - 1]);
		     system(cmd_line);
		  }
	       }
	       else{
		  ansipos(30,user.pagelen - 2);
		  putcolor('1','C');
		  printf("Can't View This Type of File");
	       }

	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       quitb = 1;
	       continue;
	    }
	    
	 }
	 continue;
      }
      else if(temp == 'e'){
	 quitb = 0;
	 display1 = 1;
	 display2 = 1;
	 cur_file = 1;
	 if(max_files <= 0){
	    ansipos(30,user.pagelen - 2);
	    putcolor('1','C');
	    printf("No Files in Directory");
	    return 1;
	 }
	 while(!quitb){
	    if(display1){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('7','E');
	       printf("%-20s",file_list[cur_file - 1]);
	       display1 = 0;
	    }
	    temp = tolower(getchar());
	    if(temp == EOF){
	       display2 = 1;
	    }
	    else if(temp == 'q'){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       quitb = 1;
	       continue;
	    }
	    else if(temp == 'a' && cur_file > 1){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       cur_file--;
	       display1 = 1;
	    }
	    else if(temp == 'b' && cur_file < max_files){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       cur_file++;
	       display1 = 1;
	    }
	    else if(temp == '\n'){
	       ansipos(30,user.pagelen - 2);
	       putcolor('1','C');
	       printf("Not Completed Yet");
	    }
	    
	 }
	 continue;
      }
      else if(temp == 'u'){
	 quitb = 0;
	 display1 = 1;
	 display2 = 1;
	 cur_file = 1;
	 if(max_files <= 0){
	    ansipos(30,user.pagelen - 2);
	    putcolor('1','C');
	    printf("No Files in Directory");
	    return 1;
	 }
	 while(!quitb){
	    if(display1){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('7','E');
	       printf("%-20s",file_list[cur_file - 1]);
	       display1 = 0;
	    }
	    temp = tolower(getchar());
	    if(temp == EOF){
	       display2 = 1;
	    }
	    else if(temp == 'q'){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       quitb = 1;
	       continue;
	    }
	    else if(temp == 'a' && cur_file > 1){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       cur_file--;
	       display1 = 1;
	    }
	    else if(temp == 'b' && cur_file < max_files){
	       ansipos(1,file_ypos[cur_file]);
	       putcolor('3','B');
	       printf("%-20s",file_list[cur_file - 1]);
	       cur_file++;
	       display1 = 1;
	    }
	    else if(temp == '\n'){
	       strcpy(cmd_line,"unzip -a -C -L -o -qq ");
	       strcat(cmd_line, hd_dir);
	       strcat(cmd_line, file_list[cur_file - 1]);
	       strcat(cmd_line, " ");
	       strcat(cmd_line, "file_id.diz");
	       strcat(cmd_line, " -d ");
	       strcat(cmd_line, user.homedir);
	       strcat(cmd_line, ".tb");
	       end = system(cmd_line);
	       if(end){
		  ansipos(25,user.pagelen - 2);
		  putcolor('1','C');
		  printf("File contains no description");
	       }
	       else{
		  strcpy(cmd_line, user.homedir);
		  strcat(cmd_line, ".tb/");
		  strcat(cmd_line, "file_id.diz");
		  fp_desc = fopen(cmd_line, "r");
		  strcpy(cmd_line, hd_dir);
		  strcat(cmd_line, ".index.temp");
		  fp_temp = fopen(cmd_line, "w+");
		  strcpy(temp2, ":");
		  strcat(temp2, file_list[cur_file - 1]);
		  quitc = 0;
		  fseek(fp_dir, 0, SEEK_SET);
		  while(!quitc){
		     end = tbc_read_line(fp_dir);
		     if(end == -1 || temp_buf[0] == '\n' || temp_buf[0] == '\0'){
			quitc = 1;
			continue;
		     }
		     fputs(temp_buf, fp_temp);
		     fputc('\n', fp_temp);
		     if(temp_buf[0] == ':'){
			if(!strcmp(temp2, temp_buf)){
			   quitd = 0;
			   while(!quitd){
			      end = tbc_read_line(fp_desc);
			      if(end == -1 || temp_buf[0] == '\n' || temp_buf[0] == '\0'){
				 quitd = 1;
				 continue;
			      }
			      fputs(temp_buf, fp_temp);
			      fputc('\n', fp_temp);
			   }
			   quitd = 0;
			   while(!quitd){
			      end = tbc_read_line(fp_dir);
			      if(end == -1 || temp_buf[0] == '\n' || temp_buf[0] == '\0'){
				 quitd = 1;
				 continue;
			      }
			      if(temp_buf[0] == ':'){
				 fputs(temp_buf, fp_temp);
				 fputc('\n', fp_temp);
				 quitd = 1;
				 continue;
			      }
			   }
			}
		     }
		  }
		  fclose(fp_temp);
		  fclose(fp_desc);
		  fclose(fp_dir);
		  strcpy(temp2, hd_dir);
		  strcat(temp2, ".index");
		  strcpy(cmd_line, hd_dir);
		  strcat(cmd_line, ".index.temp");
		  unlink(temp2);
		  link(cmd_line, temp2);
		  unlink(cmd_line);
		  fp_dir = fopen(temp2, "r+");
	       }
	       
	       quitb = 1;
	       continue;
	    }
	    
	 }
	 continue;
      }
      else if(temp == 'n'){
	 if(!end_of_list){
	    display2 = 1;
	    cur_page++;
	    d = page[cur_page];
	 }
	 else{
	    ansipos(30,user.pagelen - 2);
	    putcolor('1','C');
	    printf("Bottom of Listing");
	    continue;
	 }
	 continue;
      }
      else if(temp == 'p'){
	 if(cur_page <= 1){
	    ansipos(30,user.pagelen - 2);
	    putcolor('1','C');
	    printf("Top of Listing");
	 }
	 else{
	    end_of_list = 0;
	    cur_page--;
	    d = page[cur_page];
	    display2 = 1;
	 }
	 continue;
      }
   }
   
   return 0;
}


int tbf_wait(void)
{
   int quit = 0;
   char ans;
   disp_prompt(7);
   while(!quit){
      ans = getchar();
      if(ans != EOF){
	 quit = 1;
      }
   }
   printf("\n");
   linenum = 1;
   return 0;
}

int tbf_add_filea(){
   
   
   return 0;
}

