/* ix/MBox/WENDY (screen.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #AT activate()         send ANSI sequence for RTF code
   #SL show_line()        display text line including RTF code
   #SC show_screen()      full screen of RTF text
   #PS prep_screen()      convert RTF file to screen text
   #RS restore_screen()   convert screen text to RTF file
   #ST show_status()      show state line

   Contact <volkers@unnet.wupper.de> for help! */













#include "wendy.h"
 
int RTFMEM;
 
 
/* #AT - Convert RTF line to ANSI line */
 
activate( c )
int c;
{
  ansi( "me" );

  switch(c){
        case 'b' : ansi( "md" );
                   break;
        case 'i' : ansi( "mr" );
                   break;
        case 'f' : ansi( "mb" );
                   break;
        case 'u' : ansi( "us" );
                   break;
	case 'c' : break;
        default  : RTF_attrib = '0';
  }
}
 
 
 
/* #SL - Show a RTF line */
 
show_line( s, a, start )
unsigned char s[], a[];
int start;
{
  int olda = '0';
  int i = 0;
  int l = 0;
  int dummy = (ypos + y) -1;
  int set = 0;
 
  unsigned char line[1024];
 
  i = start -1;
 
  ansi2( "cm", start, y );
 
  while(s[i] != '\0'){

	if(BLOCK.status == BLOCKMODE){
		line[l] = '\0';
		if((dummy == BLOCK.y1) && (i == (BLOCK.x1 -1))){
			if(set == 0){
				strcat(line, (unsigned char *) termansi( "md" ));
				set++;
			}
		}
		if((dummy > BLOCK.y1) && (dummy < BLOCK.y2)){
			if(set == 0){
				strcat(line, (unsigned char *) termansi( "md" ));
				set++;
			}
		}
		if((dummy == BLOCK.y2) && (i == BLOCK.x2)){
			if((BLOCK.y1 == BLOCK.y2) && (set != 99)){
				set = 99;
			}
			if((set == 0) || (set == 99)){
				strcat(line, (unsigned char *) termansi( "me" ));
				if(set != 99) set++;
			}
		}
		if(dummy > BLOCK.y2){
			if(set == 0){
				strcat(line, (unsigned char *) termansi( "me" ));
				set++;
			}
		}
		
		if(((dummy >  BLOCK.y1) && (dummy < BLOCK.y2)) ||
                   ((dummy == BLOCK.y1) && (i > BLOCK.x1))     ||
		   ((dummy == BLOCK.y2) && (i < BLOCK.x2))) olda = a[i];

		l = strlen(line);
	}

        if(a[i] != olda){
                olda = a[i];
                line[l] = '\0';
		strcat(line, (unsigned char *) termansi( "me" ));
                switch(olda){
                        case 'b' : strcat(line, (unsigned char *) termansi( "md" ));
                                   break;
                        case 'i' : strcat(line, (unsigned char *) termansi( "mr" ));
                                   break;
                        case 'f' : strcat(line, (unsigned char *) termansi( "mb" ));
                                   break;
                        case 'u' : strcat(line, (unsigned char *) termansi( "us" ));
                                   break;
                }
		l = strlen(line);
        }
	if(s[i] == BLANK)
		line[l] = ' ';
	else
	        line[l] = s[i];
        l++;
        i++;
  }
  line[l] = '\0';
  if(start == 1) ansi( "ce" );
  printf("%s", (unsigned char *) right_stripped( (unsigned char *) line));
}
 
 
 
/* #SC - Display screen */
 
show_screen( start )
int start;
{
  int i, xmem = x, ymem = y;
 
  ansi( "me" );

  x = 1; y = start;
 
  for(i = start; i <= MAXY; i++){
        show_line( (unsigned char *) SCREEN[i], (unsigned char *) ATTRIB[i], 1 );
        y++;
  }

  x = xmem; y = ymem; 
  activate( RTF_attrib );
  ansi2( "cm", x, y );
}
 
 
 
 
/* #PS - Convert RTF file to screen text */
 
prep_screen( ypos )
int ypos;
{
  int i;
 
  RTFMEM = RTF_attrib;

  RTF_attrib = '0';
 
  for(i = START; i <= MAXY; i++){
        rtf_convert( TEXT[(ypos -1 + i)], i, (ypos -1 + i) );
  }
  RTF_attrib = RTFMEM;
}
 
 
 
/* #RS - Convert screen text to RTF */
 
restore_screen( ypos )
int ypos;
{
  int i;

  RTFMEM = RTF_attrib;
 
  for(i = START; i <= MAXY; i++){
        strcpy( TEXT[(ypos -1 + i)], (unsigned char *) make_rtf( SCREEN[i], ATTRIB[i] ));
  }
  RTF_attrib = RTFMEM;
}
 
 
 
/* ST - Show state line */
 
show_status( s )
unsigned char s[];
{
  unsigned char l[LONGSTRING];

  strcpy(l, (unsigned char *) s);
  strcat(l, "                                                                          ");
  l[MAXX] = '\0';

  ansi2( "cm", 1, 1 );
  ansi( "mr" );
  printf("%s", l);
  ansi2( "cm", (strlen(s) +1), 1 );

  STATUSM = 1;
 
  activate( RTF_attrib );
}



