#include <stdio.h>
#include <string.h>
#define __MBD
#include "uqwk.h"
/*
 *  Process a reply packet
 */

DoReply ()
{
	int n, rep_cnt;
	char bbs[PATH_LEN];

	rep_cnt = 0;

	/* Open the packet */
	if (NULL == (rep_fd = fopen (rep_file, "r")))
	{
		fprintf (stderr, "%s: can't open %s\n", progname, rep_file);
		return (0);
	}

	/* Get the first block, the BBS ID */
	if (1 != fread (buf, 128, 1, rep_fd))
	{
		fprintf (stderr, "%s: reply packet read error\n", progname);
		fclose (rep_fd);
		return (0);
	}

	/* Extract bbs id and check */
	sscanf (bbs_id, "%*d,%s", bbs);
	n = strlen (bbs);
	buf[n] = 0;
	if (strcmp (bbs, buf))
	{
		fprintf (stderr, "%s: reply BBS ID mismatch: %s != %s\n",
			progname, buf, bbs);
		fclose (rep_fd);
		return (0);
	}

	/* Read the .newsrc file; we will need the list of conferences */

	/* Read the next message header and process it */
	while (1 == fread (&rep_hdr, 128, 1, rep_fd))
	{
		SendReply ();
		rep_cnt++;
	}

	fclose (rep_fd);
	printf ("%s: sent %d replies\n", progname, rep_cnt);

	return (1);
}

SendReply ()
/*
 *  Pipe a reply to the mailer or inews
 */
{
	FILE *pfd;
	unsigned char c, to[PATH_LEN], subject[PATH_LEN], group[PATH_LEN];
	int i, n, blocks, bytes, conf;
	struct nrc_ent *np;

	/* Extract recipient */
	strncpy (buf, rep_hdr.to, 25);
	buf[25] = 0;
	sscanf (buf, "%s", to);

	/* Extract conference number */
	strncpy (buf, rep_hdr.number, 7);
	buf[7] = 0;
	sscanf (buf, "%d", &conf);

	/* Extract subject */
	strncpy (buf, rep_hdr.subject, 25);
	buf[25] = 0;
	strcpy (subject, buf);

	/* Get rid of single quotes in subject */
	n = strlen (subject);
	for (i=0; i<n; i++) if (subject[i] == '\'') subject[i] = '`';

	/* Find newsgroup with this conference number */
	np = nrc_list;
	while (np != NULL)
	{
		if (np->conf == conf) break;
		np = np->next;
	}

	/* Get newsgroup name */
	if (np == NULL)
	{
		/* Bet this generates lots of email for "ALL" */
		rep_hdr.status = QWK_PRIVATE;
	}
	else
	{
		strcpy (group, np->name);
	}

	/* Extract block count */
	strncpy (buf, rep_hdr.blocks, 6);
	buf[6] = 0;
	sscanf (buf, "%d", &blocks);
	blocks -= 1;
	bytes = 128 * blocks;

	/* Check for off-line command message */
	if ( (!strcmp (to, "uqwk")) || (!strcmp (to, "UQWK")) )
	{
		OffLine (bytes);
		return (0);
	}

	/* Check for a configuration message intended for some
	   other QWK "door" */
	if ( (!strcmp (to, "MARKMAIL")) || (!strcmp (to, "QMAIL"))   ||
	     (!strcmp (to, "markmail")) || (!strcmp (to, "qmail"))   ||
	     (!strcmp (to, "ROSEMAIL")) || (!strcmp (to, "KMAIL"))   ||
	     (!strcmp (to, "rosemail")) || (!strcmp (to, "kmail"))   ||
	     (!strcmp (to, "MAINMAIL")) || (!strcmp (to, "CMPMAIL")) ||
	     (!strcmp (to, "mainmail")) || (!strcmp (to, "cmpmail")) ||
	     (!strcmp (to, "ULTRABBS")) || (!strcmp (to, "BGQWK"))   ||
	     (!strcmp (to, "ultrabbs")) || (!strcmp (to, "bgqwk"))   ||
	     (!strcmp (to, "CAM-MAIL")) || (!strcmp (to, "TRIMAIL")) ||
	     (!strcmp (to, "cam-mail")) || (!strcmp (to, "trimail")) ||
	     (!strcmp (to, "QSO")) || (!strcmp (to, "qso")) )
	{
		/* Send warning to user */
		SendWarning (to);

		/* Skip the rest of the message */
		while (bytes--) fread (&c, 1, 1, rep_fd);

		return (0);
	}

	/* Check for a "To: " line in the body of the message */
	CheckTo (to, bytes);

	/* Open pipe to proper program */
	pfd = NULL;

	if ( (rep_hdr.status == QWK_PUBLIC) ||
	     (rep_hdr.status == QWK_PUBLIC2) )
	{
		/* Public message, open pipe to inews */
		sprintf (buf, "%s -t '%s' -n %s", "INEWS_PATH", subject, group);
		printf ("%s\n", buf);
		if (NULL == (pfd = popen (buf, "w")))
		{
			fprintf (stderr, "%s: can't popen() inews\n",
					progname);
		}
	}
	else if ( (rep_hdr.status == QWK_PRIVATE) ||
	          (rep_hdr.status == QWK_PRIVATE2) )
	{
		/* Open pipe to mail */
		sprintf (buf, "%s -s '%s' %s", MAILER_PATH, subject, to);
		printf ("%s\n", buf);
		if (NULL == (pfd = popen (buf, "w")))
		{
			fprintf (stderr, "%s: can't popen() mail\n", progname);
		}
	}

	/* Read and send all bytes of message */
	for (i=0; i<bytes; i++)
	{
		fread (&c, 1, 1, rep_fd);
		if (c == QWK_EOL) c = 012;
		if (pfd != NULL) fwrite (&c, 1, 1, pfd);
	}

	if (pfd != NULL) pclose (pfd);
	return (1);
}

SendWarning (to)
char *to;
/*
 *  Mail a warning to the user if the reply packet
 *  contains a message apparently for some other QWK
 *  "door" program.
 */
{
	FILE *pfd;

	/* Open pipe to mailer */
	sprintf (buf, "%s -s 'QWK-Server Error Message' %s",
			MAILER_PATH, user_name);
	if (NULL == (pfd = popen (buf, "w")))
	{
		fprintf (stderr, "%s: can't popen() mail\n", progname);
		return (0);
	}

	/* Send the message */

	fprintf (pfd,
"Hello. You sent a message to the username %s, presumably to\n", to);
	fprintf (pfd,
"perform some sort of offline configuration. This QWK processor,\n");
	fprintf (pfd,
"called QWK, cannot process this message. To perform offline\n");
	fprintf (pfd,
"configuration using QWK, you must send a message to the username\n");
	fprintf (pfd,
"QWK. Commands are to be included in the body of the message.\n");
	fprintf (pfd,
"For a list of commands, send a message to QWK with the word\n");
	fprintf (pfd,
"HELP in the body of the message (not the subject). Thanks!\n");

	pclose (pfd);
	return (1);
}

CheckTo (to, bytes)
char *to;
int bytes;
/*
 *  Check the first line of the body of the message for a To: line.
 *  This is the only way to send to addresses over 25 characters.
 *
 *  Whether we find a To: line or not, we have to leave the file
 *  positioned right where it is.
 */
{
	long offset;
	unsigned char c;
	int i;

	/* Sanity check */
	if (bytes < 5) return (0);

	offset = ftell (rep_fd);

	/* Check first four bytes */
	fread (buf, 4, 1, rep_fd);
	bytes -= 4;
	if (strncmp (buf, "To: ", 4))
	{
		/* Doesn't match */
		fseek (rep_fd, offset, 0);
		return (0);
	}

	/* Copy in the rest of the line until white space, EOL,
	   or run out of bytes */
	i = 0;
	fread (&c, 1, 1, rep_fd);
	bytes--;

	while ( (bytes >= 0) && (c != QWK_EOL) &&
	        (c != 9) && (c != ' ') )
	{
		to[i++] = c;

		fread (&c, 1, 1, rep_fd);
		bytes--;
	}
	to[i] = 0;

	/* Done! */
	fseek (rep_fd, offset, 0);
	return (1);
}
