
/* ix/MBox (sexport.c) by Sylvio Runge 6/94

   This C source code contains the following functions:
   
	SetSHExports()	
*/




#include <sys/types.h>
#ifndef const
#define const
#endif
#include <regex.h>
#define NOTERM   /* no old/new-termvar */
#include <stdio.h>
#include <sys/stat.h>
#include <dirent.h>
#include <signal.h>
/*#include <stdlib.h>*/
#include <unistd.h>
#include <strings.h>
/*#include <sys/wait.h>*/
#include <errno.h>
#define STTY

#ifndef VU
#include "mbox.h"
#include "s_global.h"
#include "compile.h"
#include "uqwk/uqwk.h"
#include "alias.update/defs.h"
#else
#include "../mbox.h"
#include "../s_global.h"
#include "../compile.h"
#include "../uqwk/uqwk.h"
#include "../alias.update/defs.h"
#endif


#undef A_DEBUG
#undef C_DEBUG
#undef GDEBUG

#include <string.h>
#include <time.h>
/*#include <stdlib.h>*/


#include <signal.h>
#include <sys/types.h>


#define NO_WAITPID

#if !defined(HAVE_GNU_LD) && !defined (__ELF__)
#define __environ       environ
#endif

#define SHELL_PATH      "/bin/sh"       /* Path of the shell.  */
#define SHELL_NAME      "sh"            /* Name to give it.  */




#define MAXCONF 15

typedef struct conf
    {
    char    *line;          /* tty line */
    long    von,bis;        /* von-bis-Grenze */
    int     zeit;           /* oneline-Zeit */
    int     tag[7];         /* wochentage der gueltigkeit */
    int     max_limit;    /* max-bbs_user ohne limit */
    } conf_el;
conf_el conf_arr[MAXCONF];
int conf_idx = 0;


struct list_t
 {
    char line[2*STRING];
    void *n;
 };
        
 struct list_t *BAD_TOP=NULL;
 struct list_t *BAD_MSG_TOP=NULL;
        
 int BASE64_CONT=0; PGP_CONT=0, UUE_CONT=0,BIN_CONT=0,bin_typ=0;
       
        




void SetSHExports()
{
FILE *fd;
unsigned char s[LONGSTRING],t[STRING],k[STRING];

#ifdef VU
sprintf(s,"%s/etc/list.vu.export",ZOPT.OPT->HOME);
#else
sprintf(s,"%s/etc/list.export",ZOPT.OPT->HOME);
#endif


if ((fd=fopen(s,"r"))!=NULL)
{

sprintf(s,"%s/etc/lynx.cfg",ZOPT.OPT->HOME);
setenv("LYNX_CFG",s,1); 

sprintf(s,"%d",ZOPT.OPT->USER.language);
setenv("BBS_LANG",s,1);


setenv("SHELL","bbs.shell",1);

sprintf(s,"%s/usr.public",ZOPT.OPT->HOME);
setenv("HOME",s,1); 
setenv("home",s,1); 
if (!getenv("TERM"))
 strcpy(ZOPT.tty,"vt100"); /* default */
else
 strcpy(ZOPT.tty,getenv("TERM"));
                          
                          
  while (fgets(s,STRING*2,fd)!=NULL)
  {
    if (strpos("#",s)!=1)
    {
      strcpy(t,(char *) cut_bef(s)); 
      if (strpos(" ",t)!=0) t[strpos(" ",t)-1]=0;
      strcpy(k,(char *) cut_arg(s));
      if (strpos(" ",k)!=0) k[strpos(" ",k)-1]=0;
      if (strpos("TERM",t)==1) {
       k[30]=0;
       strcpy(ZOPT.tty,k);
      }
      if (setenv(t,k,1)==(-1)) 
        logerror("sexport.c", 46, "SetSHExports", "CAN NOT SET THE ENVIROMENT (check ./etc/list.export)", s);        
    }
  }
}
setenv("BBS_HOME",ZOPT.OPT->HOME,1);
sprintf(s,"%d",ZOPT.OPT->USER.level);
setenv("BBS_USR_LEV",s,1);


sprintf(s,"%d",GetLynxColorSet());
setenv("LYNX_COLOR",s,1);


setenv("BBS_USR",(char *) leer2punkt(ZOPT.OPT->USER.name),1);
SetTermEnv(ZOPT.tty);
}





int SetTermEnv(term)
char *term;
{
 if (setenv("TERM",term)==-1)
 {
   unsetenv("TERM");
   return (!setenv("TERM",term));
 }
 return(1);
}









/* ++++++++++++++++++++++  Zusaetzliche Optionen Lesn/Speichern fuer S++/BBS/Rip */
void ReadZOpt()
{
FILE *fd;
unsigned char s[STRING];

 sprintf(s,"%s/usr/%c/%d/.zoption",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id);
 if ((fd=fopen(s,"r"))!=NULL)
 {
  /* USE_AREA */
  if (fgets(s,STRING,fd)!=NULL)
  {
   strcpy(s, (UNSIGNED char *) stripped( s ));
   ZOPT.OPT->USE_AREAS=ZOPT.bbs.area_on=atoi(s);
  } else ZOPT.bbs.area_on=1;
  
  /* MENUE_USING */
  if (fgets(s,STRING,fd)!=NULL)
  {
   strcpy(s, (UNSIGNED char *) stripped( s ));
   ZOPT.OPT->MENUE_USING=atoi(s);
  } else ZOPT.OPT->MENUE_USING=0;
  
  
  /* use adr_book */
  if (fgets(s,STRING,fd)!=NULL)
  {
   strcpy(s, (UNSIGNED char *) stripped( s ));
   ZOPT.OPT->adr_on=atoi(s);
  } else ZOPT.OPT->adr_on=1;  
  
  /* use adr_book */
  if (fgets(s,STRING,fd)!=NULL)
  {
   strcpy(s, (UNSIGNED char *) stripped( s ));
   ZOPT.OPT->adr_auto=atoi(s);
  } else ZOPT.OPT->adr_auto=1;  
  
  fclose(fd);
 }
}


void WriteZOpt()
{
FILE *fd;
unsigned char s[STRING];

 sprintf(s,"%s/usr/%c/%d/.zoption",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id);
 if ((fd=fopen(s,"w"))!=NULL)
 {
  fprintf(fd,"%d\n%d\n%d\n%d",ZOPT.bbs.area_on,ZOPT.OPT->MENUE_USING,
    ZOPT.OPT->adr_on,ZOPT.OPT->adr_auto);
  fclose(fd);
 }

}

int zeile=0;

unsigned char *ParseNewsCfg(search)
unsigned char *search;
{
FILE *fd;
static unsigned char s[STRING];

zeile=0; 
sprintf(s,"%s/etc/list.news",ZOPT.OPT->HOME);
if ((fd=fopen(s,"r"))!=NULL)
{
  
  while (fgets(s,STRING,fd)!=NULL)
  {
   zeile++;
   if ((strpos(search,s))&&(s[0]!='#')&&(strlen(s)>2))
   {
    strcpy(s,(char *) stripped(cut_arg(s)));
    return (s);
   }
  }

} else nerror("sexport.c", 107, "ParseNewsCfg", "Can't open NewsCfg-File", s);
fclose(fd);
s[0]=0;
return(s);
}






void Log(mode,search,found)
int mode;
unsigned char *search, *found;
{
FILE *fd;
unsigned char s[STRING],m[4];

return;

sprintf(s,"%s/etc/log/news.lastinit.log",ZOPT.OPT->HOME);
if (!mode) strcpy(m,"w");
  else strcpy(m,"a");
 if ((fd=fopen(s,m))!=NULL)
 {
  if (!mode) {
    fprintf(fd,"+++ %s +++  %s +++  \n(./etc/log/news.lastinit.log)\n ",VERSION,AUTOR_0);
    fprintf(fd,"date: %s,  %s\n",mydate(0),mytime(0));
    fprintf(fd,"user: %s, id: %d\n----------------------------------------------------------------------------\n\n%-5s  %-30s  %-30s\n",
         ZOPT.OPT->USER.name,ZOPT.OPT->USER.id,"zeile","search","found");
  }
  if ((mode==0)||(mode==1)) /* gefunden..... */
  {
  fprintf(fd,"%-05d  %-30s  %-30s\n",zeile,search,found);
  fclose(fd);
  } else
  if (mode<50)   /* set .... */
  {
  fprintf(fd,"   ->set: %s=%s\n\n",search,found); 
  fclose(fd);
  } else
  if (mode<100)  /* Fehler .... */
  {
  fprintf(fd,"#->-> error: %s :  %s\n\n",search,found); 
  fclose(fd);
  } else
  if (mode<150)  /* TrennStrich .... */
  {
  fprintf(fd,"\n\n+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n"); 
  fclose(fd);
  } else
  if (mode<200)  /* Msg */
  {
  fprintf(fd,"\n# ->-> %s:  %s \n",search,found); 
  fclose(fd);
  }
 } 

}







/* initialisiert die aktuell konfigurierten News-Einstellungen aus "list.news"*/
void InitNews()
{
unsigned char s[STRING];
int i;





void NewsMode()
{
strcpy(s,(char *) strings(GRead("newsaccess")));

ZOPT.news.news_mode=1;  			/* nntp(1) - direkt ist voreingestellt */
ZOPT.OPT->NNTP_ON=0;

if (strpos("direct/mbd-expire",s)) {  /* ehemals local_direct */
 ZOPT.news.news_mode=3; 
 Log(10,"news","direct/mbd-expire (6)");
} else
if (strpos("direct/mbd-index",s)) {
 ZOPT.news.news_mode=1; 
 Log(10,"news","direct/mbd-index (4)");
}
 else
if (strpos("nntp (1)",s)) {
 ZOPT.news.news_mode=2; 
 ZOPT.OPT->NNTP_ON=1;
 Log(10,"news","nntp (1)");
} else
if (strpos("nntp/nn-db",s)) {
 ZOPT.news.news_mode=6; 
 ZOPT.OPT->NNTP_ON=1;
 Log(10,"news","nntp/nn-db (2)");
} else
if (strpos("direct/mbd-newindex",s)) {    /* MBD bei jedem Gruppenwechsel */
 ZOPT.news.news_mode=4; 
 Log(10,"news","direct/mbd-newsindex (5)");
} else
if (strpos("direct/nn-db",s)) {
 ZOPT.news.news_mode=7; 
 ZOPT.OPT->NNTP_ON=0;
 Log(10,"news","direct/nn-db (3)");
} else
if (strpos("direct dbm/dbz",s)) {
 ZOPT.news.news_mode=8; 
 ZOPT.OPT->NNTP_ON=0;
 Log(10,"news","direct dbm/dbz (7)");
} 
if ((ZOPT.news.news_mode==8) ||(ZOPT.news.news_mode==7) ||(ZOPT.news.news_mode==6))
  nerror("sexport.c",265, "NewsMode()", "At this time no support (use tbbs.setup for changes)", s);

}



void NewsTimeSet()
{
 strcpy(s,ParseNewsCfg("news_direct_time"));
 Log(1,"news_direct_time",s);
 if (strlen(s)) {
  ZOPT.news.difftime=atoi(s)*60;  /* umwandl. min->sek. */
  Log(10,"news_direct_time",s); 
 }
}


void SetNntpPort()
{
 strcpy(ZOPT.news.nntp_port,"nntp");   			/* default */
 
 strcpy(s,(char *) strings(GRead("nntp.port")));
/* Log(1,"nntp_port",s);*/
 
 strcpy(ZOPT.news.nntp_port,(char *) cut_bef(s));
 strcpy(s,ZOPT.news.nntp_port);
 if (strlen(s)>1) {
  for (i=0; i<=strlen(s); i++)
  {
   if (s[i]==SPACE) s[i]=0;
  }
  strcpy(ZOPT.news.nntp_port,s);
  printf("\n%s\nservice: (tcp/%s)...",GetText("INT11_MSG"),s);
  Log(10,"nntp_service",s); 
 } else Log(10,"nntp_service: invalid (use default 'nntp'): ",s);
}


void PostTest()
{
/*strcpy(s,ParseNewsCfg("post"));*/
strcpy(s,(char *) strings(GRead("nntp.posting")));
for (i=0; i<STRING; i++) 
{
 if (s[i]==SPACE) s[i]=0;
}
ZOPT.news.post=1;  			/* posten erlaubt mit inews = ist voreingestellt */

Log(1,"post",s);
if (strpos("inews",s)) {
 ZOPT.news.post=1; 
 Log(10,"post","by inews");
}
 else
if (strpos("nntp",s)) {
 ZOPT.news.post=0; 
 Log(10,"post","by nntp-server");
}
}

void NNTPServerTest()
{
/*strcpy(s,ParseNewsCfg("nntpserver"));*/
strcpy(s,(char *) strings(GRead("nntp.server")));
for (i=0; i<STRING; i++) 
{
 if (s[i]==SPACE) s[i]=0;
}
strcpy(ZOPT.news.nntpserver,"" ); 			/* keiner = ist voreingestellt */

Log(1,"nntpserver",s);
if (strlen(s)>2)
{
strcpy(ZOPT.news.nntpserver,s);
Log(10,"nntpserver",s);
}
}

/* ++++++++++++++++++++++ news-init-main ++++++++++++++++ */
NewsCheckIt(); /* ueberprueft, ob wichtige Server und News-Files erreichbar sind */
Log(0,"news",s);
 NewsMode();
 PostTest();
 if (ZOPT.news.news_mode==2) 
 {
  NNTPServerTest();
  sprintf(s,"%s",ZOPT.news.nntpserver);
  setenv("NNTPSERVER",s,1);

 }
 if ((ZOPT.news.news_mode==3)||(ZOPT.OPT->NNTP_ON)) NewsTimeSet();

 if (ZOPT.OPT->NNTP_ON) SetNntpPort();

 Log(140,"",""); /* trenn-str */

/* if (ZOPT.OPT->NNTP_ON) NntpConnect();     connect to nntp-server */
 
}





void NewsCheckIt()
{
FILE *fd;

return;

#ifdef NEWS_DUMMY_SUP
if ((fd=fopen(NEWSGROUPS,"r"))==NULL) {		/* newsgroups desc. */
  Log(50,SE01,NEWSGROUPS);
  nerror("sexport.c", 234, "NewsCheckIt", "Can't open", NEWSGROUPS);
} else fclose(fd);
#endif
 
chdir(ZOPT.OPT->HOME);
}




#ifdef LINUX_NEW_SYSTEM_CMD
ssystem(line)
char *line;
{
  int status, save;
  pid_t pid;
  struct sigaction sa, intr, quit,term,/*hup,*/ alarm;
  sigset_t block, omask;

  if (line == NULL)
    return 1;

  sa.sa_handler = SIG_IGN;
  sa.sa_flags = 0;
  sigemptyset (&sa.sa_mask);

  if (sigaction (SIGINT, &sa, &intr) < 0)
    return -1;
  if (sigaction (SIGTERM, &sa, &term) < 0)
    return -1;    
  if (sigaction (SIGALRM, &sa, &alarm) < 0)
    return -1;    
  if (sigaction (SIGQUIT, &sa, &quit) < 0)
    {
      save = errno;
      (void) sigaction (SIGINT, &intr, (struct sigaction *) NULL);
      errno = save;
      return -1;
    }

  sigemptyset (&block);
  sigaddset (&block, SIGCHLD);
  save = errno;
  if (sigprocmask(SIG_BLOCK, &block, &omask) < 0)
    {
      if (errno == ENOSYS)
	errno = save;
      else
	{
	  save = errno;
	  (void) sigaction(SIGINT, &intr, (struct sigaction *) NULL);
	  (void) sigaction(SIGQUIT, &quit, (struct sigaction *) NULL);
	  errno = save;
	  return -1;
	}
    }

  pid = fork ();
  if (pid == (pid_t) 0)
    {
      /* Child side.  */
      char *new_argv[4];
      void *ptr;
      new_argv[0] = SHELL_NAME;
      new_argv[1] = "-c";
      new_argv[2] = line;
      new_argv[3] = NULL;      

      /* Restore the signals.  */
      
      (void) sigaction (SIGINT, &intr, (struct sigaction *) NULL);
      (void) sigaction (SIGQUIT, &quit, (struct sigaction *) NULL);
/*      (void) sigaction (SIGHUP, &hup, (struct sigaction *) NULL);      */
      (void) sigaction (SIGALRM, &alarm, (struct sigaction *) NULL);      
      (void) sigaction (SIGTERM, &term, (struct sigaction *) NULL);      
      (void) sigprocmask (SIG_SETMASK, &omask, (sigset_t *) NULL);
      
      /* Exec the shell.  */
      /*ptr= env_cpy(environ); spaeter mal ;)......*/
      ptr=environ;
      (void) execve (SHELL_PATH, (void  *) new_argv, ptr);
      exit (127);
    }
  else if (pid < (pid_t) 0)
    /* The fork failed.  */
    status = -1;
  else
  {
    /* Parent side.  */
    if (waitpid (pid, &status, 0) != pid)
      status = -1;
  }

  save = errno;
  if ((sigaction (SIGINT, &intr, (struct sigaction *) NULL) |
       sigaction (SIGQUIT, &quit, (struct sigaction *) NULL) |
       sigaction (SIGTERM, &term, (struct sigaction *) NULL) |       
       sigaction (SIGALRM, &alarm, (struct sigaction *)NULL) |
/*       sigaction (SIGHUP, &hup, (struct sigaction *) NULL) |*/
       sigprocmask (SIG_SETMASK, &omask, (sigset_t *) NULL)) != 0)
    {
      
      if (errno == ENOSYS)
	errno = save;
      else
	return -1;
    }
  
  SigAlm();
  return status;
}





#else



int ssystem(line)
char *line;
{
static int astat;
  
  alarm(0);
  astat=system(line);
  /*SigAlm();*/
  alarm( TIME_TICKER );
  return(astat);
}



#endif




char *GRead(entry)
char *entry;
{
FILE *fd;
static char s[2*STRING];

#ifndef BBS_HOME
 sprintf(s,"/etc/tbbs.setup/%s",entry);
#else
 sprintf(s,"%s/etc/config/%s",BBS_HOME,entry);
#endif

if ((fd=fopen(s,"r"))!=NULL)
 {
   if (fgets(s,STRING,fd)==NULL)
nerror("sexport.c", 363, "GRead()", "Bad entry in config-base (check the adjustments in \"tbbs.setup\")", entry);
      
   fclose(fd);      

   return((char *) s);   
      
 } else nerror("sexport.c", 367, "GRead()", "Can't read (check the adjustments in \"tbbs.setup\"); start the \"tbbs.setup\"-SH-Script", s);
 return(NULL);  
}

/* ++++++++++++++++++++++  Globale CFG lesen ++++++++++++++++++ */
void ReadGBLSetting()
{
unsigned char t[STRING];
char s[STRING],*env;
int i;

strcpy(s,"HOME");
env=(char *) getenv(s);

  strcpy(t, (UNSIGNED char *) ttyname(0));
		
  if(strpos(_PMS_TTY, t) != 0)  
   ZOPT.OPT->IM_SYSOP=1; else ZOPT.OPT->IM_SYSOP=0;



/* for Setup: HOME-Check */
strcpy(ZOPT.OPT->HOME,
#ifndef BBS_HOME
(char *) strings(GRead("HOME"))
#else
 BBS_HOME
#endif
); strcat(s," ");

#ifndef BBS_HOME
 strcpy(ZOPT.OPT->BIN,(char *) strings(GRead("BIN")));
#else
 sprintf(ZOPT.OPT->BIN,"%s/bin",BBS_HOME);
#endif

   for (i=0; i<STRING; i++) 
   {
    if (ZOPT.OPT->HOME[i]==SPACE) ZOPT.OPT->HOME[i]=0;
    if (ZOPT.OPT->BIN[i]==SPACE) ZOPT.OPT->BIN[i]=0;
   }


  

strcpy(s,(char *) strings(GRead("mailsize"))); 
ZOPT.OPT->maillogsize= atoi(s);


strcpy(s,(char *) strings(GRead("log.mail"))); 
if (strpos("on",s)==NULL) ZOPT.OPT->maillogsize=0;

StrLog("\n\n---------\n"); StrLog(mydate(1000));StrLog("   "); StrLog(mytime(0));StrLog("\n");


}



/* ++++++++++++++++++++++  Zusatz CFG lesen ++++++++++++++++++ */
void ReadZOptSetting()
{
char s[STRING];

StrLog("\nReadZOptSetting().....");
strcpy(s,GRead("load.newsgroups"));
if (strpos("load on dem",s)) {  /* load on demand */
   ZOPT.news.newsgroups=1;
   StrLog("load.newsgroups -> load by demand\n");
} else  
{
 ZOPT.news.newsgroups=0;
 StrLog("load.newsgroups -> load in memory\n");
}


strcpy(s,GRead("nntp.active.local"));
if (strpos("local",s)) {  /* read active withouth nntp */
   ZOPT.news.active_local=1;
   StrLog("news.active.local -> local ");
} else  
{
 ZOPT.news.active_local=0;
 StrLog("news.active.local -> nntp ");
}
StrLog("....done\n");

}







void bbsuser_confile()
{
  FILE *f;
  int i,j;
  char line[LONGSTRING], tmp_line[STRING], tmp_von[STRING], tmp_bis[STRING],
       tmp_tag[STRING];
  int tmp_zeit, tmp_user;


  sprintf(tmp_tag,"%s/etc/list.maxuser",ZOPT.OPT->HOME);      
  if (!(f=fopen(tmp_tag, "r")) )
  { 
    printf("\nbbsuser_configfile(): Can't find file: %s (no BBS-User-Limit!)\n", tmp_tag);
    sleep(3);
    return;
  }
  while (fgets(line, LONGSTRING-1, f))
        {
        if (*line == '#' || (*line == SPACE))
        	continue;
        sscanf(line,"%s %s %s %d %s %d\n",
           tmp_line,tmp_von, tmp_bis, &tmp_zeit, tmp_tag, &tmp_user);
           
#ifdef C_DEBUG        
 
           printf("\n(line:%s) (von:%s) (bis:%s) (zeit:%d) (tag:%s) (user:%d)",
           tmp_line,tmp_von, tmp_bis, tmp_zeit, tmp_tag, tmp_user);
           sleep(1);
#endif            

        conf_arr[conf_idx].line=strcpy((char *)malloc(strlen(tmp_line)+1),tmp_line);
/*      conf_arr[conf_idx].zeit =atoi((char *) tmp_zeit);*/
        conf_arr[conf_idx].zeit = tmp_zeit;        
        for (i=0;i<8;i++) conf_arr[conf_idx].tag[i] =0;
        if (strpos("*",tmp_tag)) 
        {
          for (i=0;i<8;i++) conf_arr[conf_idx].tag[i] =1;
        } else
        {
          if (strpos("0",tmp_tag)) conf_arr[conf_idx].tag[0] =1; 
          if (strpos("1",tmp_tag)) conf_arr[conf_idx].tag[1] =1; 
          if (strpos("2",tmp_tag)) conf_arr[conf_idx].tag[2] =1; 
          if (strpos("3",tmp_tag)) conf_arr[conf_idx].tag[3] =1; 
          if (strpos("4",tmp_tag)) conf_arr[conf_idx].tag[4] =1; 
          if (strpos("5",tmp_tag)) conf_arr[conf_idx].tag[5] =1; 
          if (strpos("6",tmp_tag)) conf_arr[conf_idx].tag[6] =1; 
        
        }
        if (strpos("*",tmp_von)) conf_arr[conf_idx].von =-1; 
        if (strpos("*",tmp_bis)) conf_arr[conf_idx].bis =-1; 
        if ( (conf_arr[conf_idx].bis ==-1)&&(conf_arr[conf_idx].von ==-1))
        {
          conf_arr[conf_idx].von =conf_arr[conf_idx].bis=-1; /* also immer ;-)*/
        } else
        {
          strcpy(tmp_von,(char *) punkt2leer(tmp_von));
          strcpy(tmp_bis,(char *) punkt2leer(tmp_bis));
          i=atoi((char *) cut_bef(tmp_von));
          j=atoi((char *) cut_arg(tmp_von));
          if ((j>59)||(j<0)) j=0;  if ((i>23)||(i<0)) i=0;
          conf_arr[conf_idx].von=(i*3600)+(j*60);
          i=atoi((char *) cut_bef(tmp_bis));
          j=atoi((char *) cut_arg(tmp_bis));
          if ((j>59)||(j<0)) j=0;  if ((i>23)||(i<0)) i=0;
          conf_arr[conf_idx].bis=(i*3600)+(j*60);
        }
        conf_arr[conf_idx].max_limit =tmp_user;
          
#ifdef A_DEBUG        
            printf("\n(line:%s) (von:%d) (bis:%d) (zeit:%d) (tag:%d%d%d%d%d%d%d) (user:%d)",
           tmp_line,conf_arr[conf_idx].von, conf_arr[conf_idx].bis, tmp_zeit,
           conf_arr[conf_idx].tag[0],conf_arr[conf_idx].tag[1],conf_arr[conf_idx].tag[2],
           conf_arr[conf_idx].tag[3],conf_arr[conf_idx].tag[4],conf_arr[conf_idx].tag[5],
           conf_arr[conf_idx].tag[6], conf_arr[conf_idx].max_limit);
           sleep(1);
#endif                    
        conf_idx++;
        }
 fclose(f);

   
}


/* ueberprueft, BBS-User auf BBS-LOGIN-LIMITS, also ob er im Raster ist oder nicht */ 
int TestBBSUser()
{
int  i;

ZOPT.OPT->max_bbs_user=1000; /* setze max. moegliche User fuer Terminal to MaxUsr*/
for (i=0; i<conf_idx; i++)
{
 if (
      (
       pat_match(conf_arr[i].line,ttyname(0))) 
        && (is_time(conf_arr[i].von,conf_arr[i].bis)) 
          && (is_day(&conf_arr[i].tag))     
      )
  {
 
     ZOPT.OPT->max_bbs_user=conf_arr[i].max_limit; /* setze max. moegliche User fuer Terminal */
     return(1);
      
  } 
}

return ((int ) 0);
}



/* return true if strg matches the regex in pattern */
char *pat_match(char *pattern,char *strg)
{
  re_comp(pattern);
  return((char *) re_exec(strg));
}


int is_time(von,bis)
time_t von,bis;
{
  struct tm *tp;
  time_t tt;
  int set=0;

  long ist_time;


  time(&tt);
  tp = localtime(&tt);
  ist_time= ((((tp->tm_hour)*60) + tp->tm_min)*60) + tp->tm_sec;
 
   if ((von < ist_time)&& (ist_time< bis)) 
           set=1;

return(set);
}



int is_day(tag)
int     *tag[];         /* wochentage der gueltigkeit */
{
  struct tm *tp;
  time_t tt;


  time(&tt);
  tp = localtime(&tt);
  
  if (tag[tp->tm_wday]==1) 
    return(1);
  else return(0);
}



void SetAnsiColor(mode)
int mode;
{
FILE *fd;
unsigned char s[2*STRING];
int i;

StrLog("\nSetAnsiColor()...");
i=0; 
strcpy(ZOPT.ansi->mode[i].org,"me"); strcpy(ZOPT.ansi->mode[i].usr,ZOPT.ansi->mode[i].org); i++;
strcpy(ZOPT.ansi->mode[i].org,"md"); strcpy(ZOPT.ansi->mode[i].usr,ZOPT.ansi->mode[i].org); i++;
strcpy(ZOPT.ansi->mode[i].org,"mr"); strcpy(ZOPT.ansi->mode[i].usr,ZOPT.ansi->mode[i].org); i++;
strcpy(ZOPT.ansi->mode[i].org,"mb"); strcpy(ZOPT.ansi->mode[i].usr,ZOPT.ansi->mode[i].org); i++;
strcpy(ZOPT.ansi->mode[i].org,"so"); strcpy(ZOPT.ansi->mode[i].usr,ZOPT.ansi->mode[i].org);i++;
strcpy(ZOPT.ansi->mode[i].org,"us"); strcpy(ZOPT.ansi->mode[i].usr,ZOPT.ansi->mode[i].org);i++;
strcpy(ZOPT.ansi->mode[i].org,"X1"); strcpy(ZOPT.ansi->mode[i].usr,ZOPT.ansi->mode[i].org);i++;
strcpy(ZOPT.ansi->mode[i].org,"X2"); strcpy(ZOPT.ansi->mode[i].usr,ZOPT.ansi->mode[i].org);i++;
strcpy(ZOPT.ansi->mode[i].org,"X3"); strcpy(ZOPT.ansi->mode[i].usr,ZOPT.ansi->mode[i].org);i++;
strcpy(ZOPT.ansi->mode[i].org,"X4"); strcpy(ZOPT.ansi->mode[i].usr,ZOPT.ansi->mode[i].org);i++;
strcpy(ZOPT.ansi->mode[i].org,"X5"); strcpy(ZOPT.ansi->mode[i].usr,ZOPT.ansi->mode[i].org);i++;
strcpy(ZOPT.ansi->mode[i].org,"X6"); strcpy(ZOPT.ansi->mode[i].usr,ZOPT.ansi->mode[i].org);i++;
strcpy(ZOPT.ansi->mode[i].org,"X7"); strcpy(ZOPT.ansi->mode[i].usr,ZOPT.ansi->mode[i].org);i++;
strcpy(ZOPT.ansi->mode[i].org,"X8"); strcpy(ZOPT.ansi->mode[i].usr,ZOPT.ansi->mode[i].org);i++;
strcpy(ZOPT.ansi->mode[i].org,"X9"); strcpy(ZOPT.ansi->mode[i].usr,ZOPT.ansi->mode[i].org);i++;
strcpy(ZOPT.ansi->mode[i].org,"X0"); strcpy(ZOPT.ansi->mode[i].usr,ZOPT.ansi->mode[i].org);i++;
strcpy(ZOPT.ansi->mode[i].org,"XA"); strcpy(ZOPT.ansi->mode[i].usr,ZOPT.ansi->mode[i].org);i++;
strcpy(ZOPT.ansi->mode[i].org,"XB"); strcpy(ZOPT.ansi->mode[i].usr,ZOPT.ansi->mode[i].org);i++;
strcpy(ZOPT.ansi->mode[i].org,"XC"); strcpy(ZOPT.ansi->mode[i].usr,ZOPT.ansi->mode[i].org);i++;
strcpy(ZOPT.ansi->mode[i].org,"XD"); strcpy(ZOPT.ansi->mode[i].usr,ZOPT.ansi->mode[i].org);i++;
while (i<20)
{
  ZOPT.ansi->mode[i].org[0]=0; i++;
}

if (mode==0){
  StrLog("...done\n");
  return;
 }

sprintf(s,"%s/usr/%c/%d/.AnsiColor",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id);

if ((fd=fopen(s,"r"))!=NULL) /* lese Farben, wenn sie existieren */
{
  i=0;
  while (fgets(s,9,fd)!=NULL)
  {
    strcpy(s,(char *) strings(s)); s[strlen((char *) s)-2]=0; 
    if (strlen(s)>1) strcpy(ZOPT.ansi->mode[i].usr,s);i++;
  }
  fclose(fd);
} 
StrLog("...done\n");
} 






char strtoctrl(char *s)
 {
  if (!s[0])
   return(0);
  if (!s[1])
   return(s[0]);
  if (s[0]=='^')
   {
    if ((s[1]>'a') && (s[1]<'z'))
     s[1]=s[1]-'a'+'A';
    return((s[1]=='?') ? 127 : s[1]-'@');
   }
  fprintf(stderr,"tbbs: invalid character %s\n",s);
  exit(1);
 }



void ANSI_Logo(i)
int i;
{
static char s[2*STRING];

if (RIPTEST) return;

     printf("\E[H\E[J");
   if (i) {
   
     if (GetSectionInt("[sleep]","ansi_tbbs_logo")!=-1)
     {   
      sprintf(s,"%s/etc/ansi/tbbs.logo.ans",ZOPT.OPT->HOME);
      show_raw( s, ANSI_TBBS_LOGO);
      MSWait(GetSectionInt("[sleep]","ansi_tbbs_logo"));
      printf("\E[H\E[J");
     }
     
     if (GetSectionInt("[sleep]","ansi_logo")!=-1)
     { 
      sprintf(s,"%s/etc/ansi/logo.ans",ZOPT.OPT->HOME);
      show_raw( s, ANSI_LOGO);
      MSWait(GetSectionInt("[sleep]","ansi_logo"));
     }

   }
   else 
   { 
     sprintf(s,"%s/etc/ansi/logo.ascii",ZOPT.OPT->HOME);
     show(s, 999, 0 );
   }

}






SetNNTPServ2()
{
int i;
char s[STRING/2];

strcpy(s,(char *) strings(GRead("nntp.server2")));
for (i=0; i<STRING; i++) 
{
 if (s[i]==SPACE) s[i]=0;
}
strcpy(ZOPT.news.nntpserver,s); 			/* keiner = ist voreingestellt */

Log(1,"nntpserver2",s);
if (strlen(s)>2)
{
setenv("NNTPSERVER",ZOPT.news.nntpserver,1);

Log(10,"nntpserver",s);
}

}



int CheckSysop()
{
char s[STRING];

   strcpy(s, (char *) ttyname(0));
   if(strpos(_PMS_TTY, s) != 0) return(1);
    else return(0);
}




long GetQwkSize()
{
static long size=DEF_MAX_SIZE/10;
FILE *fd;
char s[STRING];

sprintf(s,"%s/usr/%c/%d/qwk/.qwk_size",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id);
if ((fd=fopen(s,"r"))!=NULL)
{
  fgets(s,STRING/2,fd);
  size=atoi(s);
  fclose(fd);
}
 return((int ) size);
}





int SetQwkSize(size)
int size;
{
FILE *fd;
char s[STRING];

sprintf(s,"%s/usr/%c/%d/qwk/.qwk_size",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id);
fd=fopen(s,"w");
fprintf(fd,"%d",size);
fclose(fd);
return(0);
}





int GetQwkRunTime()
{
int size=-1;
FILE *fd;
char s[2*STRING];

sprintf(s,"%s/spool/qwk.task/%s",ZOPT.OPT->HOME,leer2punkt(ZOPT.OPT->USER.name));
if ((fd=fopen(s,"r"))!=NULL)
{
  fgets(s,STRING/2,fd);
  size=atoi(s);
  fclose(fd);
}
 return((int ) size);
}


char *GetQwkRunDay()
{
FILE *fd;
static char s[STRING];

sprintf(s,"%s/spool/qwk.task/%s",ZOPT.OPT->HOME,leer2punkt(ZOPT.OPT->USER.name));
if ((fd=fopen(s,"r"))!=NULL)
{
  fgets(s,STRING,fd);  if (fgets(s,STRING,fd)==NULL) strcpy(s,"<none>");
  fclose(fd);
} else strcpy(s,"<none>");
 return((char  *) s);
}


void SetQwkRunTime(time,day)
int time;
char *day;
{
FILE *fd;
static char s[2*STRING];

sprintf(s,"%s/spool/qwk.task/%s",ZOPT.OPT->HOME,leer2punkt(ZOPT.OPT->USER.name));
if ((fd=fopen(s,"w"))!=NULL)
{
  fprintf(fd,"%d\n%s\n%d\n",time,day,ZOPT.OPT->USER.id);
  fprintf(fd,"%d %d %d %d %d %d ",QWK.s_anz,QWK.anz,
 	  QWK.news, QWK.mail,QWK.packer,QWK.header);  
  fclose(fd);
}
}











int GetTestQwkGroup()
{
static int i=0;  /* default maessig die kurze GruppenVersion (fuer die DOSEN*/
FILE *fd;
char s[STRING];

sprintf(s,"%s/usr/%c/%d/qwk/.qwk_long_group",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id);
if ((fd=fopen(s,"r"))!=NULL)
{
  fgets(s,STRING/2,fd);
  i=atoi(s);
  fclose(fd);
}
 return((int ) i);
}




int TestSoupActive()
{
static int i=0;  /* default maessig immer QWK aktiv */
FILE *fd;
char s[STRING];

sprintf(s,"%s/usr/%c/%d/qwk/.soup",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id);
if ((fd=fopen(s,"r"))!=NULL)
{
  fgets(s,STRING/2,fd);
  i=atoi(s);
  fclose(fd);
}
 return((int ) i);
}




int TestNewUser()
{
static int i=0;  /* default maessig immer QWK aktiv */
FILE *fd;
char s[STRING];

if (WMNU_QUESTION)
{
sprintf(s,"%s/usr/%c/%d/.ask.newuser",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id);
if ((fd=fopen(s,"r"))!=NULL)
{
  i=1;
  fclose(fd);
}
 if (!ZOPT.OPT->USER.level) return((int) 1);
 return((int ) i);
} 
return ((int ) 0); 
}



/* aktiviert NewUser-Welcome-Menue */
void SetNewUser()
{
FILE *fd;
char s[STRING];

sprintf(s,"%s/usr/%c/%d/.ask.newuser",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id);
if ((fd=fopen(s,"w"))!=NULL)
{
  fclose(fd);
}
}






int GetLynxColorSet()
{
static int i=0;  /* default maessig immer Standard */
FILE *fd;
char s[STRING];

sprintf(s,"%s/usr/%c/%d/.lynxcolor",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id);
if ((fd=fopen(s,"r"))!=NULL)
{
  fgets(s,STRING,fd); i=atoi(s);
  fclose(fd);
}
 return((int ) i);
}



void SetLynxColorSet(mode)
int mode;
{
FILE *fd;
static char s[STRING];

sprintf(s,"%s/usr/%c/%d/.lynxcolor",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id);
if ((fd=fopen(s,"w"))!=NULL)
{
  fprintf(fd,"%d\n",mode);
  fclose(fd);
}
sprintf(s,"%d",mode);
if (setenv("LYNX_COLOR",s,1))
{
 unsetenv("LYNX_COLOR");
 setenv("LYNX_COLOR",s,1);
}
}







/* aktiviert Fido-Menue #2 (oder eben nicht)*/
void SetFido(mode)
int mode;
{
FILE *fd;
char s[STRING];

sprintf(s,"%s/usr/%c/%d/.fido2",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id);
if (mode!=0)
{
 if ((fd=fopen(s,"w"))!=NULL)
 {
  fprintf(fd,"%d\n",mode);
  fclose(fd);
 }
} else unlink(s);

}




/* testet, nach Fido-Menue#2 */
int TestFidoMnu2()
{
FILE *fd;
char s[STRING];

 sprintf(s,"%s/usr/%c/%d/.fido2",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id);
 if ((fd=fopen(s,"r"))!=NULL)
 {
  fgets(s,STRING/2,fd);
  fclose(fd);
  if (atoi(s)>1) return(atoi(s)); 
  	else return(1);
 }
 return(0);
}



int SetTestQwkGroup(dip)
int dip;
{
FILE *fd;
char s[STRING];

sprintf(s,"%s/usr/%c/%d/qwk/.qwk_long_group",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id);
fd=fopen(s,"w");
fprintf(fd,"%d",dip);
fclose(fd);
return(0);
}


int SetSoupActive(dip)
int dip;
{
FILE *fd;
char s[STRING];

sprintf(s,"%s/usr/%c/%d/qwk/.soup",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id);
fd=fopen(s,"w");
fprintf(fd,"%d",dip);
fclose(fd);
return(0);
}



int GetTalkReq()
{
FILE *fd;
char s[STRING];

sprintf(s,"%s/usr/%c/%d/.notalk",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id);
if ((fd=fopen(s,"r"))!=NULL)
{
  fclose(fd);
  chmod(ttyname(0),00600 );
  return(0);
}
 chmod(ttyname(0),00600 | 00020);
 return(1);
}


void ToggleTalkReq()
{
FILE *fd;
char s[STRING];

sprintf(s,"%s/usr/%c/%d/.notalk",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id);
if (!GetTalkReq()) 
  unlink(s);
else
{
 fd=fopen(s,"w");
 fclose(fd);
}

}




/* liefert prt zu letzem QWK-Job */
char *GetQwkZipFile(nummer)
int nummer;
{
static char s[STRING];
char t[STRING];
FILE *fd;
int nr;

if (!nummer)
{
sprintf(s,"%s/usr/%c/%d/qwk/.lastjob",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id);
if ((fd=fopen(s,"r"))==NULL) return(NULL);
fgets(s,STRING,fd);
nr=atoi(s);
fclose(fd);
} else nr=nummer;

sprintf(s,"%s/usr/%c/%d/qwk/.out/%d",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id,nr);
strcpy(t,s); strcat(t,".zip");
/*printf("\nt:(%s)?1",t);*/
if ((fd=fopen(t,"r"))!=NULL)
{ 
 fclose(fd);
 strcpy(s,t);
 return((char *) &s);
}

/*printf("\nt:(%s)?2",t);*/
strcpy(t,s); strcat(t,".lzh");
if ((fd=fopen(t,"r"))!=NULL)
{ 
 fclose(fd);
 strcpy(s,t);
 return((char *) &s);
}

return(NULL);
}






/* loescht letzen QWK-Job */
/* 0 -> letzer
   nr -> diesen Job
*/
int ClearLastQwkZipFile(nummer)
int nummer;
{
static char s[STRING];
char t[STRING];
FILE *fd;
int nr,ok=0;

if (!nummer)
{
sprintf(s,"%s/usr/%c/%d/qwk/.lastjob",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id);
if ((fd=fopen(s,"r"))==NULL) return(0);
fgets(s,STRING,fd);
nr=atoi(s);
fclose(fd);
} else nr=nummer;



sprintf(s,"%s/usr/%c/%d/qwk/.out/%d",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id,nr);
strcpy(t,s); strcat(t,".zip");
if ((fd=fopen(t,"r"))!=NULL)
{ 
 fclose(fd);
 strcpy(s,t);
 ok=1;
}

/*printf("\nt:(%s)?2",t);*/
strcpy(t,s); strcat(t,".lzh");
if ((fd=fopen(t,"r"))!=NULL)
{ 
 fclose(fd);
 strcpy(s,t);
 ok=1;
}
if (ok)
{
 unlink(s);
 sprintf(s,"%s/usr/%c/%d/qwk/.out/.%d.zip.gz",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id,nr);
 unlink(s);
 sprintf(s,"%s/usr/%c/%d/qwk/.out/.%d.lzh.gz",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id,nr);
 unlink(s);
 sprintf(s,"%s/usr/%c/%d/qwk/.out/.%d.log",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id,nr);
 unlink(s);
 return(1);
}

return(0);
}













/* liefert Dateinamen aus Komplettpfad zurueck */
char *GetLastPath(name)
char *name;
{
static char s[4*STRING];
char t[LONGSTRING];

strcpy(s,name);
while (strpos("/",s)!=0)
{
  strcpy(t,(char *) &s[strpos("/",s)]);
  strcpy(s,t);
}

return((char *) &s);
}







/* liefert die ID des naechsten Download-Job fuer QWK/SOUP */
int GetNextQwkId()
{
FILE *fd;
static int i=0;
char s[2*STRING];

sprintf(s,"%s/usr/%c/%d/qwk/.next",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id);
if ((fd=fopen(s,"r"))!=NULL)
{
  fgets(s,10,fd);
  i=atoi(s); i++;
  fclose(fd);
}
if (i>99) i=0;
sprintf(s,"%s/usr/%c/%d/qwk/.next",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],ZOPT.OPT->USER.id);
fd=fopen(s,"w");
fprintf(fd,"%d",i);
fclose(fd);


return((int ) i);

}


char *GetHostName()
{
static char s[STRING/2];
int i;

gethostname(s,STRING/2); 
for (i=0; i<8; i++) if (s[i]==46 /*'.'*/) s[i]=0;
s[7]=0;
return((char *) &s);
}



/* --------------------------- BIN-Mail & bad-word-Routinen ------------ 
    diese Funktionen sind nur fuer News zustaendig, der Rest (fuer externe 
    Mail) ist in den bbs-mailer-funktionen !!!!
 */
 
 
 

/* User darf UUE-Mails versenden und auch 'bad mails' (mails mit schimpfworten) ? */
int TestUUE_Member(char *user)
{
int ret=0;
FILE *fd=NULL;
static char s[2*STRING],s2[2*STRING];


if (strpos("GAST",user)==1) return (0);
if (strpos("Administration",user)==1) return (1);

sprintf(s,"%s/etc/list.ip.access",((char *) ZOPT.OPT->HOME));
fd = fopen(((char *) s),"r");
if (fd == NULL) {
      nerror("boerde_list.c", 147, "TestIP_MEMBER()", "Can't read", s);
      return(-12);
}
/* Einsprung finden */
sprintf(s2,"%s ",leer2punkt(user));  /* Kompatibilitaet zur alten ix-mbox */
while ((strpos("----------------------------------------------",s)!=1)&&(fgets(s,STRING,fd)!=NULL));
while (fgets(s,2*STRING,fd)!=NULL) 
{
 strcpy(buf,(char *) strings(s));
 if (strpos(s2, buf)>3) /* User gefunden */
 {
    if ((buf[C3]=='x')||(buf[C3]=='x'))      
     ret=1;
   fclose(fd);
   return(ret);
 }

}

                      
fclose(fd);
return(0);
}

 

void SetBadClean()
{
 BAD_MSG_TOP=NULL;
 BASE64_CONT=PGP_CONT=UUE_CONT=BIN_CONT=bin_typ=0;
}



/* BadMessage - Main !!!!!! */
/* Rueckgabe von "1" bei Treffer! */
int CheckBadArticle(artikel)
char *artikel;
{
  SetBadClean();
  CheckMailForBadActions(artikel);
  if (
       ((BAD_MSG_TOP!=NULL)||(BIN_CONT>0))
        &&(!TestUUE_Member(ZOPT.OPT->USER.name))
     )
  {
     MailBadMail(artikel);
     return(1);
  }
  else
     return(0);                               
}



 
/* veranlasst die zuruecksendung des 'bad mails' :) */ 
void MailBadMail(mail)
char *mail;
{
struct list_t *dat; 
FILE *fd,*fp;
time_t timer;
char ss[2*STRING];

if (!(fd=fopen(mail,"r"))) return;
sprintf(ss,"%s -F%s@%s -f%s@%s '%s@%s'", SYSTEM_MAIL,
  leer2punkt(ZOPT.OPT->USER.name),ZOPT.OPT->UUCPID2,
  leer2punkt(ZOPT.OPT->USER.name),ZOPT.OPT->UUCPID2,
  leer2punkt(ZOPT.OPT->USER.name),ZOPT.OPT->UUCPID2);
if ((fp = popen(ss, "w")) == NULL)
{
 nerror("sexport.c", 1323, "MailBadMail", "Can't open pipe tp Mailer", SYSTEM_MAIL);
 return;
}
time(&timer);
fprintf(fp,"To: %s@%s\n",ZOPT.OPT->USER.name,ZOPT.OPT->UUCPID2);
fprintf(fp,"From: MAILER-DAEMON@%s\n",ZOPT.OPT->UUCPID2);
fprintf(fp,"Organization: %s\n",ZOPT.OPT->ORGANIZATION);
fprintf(fp,"Subject: usenet-message failed, returning to sender\n");
fprintf(fp,"Sender: TBBS-MAILER-DAEMON@%s\n",ZOPT.OPT->UUCPID2);
fprintf(fp, "X-Mailer: %s%s :t5\n", VERSION,PATCHLEVEL);
fprintf(fp, "Message-Id: <%x.%d@%s>\n\n", timer,timer,ZOPT.OPT->UUCPID2);
                
fprintf(fp, "|------------------------- Message log follows: -------------------------|\n");
fprintf(fp, " Your usenet-acticle can't send!\n");
fprintf(fp, "|------------------------- Failed request follow: -----------------------|\n");

if (!BIN_CONT)
{

 ansi("mb");printf("\nSTOP\n");ansi("me");
 dat=BAD_MSG_TOP;
 while (dat) 
 {
  fprintf(fp, " %s\n",dat->line);   
  dat=dat->n;
 }
} else
{
 printf("\nSTOP!
 ----------------------------------------------------------------------------
 %s\n %s
 ----------------------------------------------------------------------------
 \n",GetText("UUD50_MSG"),GetText("UUD50aMSG"));
 switch (bin_typ)
 {
  case 1: /* UUEncode */
        fprintf(fp, " can't send binary-mail (typ-1), please contact admin!\n");
        break;
  case 2: /* BASE64*/
        fprintf(fp, " can't send binary-mail (typ-2), please contact admin!\n"); 
        break;
  case 3: /* PGP*/
        fprintf(fp, " can't send binary-mail (typ-3), please contact admin!\n"); 
        break;        
  default:
  	fprintf(fp, " can't send binary-mail (typ-unknown), please contact admin!\n");
  	break;
 }

}

fprintf(fp, "|------------------------- Message text follows: ------------------------|\n\n");                                                                


 for (timer=0; timer<2; timer++) 
 {
       fgets(ss,STRING,fd);  
       fprintf(fp,"%s",ss);
 }
 fprintf(fp,"Newsgroups: %s\n",ZOPT.OPT->NG);
 fprintf(fp,"Organization: %s\n",ZOPT.OPT->ORGANIZATION);
 fprintf(fp, "X-Mailer: %s%s#k\n\n", VERSION,PATCHLEVEL);            

while (fgets(ss,STRING,fd)!=NULL)   fprintf(fp,"%s",ss);
pclose(fp);
fclose(fd);
} 
 
 
 
 
 
 
/* liest alle 'bad words' in eine Heap-Liste */ 
void LoadBadWord()
{
FILE *fd;
int i;
struct list_t *dat,*dat2;

  sprintf(buf,"%s/etc/list.dirty.dictionary",ZOPT.OPT->HOME);

  dat=BAD_TOP;
  if ((fd=fopen(buf,"r"))!=NULL)
  {
   while (fgets(buf,STRING,fd)!=NULL)
   {
   if ((buf[0]!='#')&&(strlen(buf)>3)) /* kein Kommentar, bzw. leerzeile :) */  
   {
     strcpy(buf,(char *) strings(buf));
     i=strlen(buf)-1;
     while ((buf[i]==SPACE)&&(i>0))
     {
      buf[i]=0;
      i--;
     }
     
     dat2=(struct list_t*) malloc(sizeof(struct list_t));
     dat2->n=NULL;
     strcpy(dat2->line,buf);
     if (!BAD_TOP)  /* anfang */
     {
       BAD_TOP=dat2;
       dat=BAD_TOP;
     } else
     {
       dat->n=(void *) dat2;    
       dat=dat2;
     }
   
   }
   } /* while fgets() */
   fclose(fd); 
  }

}


/* haengt Zeile an Heap-Logfile an */
void AddLog(line)
char *line;
{
struct  list_t *dat,*dat2;


printf("\n%s",line);
 dat2=(struct list_t*) malloc(sizeof(struct list_t));
 dat2->n=NULL;
 strcpy(dat2->line,line);
 dat=BAD_MSG_TOP;
 if (!dat)  /* anfang */
 {
    BAD_MSG_TOP=dat2;
 } else
 {
    dat=BAD_MSG_TOP;
    while(dat->n!=NULL) dat=dat->n;
    dat->n=(void *) dat2;    
 }
 

}
 
 
/* prueft eine Mail-Zeile nach 'bad words' und legt bei Treffer ein
   Heap-Log-File an */ 
 CheckBadLine(line)
 char *line;
 {
 struct list_t *dat,*ldat,*dat2;
 char s[2*STRING];
 
  dat=BAD_TOP;
  
  while (dat!=NULL) 
  {
    strcpy(s,(char *) strings(line));
    if ((strpos((char *) &dat->line, (char *) s)!=0)&&(!TestUUE_Member(ZOPT.OPT->USER.name)))
    {
      sprintf(s,"bad word: \"%s\" (resolution of \"communications decency act 1995\" (P314)), please contact admin for full access!",dat->line);
      AddLog(s);
      sprintf(s,"orginal-line: %s",(char *) strings(line));
      AddLog(s);         
      AddLog("---");
    }
    dat=dat->n;
  }
 }
 
 
 
 
 void CheckBinLine(line)
 char *line;
 {
 char ss[2*STRING];
 int i;
 
  strcpy(ss,(char *) strings(line));
  i=strlen(ss)-1;
  while ((ss[i]==SPACE)&&(i>0))
  {
    ss[i]=0;
    i--;
  }
 
/*  printf("\n(%s)=%d,",ss,strlen(ss));*/
  if (strlen(ss)==BASE64_LEN) BASE64_CONT++; else BASE64_CONT=0;
  
  if (strlen(ss)==PGP_LEN) PGP_CONT++; else PGP_CONT=0;
  
  if ((strlen(ss)==UUE_LEN)&&(ss[0]=='M')) UUE_CONT++; else UUE_CONT=0;
  
  if ((BASE64_CONT>BIN_LINES)||(UUE_CONT>BIN_LINES)||(PGP_CONT>BIN_LINES))
  {
   BIN_CONT++;
   if (UUE_CONT>1) { bin_typ=1; 
                     UUE_CONT=0;
                   }
   if (PGP_CONT>1) { bin_typ=3; 
                     PGP_CONT=0;
                   }                   
   if (BASE64_CONT>1) 
                   {
                    BASE64_CONT=0;
                    bin_typ=2;
                   }
  }
 
 }
 
 
 
 
 /* Checkt Mail nach BIN-Mail und 'bad words'  
    es wird dadurch z.B. UUE-Mail usw. abgefangen!
 */
 int CheckMailForBadActions(mail)
 char *mail;
 {
 FILE *fd;
 char ss[2*STRING];

 
 
/* LoadBadWord();*/
 
 fd=fopen(mail,"r");
 while (fgets(ss,2*STRING,fd)!=NULL) 
 {
   ss[2*STRING]=0;
   CheckBadLine((char *) &ss);
   CheckBinLine((char *) &ss); 

 }
 fclose(fd);
 
}



/* schaelt zwischen PC und UNIX-Zeichensatz um :
  0  -> in Unix
  1  -> auf PC
*/ 
void DipAnsi(mode)
int mode;
{
   switch (mode) 
   {
    case 0:
           printf("\e(B"); /* set unix character set */ 
    	   break;
    case 1:
           printf("\033(K");/*this is for the special characters*/
    	   break;
   }

}



void CleanKeyb()
{
#ifndef _BSD
#if defined(_ESTDIO) || !defined(_SYS7)
         fflush(stdin);
         stdin->_IO_read_end=stdin->_IO_read_ptr=stdin->_IO_read_base;
         /*fpurge(stdin); !else -> Linux may not support fpurge */
#endif
#endif
}


void MSWait(time)
long time;
{
int i, c2=100;

     for (i=0; i<(time/c2); i++)
           if (!keypressed()) msleep(c2);
}





int GetQwkNo()
{

unsigned char s[STRING*3];
int pid,stat;
int i,j=0, p=0;
FILE *fd;
DIR *dp;
char _s[STRING];
     struct dirent *actdir;
     
     sprintf (_s,"%s/usr/%c/%d/qwk/.out",ZOPT.OPT->HOME,ZOPT.OPT->USER.name[0],
      ZOPT.OPT->USER.id);
     dp=opendir(_s);
     for (i=0;i<2;i++) readdir(dp);
     while(((actdir = readdir(dp)) != NULL))
 	{
	strcpy(_s,(char *)cut_bef(punkt2leer(actdir->d_name)));
	j=atoi(_s);
	if (j>p) p=j;
	}
    p++;
    closedir(dp);
    return(p);
}








char *GetGbl(str)
char *str;
{
return((char *)GetASection(1,"[gbl_msg]",str));
} 




int GetSectionInt(section,str)
char *section,*str;
{
char *bla;

bla=(char *) GetASection(0,section,str);
if (atoi(bla)>0)
{
  return(atoi(bla));
}
if (strpos("yes",touppers(bla))==1)
{
  return(1);
}
return 0;
} 




char *GetASection(mode,section,str)
int mode;
char *section,*str;
{
static char s[2*STRING],t[STRING];
int i;
FILE *fd;

sprintf(s,"%s/etc/list.config",ZOPT.OPT->HOME);
if ((fd=fopen(s,"r"))==NULL)
{
  nerror("sexport.c", 1969, "GetGbl", "Can't read", s);
}
while (fgets(s,STRING,fd)!=NULL)
{
  if (strpos(section,touppers(strings(s)))!=0)
  {
#ifdef GDEBUG  
    printf("\nfound: %s",section); sleep(1);
#endif

    while (
           (fgets(s,STRING,fd)!=NULL)        &&
           ('['!=s[0])
          )
    {

#ifdef GDEBUG
         printf("\nfound: '['!=s[0]"); sleep(1);
#endif
         
     if (strpos(touppers(str),cut_leer(touppers(s)))==1)
     {
      i=0;
      strcpy(t,(char *) cut_arg(s));
      if (!mode)
      {
      while (i<80) {
        if (t[i]==SPACE) t[i]=0;
        i++;
      }
      }
      fclose(fd);
      return((char *)&t);
     }
    
    }  
  
  }
}
fclose(fd);
strcpy(t,"not define");
return((char *)&t);
} 

                             