
#undef DEBUG

#include <stdio.h>
#include <string.h>
#include <sys/types.h>

#ifdef _BSD
#undef _POSIX_SOURCE
#include <sys/stat.h>
#define _POSIX_SOURCE
#else
#include <sys/stat.h>
#endif

#include <time.h>
#include <utmp.h>
#include <unistd.h>
#include <errno.h>
#include <pwd.h>
/*#include <stdlib.h>*/

#include <fcntl.h>


#define TRUE 1
#define FALSE 0
#define ZOMBIE "<zombie>"


#ifndef VU
#include "mbox.h"
#include "s_global.h"
#include "procs/whattime.h"
#else
#include "../mbox.h"
#include "../s_global.h"
#include "../procs/whattime.h"
#endif







int user_lim_anzahl()
{
char ex[STRING];
struct usrproc_typ *dat=NULL;
int i=0;


  SRungeGetProc(0);
  dat=ZOPT.OPT->usrproc_top;
  while (dat!=NULL) 
  {
    if ((!strpos("<Shell Acc",dat->user))&&(!strpos("<SLIP",dat->user)))
    {
/*  dat->user,dat->login,dat->tty,dat->time,dat->what);*/
    	i++;
    }
    dat=dat->n;
  }
  
return(i);
}




char *idletime(tty)

char *tty;

{
    struct stat terminfo;
    long idle;
    char ttytmp[40];
    static char give[20];
    time_t curtime;

    curtime = time(NULL);
    sprintf(ttytmp, "/dev/%s", tty);
    stat(ttytmp, &terminfo);
    idle = (curtime - terminfo.st_atime);

    if (idle >= (60 * 60))		/* more than an hour */
    {
	if (idle >= (60 * 60 * 48))	/* more than two days */
	    sprintf(give, "%2ddays", ((int) idle / (60 * 60 * 24)));
	else
	    sprintf(give, " %2d:%s%d", (int) (idle / (60 * 60)), 
		(idle / 60) % 60 < 10 ? "0" : "", (int) ((idle / 60) % 60));
    }
    else
    {
	if (idle / 60)
	    sprintf(give, "%6d", ((int) idle / 60));
	else
	    give[0]=0;
    }

    return give;
}




/* get-idle-time for current tty in double */
long idletime_log()
{
    struct stat terminfo;
    long idle;
    char ttytmp[40];
    time_t curtime;

    curtime = time(NULL);
    if (ttyname(0)==NULL)
     {
       control( "idletime_log(): Terminal lost !!!!!", 3 );
       printf("\nidletime_log(): Terminal lost !!!!!\n");
       exit(-3);
     }
    sprintf(ttytmp, "%s", ttyname(0));
    stat(ttytmp, &terminfo);
    idle = (curtime - terminfo.st_atime);


    return (idle);
}



/*
 * logintime()
 *
 * Returns the time given in a suitable format
 *
 * This routine was lifted from the original w program
 * by Larry Greenfield  (greenfie@gauss.rutgers.edu)
 * Copyright (c) 1993 Larry Greenfield
 *
 */
char *logintime(ut_time)

time_t ut_time;

{
    time_t curtime;
    struct tm *logintime, *curtm;
    int hour, am, curday, logday;
    static char give[20];
    static char *weekday[] = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };
    static char *month[] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul",
				"Aug", "Sep", "Oct", "Nov", "Dec" };

    curtime = time(NULL);
    curtm = localtime(&curtime);
    curday = curtm->tm_yday;
    logintime = localtime(&ut_time);
    hour = logintime->tm_hour;
    logday = logintime->tm_yday;
    am = (hour < 12);

    if (!am)
	hour -= 12;

    if (hour == 0)
	hour = 12;

/*
 * This is a newer behavior: it waits 12 hours and the next day, and then
 * goes to the 2nd time format. This should reduce confusion.
 * It then waits only 6 days (not till the last moment) to go the last
 * time format.
 */
    if ((curtime > (ut_time + (60 * 60 * 12))) && (logday != curday))
    {
	if (curtime > (ut_time + (60 * 60 * 24 * 6)))
	    sprintf(give, "%2d%3s%2d", logintime->tm_mday,
		month[logintime->tm_mon], (logintime->tm_year % 100));
	else
	    sprintf(give, "%*s%2d%s", 3, weekday[logintime->tm_wday],
		hour, am ? "am" : "pm");
    }
    else
	sprintf(give, "%2d:%02d%s", hour, logintime->tm_min, am ? "am" : "pm");

    return give;
}



int TestPID(pid)
int pid;
{
char s[STRING];
struct stat fst;
int i;

sprintf(s,"/proc/%d",pid);
i=stat(s, &fst);
if (((fst.st_mode & S_IFMT)==S_IFDIR) && (i==0))
{
 return(1);
}
else return(0);

}


/* show the number of user */
int user_anzahl()
{
  FILE *fp;
  FILE *pp;
  int fd;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char terms[STRING];
  UNSIGNED char tmp[STRING];
  struct utmp US;
  int k, l,pid; 
  int usr=0;


  chdir(ZOPT.OPT->HOME);
  sprintf(tmp, "%s/%dps", TMP, getpid());
  sprintf(s, "ps -a > %s", tmp);
  ssystem( s );

#ifdef _SYS7
  maybe_locked(UTMP, "r");
  fd = open(UTMP, O_RDONLY);
#else
  maybe_locked(UTMP_FILE, "r");
  fd = open(UTMP_FILE, O_RDONLY);
#endif

  if (fd == -1) {

#ifdef _SYS7
	nerror("portinfo.c", 83, "port", "Can't read", UTMP);
#else
	nerror("portinfo.c", 83, "port", "Can't read", UTMP_FILE);
#endif


  }
  while (read(fd, (UNSIGNED char *) &US, sizeof(US)) == sizeof(US)) {

 	if (US.ut_type == USER_PROCESS) {

		l = atoi((char *) strcopy(US.ut_line, 3, 6));

		sprintf(s, "%s/etc/spool/whatdoes.%s", ZOPT.OPT->HOME, US.ut_line);
		fp = fopen( s, "r" ); pid=0;
		if(fp != NULL){
			fgets(terms, STRING, fp);
			fgets(s, STRING, fp);			
			pid=atoi((char *) s);
			fclose(fp);
			 
			
		}
		if ((fp==NULL)||(TestPID(pid)==0))
		{
			pp = fopen(tmp, "r");
			if (pp == NULL) {
				nerror("portinfo.c", 113, "port", "Can't read", tmp);
			}
			while (fgets(s, STRING, pp) != NULL) {
				k = atoi((UNSIGNED char *) strcopy(s, 8, 10));
				if ((k == l) && (s[17] != '-')) {
					strcpy(t, (UNSIGNED char *) strcopy(s, 21, 40));
					strcpy(t, (UNSIGNED char *) stripped( t ));
					t[27] = 0;
				}
			}
			fclose(pp);
			strcat(terms, t);

		} else usr++;
	}
  }
  close(fd);
  unlink(tmp);
 return(usr);
}
















/* #SL - Show the user levels and permissions. */

void show_level()
{
  headblock( GetText("POR04_MSG"), GetText("POR05_MSG") );

  printf("%s (%d)\n", GetText("POR06_MSG"), GUEST_LEV);
  printf("%s (%d)\n", GetText("POR07_MSG"), ZOPT.OPT->WRITE_IN_LEV);
  printf("%s (%d)\n", GetText("POR08_MSG"), ZOPT.OPT->MAILOUT_LEV);
  printf("%s (%d)\n", GetText("POR09_MSG"), ZOPT.OPT->WRITE_EX_LEV);
  printf("%s (%d)\n", GetText("POR10_MSG"), ZOPT.OPT->WRITE_INTERNAT);
  printf("%s (%d)\n", GetText("POR11_MSG"), ZOPT.OPT->PD_D_LEV);
  printf("%s (%d)\n", GetText("POR12_MSG"), ZOPT.OPT->PD_U_LEV);
  printf("%s (%d)\n", GetText("POR12a_MSG"),ZOPT.OPT->PD_U_LEV+1);
  printf("%s (%d)\n", GetText("POR12b_MSG"),DIRECT_UPLOAD_LEVEL);
  printf("%s (%d)\n", GetText("POR12c_MSG"),ZOPT.OPT->PD_U_LEV+2);
  printf("%s (%d)\n", GetText("POR14_MSG"), ADMIN_LEV);

  printf("\n%s (%d), %s !\n\n", GetText("POR15_MSG"), ZOPT.OPT->USER.level, ZOPT.OPT->USER.name);
}





/* #UL - Show one of a couple of userlists.

   [arg]    ->  ''    = Username and ID, only
                '*'   = Name, last call etc.
                '#'   = Name, Up- / Download
                '$'   = Fees/Charges
                '%'   = Name, level, newsgroups */

void userliste(arg)
UNSIGNED char arg[];
{
  FILE *fp;
  int fd;
  struct userdaten LOOSER;
  UNSIGNED char s[STRING];
  UNSIGNED char u[(STRING*2)];
  UNSIGNED char tmp[STRING];
  UNSIGNED char t[STRING];
  int i = 0, z;
  int mode = 0;
  int totalusr = 0;
  int totalact = 0;
  int totalgas = 0;

  UNSIGNED char c;

  if (arg[0] == '*') mode = 1;
  if ((arg[0] == '#') && (ZOPT.OPT->USER.level >= ADMIN_LEV)) mode = 2;
  if ((arg[0] == '$') && (ZOPT.OPT->USER.level >= ADMIN_LEV)) mode = 3;
  if (arg[0] == '%') mode = 4;
  if ((arg[0] > 47) && (mode == 0)){
	finger(arg);
	return;
  }
 
  show(UDBASE, 99, 99); /* RESET */

  if(mode == 0){
	if(ZOPT.OPT->USER.schluessel[3] != 128)
		headline( GetText("POR15aMSG") );
	else
		show_raw( ANSI_USERS, ANSI_USER );
  }
  else{
	if(mode == 1)
		headblock( GetText("POR15aMSG"), GetText("POR16_MSG") );

	if(mode == 2)
		headblock( GetText("POR15aMSG"), GetText("POR18_MSG") );

	if(mode == 3)
		headblock( GetText("POR15aMSG"), GetText("POR18aMSG") );

	if(mode == 4)
		headblock( GetText("POR15aMSG"), GetText("POR18bMSG") );

	printf("%s", GetText("POR17_MSG"));
  }
  
  sprintf(tmp, "%s/%d", TMP, getpid());
  fp = fopen(tmp, "w");
  if (fp == NULL) {
	nerror("portinfo.c", 231, "userliste", "Can't write to", tmp);
  }
  /*maybe_locked(UDBASE, "r");*/
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	nerror("admin.c", 254, "userliste", "Can't read", UDBASE);
  }
  while (read(fd, (UNSIGNED char *) &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER)) {
	if (mode == 0) {
		sprintf(u, "%s", LOOSER.name);
		sprintf(s, " (%d) ", LOOSER.id);		
		u[26 - strlen(s)] = 0;
		strcat(u, s); strcat(u, "                                ");	
 		u[26] = 0;
		fprintf(fp, "%s", u);
		i++;
		if (i == 3) {
			i = 0;
			fprintf(fp, "\n");
		}
	}
	if (mode == 1) {
		sprintf(s, "%s", LOOSER.name);
		s[24] = 0;
		sprintf(u, "%s [%d]", s, LOOSER.id);

		sprintf(s, "%s", "   ");
		if ((LOOSER.elapsed / 60) > 2) {
			if (LOOSER.wohnort[0] < 48) {
				if 
				 (
				  (!(((i=(MuellTest(0,LOOSER.name)))!=NULL)&&(strlen(LOOSER.name)>2) ))
				   ||
				  (!((i=(MuellTest(1,LOOSER.nick)))!=NULL) )
				   ||
				  (!((i=(MuellTest(0,LOOSER.wohnort)))!=NULL))
				   ||
				  (!((i=(MuellTest(0,LOOSER.strasse)))!=NULL))
				   ||
				  (!((i=(MuellTest(0,LOOSER.telefon1)))!=NULL))
				   ||
				  (!((i=(MuellTest(0,LOOSER.telefon2)))!=NULL))				 
				   ||
				  (!((i=(MuellTest(0,LOOSER.geburtsdatum)))!=NULL))
				 )
					sprintf(s, "%s", "<?>");
			}
		}
		else {
			sprintf(s, "%s", "{-}");
		}
		if (LOOSER.seq == 1) {
			sprintf(s, "%s", "<!>");
		}
		fprintf(fp, "%-30.30s  %10s %s%6d %8ld\"  %5d%10.10s\n",
			u, LOOSER.lastlog, s, LOOSER.seq, (LOOSER.elapsed / 60), LOOSER.level, LOOSER.sh_name);

	}
	if (mode == 2) {
		fprintf(fp, "%-30.30s  %8d kB  %10d kB %8d\"\n",
			LOOSER.name, LOOSER.upratio, LOOSER.downratio, (LOOSER.elapsed / 60));
	}
        if (mode == 3) {
		if((atoi(LOOSER.account) > 0) && (LOOSER.level >= ZOPT.OPT->WRITE_EX_LEV)){
			if(LOOSER.account[0] == 0) strcpy(LOOSER.account, "00.00.0000");
			strcpy(s, LOOSER.account);
			s[10] = 0;
			c = ' ';
			strcpy(t, (UNSIGNED char *) strcopy(LOOSER.account, 11, 16));
			z = atoi(t);			
			if(strcomp("01.01.2001", s) != 0L)
				fprintf(fp, "%-30.30s  %5d   %c %s $\n",  
					LOOSER.name, LOOSER.id, c, s);
			else
				fprintf(fp, "%-30.30s  %5d   %c %s\n",  
					LOOSER.name, LOOSER.id, c, s);

		}
        }
        if (mode == 4) {
		fprintf(fp, "%-15.15s %5d %4d    %s\n",
			LOOSER.name, LOOSER.id, LOOSER.level, LOOSER.newsgrps);
	}       
	totalusr++;
	sprintf(s, "%s", (UNSIGNED char *) mydate( 0 )); 
	if( ((long) dateconv(s) - (long) dateconv(LOOSER.lastlog)) < 30 ) totalact++;
	if(strcomp(GUEST, LOOSER.name) == 0) totalgas = LOOSER.seq;
  }
  close(fd);

  fclose(fp);

  if (mode != 0) {
	printf("%c", CR);
	sprintf(s, "sort -d -o %s %s", tmp, tmp);
	ssystem(s);
	show(tmp, 9999, ZOPT.OPT->USER.more + 100);
	if (mode == 1) {
		printf("\n%s\n%s\n%s\n%s", GetText("POR19_MSG"), GetText("POR20_MSG"),
		   GetText("POR20a_MSG"), GetText("POR20b_MSG"));
	}
  }
  else{
	if(ZOPT.OPT->USER.schluessel[3] != 128)
		show(tmp, 9999, ZOPT.OPT->USER.more);
	else
		show(tmp, 9999, ZOPT.OPT->USER.more + 1000);
  }
  if(mode == 0){
	printf("\n\n%s %d %s %d %s", GetText("POR21_MSG"), totalusr, GetText("POR22_MSG"), totalact, GetText("POR23_MSG")); 
	printf("\n%s %d %s", GetText("POR24_MSG"), totalgas, GetText("POR25_MSG"));
  }
  printf("\n");
  unlink(tmp);
}






/* #FI - Get and show information on a user [arg]. 

   [arg] could be a username or a user-id. */

int finger(arg)
UNSIGNED char arg[];
{
  int fd;
  struct userdaten DUMMY, LOOSER;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  long ll = -1L;
  size_t dummy = sizeof(DUMMY);
  UNSIGNED char c;
  UNSIGNED char ex[LONGSTRING];
  int i, ok, a, b;
  int uid = -1;
  UNSIGNED char name[STRING];
  UNSIGNED char domain[STRING];	  


  FILE *fp;

  
  if ((arg[0] > 47) && (arg[0] < 58)) {
	uid = atoi(arg);
  }
  else{
	a = 0; b = 0;
	i = 0;
	while(arg[i] != 0){	
		if(arg[i] == '!') a = i;
		if(arg[i] == '@') b = i;
		i++;
	}
	if((a != 0) && (b == 0)){
		if(a != 0){
			strcpy(name, (UNSIGNED char *) strcopy(arg, (a+1), strlen(arg)));
			strcpy(domain, (UNSIGNED char *) strcopy(arg, 0, (a-1)));
		}
		else{
			strcpy(name, (UNSIGNED char *) strcopy(arg, 0, (b-1)));
			strcpy(domain, (UNSIGNED char *) strcopy(arg, (b+1), strlen(arg)));
		}
		strcpy(t, ZOPT.OPT->USER.name);
		i = 0;
		while(t[i] != 0){
			if(t[i] == ' ') t[i] = '.';
			i++;
		}
		chdir( "/" );
		sprintf(s, "%s %s!%s!\"finger %s\" \\| mail %s@%s", ZOPT.OPT->UUX, ZOPT.OPT->SMARTHOST, 
		    domain, name, t, ZOPT.OPT->UUCPID);
		ssystem( s );
		chdir( ZOPT.OPT->HOME );
		printf("\n\n%s \"%s\",\n%s \"%s\" %s.", GetText("POR25aMSG"), name, GetText("POR25bMSG"), domain, GetText("POR25cMSG"));
		ansi2( "md", 0, 0 );
		printf("\n%s\n", GetText("POR26_MSG"));
		ansi2( "me", 0, 0 );
		return(0);
	}
	else{
		if(b != 0){
			ansi2( "md", 0, 0 );
			printf(" <- %s\n\n", GetText("POR26aMSG"));
			ansi2( "me", 0, 0 );
			return(0);
		}
	}
  }

  /*maybe_locked(UDBASE, "r"); mblock(UDBASE);*/
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	nerror("admin.c", 324, "aendern", "Can't read", UDBASE);
  }
  while (read(fd, (UNSIGNED char *) &DUMMY, dummy) == dummy) {
	if (uid == DUMMY.id) {
		ll = lseek(fd, 0L, SEEK_CUR) - dummy;
	} 
	else{
		if ((strcomp(arg, DUMMY.name) == 0) ||
		    (strcomp(arg, DUMMY.nick) == 0) ||
		    (strcomp(arg, DUMMY.sh_name) == 0)) {
			ll = lseek(fd, 0L, SEEK_CUR) - dummy;
		}
	}
  }
  lseek(fd, ll, SEEK_SET);
  read(fd, (UNSIGNED char *) &LOOSER, sizeof(LOOSER));
  close(fd);
  mbunlock(UDBASE);

  if (ll == -1L) {
	ansi2( "md", 0, 0 );
	printf(" <- %s\n\n", GetText("POR27_MSG"));
	ansi2( "me", 0, 0 );
	return(0);
  }

  sprintf(s, " %s: %s ", GetText("POR28_MSG"), arg);
  headline( s );

  ansi2( "md", 0, 0 );
  printf("\n%s ", GetText("POR29_MSG"));
  ansi2( "me", 0, 0 );
  printf("%d\n", LOOSER.id);

  ansi2( "md", 0, 0 );
  printf("%s ", GetText("POR30_MSG"));
  ansi2( "me", 0, 0);
  printf("%s\n", LOOSER.name);

  if(LOOSER.sh_name[0] != 0){
	ansi2( "md", 0, 0 );
	printf("%s ", GetText("POR31_MSG"));
	ansi2( "me", 0, 0 );
	printf("%s\n", LOOSER.sh_name);
  }

  if(LOOSER.nick[0] != 0){
	ansi2( "md", 0, 0 );
  	printf("%s ", GetText("POR32_MSG"));
	ansi2( "me", 0, 0 );
	printf("%s\n", LOOSER.nick);
  }

  ansi2( "md", 0, 0 );
  printf("%s ", GetText("POR33_MSG"));
  ansi2( "me", 0, 0 );
  strcpy(s, LOOSER.name);
  i = 0;
  while(s[i] != 0){
	if(s[i] == ' ') s[i] = '.';
	i++;
  }
  if(LOOSER.level >= ZOPT.OPT->WRITE_INTERNAT)
	printf("%s@%s\n", s, ZOPT.OPT->UUCPID2);
  else
	printf("%s@%s\n", s, ZOPT.OPT->UUCPID1);

  printf("\n"); ok = 0;

  if(ZOPT.OPT->USER.level >= ZOPT.OPT->WRITE_EX_LEV){
	if(LOOSER.wohnort[0] != 0){
		ok++;
		ansi2( "md", 0, 0 );
		printf("%s ", GetText("POR34_MSG"));
		ansi2( "me", 0, 0 );
		printf("%s\n", LOOSER.wohnort);
	}
  }

  if(ZOPT.OPT->USER.level >= ADMIN_LEV){
	if(LOOSER.strasse[0] != 0){
		ok++;
		ansi2( "md", 0, 0 );
		printf("%s ", GetText("POR35_MSG"));
		ansi2( "me", 0, 0 );
		printf("%s\n", LOOSER.strasse);
	}
	if(LOOSER.telefon1[0] != 0){
		ok++;
		ansi2( "md", 0, 0 ); 
		printf("%s ", GetText("POR36_MSG"));
		ansi2( "me", 0, 0 );
		printf("%s", LOOSER.telefon1);

		if(LOOSER.telefon2[0] != 0){
			printf(" // %s\n", LOOSER.telefon2);
		}
		else{
			printf("\n");
		}
	}

	if(ok != 0) printf("\n"); 
	ok = 0;

	if(LOOSER.geburtsdatum[0] != 0){
		ok++;
		ansi2( "md", 0, 0 );
		printf("%s ", GetText("POR37_MSG"));
		ansi2( "me", 0, 0 );
		printf("%s\n", LOOSER.geburtsdatum);
	}
  }

  if(ok != 0) printf("\n");

  if(ZOPT.OPT->USER.level >= ZOPT.OPT->WRITE_EX_LEV){
	ansi2( "md", 0, 0 );
	printf("%s ", GetText("POR38_MSG"));
	ansi2( "me", 0, 0 );
	printf("%d\n", LOOSER.seq);
  	ansi2( "md", 0, 0 );
	printf("%s ", GetText("POR39_MSG"));
	ansi2( "me", 0, 0 );
	printf("%s // %s\n", LOOSER.lastlog, (UNSIGNED char *) timereconv(LOOSER.lasttime));
  }

  ansi2( "md", 0, 0 );
  printf("%s ", GetText("POR45_MSG"));
  ansi2( "me", 0, 0 );
 
  b = 0;
  sprintf(s, "%s/usr/%c/%d/INDEX", ZOPT.OPT->HOME, LOOSER.name[0], LOOSER.id);  
	
  fp = fopen(s, "r");
  if (fp == NULL) {
	nerror("intro.c", 291, "intro", "Can't read", s);
  }
  while (fgets(ex, LONGSTRING, fp) != NULL){
	if(ex[0] < 65) b++;
  }
  fclose(fp);
  printf("%d\n", b-1);

  if(ZOPT.OPT->USER.level >= ADMIN_LEV){
	ansi2( "md", 0, 0 );
	printf("%s ", GetText("POR40_MSG"));
	ansi2( "me", 0, 0 );
	b = LOOSER.elapsed/(3600*24);
	printf("%d %s, ", b, GetText("POR41_MSG"));
	a = (LOOSER.elapsed - (b*(3600*24)))/3600; 
	printf("%d %s, ", a, GetText("POR41aMSG"));
        b = (LOOSER.elapsed - (b*(3600*24)) - (a*3600))/360;
   	printf("%d %s\n", b, GetText("POR41bMSG"));
        ansi2( "md", 0, 0 );
        printf("%s ", GetText("POR41cMSG"));
        ansi2( "me", 0, 0 );
        printf("%s\n", LOOSER.account);
	ansi2( "md", 0, 0 );
	printf("%s ", GetText("POR42_MSG"));
	ansi2( "me", 0, 0 );
	printf("%ld %s\n", LOOSER.upratio, GetText("POR43_MSG"));
	ansi2( "md", 0, 0 );
	printf("%s ", GetText("POR44_MSG"));
	ansi2( "me", 0, 0 );
	printf("%ld %s\n", LOOSER.downratio, GetText("POR43_MSG"));
  }

  printf("\n");

  sprintf(s, "%s/usr/%c/%d/.plan", ZOPT.OPT->HOME, LOOSER.name[0], LOOSER.id);  
  fp = fopen( s, "r" );
  if(fp != NULL){
	fclose(fp);
 
	ansi2("mr", 0, 0);
	printf("%c%s [%c, %c] > ", CR, GetText("POR46_MSG"), GetEChar("GBL06_MSG"), GetEChar("GBL07_MSG"));
	ansi2("me", 0, 0);

	c = yesno();

	if (c == GetEChar("GBL06_MSG")) {
		sprintf(s, " %s: %s ", GetText("POR28_MSG"), arg);
		headline( s );

		sprintf(s, "%s/usr/%c/%d/.plan", ZOPT.OPT->HOME, LOOSER.name[0], LOOSER.id);
		show( s, 9999, ZOPT.OPT->USER.more );	
	}
  }

  printf("\n");
  return(0);
}





/* #RA - Add an entry for every user in smails aliases DB */

void new_user_dir()
{
  FILE *fp;
  int fd;
  struct userdaten LOOSER;
  UNSIGNED char s[STRING];

  int i;

  headline( " Updating User Directories " );

  printf("\n");

  /*maybe_locked(UDBASE, "r");*/
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	nerror("admin.c", 254, "userliste", "Can't read", UDBASE);
  }
  while (read(fd, (UNSIGNED char *) &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER)) {

	for(i = 'A'; i <= 'Z'; i++){
		sprintf(s, "%s/usr/%c", ZOPT.OPT->HOME, i);
#ifndef _LINUX
		mkdir( s );
		chmod( s, 0777 );
#else
		mkdir( s, 0777 );
#endif
	}

	sprintf(s, "%s/usr/%d/.dummy", ZOPT.OPT->HOME, LOOSER.id); /* New User-Directory !!! */

	printf("%s (%d)", LOOSER.name, LOOSER.id);

	fp = fopen( s, "w" );
	if(fp != NULL){
		fclose(fp);
		unlink(s);
		sprintf(s, "%s/usr/%c", ZOPT.OPT->HOME, LOOSER.name[0]);
#ifndef _LINUX
		mkdir( s );
		chmod( s, 0777 );
#else
		mkdir( s, 0777 );
#endif
		sprintf(s, "%s/usr/%c/%d", ZOPT.OPT->HOME, LOOSER.name[0], LOOSER.id);
#ifndef _LINUX
		mkdir( s );
		chmod(s , 0777 );
#else
		mkdir( s, 0777 );
#endif
		sprintf(s, "cp %s/usr/%d/.* %s/usr/%c/%d > /dev/null 2>&1", ZOPT.OPT->HOME, LOOSER.id, ZOPT.OPT->HOME, LOOSER.name[0], LOOSER.id);
		ssystem( s );
		sprintf(s, "cp %s/usr/%d/* %s/usr/%c/%d > /dev/null 2>&1", ZOPT.OPT->HOME, LOOSER.id, ZOPT.OPT->HOME, LOOSER.name[0], LOOSER.id);
		ssystem( s );
		sprintf(s, "rm -r %s/usr/%d > /dev/null 2>&1", ZOPT.OPT->HOME, LOOSER.id);
		ssystem( s );
	}

	printf("%c                                                                  %c", CR, CR);
  }
  close(fd);

  printf("\n");
}


void rebuild_aliases()
{
  int fd;
  struct userdaten LOOSER;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];

  int i;

  headline( " Rebuilding Aliases Database" );

  printf("\n");

  maybe_locked(UDBASE, "r");
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	nerror("portinfo.c", 800, "userliste", "Can't read", UDBASE);
  }
  while (read(fd, (UNSIGNED char *) &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER)) 
  {

	i = 0;
	strcpy(t, (UNSIGNED char *) LOOSER.name);
	while(t[i] != 0){
		if(t[i] == ' ') t[i] = '.';
		i++;
	}
	
	sprintf(s, "./etc/alias.sh \"%s\"", t);
	ssystem( s );
	printf("%s\n", t);
  }
  close(fd);

  printf("\n");
}



struct usrproc_typ *TToggleUser(top,z)
struct usrproc_typ *top;
unsigned char z[];
{
  struct usrproc_typ *d;
  
  d=ZOPT.OPT->usrproc_top;
  z[strlen(z)-1]=0;
  while (d!=NULL) 
  {
    if ((strpos(z,d->tty))!=0) /* wenn es der user ist */
     {
      d->on=(!d->on);
      return(d);
     }
    d=d->n;
  } 
  return(NULL);
}









int FindUSRTTY(top,z)
struct userproc_typ *top;
unsigned char *z;
{
  struct usrproc_typ *dat;

  z[strlen(z)-1]=0; /* letztes Space muss weg */
  dat=(struct usrproc_typ *) top;
  while (dat!=NULL) 
  {
    if ( ( strpos(z,dat->tty) )!=0) /* wenn es der user ist */    
      return(1);
    dat=dat->n;
  } 
  return(0);
}




void TTYTalkExec(user)
struct usrproc_typ *user;
{
unsigned char kk[STRING];
 sprintf(kk,"talk %s %s",user->login /*user*/,user->tty);
 whodo(kk);
 sprintf(kk,"%s %s#%s",TALK,user->login,user->tty);
 ssystem(kk);
}





/* welcher Prozess gehoert zu dieser PID ? */
char *GetWhatIs(pid)
int pid;
{
static char s[STRING];
int ist;
unsigned char str[STRING];
FILE *fd;

sprintf(s,"%s/tmp/%dproc.~", ZOPT.OPT->HOME,getpid());


if ((fd=fopen(s,"r"))!=NULL)
{

while (fgets(s,STRING,fd)!=NULL)
{
 strcpy(str,s); str[5]=0;
 ist=atoi(str);
  if (pid==ist)
  {
   fclose(fd);
   strcpy(s,(char *) strings(s));
   strcpy(s,(char *) &s[21]);
/*   strcpy(s,"test :)");*/
   return((char *) &s);
  }
}
fclose(fd);
}
else nerror("portinfo.c", 1158, "GetWhatIs", "Can't read", s);
return(NULL);
}


/* welcher (aktueller) Prozess gehoert zu diesem tty ? */
char *GetWhatIsTTY(tty)
char *tty;
{
static char s[2*STRING];
char str[STRING],txt[2*STRING];
FILE *fd;

sprintf(s,"%s/tmp/%dproc.w~", ZOPT.OPT->HOME,getpid());


if ((fd=fopen(s,"r"))!=NULL)
{
sprintf(str,"%s ",tty); 
while (fgets(s,100,fd)!=NULL)
{
/*  printf("\nstr:(%s), s:(%s)",str,s); sleep(1);*/
  if (strpos(str,s)==10)
  {
    
   fclose(fd);
   strcpy(txt,(char * ) strings(s));
   txt[80]=0;
   strcpy(s,(char *) &txt[27]); /* 43 altes linux ??? */
   s[80]=0;
/*   printf("\n(%s) OK!!!:  s:(%s), txt:(%s)",tty,s,txt);*/
   return((char *) &s);
  }
}
printf("NULL");
fclose(fd);
} else nerror("portinfo.c", 1158, "GetWhatIs", "Can't read", s);
strcpy(s,"-");
return((char *) &s);
}








/*-----------------------------------------------------------------------*/


void SetBBSPortInfo(d)
struct usrproc_typ *d;
{
char f[STRING],h[STRING],s[STRING];
FILE *fd;
int i;

  sprintf(f,"%s/etc/spool/whatdoes.%s",ZOPT.OPT->HOME,d->tty);
  
  if ((fd=fopen(f,"r"))!=NULL)
  {

   if (fgets(h,STRING,fd)!=NULL)
   {
    h[75]=0;
    fgets(s,STRING,fd);
    i=atoi((char *) s);
/*    printf("\ns=(%s);i=(%d)\n",s,i);*/

    if (TestPID(i))   /* wenn dieser BBS-Prozess  noch aktiv ist */
    {
     h[STRING-1]=0;
     d->bbs=1;
     strcpy(d->what,(char *) strings(&h[52]));
     h[35]=0;
     strcpy(d->user, h);
    }
    fclose(fd);
   }

  }
 }



void  SRungeGetProc(mode)
int mode;  
/* mode: 	== 0 	Normal-Mode
 *		== 1	Test-Mode (Ausgabe)
 */		
{


int  ignore_user=FALSE;
int i;
struct utmp *utmp_rec;

struct passwd *passwd_entry;
uid_t uid=0;
char username[9], tty[13], rhost[17], login_time[27];
char idle_time[7], what[256];
char search_name[9];


                                                    


void CleanProc()
{
struct usrproc_typ *_d,*d2;
 
 _d=(struct usrproc_typ  *) ZOPT.OPT->usrproc_top;
 while (_d!=NULL)
 {
  d2=_d;
  _d=_d->n;
  free(d2);
 }
 ZOPT.OPT->usrproc_top=NULL;
}









void SetLoop()
{
struct usrproc_typ *d2,*d;

search_name[0] = 0;

/*
 * Process user information.
 *
 * getutent() opens the utmp file for us,
 * and reads off the first record.
 * If the file was already opened, it reads the
 * subsequent record for us. See man page for more info.
*/

ZOPT.OPT->usrproc_top=NULL;
setutent();          
    while (utmp_rec = getutent())
    {

/*
 * Check we actually want to see this record.
 * It must be a valid active user process,
 * and match a specified search name.
 */
	if ( (utmp_rec->ut_type == USER_PROCESS)
	  && (strcmp(utmp_rec->ut_user, ""))
	  && ( (search_name[0] == 0)
	    || ( (search_name[0] != 0)
	    && !strncmp(search_name, utmp_rec->ut_user, 8) ) ) )
	{
	

/*
 * Important note:
 *
 * Strings in the utmp struct are *NOT*
 * necessarily null terminated :-(
 * This only occurs if the string fills
 * up its allocated space exactly.
 * If it is shorter, it is terminated by a null.
 * Because of this, strcpy breaks, and strncpy
 * won't necessarily add a terminator, so we have to
 * do it ourselves. The non-null-terminated string
 * can also cause problems for printf type calls,
 * otherwise I'd just read it direct !
 */

/* Get the username */
	    for (i = 0; i < 8; i++)
	    {
		username[i] = 0;

		if (utmp_rec->ut_user[i] != 0)
		    username[i] = utmp_rec->ut_user[i];
		else
		    i = 8;
	    }
           username[8]=0;  /* not null-term !!! */


/* If necessary, find out the uid of that user (from their passwd entry) */
 /*
	    if (ignore_user == FALSE)
	    {
		passwd_entry = getpwnam(username);
		uid = passwd_entry->pw_uid;
	    }
*/	   


/* Get the tty line */
	    for (i = 0; i < 6; i++)
	    {
		tty[i] = 0;

		if (utmp_rec->ut_line[i] != 0)
		    tty[i] = utmp_rec->ut_line[i];
		else
		    i = 6;
	    }


/* Don't other getting info if it's not asked for */
            
/* Get the remote hostname */
		for (i = 0; i < 15; i++)
		{
		    rhost[i] = 0;

		    if (utmp_rec->ut_host[i] != 0)
			rhost[i] = utmp_rec->ut_host[i];
		    else
			i = 15;
		}


/*
 * Get the login time
 * (Calculated by LG's routine, below)
 */
		strcpy(login_time, logintime(utmp_rec->ut_time));



/*
 * Get the idle time.
 * (Calculated by LG's routine, below)
 */
	    strcpy(idle_time, idletime(tty));



/*
 * That's all the info out of /etc/utmp.
 * The rest is more difficult.
 * We use the pid from utmp_rec->ut_pid to look in /proc for the info.
 * NOTE: This is not necessarily the active pid, so we chase
 * down the path of parent -> child pids until we find it,
 * according to the information given in /proc/<pid>/stat.
 */


	    what[0] = 0;
	    
/*	    
printf("\nuser: (%s), uid: %d, tty: (%s)",username,uid,tty);
printf("\n  host: (%s), login-time: (%s), idle (%s)\n",rhost,login_time,idle_time);	    
printf("\n  what: (%s)\n",GetWhatIs(utmp_rec->ut_pid));
*/
 d=ZOPT.OPT->usrproc_top; d2=NULL;
 while (d!=NULL)
 {
    d2=d;
    d=d->n;
 }
 d=(struct usrproc_typ *) malloc(sizeof(struct usrproc_typ));
 d->n=NULL; d->bbs=0;
 
 strcpy(d->user,username);
 strcpy(d->login,d->user); 
 if (username[0]!='S')
   strcat(d->user,"<Shell Account>");
  else
   strcat(d->user,"<SLIP/PPP>");
 strcpy(d->tty,tty);
 /*sprintf(d->what,"%-50.50s",GetWhatIs(utmp_rec->ut_pid));*/
 strcpy(d->what,GetWhatIsTTY(d->tty));
 strcpy(d->rhost,rhost);
 sprintf(d->time,"%s %s",login_time,idle_time);
 
         
 SetBBSPortInfo(d);
 if (d2==NULL)  ZOPT.OPT->usrproc_top=d;
  else d2->n=d;
    
          
/* !!!!!!!!!!!!!!!!!!!!         */


   } /* while ->  usr-proc */
 }  /*  while -> utmp */
}




unsigned char f[2*STRING];


search_name[0] = 0;
if (ZOPT.OPT->usrproc_top!=NULL) CleanProc();
ZOPT.OPT->usrproc_top=NULL;

if (chdir("/proc"))
{
   nerror("portinfo.c", 1245, "RungeGetProc()", "t-bbs: fatal error: cannot access /proc", "/proc-filesystem-failure");
}
chdir(ZOPT.OPT->HOME);                                    

/*
sprintf(f,"ps -xa >%s/tmp/%dproc.~", ZOPT.OPT->HOME,getpid());
ssystem(f);
*/

sprintf(f,"w -s >%s/tmp/%dproc.w~", ZOPT.OPT->HOME,getpid());
ssystem(f);

  SetLoop();


 sprintf(f,"%s/tmp/%dproc.~", ZOPT.OPT->HOME,getpid());
 unlink(f);
 
 sprintf(f,"%s/tmp/%dproc.w~", ZOPT.OPT->HOME,getpid());
 unlink(f); 
 
 
}


/*-----------------------------------------------------------------------*/



void TTY_YTalk()  /*  Terminal-Version "Talk zu User" */
{
/* const */
int MAXZEILE = 22;  /* Bildschirm-Zeilen mit Font 1, Groesse 2*/


 unsigned char s[STRING];
 int i=0;
 struct usrproc_typ *dat,*user=NULL;
 unsigned char t[STRING];
 

void SetRahmen()
{
 unsigned char kk[STRING];

 sprintf(kk,"%s",(char *)GetText("SUB61_MSG"));
 whodo(kk);
 headline(GetText("SUB62_MSG"));
 headblock( GetText("SUB62_MSG"), GetText("SUB65_MSG") );
}



 
 

void Titel()
{
}
 
 
 
 
void SetBalken()
{
if (!(strpos("<Shell Acc",dat->user)||strpos("<SLIP",dat->user))) ansi2("md");
printf("%-20.20s %-15.15s  %-6.6s  %-30.30s\n",
  dat->user,dat->login,dat->tty,dat->what);
  i++;
  ansi((char *) "me");
  
} 
 

 

void Entry()
{ 
int abbruch;

i=1; 
chdir(ZOPT.OPT->HOME); 
abbruch=0;
if (ZOPT.OPT->usrproc_top!=NULL)  /* wenn UsrProc-Info da ist */
{
  while ( (dat!=NULL) && (i<MAXZEILE))
  {
  			  SetBalken(); 
  			  dat=dat->n;
  } 
 } 
  
  if (ZOPT.OPT->usrproc_top==NULL) {
   printf("\n%s",GetText("RIP37f"));
  } else
  if ((i==1)||(dat==NULL)) {
   ansi("us");
   printf("\n%s",GetText("RIP37b")); /* Ende der Liste */
   ansi("me");
  } else
  {
   printf("\n%s\n",GetText("RIP70a"));
  }
 
  
  chdir(ZOPT.OPT->HOME);
  printf("\n%s",GetText("RIP34c"));
 
} /* ende Screen Func */





NLOOP: 
 SetRahmen();
 Titel();
 SRungeGetProc(0);
 dat=ZOPT.OPT->usrproc_top;
 if (dat==NULL) nerror("RipPortInfo.c", 809, "Rip_TYTalk/main", "(dat==NULL)", "no Portinfo");
NCD:
Entry();
 
 do
 {
  ansi2("me",0,0);printf("\n");
  gets(s);
  
    strcpy(s,(char *) strings(s));
    i=strlen(s)-1;
    while (i!=0) {
      if (s[i]==SPACE) s[i]=0;
      i--;
    }  
  
  strcpy(t,s);  
  if (  (strpos("q",t)!=1) && (!FindUSRTTY(ZOPT.OPT->usrproc_top,t)) ) 
  { /*ungueltiger Nummer */
   printf("\n'%s': %s\n ",s,
        GetText("RIP35c")/*,GetText("SUB66_MSG")*/); Beep();
   printf("\n");
   if (s[0]==SPACE) return;
   gets(s);
   goto NLOOP;
  } else 
  if ((strlen(s)>2)&&(!strpos("q",s))) 
  {		/* setzen des users */
     
    user=TToggleUser(ZOPT.OPT->usrproc_top,strings(s));
    
    /*printf("\n%s: gesetzt",s);  */
    if (user!=NULL)
    {
     if (strpos(user->tty,ttyname(0))!=0)
      {
       printf("\n%s %c",GetText("RIP76"),BELL);
      strcpy(user->user,"");
      } else
     TTYTalkExec(user);
      return;
     } else{ 
       printf("\n'%s': %s\n %s",s,
        GetText("RIP35c"),GetText("SUB66_MSG")); Beep();
      printf("\n");
      gets(s);
     }
  } else 
  
  if (strpos("q",s)!=1) goto NCD;
     
     
 } while ((!strpos("q",s))&&(strlen(s)>0));
 
 
}











/* #PO - Show who is doing what ... */

void port(arg)
UNSIGNED char arg[];
{
char ex[STRING];
struct usrproc_typ *dat=NULL;
int i;

  chdir(ZOPT.OPT->HOME);
  if(ZOPT.OPT->USER.schluessel[3] != 128){
        sprintf(ex,"%-9.9s: %-69.69s",GetText("POR01_MSG"),sprint_uptime());
	headblock( ex, GetText("POR02_MSG") );
  }
  else{
  
	if (!ZOPT.OPT->RIP_ON) show_raw( ANSI_PORTINFO, ANSI_PORT);
	strcpy(ex, (UNSIGNED char *) GetText("POR02_MSG") );
	ex[79] = 0;
	ansi( "md");
	printf("%s\n", ex );
	ansi2( "me" );
  }

  printf("%s ...%c", GetText("POR03_MSG"), CR);

#ifdef DEBUG
printf("\nvor proc");
#endif

  SRungeGetProc(0);

#ifdef DEBUG  
printf("\nnach  proc");
#endif

  if (ZOPT.OPT->usrproc_top!=NULL)  /* wenn UsrProc-Info da ist */
  {
   
    dat=ZOPT.OPT->usrproc_top;
    while ( (dat!=NULL) )
	{
	   i=0;
	   if(arg[0] == '$') 
	   {
   	     if ((strpos("<Shell Acc",dat->user))||(strpos("<SLIP",dat->user)))
   	     {
  		 printf("%-20.20s %-5.5s %-13.13s %-6.6s %-15.15s%-15.15s\n",
		  dat->user,dat->login,dat->rhost,dat->tty,dat->time,dat->what);
		i++;
	      }
	   }
	   if ((arg[0] == '%') &&(i==0))
	   {
		if (!(((strpos("<Shell Acc",dat->user))||(strpos("<SLIP",dat->user)))))
		{ 
		 printf("%-20.20s %-5.5s %-13.13s %-6.6s %-15.15s%-15.15s\n",
		           dat->user,dat->login,dat->rhost,dat->tty,dat->time,dat->what);
		 /*               
  		 printf("%-20.20s %-8.8s %-6.6s %-16.16s%-25.25s\n",
		  dat->user,dat->login,dat->tty,dat->time,dat->what);
		 */
		}
		i++;
	   }
	   if(i == 0) 
	   {
		if (!(((strpos("<Shell Acc",dat->user))||(strpos("<SLIP",dat->user))))) ansi2("md");
		/*
  		 printf("%-20.20s %-8.8s %-6.6s %-16.16s%-25.25s\n",
		  dat->user,dat->login,dat->tty,dat->time,dat->what);
		 */
		 printf("%-20.20s %-5.5s %-13.13s %-6.6s %-15.15s%-15.15s\n",
		  dat->user,dat->login,dat->rhost,dat->tty,dat->time,dat->what);
		                  
		  ansi("me");
	   }
	   	  
		dat=dat->n;
	}
   }
                                                             
  if(ZOPT.OPT->USER.schluessel[3] == 128) print_uptime();  
  printf("\n");

}




char *GetRHostName()
{
int i;
struct utmp *utmp_rec;

char tty[13];
static char  rhost[17];
char search_name[9];





/*
 * Process user information.
 *
 * getutent() opens the utmp file for us,
 * and reads off the first record.
 * If the file was already opened, it reads the
 * subsequent record for us. See man page for more info.
*/

setutent();       
gethostname((char *) rhost,15);   
    while (utmp_rec = getutent())
    {

/*
 * Check we actually want to see this record.
 * It must be a valid active user process,
 * and match a specified search name.
 */
	if ( (utmp_rec->ut_type == USER_PROCESS)
	  && (strcmp(utmp_rec->ut_user, ""))
	  && ( (search_name[0] == 0)
	    || ( (search_name[0] != 0)
	    && !strncmp(search_name, utmp_rec->ut_user, 8) ) ) )
	{
	



/* Get the tty line */
	    for (i = 0; i < 6; i++)
	    {
		tty[i] = 0;

		if (utmp_rec->ut_line[i] != 0)
		    tty[i] = utmp_rec->ut_line[i];
		else
		    i = 6;
	    }

	    if (strpos(tty, ttyname(0))!=0)
	    {
/* Don't other getting info if it's not asked for */
            
/* Get the remote hostname */
		for (i = 0; i < 15; i++)
		{
		    rhost[i] = 0;

		    if (utmp_rec->ut_host[i] != 0)
			rhost[i] = utmp_rec->ut_host[i];
		    else
			i = 15;
		}
	      
	    }

   }
  }

 return ((char *) rhost);
}