
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <time.h>
#include <fcntl.h>
#include <sys/stat.h>
/*#include <stdlib.h>*/
#include <strings.h>

#ifndef VU
#include "mbox.h"
#include "proto.h"
#include "s_global.h"
#include "language.h"
#else
#include "../mbox.h"
#include "../proto.h"
#include "../s_global.h"
#include "../language.h"
#endif



/* #MK - Swapping macros in an input line [s] with their substitutes.

   The function returns the input line with the substitutes. */

UNSIGNED char *makro( s_ )
UNSIGNED char *s_;
{
  static UNSIGNED char t[STRING],s[STRING];
  UNSIGNED char f[STRING];
  int a = 0, b = 0, i = 0;
  int m = 0, ok = 0;
  int subcom = 0;

  t[0] = 0;
   
  strcpy(s,s_);
  strcat(s, " ");

/*  while(s[0] == ' ') *s++;  GCCs warning concerning this *IS* wrong!!! */

  while(s[i] != 0){

	if(s[i] == ' '){
		b = i -1;
		f[0] = 0;
		strcat(f, (char *) strcopy(s, a, b));
		a = i +1;
		ok = 0; 
		m = 0;

		while(ZOPT.OPT->MAK[m].makname[0] != 0){
			if((strcomp(f, ZOPT.OPT->MAK[m].makname) == 0) && (strcomp(ZOPT.OPT->MAK[m].makname, f) == 0) && (subcom == 0)){
				ok = 1; 
				strcat(t, ZOPT.OPT->MAK[m].makwert);
			}
			m++;
		}
		if(ok == 0) strcat(t,(char *) stripped(f));
		strcat(t, " ");
	
		subcom++;
	}
	i++;
  }
  return (UNSIGNED char *) t;
}





/* #SM - Displays the macro file. It could be changed. */

void set_makros()
{
  UNSIGNED char c;
  int b;


  printf("\n\n%s\n\n", GetText("MAK01_MSG"));

  ansi2("md", 0, 0);
  b = 0;
  while(ZOPT.OPT->MAK[b].makname[0] != 0){
	printf("%s%c=%c%s\n", ZOPT.OPT->MAK[b].makname, TAB, TAB, ZOPT.OPT->MAK[b].makwert);
	b++;
  }  
  printf("\n");  
  ansi2("mr", 0, 0);
  printf("%c%s [%c, %c] > ", CR, GetText("MAK02_MSG"), 
       GetEChar("GBL06_MSG"), GetEChar("GBL07_MSG"));
  ansi2("me", 0, 0);

  c = yesno();

  if (c == GetEChar("GBL06_MSG")) {
	security_ed( ZOPT.OPT->MAKRO );
  }

  get_makros();

  printf("\n");
}






/* #GM - Make up a structure out of the macro file. */

void get_makros()
{
  FILE *fp;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  int b = 0, i = 0;

LOOP:
  fp = fopen(ZOPT.OPT->MAKRO, "r");
  if (fp == NULL) {
	ZOPT.OPT->MAK[0].makname[0] = 0;
	return;
  }

  while(fgets(s, STRING, fp) != NULL){

	ZOPT.OPT->MAK[b].makname[0] = 0;
	ZOPT.OPT->MAK[b].makwert[0] = 0;
	
	i = 0;

	while((s[i] != '=') && (s[i] != 0)) i++;

	t[0] = 0; strcat(t,(char *) strcopy(s, 0, (i-1)));
	strcat(ZOPT.OPT->MAK[b].makname,(char *) stripped(t));

	t[0] = 0; strcat(t,(char *) strcopy(s, (i+1), strlen(s)));
 	strcat(ZOPT.OPT->MAK[b].makwert,(char *) stripped(t));

	b++;
	if (b >= (MAX_MAK -1)) {
	        SetFett(); printf("\nget_makro: makro-file is corrupt ->
                unlink! (MAX_MAK=50)\n"); logerror("makro.c", 148, 
                    "get_makro","Definition MAX_MAK", "to small"); 
                SetNorm(); 
                unlink((char *) ZOPT.OPT->MAKRO); 
                goto LOOP;
	}
  }
  ZOPT.OPT->MAK[b].makname[0] = 0;

  fclose(fp);

}



/* #AM - Adds a new macro defintion [s] to the macro file. */

void add_makro( s )
UNSIGNED char s[];
{
  FILE *fp;

  fp = fopen( ZOPT.OPT->MAKRO, "a" );
  if(fp == NULL){
	nerror("makro.c", 189, "add_makro", "Can't append to", ZOPT.OPT->MAKRO);
  }
  fputs((UNSIGNED char *) stripped(s), fp);
  fputs("\n", fp);
  fclose(fp);

  get_makros();

  printf("\n\n%s\n", GetText("MAK03_MSG"));
  
}



/* #MD - Checks whether an input line [s] includes macro defintions.

   The functions returns 1, if a defintion is found and 0 otherwise. */

int makro_definition( s )
UNSIGNED char s[];
{
  int i = 0;
  int ok = 0;

  if(ZOPT.OPT->USER.level < 1) return 0;

  while(s[i] != 0){
	if(s[i] == '=') ok++;
	i++;
  }

  if(ok == 1){
	add_makro( s );
  }
  if(ok > 1){
	ansi2("md", 0, 0);
	printf(" %s\n", GetText("MAK04_MSG"));
	ansi2("me", 0, 0);
  }
  return ok;
}

