{ Message Unit
  2/7/95
  Sauron Unit }

{ OCT 97 - Added More Commands }

{ OCT 97 - Release Notes                                         }
{ Displays Message Areas                                         }

Unit Msgs;

Interface

Uses Dos, Crt, Lib, Data, Colours, ErrorLog, WaitTix;

procedure ListMessageAreas;
procedure AddMessageArea;
procedure DeleteMessageArea;

Implementation

function MessageCount : integer;
var
  IndexPath : string;
begin
  If BBSCfg.MsgDir[Length(BBSCfg.MsgDir)] = '\' then
    begin
      IndexPath := BBSCfg.MsgDir + Msg.MsgNumber + '\';
    end
   Else
    begin
      IndexPath := BBSCfg.MsgDir + '\' + Msg.MsgNumber + '\';
    end;
  Assign(IdxFile, IndexPath + 'MESSAGE.IDX');
  {$I-} Reset(IdxFile); {$I+}
  If IOResult <> 0 then
    begin
      MessageCount := 0;
    end
  Else
    begin
      MessageCount := FileSize(IdxFile);
      Close(IdxFile);
    end;
end;

procedure ListMessageAreas;
Var
  Step        : Integer;
  Strgs       : string;
begin
  ClearDisplay(True);
  Colour(FYellow);
  Print('  Message Areas Available                    No. Of Messages ');
  LineFeed;
  LineFeed;
  for Step := 0 to FileSize(MsgFile) - 1 do
    begin
      Strgs := '';
      Seek(MsgFile, Step);
      Read(MsgFile, Msg);
      If Step < 9 then
      SetX('4')
      Else SetX('3');
      Colour(FGreen);
      Print(Msg.MsgNumber);
      Colour(FWhite);
      Print('. ');
      Colour(FMagenta);
      Print(Msg.AreaName);
      SetX('52');
      Colour(FWhite);
      Str(MessageCount, Strgs);
      Print(Strgs);
      LineFeed;
      Colour(FWhite);
    end;
  LineFeed;
end;

procedure DisplayMessageAreas;
begin
  AreaSize := Filesize(MsgFile);
  ClearDisplay(True);
  ListMessageAreas;
end;

procedure AddMessageArea;
var
  NewMsgArea : string[30];
begin
  AreaSize := Filesize(MsgFile);
  DisplayMessageAreas;
  Print(' [A] Add Message Area / [Enter] Continue ');
  Response := ReadKB(2);
  if (Response = 'a') or (Response = 'A') then
   begin
     LineFeed;
     LineFeed;
     Colour(FYellow);
     Print(' Enter New Message Area Name [Max 30 Chars] : ');
     Colour(FWhite);
     Response := ReadKB(31);
     NewMsgArea := Response;
     LineFeed;
     LineFeed;
     Colour(FYellow);
     Print(' Create New Area ');
     Colour(FMagenta);
     Print(NewMsgArea);
     Colour(FYellow);
     Print(' Yes / No ');
     Colour(FWhite);
     Response := ReadKB(2);
     if (Response = 'y') or (Response = 'Y') then
      begin
        Str(AreaSize + 1, Msg.MsgNumber);
        Msg.AreaName := NewMsgArea;
        {$I-}
          Write(MsgFile, Msg);
        {$I+}
        FileError := IOResult;
        if FileError <> 0 then
         begin
           LineFeed;
           Colour(FRed);
           Print(' Unable To Create New File Area In MESSAGE.DAT');
           Colour(FWhite);
           Wait(40);
           LogError('Unable To Write New Message Area To Message.dat ' + Msg.AreaName + ' - ' + ErrorString(FileError));
         end
        else
         begin
           LineFeed;
           LineFeed;
           Colour(FCyan);
           Print(' New File Area Created In MESSAGE.DAT');
           Colour(FWhite);
           LogError('Created New Message Area In Message.dat ' + Msg.AreaName + ' - ' + ErrorString(FileError));
           Wait(30);
         end;
      end;
   end;
end;

procedure DeleteMessageArea;
var
   MsgAreaNumber : integer;
   CurrentArea   : string;
begin
  AreaSize := Filesize(MsgFile); { Message Area Size }
  CurrentArea := Msg.MsgNumber;  { Save Message Area }
  DisplayMessageAreas;
  Print(' [D] Delete Message Area / [Enter] Continue ');
  Response := ReadKB(2);
  if (Response = 'd') or (Response = 'D') then
   begin
     LineFeed;
     LineFeed;
     Colour(FYellow);
     Print(' Enter Message Area To Be Removed ');
     Colour(FWhite);
     Response := ReadKB(5);
     Val(Response, MsgAreaNumber, Code);
     if MsgAreaNumber <= AreaSize then
      begin
        {$I-}
          Seek(MsgFile, MsgAreaNumber - 1);
          Read(MsgFile, Msg);
        {$I+}
        LineFeed;
        LineFeed;
        Colour(FYellow);
        Print(' Remove Message Area ');
        Colour(FMagenta);
        Print(Msg.AreaName);
        Colour(FYellow);
        Print(' Yes / No ');
        Colour(FWhite);
        Response := ReadKB(2);
        if (Response = 'y') or (Response = 'Y') then
         begin
         end;
         Val(CurrentArea, MsgAreaNumber, Code);
         {$I-}
           Seek(MsgFile, MsgAreaNumber - 1);
           Read(MsgFile, Msg);
         {$I+}
       end;
     end
  else
     begin
       LineFeed;
       Colour(FRed);
       Print(' Invalid Message Area');
       Colour(FWhite);
       Wait(40);
     end;
end;

procedure DeleteMessage;
begin
end;

end.