(* Sauron BBS Data Unit                                        *)
(* 18/02/96  Added UserTemp File                               *)
(* 26/07/96  Added Error Descriptions To External File Opening *)
(* 07/09/96  Add Fax                                           *)

{ OCT 97 - Release Notes                                         }
{ Main data file for sauron                                      }
{ Not sure what all the var's do now                             }

Unit Data;

Interface

Uses Dos, Crt, Dates, Wins;

procedure OpenDataFiles;
procedure CloseDataFiles;

{ Modem data }
type
  Cfg = record
     ComPort     : Integer;
     BaudRate    : Byte;
     InitString1 : String[50];
     InitString2 : String[50];
     InitString3 : String[50];
     InitAnswear : String[20];
     LockBaud    : Boolean;
     Node        : Byte;
     MultiNode   : Boolean;
     L1T,
     L2T,
     L3T,
     L4T,
     L5T,
     L6T,
     L7T,
     L8T,
     L9T        : Word;   { Level Time }
     L1C,
     L2C,
     L3C,
     L4C,
     L5C,
     L6C,
     L7C,
     L8C,
     L9C       : Word;   { Level Calls Per Day }
     SysDir,    { System Directories }
     ScriptDir,
     MenuDir,
     BBSMailDir,
     MsgDir,
     TempDir,
     NodeDir    : String[30];  { Node Directory Is Where All nodes Share Info }
     SysopFirst : String[15];
     SysopSec   : String[15];
     BBSName    : String[30];
     BBSTele    : String[20];
     Calls      : integer;
     NuLevel    : integer;
     IdleTime,
     MaxUsers,
     MaxMsg     : Word;
     LogFile,
     ErrFile    : String[12];
     Bulletin   : word;
end;

{ Sauron BBS File Areas     }
type
  Area = record
    AreaNumber  : String[3];
    Description : String[30];
    OpenClosed  : Boolean;
    FileNumber  : LongInt;
    CatNumber   : LongInt;
end;

{ Sauron BBS File Areas }
type
  FileAreas = record
    DirNo   : Integer;     { Number Of File Directorys }
    Dir     : String[30];  { Directory path       }
    DirDes  : String[30];  { Directory Area Name  }
    FileLst : String[30];  { Files List & Path    }
    Uploads : Integer;     { Uploads Allowed      }
    DnLoads : Integer;     { DownLoads Allowed    }
    Access  : integer;     { Minimum Level Access }
end;

{ Tag File }
type
  FileTags = record
    FileName  : String[12];
    Dir       : String[80];
    DirLst    : String[80];
    Des       : String[40];
    Tagged    : Byte;
    Size      : LongInt;
    DLTimes   : Integer;
    ULUser    : String[30];
    Date      : String[8];
    RecNumber : integer;
end;

{ Sauron BBS File Information }
type
  FileInfo = Record
    FileName  : String[12];
    Size      : LongInt;      { FileSize }
    FDate     : String[8];    { FileDate }
    Des1,
    Des2,
    Des3,
    Des4,
    Des5,
    Des6,
    Des7,
    Des8,
    Des9,
    Des10,
    Des11,
    Des12,
    Des13,
    Des14,
    Des15     : String[60];   { File Description }
    DLTimes   : Integer;      { Number Of Times File Has Been Downloaded }
    ULUser    : String[30];   { User Who Uploaded File }
end;

{ Sauron BBS Data Information  SIMPBBS.DAT }
type
  bbs = record
    NextUser   : integer;
    Line       : string;
    From       : string;
    Date       : string;
    Time       : Word;
    Fax        : integer;
    FaxTime    : string;
end;

{ Sauron Message Index File }
type
  Index = Record
     MsgNumber : Integer;
end;

{ Sauron Message Areas Data Files }
type
  MsgArea = Record
    MsgNumber : String;
    AreaName  : String[30];
end;

{ Sauron Message Number }
type
  MS = record
    MsgNumber : integer;
end;

{ User Information  USERDAT.DAT}
type
  User = record
    UserAcc    : String[3];     { Account Number }
    UserAnsi   : byte;          { Ansi or Avatar }
    UserColour : byte;          { Colour ON or OFF }
    Userlevel  : byte;
    UserName   : string[30];
    UserPass   : string[10];
    UserTown   : string[30];
    UserInfo1  : string[30];
    UserInfo2  : string[30];
    UserInfo3  : string[30];
    Userinfo4  : string[30];
    Userinfo5  : string[30];
    Userinfo6  : string[30];
    Userinfo7  : string[30];
    Userinfo8  : string[30];
    UserCls    : Boolean;      { Screen clear code to be sent }
    UserLines  : byte;         { Lines of user terminal }
    Bulletin   : word;         { Current Bulletin Number Read }
    MailCount  : integer;      { User Mail }
    LastMsgNum : integer;
    Calls      : integer;      { Calls to system }
    CallsToday : integer;      { Calls today }
    LCallDate  : String[10];   { Last call date }
    LastCall   : string[30];   
    CallNumber : integer;
    TimeOnLine : word;
    FileArea   : integer;      { Last file area visited - Will return user to this file area on next logon }
    DownLoads  : integer;      { Number of downloads }
    Uploads    : integer;      { Number of uploads }
    BytesDL    : LongInt;      { Bytes downloaded }
    BytesUL    : LongInt;      { Bytes uploaded }
end;

const
  { Sauron Colour Codes }
  { Foreground }
    FBlack   = 224;
    FRed     = 225;
    FGreen   = 226;
    FYellow  = 227;
    FBlue    = 228;
    FMagenta = 229;
    FCyan    = 230;
    FWhite   = 231;
  { Background }
    BBlack   = 232;
    BRed     = 233;
    BGreen   = 234;
    BYellow  = 235;
    BBlue    = 236;
    BMagenta = 237;
    BCyan    = 238;
    BWhite   = 239;

    Version = ' 1.01B';
    RegTo   = 'APEX ONLINE - SAURON SUPPORT ';
    RegNo   = '101011-01-1996-APEX';

var
  UserNumber : Integer;      { Holds Current UserNumber }
  bbsinfo    : bbs;
  Userinfo,
  UserTemp   : user;          { UserTemp is a tempory file to write and retrive  }
  Areas      : FileAreas;     { Data, as the main file was somehow being corrupt }
  SAreas     : Area;
  BBSCfg     : Cfg;
  FInfo      : FileInfo;
  Idx        : Index;
  Msg        : MsgArea;
  MsIndex    : Ms;
  Tags       : FileTags;
  UserSize   : LongInt;
  AreaSize   : LongInt;
  TagSize    : LongInt;
  InFile     : Text;
  DataFile,
  DataTemp   : File of user;       { UserFile & User Temp File}
  BBSini     : File of bbs;        { BBS Data File }
  FileArea   : File of FileAreas;  { File Directorys }
  CatArea    : File of Area;
  SBBSCfg    : File of Cfg;
  Files      : File of FileInfo;
  TagInfo    : File of FileTags;
  IdxFile    : File of Index;
  MsgFile    : File of MsgArea;
  MsgNum     : File of MS;
  Temp       : String;
  Loop       : Integer;

  FileNumber : byte;     { Record Number Of File DownLoaded }

  StatsBox   : Byte;     { Holds Whats To Displayed In Stats Box }
  SOnOff     : Boolean;  { Status Bar On / Off Flag              }

  Tagged,                { True if files are tagged }
  Local,                 { True if local logon }
  OnLine     : Boolean;

  Regs       : Registers; { DOS registers }
  Response   : string;    { Command & char responses from users }

  LineCount,                { Keeps Count On Lines Scrolled In PrintFile }
  BBSlines,                 { Keeps Count of BBS Screen Lines }
  CurrentLine : Integer;

  ScriptFile : String;          { Holds ScriptFile Name }
  FinScript  : Boolean;         { True if script file is finished }

  ConfigFile : String;      {Name of Node Configuration File }

  Error      : Integer;{ Error Holds The Error Number Returned In %error% }
  Errored    : Boolean;{ This Sets To True On Every Logon, Used In LogError }
  FileError  : Byte;   { Main File Errors }

  DlFile,                    { Dload Filename      }
  ULFile,                    { File to be uploaded }
  SelFile    : string;       { Name of File being downloaded }

  YN         : Byte;          { Used for %YN% in script I think }

  Echo,
  PassEcho,
  NoUpper    : Boolean;

  NewUser,
  Finish     : Boolean;

  LastCall,
  CallAway   : Integer;
  LastCalls,
  LastCaller,
  LastCallerTown : String;

  SessionTime,
  SessionLength,
  StartTimes,
  Minutes,
  Times,
  Time,
  LastOnTime     : Word;  { Reset Time Procedure }

  Carrier,                 { Line Speed }
  LineBaud       : Word;
  ActualBaud     : String;
  ConnectString  : String;

  ColourSelect   : Byte;
  ColourCode     : String;

  {AVATAR}
  AvatarChar,
  AvatarCode,
  AvatarCol      : byte;

  {ANSI}
  AnsiCode       : Byte;
  AnsiDetect     : Boolean;  { True Ansi Detected }

  SaveCurX,
  SaveCurY       : integer;
  CurSaved       : Boolean;
  CaseKey,
  CaseKey2,
  Back,
  Fore,
  Flash,
  High          : integer;
  Delimiter     : Boolean;
  AnsiCommand,
  Fst,
  Snd,
  Command       : String;
  temps,
  I,
  Code,
  Pntr,
  Fval,
  Sval,
  Cval          : integer;

Implementation

{ OCT 97 - Release Notes                                         }
{ This was added because I had a trouble linking in error.pas    }

procedure ErrorString(ErrorNumber : Byte);
var
  Strgs,
  ErrorStrings : string;
begin
  Str(ErrorNumber, Strgs);
  Case ErrorNumber of
   $02 : ErrorStrings := 'File not found';
   $03 : ErrorStrings := 'Path not found';
   $04 : ErrorStrings := 'To many open Files';
   $05 : ErrorStrings := 'Access denied';
   $06 : ErrorStrings := 'Invalid file handle';
   $07 : ErrorStrings := 'Memory blocks invalid';
   $08 : ErrorStrings := 'Not enough memory';
   $09 : ErrorStrings := 'Memory blocks invalid';
   $0A : ErrorStrings := 'Invalid environment';
   $0B : ErrorStrings := 'Invalid format';
   $0C : ErrorStrings := 'Invalid file Access code';
   $0F : ErrorStrings := 'Invalid drive number';
   $10 : ErrorStrings := 'Cannot remove current directory';
   $11 : ErrorStrings := 'Cannot rename across drives';
   $12 : ErrorStrings := 'No more files';
   $13 : ErrorStrings := 'Disk write protected';
   $15 : ErrorStrings := 'Drive not ready';
   $16 : ErrorStrings := 'Bad command';
   $17 : ErrorStrings := 'Data error on disk';
   $19 : ErrorStrings := 'Seek error';
   $1A : ErrorStrings := 'Bad media';
   $1B : ErrorStrings := 'Sector not found';
   $1D : ErrorStrings := 'Unable to write to disk';
   $1E : ErrorStrings := 'Unable to read from disk';
   $20 : ErrorStrings := 'File sharing error';
   $21 : ErrorStrings := 'File locking error';
   $23 : ErrorStrings := 'No free FCBs';
   $24 : ErrorStrings := 'File sharing buffer full';
   $35 : ErrorStrings := 'Bad network patch';
   $36 : ErrorStrings := 'Network busy';
   $37 : ErrorStrings := 'Device does not exist';
   $39 : ErrorStrings := 'Hardware error';
   $64 : ErrorStrings := 'Disk read error';
   $65 : ErrorStrings := 'Disk write error';
   $66 : ErrorStrings := 'File not assigned';
   $67 : ErrorStrings := 'File not open';
   $68 : ErrorStrings := 'File not open for input';
   $69 : ErrorStrings := 'File not open for output';
  Else
    ErrorStrings := ' ('+ Strgs + ')unKown Error';
  end; { Case End }
  writeln('(',Strgs,') ', ErrorStrings);
  writeln;
end;


{ Open All Data Files needed To Run SimpleBBS }

procedure OpenUserTemp;
begin
  Assign(DataTemp,'USERLOG.TMP');
  {$I-} Reset(DataTemp); {$I+}
  FileError := IOResult;
  if FileError <> 0 then
      begin
        Writeln('Unable To Open USERLOG.TMP');
        ErrorString(FileError);
        Halt(1);
      end;
end;

procedure OpenDataFiles;
begin
  LastOnTime  := 0;
  StatsBox    := 1;
  FileNumber  := 0;
  LineCount   := 0;
  BBSLines    := 0;
  CurrentLine := 24;
  Carrier     := 0;
  LineBaud    := 0;
  LastCall    := 0;
  CallAway    := 0;
  Echo        := True;
  Tagged      := True;
  PassEcho    := False;
  NoUpper     := False;
  FileError   := 0;
  ColourSelect := 1;
  AvatarChar  := 0;
  AvatarCode  := 0;
  AvatarCol   := 0;
  AnsiCode    := 0;
  AnsiDetect  := False;
  Back := 0;
  Fore := White;
  Flash := 0;
  High := 0;
  UserNumber := 0;
  UserInfo.UserAnsi := 1; { Default User To ANSI }
  ConnectString := 'LOCAL';
  Assign(DataFile,'USERLOG.DAT');
  {$I-} Reset(DataFile); {$I+}
  FileError := IOResult;
  if FileError = 0 then
      begin
         UserSize := FileSize(DataFile);
          If UserSize <> 0 then
           begin
             Seek(DataFile, 0);
             Read(DataFile, UserInfo);
           end;
         end
      else
         begin
           OnCursor;
           OffCursor;
           Box(15, 10, 65, 16, 78, 1, True);
           TextBackground(Red);
           Textcolor(White);
           ClrScr;
           Write('   ERROR : ');
           ErrorString(FileError);
           Writeln('                    USERLOG.DAT');
           Writeln('               PRESS ANY KEY TO EXIT');
           Repeat Until Keypressed;
           Halt(1);
         end;
  Assign(DataTemp,'USERLOG.TMP');
  {$I-} Rewrite(DataTemp); {$I+}
  FileError := IOResult;
  if FileError <> 0 then
      begin
        OnCursor;
        OffCursor;
        Box(15, 10, 65, 16, 78, 1, True);
        TextBackground(Red);
        Textcolor(White);
        ClrScr;
        Write('   ERROR : ');
        ErrorString(FileError);
        Writeln('                    USERLOG.TMP');
        Writeln('               PRESS ANY KEY TO EXIT');
        Repeat Until Keypressed;
        Halt(1);
      end;
  Assign(BBSini,'SIMPBBS.DAT');
  {$I-} Reset(BBSini); {$I+}
  FileError := IOResult;
  if FileError = 0 then
    begin
      Seek(BBSINI, 0);
      Read(BBSINI, BBSInfo);
    end
  else
    begin
      OnCursor;
      OffCursor;
      Box(15, 10, 65, 16, 78, 1, True);
      TextBackground(Red);
      Textcolor(White);
      ClrScr;
      Write('   ERROR : ');
      ErrorString(FileError);
      Writeln('                     SIMPBBS.DAT');
      Writeln('               PRESS ANY KEY TO EXIT');
      Repeat Until Keypressed;
      Halt(1);
    end;
  Assign(CatArea,'AREAS.DAT');
  {$I-} Reset(CatArea); {$I+}
  FileError := IOResult;
  if FileError = 0 then
    begin
      if FileSize(CatArea) <> 0 then
       begin
         Seek(CatArea, 0);
         Read(CatArea, SAreas);
       end;
    end
  else
    begin
      OnCursor;
      OffCursor;
      Box(15, 10, 65, 16, 78, 1, True);
      TextBackground(Red);
      Textcolor(White);
      ClrScr;
      Write('   ERROR : ');
      ErrorString(FileError);
      Writeln('                     AREAS.DAT');
      Writeln('               PRESS ANY KEY TO EXIT');
      Repeat Until Keypressed;
      Halt(1);
    end;
  Assign(FileArea,'AREA.1');   { Open Default File Area }
  {$I-} Reset(FileArea); {$I+}
  FileError := IOResult;
  if FileError = 0 then
    begin
      AreaSize := FileSize(FileArea);
      if AreaSize <> 0 then
       begin
         Seek(FileArea, 0);
         Read(FileArea, Areas);
       end;
    end
  else
    begin
      OnCursor;
      OffCursor;
      Box(15, 10, 65, 16, 78, 1, True);
      TextBackground(Red);
      Textcolor(White);
      ClrScr;
      Write('   ERROR : ');
      ErrorString(FileError);
      Writeln;
      Writeln('                     AREA1.DAT');
      Writeln('               PRESS ANY KEY TO EXIT');
      Repeat Until Keypressed;
      Halt(1);
    end;
  Assign(SBBSCfg, ConfigFile);
  {$I-} Reset(sbbscfg); {$I+}
  FileError := IOResult;
  if FileError = 0 then
    begin
      If FileSize(SBBSCfg) <> 0 then
        begin
          Seek(sbbscfg, 0);
          Read(sbbscfg, bbscfg);
        end;
    end
  else
    begin
      OnCursor;
      OffCursor;
      Box(15, 10, 65, 16, 78, 1, True);
      TextBackground(Red);
      Textcolor(White);
      ClrScr;
      Write('   ERROR : ');
      ErrorString(FileError);
      Writeln('                     '+ ConfigFile );
      Writeln('               PRESS ANY KEY TO EXIT');
      Repeat Until Keypressed;
      Halt(1);
    end;
  Assign(MsgFile,'MESSAGE.DAT');
  {$I-} Reset(MsgFile); {$I+}
  FileError := IOResult;
  if FileError = 0 then
    begin
      If FileSize(MsgFile) <> 0 then
        begin
          Seek(MsgFile, 0);
          Read(MsgFile, Msg);
        end;
    end
  else
    begin
      OnCursor;
      OffCursor;
      Box(15, 10, 65, 16, 78, 1, True);
      TextBackground(Red);
      Textcolor(White);
      ClrScr;
      Write('   ERROR : ');
      ErrorString(FileError);
      Writeln('                    MESSAGE.DAT');
      Writeln('               PRESS ANY KEY TO EXIT');
      Repeat Until Keypressed;
      Halt(1);
    end;
  Assign(MsgNum,'MSINDEX.DAT');
  {$I-} Reset(MsgNum); {$I+}
  FileError := IOResult;
  if IOResult = 0 then
    begin
      If FileSize(MsgNum) <> 0 then
        begin
          Seek(MsgNum, 0);
          Read(MsgNum, MsIndex);
        end;
    end
  else
    begin
      OnCursor;
      OffCursor;
      Box(15, 10, 65, 16, 78, 1, True);
      TextBackground(Red);
      Textcolor(White);
      ClrScr;
      Write('   ERROR : ');
      ErrorString(FileError);
      Writeln('                    MSINDEX.DAT');
      Writeln('               PRESS ANY KEY TO EXIT');
      Repeat Until Keypressed;
      Halt(1);
    end;
  UserInfo.UserInfo1  := 'NULL';
  UserInfo.UserInfo2  := 'NULL';
  UserInfo.UserInfo3  := 'NULL';
  UserInfo.Userinfo4  := 'NULL';
  UserInfo.Userinfo5  := 'NULL';
  UserInfo.Userinfo6  := 'NULL';
  UserInfo.Userinfo7  := 'NULL';
  UserInfo.Userinfo8  := 'NULL';
  if UserSize <> 0 then { BackUp UserFile }
    begin
      for Loop := 0 to UserSize - 1 do
        begin
          {$I-}
          Seek(DataFile, Loop);
          Read(DataFile, UserInfo);
          Seek(DataTemp, Loop);
          Write(DataTemp, UserInfo);
          {$I+}
        end;
      {$I-} Close(DataTemp); {$I+}
    end;
end;

function MinutesPast: word;
Var
  H,M,S,Hund,
  Mins  : Word;
begin
  GetTime(H,M,S,Hund);
  If M <> StartTimes then
    begin
      Inc(Minutes);
      StartTimes := M;
    end;
  MinutesPast := Minutes;
end;

procedure CloseDataFiles;
Var
  Rec, Code : Integer;
begin
  Code := MinutesPast;
  UserInfo.LastMsgNum := MsIndex.MsgNumber;
  UserInfo.FileArea   := Areas.DirNo - 1;
  UserInfo.TimeOnline := LastOnTime + Code;
  if UserNumber <> 0 then
    begin
      BBSInfo.Time := Code;
      BBSInfo.Line := UserInfo.UserName;
      BBSInfo.From := UserInfo.UserTown;
      BBSInfo.Date := Today;
      {$I-}
      Seek(BBSini, 0);
      Write(BBSINI, BBSInfo);
      Seek(DataFile, UserNumber);
      Write(DataFile, UserInfo);
      {$I+}
    end;
  for Loop := 0 to UserSize - 1 do
     begin
       OpenUserTemp;
       if Loop <> UserNumber then
         begin
           {$I-}
           Seek(DataTemp, Loop);
           If FilePos(DataTemp) = Loop Then Read(DataTemp, UserTemp);
           Seek(DataFile, Loop);
           If FilePos(DataFile) = Loop Then Write(DataFile, UserTemp);
           {$I+}
         end;
      {$I-} Close(DataTemp); {$I+}
    end;
  UserInfo.UserAcc    := '0';
  UserInfo.UserAnsi   := 1;
  UserInfo.UserColour := 0;
  UserInfo.Userlevel  := 0;
  UserInfo.UserName   := 'SYSTEM';
  UserInfo.UserPass   := 'SAURON';
  UserInfo.UserTown   := '    ';
  UserInfo.UserInfo1  := 'NULL';
  UserInfo.UserInfo2  := 'NULL';
  UserInfo.UserInfo3  := 'NULL';
  UserInfo.Userinfo4  := 'NULL';
  UserInfo.Userinfo5  := 'NULL';
  UserInfo.Userinfo6  := 'NULL';
  UserInfo.Userinfo7  := 'NULL';
  UserInfo.Userinfo8  := 'NULL';
  UserInfo.UserCls    := True;
  UserInfo.Bulletin   := 0;
  UserInfo.UserLines  := 24;
  UserInfo.MailCount  := 0;      { User Mail }
  UserInfo.LastMsgNum := 0;
  UserInfo.Calls      := 0;
  UserInfo.CallsToday := 0;
  UserInfo. LCallDate  := '1/1/95';
  UserInfo.LastCall   := '1st January 1995';
  UserInfo.CallNumber := 0;
  UserInfo.TimeOnLine := 0;
  UserInfo.FileArea   := 0;
  UserInfo.DownLoads  := 0;
  UserInfo.Uploads    := 0;
  UserInfo.BytesDL    := 0;
  UserInfo.BytesUL    := 0;
  {$I-}
      Seek(DataFile, 0);
      If FilePos(DataFile) - 1 = 0 Then Write(DataFile, UserInfo);
      Close(BBSINI);
      Close(FileArea);
      Close(CatArea);
      Close(MsgNum);
      Close(SBBSCfg);
      Close(DataFile);
  {$I+}
end;

end.