// Filename:	msqldb.h
// Contents:	the msql database access object definition
// Author:	Greg Shaw
// Created:	2/13/96

#ifndef _MSQLDB_H_
#define _MSQLDB_H_

#include "bbshdr.h"

// Object:	msqldb
// Purpose:	encapsulate the msql database function calls
// Attributes:	very few.  Higher level objects should keep track of the 
//		database connectivity rather than depending on this object
//		to store the database information.
// Methods:
// Notes:	this object is basically a c++ frontend to the msql library
// Author:	Greg Shaw
// Created:	2/13/96

class msqldb : public filelock
{
public:
	msqldb();
	int	connect(char *dbname);		// connect to database
	// database interface functions
	void	dbclose(int sock);	// close connection

	void	dataseek(m_result *result, int pos);	// seek in query
	void	disconnect(void);

	m_field *fetchfield(m_result *result);	// get field
	m_row	fetchrow(m_result *result);	// get row
	void	fieldseek(m_result *result, int pos);	// seek in row
	void	freeresult(m_result *result);	// free stored result

	int	get_sock(char *dbname);		// get socket (or connect)

	m_result *listdbs(int sock);		// list databases
	m_result *listtables(int sock);		// list tables in database
	m_result *listfields(int sock, char *tablename);	// list fields

	int	numfields(m_result *result);	// number of fields selected
	int	numrows(m_result *result);	// number of rows selected

	int	dbopen(char *host);	// open connection to database engine

	int	query(int sock, char *query);	// send query to database

	int	rows(m_result *result);		// number of rows selected

	int	selectdb(int sock, char *dbname);	// connect to database
	m_result *storeresult(void);		// store result of query

	// other functions
	char	*dberror(void);			// return database error string

};

#endif // _MSQLDB_H_
