// Filename:   errlog.C
// Contents:   the error logger interface object (for bbs interface)
// Author:     Greg Shaw
// Created:        7/11/93

/*
This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _ERRLOG_C_
#define _ERRLOG_C_

#include "bbshdr.h"             // the world
//#define DEBUG

static char progname[MAX_PROGNAME] = "";		// name of the current program

// Method:     ap_log
// Purpose:        send an error message to the error logger daemon
// Input:      msg - the message to append to the log file
// Output:     the message will be sent to the logger daemon, or, error
//             error will be returned
// Author:     Greg Shaw
// Created:        7/11/93

int errlog::ap_log(char *msg)
{
	char ttystr[50];
	char tmpstr[50];
	char pname[MAX_PROGNAME];
	char *u;
	char *sendstr=NULL;
	char hostname[50];
	int needfree = 0;


	ttystr[0] = 0;
	hostname[0] = 0;
	strcpy(pname,progname);
	// open socket successful?
	#ifdef DEBUG
	fprintf(stderr,"ap_log: opening port\n");
	fflush(stderr);
	#endif
	if (err_ipcobj.open_sock(loghost(),ERRLOG_PORT) == 0)
	{
		#ifdef DEBUG
		fprintf(stderr,"ap_log: port open successful\n");
		fflush(stderr);
		#endif
		// check for valid tty
		if (isatty(fileno(stdout)))
		{
			// get ttyname
			strcpy(ttystr,ttyname(fileno(stdout)));
			if (u = strchr(ttystr,'y'), u != NULL)
			{                   // chop off /dev/tty
				// chop after y
				strcpy(tmpstr,++u);
				// copy back
				strcpy(ttystr,tmpstr);
			}
#ifdef MULTIPLE_MACHINE_BBS
			gethostname(hostname,49);
			int len = strlen(hostname) + strlen(ttystr)+ strlen(pname)+ strlen(msg)+30;
			sendstr = (char *)malloc(len);
			if (sendstr == NULL)	// no memory?
			{	// then keep it simple
				sendstr = msg;
			}
			else
			{
				needfree++;
				sprintf(sendstr,"(%s %s) %s: %s",hostname,ttystr,pname,msg);
			}
#else
			sendstr = (char *)malloc(strlen(ttystr)+strlen(pname)+strlen(msg)+1)+30;
			if (sendstr == NULL)	// no memory?
			{	// then keep it simple
				sendstr = msg;
			}
			else
			{
				needfree = 1;
				sprintf(sendstr,"%s: %s",pname,msg);
			}
#endif
		}
		else
		{
			sendstr = (char *)malloc(50+strlen(pname)+strlen(msg)+30);
			if (sendstr == NULL)	// no memory?
			{	// then keep it simple
				sendstr = msg;
			}
			else
			{
				needfree = 1;
#ifdef MULTIPLE_MACHINE_BBS
				gethostname(hostname,49);
				sprintf(sendstr,"(%s) %s: %s",hostname,pname,msg);
#else
				sprintf(sendstr,"%s: %s",pname,msg);
#endif 
			}
		}
		#ifdef DEBUG
		fprintf(stderr,"ap_log: sending message\n");
		fflush(stderr);
		#endif
		// send message to error logger
		if (err_ipcobj.send(sendstr,1) == 0)
		{
			#ifdef DEBUG
			fprintf(stderr,"ap_log: send successful\n");
			fflush(stderr);
			#endif
			err_ipcobj.close_sock(0);
			if (needfree)
				free(sendstr);
			return(0);
		}
		else
		{
			#ifdef DEBUG
			fprintf(stderr,"ap_log: send UNsuccessful\n");
			fflush(stderr);
			#endif
		}
	}
	// close socket
	err_ipcobj.close_sock(0);
	if (needfree)
		free(sendstr);
	return(-1);
};


// Method:     er_log
// Purpose:        send an error message to the error logger daemon then exit
// Input:      msg - the message to append to the log file
// Output:     the message will be sent to the logger daemon and, the program
//             will abort
// Author:     Greg Shaw
// Created:        7/11/93

int errlog::er_log(char *msg)
{
	char ttystr[50];
	char *u;
	char sendstr[255];

	// open socket successful?
	if (err_ipcobj.open_sock(loghost(),ERRLOG_PORT) == 0)
	{
		// check for valid tty
		if (isatty(fileno(stdout)))
		{
			// get ttyname
			strcpy(ttystr,ttyname(fileno(stdout)));
			if (u = strchr(ttystr,'y'), u != NULL)
			{                   // chop off /dev/tty
				// chop after y
				strcpy(sendstr,++u);
				// copy back
				strcpy(ttystr,sendstr);
			}
			sprintf(sendstr,"(%s) %s",ttystr,msg);
		}
		else
			strcpy(sendstr,msg);
		// send message to error logger
		if (err_ipcobj.send(sendstr,1) == 0)
			err_ipcobj.close_sock(0);
	}
	exit(0);                    // abort program
};


// Method:     set_progname
// Purpose:    set the program name variable so that error logging is possible.
// Input:      msg - the message to append to the log file
// Output:     the message will be sent to the logger daemon and, the program
//             will abort
// Author:     Greg Shaw
// Created:        7/11/93

void errlog::set_progname(char *prog)
{
	strncpy(progname,prog,MAX_PROGNAME-1);
}

#endif                          // _ERRLOG_C_






