#ifndef _TOWN_C_
#define _TOWN_C_


#include "bf.h"


void bank(void)
{
  char c[256];
  long num, int_;
  Player *uptr;
  char STR2[256];
  struct tm now;
  struct tm then;

  ioobj.clear_scr();
  if (!find_player_by_name(playername, &uptr))
   ioobj.sstrcr("error!");
 ioobj.sstrcr("You enter the humble establishment with \"Bank\" painted");
 ioobj.sstrcr("on the window.  A clerk steps up to you and says:  \"May I help you?\"");
 ioobj.sstrcr("then the clerk does a double-take.  \"Oh, I remember you!  you were the \"");
 ioobj.sstrcr("man that inherited that castle. \"  He opens his ledger, and says: ");
  sprintf(STR2, "you have %ld", uptr->gold);
  ioobj.sstr(STR2);
 ioobj.sstrcr(" gold pieces with you.");
  if (uptr->bank == 0) {
   ioobj.sstrcr("Since you don't have any money in your account , I assume you ");
   ioobj.sstrcr("wish to make a deposit.  ");
    ioobj.sstr("How much would you like to deposit? ");
    strcpy(c,"");
    ioobj.gstr(c, 7L);
    if (sscanf(c,"%ld", &num) == 1)
    {
    if (num > uptr->gold)
     ioobj.sstrcr("You don't have that much gold!  Come back when you're reasonable.");
    else {
      uptr->gold -= num;
      uptr->last_bank_visit = uptr->entrydate;
      uptr->bank = num;
      if (num > 5) {
	ioobj.sstrcr("Thank you for your deposit. There is a 5 gold piece service charge.");
	uptr->bank -= 5;
      } else {
	ioobj.sstrcr("You must make a deposit of greater than 5 gold pieces for us to create");
	ioobj.sstrcr("a new account.  Thank you for your business.  ");
      }
    }
    }
  } else {
    ioobj.sstr("Let's see . . . your gold has been in the bank for ");

    memcpy(&now,localtime(&uptr->entrydate),sizeof(struct tm));
    memcpy(&then,localtime(&uptr->last_bank_visit),sizeof(struct tm));
    sprintf(STR2, "%d days.", now.tm_yday - then.tm_yday);
    ioobj.sstrcr(STR2);
    sprintf(STR2,"At the current rate, %2.3f%% per week, that comes to",INTEREST/(double)theoptions.difficulty);
    ioobj.sstrcr(STR2);
    int_ = (long)floor((now.tm_yday - then.tm_yday) * ((INTEREST/7.0)/(double)theoptions.difficulty) * uptr->bank / 7 + 0.5);
    int_ = labs(int_);
    sprintf(STR2, "%ld gold pieces interest.", int_);
   ioobj.sstrcr(STR2);
    sprintf(STR2, "You now have %ld gold pieces in your account.", uptr->bank + int_);
    ioobj.sstrcr(STR2);
    uptr->last_bank_visit = uptr->entrydate;
    uptr->bank += int_;
    ioobj.cr();
    ioobj.sstr("Would you like to deposit or withdraw? (d/w) ");
    strcpy(c,"");
    ioobj.gstr(c, 1L);
    if (uncase(c[0]) == 'd') 
    {
      ioobj.sstr("How much would you like to deposit? ");
    strcpy(c,"");
      ioobj.gstr(c, 6L);
      if (sscanf(c,"%ld", &num) == 1)
      {
	      if (num > uptr->gold)
		ioobj.sstrcr("You don't have that much gold!  Please leave!");
	      else 
	      {
		uptr->gold -= num;
		uptr->bank += num;
		if (num > 5) 
		{
		 ioobj.sstrcr("Thank you for your deposit. There is a 5 gold piece service charge.");
		  uptr->bank -= 5;
		}
	      }
      }
    } else {
      ioobj.sstr("How much would you like to withdraw? ");
    strcpy(c,"");
      ioobj.gstr(c, 6L);
      if (sscanf(c,"%ld", &num) == 1)
      {
      if (num > uptr->bank) {
	ioobj.sstrcr(
	  "You don't have that much gold!  I am far too busy to honor ridiculous requests.");
	ioobj.sstrcr("He turns around, and says: \"Next, please!\"");
      } else {
	uptr->gold += num;
	uptr->bank -= num;
	ioobj.sstrcr("Thank you for your business.  Have a nice day.");
	if (uptr->bank > 5)
	  uptr->bank -= 5;
      }
      }
    }
  }
  ioobj.waitcr();
}


void cathedral(boolean church)
{
  Player *uptr;
  long base;
  char c[256];
  long gift, tmp;

  ioobj.clear_scr();
  enteredchurch++;
  if (enteredchurch > 5) {
   ioobj.sstrcr("You have already entered the church five times today.  ");
   ioobj.sstrcr("If you're not careful, you'll turn into a monk..");
   ioobj.sstrcr("Please leave the clergy to their prayers.");
    ioobj.waitcr();
    return;
  }
  if (!find_player_by_name(playername, &uptr))
   ioobj.sstrcr("error!");
  if (church) {
   ioobj.sstrcr("You enter a small, undecorated church.  The walls are whitewashed and ");
   ioobj.sstrcr("covered with cracks.  You wonder how this church pays its bills.");
   ioobj.sstrcr("The walls are almost completely barren, with sparse, crude paintings ");
   ioobj.sstrcr("here and there.  The pews are little more than logs.  The pastor of the ");
   ioobj.sstrcr("church walks up to you.  He is dressed shabbily, but is still proud.");
   ioobj.sstrcr(
      "He says:  'welcome, your highness, to our humble church.  May I impinge on ");
    ioobj.sstr("you to contribute towards our humble church? ");
    base = 0;
    if (yesno()) {
      ioobj.sstr("How much would you like to give? ");
    strcpy(c,"");
      ioobj.gstr(c, 5L);
      if (sscanf(c,"%ld", &gift) == 1)
      {
      if (gift <= 0)
      {
	ioobj.sstrcr("The priest says:  'Thanks for nothing.  ");
	ioobj.sstrcr("God remembers those who try to cheat Him'");
      }
      else {
	if (gift > uptr->gold)
	 ioobj.sstrcr("The priest says:  'I am sorry you could not give us any gold.'");
	else {
	 ioobj.sstrcr("The priest thanks you profusely.  ");
	  uptr->gold -= gift;
	  base = (uptr->gold + uptr->bank) / (100/theoptions.difficulty);
	  if (base == 0)
	    base = 1;
	  base = gift / base;
	}
      }
     } 
    }
   ioobj.sstrcr("The priest walks off.");
  } else {
   ioobj.sstrcr("You walk into an immense building.  The sheer size of it is astounding.");
   ioobj.sstrcr(
      "What is more, every thing is made from red granite with veins of gold in it.");
   ioobj.sstrcr("gold is to be found almost everywhere.");
   ioobj.sstrcr("Even the pews are inlaid with gold.  What an opulent place!");
   ioobj.sstrcr("A deacon shambles up to you.  He sneers:");
   ioobj.sstrcr("Welcome, your highess.  Would you like to contribute to our ");
    ioobj.sstr("beautiful establishment? ");
    base = 0;
    if (yesno()) {
      ioobj.sstr("How much would you like to give? ");
    strcpy(c,"");
      ioobj.gstr(c, 5L);
      stringtonum(c, &gift);
      if (gift <= 0)
	ioobj.sstrcr("The deacon says:  'Your mother wears army boots!'");
      else {
	if (gift > uptr->gold)
	 ioobj.sstrcr("the priest says:  'Yeah, right.  Imaginary gold.  Cheapskate.'");
	else {
	 ioobj.sstrcr("The deacon grabs the gold, and sneers: 'Thanks.'  ");
	  uptr->gold -= gift;
	  base = (uptr->gold + uptr->bank) / (50*theoptions.difficulty);
	  if (base == 0)
	    base = 1;
	  base = gift / base;
	}
      }
    }
   ioobj.sstrcr("The deacon saunters off.");
  }
  ioobj.sstr("Would you like to pray? ");
  if (yesno()) {
   ioobj.sstrcr("You enter one of the pews..");
   ioobj.sstrcr("You kneel, and concentrate on praying..");
    tmp = abs(rand() % 100) - base;
    if (tmp < (3*theoptions.difficulty))
      uh_oh();	// bad thing
    else if (tmp < (10*(theoptions.difficulty/2+1)))
      neat();	// good thing
    else {
     ioobj.sstrcr("But, it seems that the gods are deaf to pleas today.");
     ioobj.sstrcr("Maybe if you try again tomorrow..");
    }
  } else
   ioobj.sstrcr("You leave the church..");
  ioobj.waitcr();
}

void create_villages(void)
{

  FILE *vilfile;
  Village village;
  char STR1[256];
  char name[32];
  long FORLIM;
  struct stat buf;
  int count;

  vilfile = NULL;
  sprintf(STR1, "%s/Villages", CONFDIR);
  if (stat(STR1,&buf) < 0)
  {  /* doesn't exist */
	  ioobj.sstrcr("Creating villages");
	  sprintf(STR1, "%s/Villages", CONFDIR);
	  vilfile = ioobj.bopen(STR1, "wb");
	  if (vilfile == NULL)
	    {
		perror(STR1);
		exit_game(1);
	    }
	  FORLIM = (long)floor(sqrt((double)boardsize) + 0.5);
	  for (count = 1; count <= FORLIM; count++) {
	    villagenames(count, name);
	    strcpy(village.name, name);
	    village.regeneration = abs(rand() % 15) + 5;
	    village.men = abs(rand() % 30000) + 50000L;
	    village.price = abs(rand() & 1) + 1;
	    village.sector = abs(rand() % boardsize) + 1;
	    fwrite(&village, sizeof(Village), 1, vilfile);
	  }
	  ioobj.bclose(vilfile);
	  chmod(STR1,0775);
  }
}

boolean find_village_in_sector(long sector, Village **village)
{
  Village *gptr;
  boolean found;


  gptr = villages;
  found = false;
  while (gptr != NULL && !found) {
    if (gptr->sector == sector) {
      found = true;
      *village = gptr;
    } else
      gptr = gptr->next;
  }
  return found;
}

void buy_armor(long base)
{
  long worth, worth2,tworth;
  char s[256];
  boolean chose;
  long tmp3, top;
  int x,max,choice;
  char armorn[32];
  Castle *cptr;
  Player *uptr;
  char tmpstr[256];

  top = 0;
  if (!find_player_by_name(playername, &uptr))
    ioobj.sstrcr("player not found!");
  else {
    ioobj.clear_scr();
    ioobj.sstrcr("You enter a stout shop with an old cuirass hanging");
    ioobj.sstrcr("above the door.  As you enter, a very large man ");
    ioobj.sstrcr("appears behind the counter.  He says:");
    ioobj.sstrcr("Welcome to: ");
    ioobj.sstrcr("The armor shop ");
    ioobj.sstrcr("\"We'll save you from that sword point\"");
    ioobj.sstr("Let's see..your armor currently is ");
    if (uptr->armor < 1 || uptr->armor > 20)
      uptr->armor = 1;
    get_armor(uptr->armor, armorn, &worth);
    ioobj.sstrcr(armorn);
    if (worth == -1) {
	sprintf(s,"Sire, since I do not deal in divine armor, %s is useless to me. ",armorn);
      ioobj.sstrcr("My services are useless to you.");
      ioobj.waitcr();
    } else {
      ioobj.waitcr();
      ioobj.clear_scr();
      // rob em blind!
      chose = false;
      sprintf(tmpstr, "Your trade is worth %ld gold pieces new.", worth);
      ioobj.sstrcr(tmpstr);
      worth2 = 0;
      if (worth > 0) {
	worth2 = worth / 2 + abs(rand() % 1000);
	ioobj.sstr("But , because of ");
	ioobj.sstrcr("its worn condition, I may only give you ");
	sprintf(tmpstr, "%ld gold pieces.", worth2);
	ioobj.sstrcr(tmpstr);
      }
      tmp3 = worth2 + uptr->gold;
      sprintf(tmpstr, "You have %ld (%ld total) gold pieces.", uptr->gold,tmp3);
      ioobj.sstrcr(tmpstr);
      ioobj.sstrcr("Here is the current armor price list:");
      ioobj.sstrcr("You may buy the following ");
      ioobj.sstrcr("------------------------------------------------");
      max = 100;
      for (x=2; x<=16; x++)
      {
        get_armor(x, armorn, &tworth);
	if (x > 10)
	{	// only show a few top ones
		if (x < max)
		{	// once failed, the user won't see again
			if (abs(rand() % 35) + uptr->luck > 28) 
			{
				sprintf(tmpstr,"%x. %-26s %9ld",x-2,armorn,tworth);
				ioobj.sstrcr(tmpstr);
			}
			else
				max = x;
		}
	}
	else
	{
		sprintf(tmpstr,"%x. %-26s %9ld",x-2,armorn,tworth);
		ioobj.sstrcr(tmpstr);
	}
      }
      ioobj.sstr("Your choice? ");
    strcpy(s,"");
      ioobj.gstr(s, 1L);
      if (strlen(s) > 0)
      {
	      sscanf(s,"%x", &choice);
	      choice += 2;
	      if (choice <= 0xf+2)
	      {
		      get_armor(choice, armorn, &tworth);
			if (tmp3 < tworth)
			{
				  ioobj.sstrcr("I am sorry milord, you do not have enough"); 
				  sprintf(tmpstr,"gold to buy %s.",armorn);
				  ioobj.sstrcr(tmpstr);
			}
			else
			{
			  uptr->armor = choice;
			  cptr = castles;
			  while (cptr != NULL) {
			    if (!strcmp(cptr->alias, uptr->alias))
			      cptr->armor = uptr->armor;
			    cptr = cptr->next;
			  }
			  uptr->gold = tmp3 - tworth;
			}
		}
	}
    }
    ioobj.sstrcr("Thank you for your business, milord!");
    ioobj.waitcr();
  }
}


void buy_weapons(long base)
{
  char weaponn[32];
  long worth, worth2,tworth;
  char s[256];
  boolean chose;
  long tmp3, top;
  int x,max,choice;
  Castle *cptr;
  Player *uptr;
  char tmpstr[256];

  top = 0;
  if (!find_player_by_name(playername, &uptr))
   ioobj.sstrcr("player not found!");
  else {
    ioobj.clear_scr();
   ioobj.sstrcr("A small but powerful blacksmith appears");
   ioobj.sstrcr("from the back of the shop as you enter.");
   ioobj.sstrcr("He says:");
   ioobj.sstrcr("Welcome to: ");
    if (uptr->weapon < 1 || uptr->weapon > 20)
      uptr->weapon = 1;
   ioobj.sstrcr("The Weapon Shop ");
   ioobj.sstrcr("\"Dastardly deeds do need us\"");
    ioobj.sstr("Let's see..your weapons currently are ");
    get_weapon(uptr->weapon, weaponn, &worth);
   ioobj.sstrcr(weaponn);
    if (worth == -1) {
     ioobj.sstrcr(
	"Sire, since I do not deal in divine weapons, firebrands are worthless to me. ");
     ioobj.sstrcr("My shop is useless to you.");
      ioobj.waitcr();
    } else {
      ioobj.waitcr();
      ioobj.clear_scr();
      // rob em blind!
      chose = false;
      sprintf(tmpstr, "Your trade is worth %ld gold pieces new.", worth);
      ioobj.sstrcr(tmpstr);
      worth2 = 0;
      if (worth > 0) {
	worth2 = worth / 2 + abs(rand() % 1000);
	ioobj.sstr("But , because of ");
	ioobj.sstrcr("its worn condition, I may only give you ");
	sprintf(tmpstr, "%ld gold pieces.", worth2);
	ioobj.sstrcr(tmpstr);
      }
      tmp3 = worth2 + uptr->gold;
      sprintf(tmpstr, "You have %ld (%ld total) gold pieces.", uptr->gold,tmp3);
      ioobj.sstrcr(tmpstr);
      ioobj.sstrcr("Here is the current weapon price list:");
      ioobj.sstrcr("You may buy the following ");
      ioobj.sstrcr("------------------------------------------------");
      max = 100;
      for (x=2; x<=16; x++)
      {
        get_weapon(x, weaponn, &tworth);
	if (x > 10)
	{	// only show a few top ones
		if (x < max)
		{	// once failed, the user won't see again
			if (abs(rand() % 35) + uptr->luck > 28) 
			{
				sprintf(tmpstr,"%x. %-26s %9ld",x-2,weaponn,tworth);
				ioobj.sstrcr(tmpstr);
			}
			else
				max = x;
		}
	}
	else
	{
		sprintf(tmpstr,"%x. %-26s %9ld",x-2,weaponn,tworth);
		ioobj.sstrcr(tmpstr);
	}
      }
      ioobj.sstr("Your choice? ");
    strcpy(s,"");
      ioobj.gstr(s, 1L);
      if (strlen(s) != 0)
      {
	      sscanf(s,"%x", &choice);
	      choice +=2;
	      if (choice <= 0xf+2)
	      {
			get_armor(choice, weaponn, &tworth);
			if (tmp3 < tworth)
			{
				  ioobj.sstrcr("I am sorry milord, you do not have enough"); 
				  sprintf(tmpstr,"gold to buy %s.",weaponn);
				  ioobj.sstrcr(tmpstr);
			}
			else
			{
			  uptr->weapon = choice;
			  cptr = castles;
			  while (cptr != NULL) {
			    if (!strcmp(cptr->alias, uptr->alias))
			      cptr->weapon = uptr->weapon;
			    cptr = cptr->next;
			  }
			  uptr->gold = tmp3 - tworth;
			}
		}
	}
    }
   ioobj.sstrcr("Thank you for your business, milord!");
   ioobj.sstrcr("You leave the shop");
  }
  ioobj.waitcr();
}

void get_villages(Village **villages)
{
  FILE *vilfile;
  Village *vptr, vilrec;
  char STR1[256];

  vilfile = NULL;
  sprintf(STR1, "%s/Villages", CONFDIR);
  vilfile = ioobj.bopen(STR1, "rb");
  if (vilfile == NULL)
    {
	perror(STR1);
	exit_game(1);
    }
  while (!feof(vilfile)) {
    if (fread(&vilrec, sizeof(Village), 1, vilfile) == 1)
    {
	    vptr = (Village *)malloc(sizeof(Village));
	    strcpy(vptr->name, vilrec.name);
	    vptr->sector = vilrec.sector;
	    vptr->price = vilrec.price;
	    vptr->regeneration = vilrec.regeneration;
	    vptr->men = vilrec.men;
	    vptr->next = *villages;
	    *villages = vptr;
    }
  }
  ioobj.bclose(vilfile);
}

void mercenaries(boolean castle,long mercprice)
{
  long rate;
  boolean done;
  long tmp;
  char s[256];
  Village *vptr;
  long warriors;
  Player *uptr;
  char STR2[256], STR3[256];

  ioobj.clear_scr();
  if (!find_player_by_name(playername, &uptr)) {
   ioobj.sstrcr("can't find player!");
    return;
  }
  done = false;
 ioobj.sstrcr("Welcome to: ");
 ioobj.sstrcr("The warriors guild");
 ioobj.sstrcr("\"Where one may hire the warriors dynasties are founded with\"");
  ioobj.cr();
  if (!castle) {
    if (!find_village_in_sector(currentsector, &vptr))
      rate = 5;
    else
      rate = vptr->price;
  } else
    rate = mercprice;
  while (!done) {
    if (rate <= 0)
      rate = 1;
    rate *= theoptions.difficulty;	// adjust for difficulty
    ioobj.sstr("The going rate for mercenaries is ");
    sprintf(STR2, "%ld per man.", rate);
   ioobj.sstrcr(STR2);
    ioobj.cr();
    if (!castle && rate != 5) {
      vptr->men = labs(vptr->men);
      sprintf(STR3, "We have %ld men available.", vptr->men);
     ioobj.sstrcr(STR3);
    }
    ioobj.cr();
    uptr->gold = labs(uptr->gold);
    tmp = uptr->gold / rate;
    sprintf(STR3, "You can afford %ld", tmp);
    ioobj.sstr(STR3);
   ioobj.sstrcr(" warriors.");
    ioobj.cr();
    sprintf(STR2, "You have %ld warriors in your army.", uptr->armysize);
   ioobj.sstrcr(STR2);
    ioobj.cr();
    ioobj.sstr("How many warriors would you like? ");
    strcpy(s,"");
    ioobj.gstr(s, 10L);
    stringtonum(s, &warriors);
    if (!castle && warriors > vptr->men) {
     ioobj.sstrcr("We do not have that many warriors available!");
      continue;
    }
    if (warriors <= 0) {
      done = true;
      break;
    }
    if (warriors <= 0 || warriors >= 1000000L)
      continue;
    if (warriors * rate > uptr->gold) {
     ioobj.sstrcr("You cannot afford that many warriors.  please choose again. ");
      continue;
    }
    done = true;
    uptr->gold -= warriors * rate;
    uptr->armysize += warriors;
    sprintf(STR2, "You have bought %ld warriors.", warriors);
    ioobj.sstrcr(STR2);
    ioobj.cr();
    if (!castle && rate != 5)
      vptr->men -= warriors;
   ioobj.sstrcr("Thank you for your business");
    ioobj.cr();
    ioobj.waitcr();
  }
}

void rumors(void)
{
  Player *uptr, *uptr2;
  Castle *cptr;
  telerec *tele;
  int count;
  int where;
  long numtele, numcastles, numplayers, tmp;
  char STR3[256];

  ioobj.clear_scr();
  bar++;
  if (bar > 5) {
   ioobj.sstrcr("As you enter the bar, the bartender yells:");
   ioobj.sstrcr("You're getting too drunk.  Get out!");
   ioobj.sstrcr("After which, he throws you out on your ear.");
   ioobj.sstrcr("You try to get up only to find that you really are drunk.");
   ioobj.sstrcr("Maybe a drink wasn't such a good idea after all...");
  } else {
    if (!find_player_by_name(playername, &uptr))
     ioobj.sstrcr("error!");
   ioobj.sstrcr("You enter a building with a mug on the sign above the door.");
   ioobj.sstrcr("It is a saucy little place, with thick smoke hanging in the air.");
   ioobj.sstrcr("You see a greasy bartender working behind the bar.");
    ioobj.sstr("Do you want to buy a drink? ");
    if (yesno()) {
     ioobj.sstrcr("Sauntering up, you buy a drink.");
     sprintf(STR3,"The bartender says:  %d gold pieces please.",2*theoptions.difficulty);
     ioobj.sstrcr(STR3);
      if (uptr->gold <= 2*theoptions.difficulty) {
	ioobj.sstrcr("You don't have the gold!  Well, maybe you will get a drink ");
	ioobj.sstrcr("another day.");
      } else {
	sprintf(STR3,"You give the bartender the %d gold pieces.",2*theoptions.difficulty);
	ioobj.sstrcr(STR3);
	uptr->gold -= 2*theoptions.difficulty;
	ioobj.sstrcr("Then you ask the bartender for some information..");
	tmp = abs(rand() % 60*theoptions.difficulty);
	if (tmp < 30) {
	  if (tmp < 6) {
	    uptr2 = players;
	    numplayers = 0;
	    while (uptr2 != NULL) {
	      uptr2 = uptr2->next;
	      numplayers++;
	    }
	    do {
	      tmp = abs(rand() % numplayers);
	      uptr2 = players;
	      count = 0;
	      while (count < tmp) {
		count++;
		uptr2 = uptr2->next;
	      }
	    } while (uptr2->dead);
	   ioobj.sstrcr("The bartender steps up to you and says: ");
	    tmp = abs(rand()%100);
	    if (tmp > 95)	// 4% chance of a 'fudge'
		where = uptr2->sector = abs(rand()%20);	    	
	    else
	    	where = uptr2->sector;
	    sprintf(STR3, "I hear that %s is in sector %d.", uptr2->alias, where);
	   ioobj.sstrcr(STR3);
	   ioobj.sstrcr(
	      "You look at the bartender.  You're not really sure that the information");
	   ioobj.sstrcr("is valid, but you thank him anyway.");
	  } else if (tmp < 14) {
	    cptr = castles;
	    numcastles = 0;
	    while (cptr != NULL) {
	      numcastles++;
	      cptr = cptr->next;
	    }
	    tmp = abs(rand() % numcastles);
	    count = 0;
	    cptr = castles;
	    while (count < tmp) {
	      count++;
	      cptr = cptr->next;
	    }
	   ioobj.sstrcr("The bartender sneaks up to you and speaks:");
	    tmp = abs(rand()%100);
	    if (tmp > 95)	// 4% chance of a 'fudge'
		where = cptr->sector = abs(rand()%20);	    	
	    else
	    	where = cptr->sector;
	    sprintf(STR3, "I hear that the castle %s is in sector %d.", cptr->name, where);
	   ioobj.sstrcr(STR3);
	   ioobj.sstrcr("The bartender then walks away.");
	   ioobj.sstrcr("You aren't sure whether he was pulling your leg.");
	  } else if (tmp < 18) {
	   ioobj.sstrcr("The bartender practically falls over himself trying to speak.");
	   ioobj.sstrcr("Have you heard the news?  They say they've found an old relic in ");
	    tele = teleporters;
	    numtele = 0;
	    while (tele != NULL) {
	      tele = tele->next;
	      numtele++;
	    }
	    tmp = abs(rand() % numtele);
	    tele = teleporters;
	    count = 0;
	    while (count < tmp) {
	      count++;
	      tele = tele->next;
	    }
	    sprintf(STR3, "sector %ld.  They say it was a teleporter!", tele->sector);
	   ioobj.sstrcr(STR3);
	   ioobj.sstrcr("They even say it still works!");
	   ioobj.sstrcr("You are intensely curious about this, but the bartender can tell");
	   ioobj.sstrcr("you no more.");
	  } else {
	   ioobj.sstrcr("The bartender walks up to you and speaks:");
	   ioobj.sstrcr("Sorry, but it has been very quiet around here lately");
	   ioobj.sstrcr("I haven't heard a thing.");
	  }
	} else {
	 ioobj.sstrcr("The bartender walks up to you and speaks:");
	 ioobj.sstrcr("Sorry, but it has been very quiet around here lately");
	 ioobj.sstrcr("I haven't heard a thing.");
	}
      }
    }
  }
 ioobj.sstrcr("You leave the tavern.");
  ioobj.waitcr();
}


void teleport(void)
{
  Castle *cptr, *clist, *lptr;
  char c[256];
  Player *player;
  long count, count2;
  char STR1[56];
  char STR2[256];

  if (!find_player_by_name(playername, &player))
   ioobj.sstrcr("something is really screwed!!!");
  clist = NULL;
  cptr = castles;
  ioobj.clear_scr();
  count = 0;
  while (cptr != NULL) {
    if (cptr->alliance == player->alliance && player->alliance != 0 ||
	!strcmp(cptr->alias, player->alias)) {
      lptr = (Castle *)malloc(sizeof(Castle));
      lptr->sector = cptr->sector;
      strcpy(lptr->name, cptr->name);
      lptr->next = clist;
      clist = lptr;
      count++;
    }
    cptr = cptr->next;
  }
  if (count < 2) {
   ioobj.sstrcr("Milord!  You do not have another friendly castle to teleport to!");
    ioobj.cr();
   ioobj.sstrcr("You must conquer one to teleport!");
    ioobj.waitcr();
    return;
  }
 ioobj.sstrcr("You walk into a brightly lit chamber that glows with energy.  ");
 ioobj.sstrcr("Strange, magical paraphenalia are scattered in exact places in the room.");
 ioobj.sstrcr("A man walks up to you and asks:  ");
 ioobj.sstrcr("\"Where would you like me to transport you , sire ?\"");
 ioobj.sstrcr("Since you don't know the magical names for places he can transport ");
 ioobj.sstrcr("you and your army, you ask him for a list.  He gives one to you.");
 ioobj.sstrcr("The list follows: ");
  count2 = 1;
  cptr = clist;
 ioobj.sstrcr("0.  Don't Teleport");
  while (cptr != NULL) {
    sprintf(STR2, "%ld.  ", count2);
    ioobj.sstr(STR2);
    sprintf(STR1, "%s                       ", cptr->name);
    sprintf(STR2, "%.30s", STR1);
    ioobj.sstr(STR2);
    sprintf(STR2, " in sector %ld", cptr->sector);
   ioobj.sstrcr(STR2);
    cptr = cptr->next;
    count2++;
  }
  ioobj.sstr("Your choice? ");
    strcpy(c,"");
  ioobj.gstr(c, 3L);
  stringtonum(c, &count);
  if (count2 - 1 < count || count <= 0) {
   ioobj.sstrcr("Teleport aborted.");
    ioobj.cr();
    ioobj.waitcr();
    return;
  }
  count2 = 1;
  cptr = clist;
  while (count2 < count) {
    cptr = cptr->next;
    count2++;
  }
  currentsector = cptr->sector;
  player->sector = cptr->sector;
  cptr = clist;
  while (cptr != NULL) {
    lptr = cptr;
    cptr = cptr->next;
    free(lptr);
  }
}

void update_villages(Village **villages)
{
  Village *vptr;

  vptr = *villages;
  while (vptr != NULL) {
    if (vptr->men < 300000L)
      vptr->men += (10000 * vptr->regeneration)/theoptions.difficulty;
    vptr = vptr->next;
  }
}

void villagenames(long number, char *name)
{
  switch (number) {

  case 1:
    strcpy(name, "Dirt");
    break;

  case 2:
    strcpy(name, "Makon");
    break;

  case 3:
    strcpy(name, "Gr'Nell");
    break;

  case 4:
    strcpy(name, "Turin");
    break;

  case 5:
    strcpy(name, "Kion");
    break;

  case 6:
    strcpy(name, "Firton");
    break;

  case 7:
    strcpy(name, "Opior");
    break;

  case 8:
    strcpy(name, "Eanor");
    break;

  case 9:
    strcpy(name, "Hamal");
    break;

  case 10:
    strcpy(name, "Miden");
    break;

  case 11:
    strcpy(name, "Mark");
    break;

  case 12:
    strcpy(name, "Geom");
    break;

  case 13:
    strcpy(name, "Tyrome");
    break;

  case 14:
    strcpy(name, "Garisha");
    break;

  case 15:
    strcpy(name, "Humat");
    break;

  case 16:
    strcpy(name, "Q'Mere");
    break;

  case 17:
    strcpy(name, "Ionia");
    break;

  case 18:
    strcpy(name, "Deon");
    break;

  case 19:
    strcpy(name, "Pvarik");
    break;

  case 20:
    strcpy(name, "R'Maria");
    break;

  case 21:
    strcpy(name, "Weria");
    break;

  case 22:
    strcpy(name, "Henra");
    break;

  case 23:
    strcpy(name, "Y'Hima");
    break;

  case 24:
    strcpy(name, "Kirol");
    break;

  case 25:
    strcpy(name, "Mar");
    break;

  case 26:
    strcpy(name, "Branc");
    break;

  case 27:
    strcpy(name, "S'Makir");
    break;

  case 28:
    strcpy(name, "Demarn");
    break;

  case 30:
    strcpy(name, "Rania");
    break;

  case 31:
    strcpy(name, "Anrovia");
    break;

  case 32:
    strcpy(name, "Mak Morn");
    break;

  case 33:
    strcpy(name, "Grala");
    break;

  case 34:
    strcpy(name, "T'Mir");
    break;

  case 35:
    strcpy(name, "Jefron");
    break;

  case 36:
    strcpy(name, "Ricion");
    break;

  case 37:
    strcpy(name, "Antione");
    break;

  case 38:
    strcpy(name, "Tudor");
    break;

  case 39:
    strcpy(name, "Doncat");
    break;

  case 40:
    strcpy(name, "Yus");
    break;

  case 41:
    strcpy(name, "Bion's Stead");
    break;

  case 42:
    strcpy(name, "Liron");
    break;

  case 43:
    strcpy(name, "Fleh");
    break;

  case 44:
    strcpy(name, "Vicoma");
    break;

  case 45:
    strcpy(name, "Iumio");
    break;

  case 46:
    strcpy(name, "Thaka");
    break;

  case 47:
    strcpy(name, "G'Nam");
    break;

  case 48:
    strcpy(name, "Waron");
    break;

  case 49:
    strcpy(name, "Weston");
    break;

  case 50:
    strcpy(name, "Micam");
    break;

  case 51:
    strcpy(name, "Jamis");
    break;

  case 52:
    strcpy(name, "Xeon");
    break;

  case 53:
    strcpy(name, "Marathon");
    break;

  case 54:
    strcpy(name, "Hilon");
    break;

  case 55:
    strcpy(name, "Eakin");
    break;

  case 56:
    strcpy(name, "Ft. Collins");
    break;

  case 57:
    strcpy(name, "Fiaka");
    break;

  case 58:
    strcpy(name, "Deon");
    break;

  case 59:
    strcpy(name, "Vionha");
    break;

  case 60:
    strcpy(name, "Kanaka");
    break;

  case 61:
    strcpy(name, "Nisam");
    break;

  case 62:
    strcpy(name, "Anakim");
    break;

  case 63:
    strcpy(name, "Birton");
    break;

  case 64:
    strcpy(name, "Hamiria");
    break;

  case 65:
    strcpy(name, "Jamicia");
    break;

  case 66:
    strcpy(name, "Dearton");
    break;

  case 67:
    strcpy(name, "Min");
    break;

  case 68:
    strcpy(name, "Bern");
    break;

  case 69:
    strcpy(name, "Jorge");
    break;

  case 70:
    strcpy(name, "Teriop");
    break;

  case 71:
    strcpy(name, "Eabin");
    break;

  case 72:
    strcpy(name, "Laroin");
    break;

  case 73:
    strcpy(name, "Wen");
    break;

  case 74:
    strcpy(name, "Tni-Mga");
    break;

  case 75:
    strcpy(name, "Coy");
    break;

  case 76:
    strcpy(name, "Uin");
    break;

  case 77:
    strcpy(name, "Oikos");
    break;

  case 78:
    strcpy(name, "Ren");
    break;

  case 79:
    strcpy(name, "Miax");
    break;

  case 80:
    strcpy(name, "Rontor");
    break;

  case 81:
    strcpy(name, "Pon");
    break;

  case 82:
    strcpy(name, "Nim");
    break;

  case 83:
    strcpy(name, "Myn");
    break;

  case 84:
    strcpy(name, "Xin");
    break;

  case 85:
    strcpy(name, "Thym");
    break;

  case 86:
    strcpy(name, "Mytn");
    break;

  case 87:
    strcpy(name, "Pan");
    break;

  case 88:
    strcpy(name, "Stedding Shang'Tai");
    break;

  case 89:
    strcpy(name, "Wearn");
    break;

  case 90:
    strcpy(name, "Ban");
    break;

  case 91:
    strcpy(name, "Sfix");
    break;

  case 92:
    strcpy(name, "Calvin");
    break;

  case 93:
    strcpy(name, "Cen");
    break;

  case 94:
    strcpy(name, "Yar");
    break;

  case 95:
    strcpy(name, "Chir");
    break;

  case 96:
    strcpy(name, "Earnid");
    break;

  case 97:
    strcpy(name, "Sisay");
    break;

  case 98:
    strcpy(name, "Birnim");
    break;

  case 99:
    strcpy(name, "Quean");
    break;

  case 100:
    strcpy(name, "Hok Non");
    break;

  default:
    strcpy(name, "Tomayon");
    break;
  }
}

#endif  _TOWN_C_
