#ifndef _SCORES_C_
#define _SCORES_C_

#include "bf.h"


void clear_scores(scorerec *scores)
{
  long count;

  for (count = 0; count <= 19; count++)
    scores[count].score = 0;
}


void high_scores(boolean tofile, boolean final)
{
  scorarray scores;
  long count;
  Castle *gptr;
  long thetype;
  Player *uptr;
  alliancerec *aptr;
  scorerec playerscore;
  long ucount;
  FILE *scorefile;
  time_t now;
  char s[255];

  scorefile = NULL;
  if (tofile) {
	if (final) 
		sprintf(s,"%s/BattleField Victories",CONFDIR);
	else
		sprintf(s,"%s",theoptions.scorespath);
	if (scorefile = ioobj.bopen(s,"w"), scorefile == NULL)
	{
		ioobj.ap_log("Unable to open scores output file.");
		return;
	}
  }
  else
  	scorefile = stdout;	// pipe to stdout
  clear_scores(scores);
  uptr = players;
  while (uptr != NULL) {
    playerscore.score = uptr->experience * 5 + uptr->armysize * 100 +
	uptr->weapon * 100 + uptr->armor * 100 + uptr->gold + uptr->bank;
    gptr = castles;
    while (gptr != NULL) {
      if (!strcmp(gptr->alias, uptr->alias)) {
	playerscore.score += 10000;
	playerscore.score += gptr->defend * 100;
      }
      gptr = gptr->next;
    }
    strcpy(playerscore.name, uptr->alias);
    strcpy(playerscore.killedby, uptr->killedby);
    playerscore.score /= 15113;
    insert_score(playerscore, scores);
    uptr = uptr->next;
  }
    time(&now);
    fprintf(scorefile, "BattleField High Scores for %s\n", ctime(&now));
    fprintf(scorefile, "Top Royalty:\n");
    fprintf(scorefile,
	    "Rank     Score      Name                           Killed by\n");
    fprintf(scorefile,
	    "----     -----      ----                           --------\n");
    for (count = 0; count <= 14; count++) {
      if (scores[count].score > 0) {
	fprintf(scorefile, "%2ld.    %7ld      %-30s %s\n", count+1,scores[count].score,scores[count].name,scores[count].killedby);
      }
    }
    if (!tofile)
	    ioobj.waitcr();

  clear_scores(scores);
  gptr = castles;
  while (gptr != NULL) {
    playerscore.score = gptr->defend * 100 + gptr->weapon * 100 +
	gptr->armor * 100 + gptr->towers * 100000L + gptr->moat * 50000L +
	gptr->wall * 75000L + gptr->oil * 15000;
    playerscore.score /= 2101;
    get_castle_type(gptr, s, &thetype);
    gptr->castype = thetype;
    sprintf(playerscore.name, "%s %s", s, gptr->name);
    strcpy(playerscore.killedby, gptr->alias);
    if (gptr->alliance != 99)
      insert_score(playerscore, scores);
    gptr = gptr->next;
  }
    fprintf(scorefile, "\n\n\nTop Castles:\n");
    fprintf(scorefile,
	    "Rank     Score      Name                           Owned by\n");
    fprintf(scorefile,
	    "----     -----      ----                           --------\n");
    for (count = 0; count <= 14; count++) {
      if (scores[count].score > 0) {
	fprintf(scorefile, "%2ld.    %7ld      %-30s %s\n", count+1,scores[count].score,scores[count].name,scores[count].killedby);
      }
    }
    if (!tofile)
	    ioobj.waitcr();
  clear_scores(scores);
  aptr = alliances;
  while (aptr != NULL) {
    ucount = 0;
    uptr = players;
    playerscore.score = 0;
    while (uptr != NULL) {
      if (uptr->alliance == aptr->num) {
	ucount++;
	playerscore.score += uptr->armysize * 100 + uptr->weapon * 100 +
			   uptr->armor * 100 + uptr->gold + uptr->bank;
	gptr = castles;
	while (gptr != NULL) {
	  if (!strcmp(gptr->alias, uptr->alias))
	    playerscore.score += 1000;
	  gptr = gptr->next;
	}
	strcpy(playerscore.name, uptr->alliancename);
      }
      uptr = uptr->next;
    }
    playerscore.score /= 2111;
    playerscore.members = ucount;
    insert_score(playerscore, scores);
    aptr = aptr->next;
  }
    fprintf(scorefile, "\n\n\n\nTop Alliances:\n");
    fprintf(scorefile,
      "Rank     Score      Name                           Number of Members\n");
    fprintf(scorefile,
      "----     -----      ----                           ----------------\n");
    for (count = 0; count <= 14; count++) {
      if (scores[count].score > 0) {
	fprintf(scorefile, "%2ld.    %7ld      %-30s %ld\n", count+1,scores[count].score,scores[count].name,scores[count].members);
      }
    }
    if (!tofile)
	    ioobj.waitcr();
  count = 1;
  if (tofile) {
    if (scorefile != NULL)
      ioobj.bclose(scorefile);
	if (final) 
		sprintf(s,"%s/BattleField Victories",CONFDIR);
	else
		sprintf(s,"%s",theoptions.scorespath);
    	chmod(s,0775);
  }
}


void insert_score(scorerec thescore, scorerec *scores)
{
  long count;
  scorerec tmp, tmp2;
  boolean inserted;

  inserted = false;
  for (count = 0; count <= 19; count++) {
    if (thescore.score > scores[count].score && !inserted) {
      inserted = true;
      tmp = scores[count];
      scores[count] = thescore;
    } else if (inserted) {
      tmp2 = scores[count];
      scores[count] = tmp;
      tmp = tmp2;
    }
  }

}

#endif // _SCORES_C_
