// Filename:	Player.h
// Contents:	the Player object
// Author:	Greg Shaw
// Created:	6/26/95

#ifndef _PLAYER_H_
#define _PLAYER_H_

#include "bf.h"

typedef struct Player
{
  char name[32]; 	// name in game
  char alias[32];	// alias in game
  char alliancename[32];// name of alliance
  char killedby[32];	// last killed by
  // where player is located
  long sector;		// sector
  long region; 		// region
  long region_sub;	// subregion
  long armysize;	// size of army 
  long armor;		// armor type
  long weapon;		// weapon type
  long castaken;	// number of castles taken over time
  // statistics
  long str; 		// strength 
  long int_;		// intelligence
  long luck; 		// luck 
  long chrs;		// charisma 
  long level;		// level
  long experience;	// experience
  long agi;		// agility
  long race;		// race type
  long gold;		// gold in posession
  long alliance;	// alliance number
  long killed;		// # of men killed in the last battle
  long bank;		// amount of gold in the bank
  long timesplayed;	// # of times played
  long goldfound;	// gold found on an unsuccessful assassin
  long himsg;		// highest message read
  // spells
  int teleport; 	// # of teleport spells
  int map; 		// # of map spells
  int dmons; 		// # of destroy monster spells
  int killer;		// # of kill Player spells
  int descas;		// # of destroy castle spells
  int mweapon;		// # of magical weapon upgrade spells
  int mwarriors;	// # of magical warriors upgrade spells
  int steal;		// # of steal castle spells
  boolean male; 	// 1 = male, 0 = female
  boolean incastle;	// 1 = in castle when quit
  boolean alignment;	// alignment
  boolean dead;		// player dead?
  boolean allianceleader;// leader (creator) of alliance?
  time_t entrydate; 	// last entry date
  time_t lastlogon;	// last logon
  time_t last_bank_visit;// the last time the player collected their interest
  struct Player *next;
} Player;


#endif // _PLAYER_H_
