#ifndef _PLAYER_C_
#define _PLAYER_C_

#include "bf.h"





void addplayer(Player player)
{
  Player *gptr;

  gptr = (Player *)malloc(sizeof(Player));
  memcpy(gptr,&player,sizeof(Player));
  gptr->next = players;
  players = gptr;
}




void change_player_name()
{
  char c[256];
  Player *uptr;
  Castle *gptr;
  Army *aptr;
  char STR1[256];
  int done;

  if (!find_player_by_name(playername, &uptr))
   ioobj.sstrcr("error!");
 done = 0;
 while (!done)
 {
	ioobj.sstrcr("What would you like to change your name to?");
	ioobj.sstrcr("                1-------10--------20--------30");
	ioobj.sstr("Prince/Princess |");
	strcpy(c,"");
	ioobj.gstr(c, 31L);
	sprintf(c, "%.30s", strcpy(STR1, c));
	if (find_castle_by_o_a(c, &gptr) || c[0] == ' ')
		ioobj.sstrcr("I'm sorry, but that name is already taken.  Name change aborted.");
	else {
		cptr = castles;
		while (cptr != NULL) {
			if (!strcmp(cptr->alias, uptr->alias))
				strcpy(cptr->alias, c);
				cptr = cptr->next;
		}
		strcpy(uptr->alias, c);
		aptr = armies;
		while (aptr != NULL) {
			if (!strcmp(aptr->owner, uptr->alias))
				strcpy(aptr->owner, c);
			aptr = aptr->next;
		}
		ioobj.sstrcr("Name changed!");
		done++;
	}
	ioobj.waitcr();
 }
}



void check_for_level(Player *player)
{
  long level;
  double num;
  char STR1[256], STR2[256];


  level = 1;
  num = 450.0;
  while (num < player->experience) {
    level++;
    num *= 1.5;
  }
  level--;
  if (level <= player->level)
    return;
  ioobj.clear_scr();
  ioobj.sstrcr("Congratulations, sire, you have gained from the fight,");
  sprintf(STR2, "%ld %s.", level-player->level, level-player->level>1?"levels":"level");
  ioobj.sstrcr(STR2);
  player->level = level;
  sprintf(STR1, "You are now level %ld", level);
  ioobj.sstrcr(STR1);
  ioobj.waitcr();
  ioobj.clear_scr();
  if (player->level == 40)
    reset_game(true, true);
}


void check_for_win(void)
{
  Castle *cptr;
  Player *uptr;
  boolean found;

  if (!find_player_by_name(playername, &uptr))
    ioobj.sstrcr("error!");
  cptr = castles;
  found = false;
  while (cptr != NULL && !found) {
    if (cptr->alliance != uptr->alliance ||
	(strcmp(cptr->alias, uptr->alias) &&
	 cptr->alliance != uptr->alliance))
      found = true;
    cptr = cptr->next;
  }
  if (!found)
    reset_game(!found, false);
}



void check_player(Player *player, Castle **castles)
{
  Castle *cptr;
  char STR1[58];
  char STR3[256], STR4[256];

  ioobj.clear_scr();
  if (player->incastle)
    player->incastle = false;
  if (player->sector > boardsize) {
    player->sector = abs(rand() % boardsize) + 1;
  }
  if (player->killed > 0) {
    sprintf(STR1, "Your army was attacked by %s", player->killedby);
    ioobj.sstrcr(STR1);
    sprintf(STR1,"You lost %ld warriors.",player->killed);
    ioobj.sstrcr(STR1);
    player->killed = 0;
    if (player->dead) {
      ioobj.cr();
      ioobj.sstrcr("You were killed in the battle!");
      ioobj.cr();
      ioobj.sstrcr("Due to the god's immense generousity (and a shortage of space");
      ioobj.sstrcr("in hades), then have decided to give you ");
      player->armysize = (abs(rand() % 5000) + 2000) / theoptions.difficulty;
      sprintf(STR3, "%ld warriors to fight with, and have raised you from the dead!", player->armysize);
      ioobj.sstrcr(STR3);
      player->dead = false;
      ioobj.cr();
    } else {
      ioobj.cr();
      ioobj.sstrcr("but, happily, he was repulsed.");
      ioobj.sstrcr("by your gallant warriors. ");
      sprintf(STR4, "You found %ld gold pieces on your dead enemy.", player->goldfound);
      ioobj.sstrcr(STR4);
      player->goldfound = 0;
    }
    ioobj.waitcr();
  }  /*if*/
  else if (player->dead) {
    sprintf(STR4, "You were killed by %s", player->killedby);
    ioobj.sstrcr(STR4);
    ioobj.sstrcr("but, due to the gods' good graces, you have been ");
    ioobj.sstrcr("brought back from the dead . ");
    ioobj.sstrcr("Maybe you'll do better next time...");
    player->dead = false;
    ioobj.waitcr();
  }
  if (!find_castle_by_o_a(player->alias, &cptr)) {
    ioobj.sstrcr("Someone has taken over your only castle!");
    ioobj.cr();
    ioobj.sstrcr("Due to the immense generousity of the gods, they have deemed");
    ioobj.sstrcr("to give you another castle. ");
    ioobj.cr();
    give_castle(castles, 0L);
    ioobj.waitcr();
    cptr = *castles;
    while (cptr != NULL) {
      if (!strcmp(cptr->oldowner, player->alias)) {
	*cptr->oldowner = '\0';
	ioobj.sstrcr("uh, oh.");
	sprintf(STR4, "%s has taken over one of your castles. ",
		cptr->alias);
	ioobj.sstrcr(STR4);
	sprintf(STR4, "the castle %s", cptr->name);
	ioobj.sstr(STR4);
	ioobj.sstr(" now belongs to ");
	ioobj.sstrcr(cptr->alias);
	ioobj.sstrcr("I'd consider some retaliation. ");
	ioobj.cr();
	ioobj.waitcr();
      }
      if (!strcmp(cptr->alias, player->alias) && cptr->attacked) {
	sprintf(STR4, "During your abscence, %s",
		cptr->attackedby);
	ioobj.sstrcr(STR4);
	ioobj.sstrcr(
	  " attacked your castle.  Happily, he was repulsed.  Your valiant defenders");
	player->gold += cptr->newgold;
	sprintf(STR3, "found %ld gold pieces in the camp remains.", cptr->newgold);
	ioobj.sstrcr(STR3);
	ioobj.cr();
	ioobj.waitcr();
	cptr->attacked = false;
	cptr->newgold = 0;
      }
      cptr = cptr->next;
    }  /*check_castle*/
  }
  strcpy(player->killedby, "-");   /*with*/
  check_for_messages(player);
}  /*procedure*/


void delete_player()
{
  Player *uptr1, *uptr2;
  boolean found;
  char STR1[256];
  char c[255];

  ioobj.sstr("Please enter player to delete");
	strcpy(c,"");
  ioobj.gstr(c, 31L);
  sprintf(c, "%.30s", strcpy(STR1, c));
  uptr1 = players;
  uptr2 = players;
  found = false;
  while (uptr1 != NULL && !found) {
    if (!strcmp(uptr1->alias, c))
      found = true;
    else {
      uptr2 = uptr1;
      uptr1 = uptr1->next;
    }
  }
  if (uptr1 == NULL)
   ioobj.sstrcr("player not found!");
  else {
    if (uptr2 != players)
      uptr2->next = uptr1->next;
    else
      players = uptr1->next;
    free(uptr1);
   ioobj.sstrcr("player deleted.");
  }
  ioobj.waitcr();
}

void display_stats(Player usr, long flag)
{
  char armorn[32];
  long linecount;
  char weaponn[32];
  char tmp[256];
  long dum, worth, llen;
  Army *arptr;
  char totalstr[256];
  Castle *cptr;
  char s[256], STR1[256], STR2[256];
  char STR3[256];
  char STR4[256];
  char STR6[256];

  ioobj.clear_scr();
  if (usr.male) {
    sprintf(STR2, "Prince %s", usr.alias);
    ioobj.sstr(STR2);
  } else {
    sprintf(STR2, "Princess %s", usr.alias);
    ioobj.sstr(STR2);
  }
  if (flag == 0)
    sprintf(STR2, " in sector %ld", usr.sector);
  else
    strcpy(STR2, "in sector xxxx");
  ioobj.sstrcr(STR2);
    sprintf(tmp,"Status: %-18s Race: %-18s Alignment: %-4s",
    	usr.dead?"Dead":"Alive",race(usr.race),
	usr.alignment?"Good":"Evil");
  ioobj.sstrcr(tmp);
  sprintf(tmp, "Level: %-19ld Experience: %-13ld", usr.level,usr.experience);
  ioobj.sstrcr(tmp);
  get_armor(usr.armor, armorn, &worth);
  get_weapon(usr.weapon, weaponn, &worth);
  sprintf(tmp, "Armor: %-19s Weapon: %-18s", armorn, weaponn);
  ioobj.sstrcr(tmp);
  sprintf(tmp, "Strength: %-16ld Agility: %-15ld Charisma: %ld", 
	  usr.str, usr.agi, usr.chrs);
  ioobj.sstrcr(tmp);
  sprintf(tmp, "Intelligence: %-12ld Luck: %-18ld Gold: %ld", 
  	usr.int_, usr.luck, usr.gold);
  ioobj.sstrcr(tmp);
  sprintf(tmp, "Gold in bank: %-11ld  Army size: %ld", usr.bank, usr.armysize);
  ioobj.sstrcr(tmp);
  strcpy(totalstr, "Spells:   ");
  sprintf(totalstr, "%d/%d/%d/%d/%d/%d/%d/%d", usr.teleport, 
  	usr.map, usr.dmons, usr.mweapon, usr.descas, usr.mwarriors, 
	usr.killer, usr.steal);
  ioobj.sstrcr(totalstr);
  if (usr.alliance == 0)
    ioobj.sstrcr("Alliance: None                         ");
  else {
    sprintf(s, "Alliance: %s ", usr.alliancename);
    ioobj.sstr(STR1);
    if (usr.allianceleader)
      ioobj.sstrcr("Alliance Captain");
    else
      ioobj.cr();
  }
  sprintf(STR2, "Last killed by: %s", usr.killedby);
  ioobj.sstrcr(STR2);
  ioobj.sstrcr("Armies:");
  arptr = armies;
  llen = 1;
  while (arptr != NULL) {
    if (!strcmp(arptr->owner, usr.alias)) {
      if (!strcmp(arptr->owner, player->alias))
	sprintf(s,"%ld",arptr->sector);
      else
	strcpy(s, "xxxx");
      sprintf(STR4, "[%s:%ld]  ", s, arptr->men);
      ioobj.sstr(STR4);
      llen++;
      if (llen > 6) {
	ioobj.cr();
	llen = 1;
      }
    }
    arptr = arptr->next;
  }
  ioobj.cr();
  ioobj.sstrcr("Castles:");
  cptr = castles;
  linecount = 13;
  while (cptr != NULL) {
    if (!strcmp(cptr->alias, usr.alias)) {
      get_castle_type(cptr, s, &dum);
      sprintf(STR3, "%s %s", s, cptr->name);
      ioobj.sstr(STR3);
      if (flag == 0)
        sprintf(STR4, " in sector %ld", cptr->sector);
      else
	strcpy(STR4, "in sector xxxx");
      ioobj.sstr(STR4);
      sprintf(STR6, " with %ld/%ld/%ld/%ld", cptr->defend, cptr->wall,
      cptr->towers, cptr->moat);
      ioobj.sstrcr(STR6);
      linecount++;
      if (linecount == 24) {
	ioobj.waitcr();
	linecount = 1;
      }
    }
    cptr = cptr->next;
  }
  ioobj.waitcr();
  ioobj.clear_scr();
}  /*procedure*/


void edit_player(void)
{
  Player *uptr1, *uptr2;
  long int_, intl;
  boolean found, done;
  long choice;
  char c[50];

  ioobj.clear_scr();
  done = false;
  ioobj.sstr("Enter characters to search for in player name: ");
	strcpy(c,"");
  ioobj.gstr(c, 31L);
  uptr2 = players;
  while (!found && uptr2 != NULL) {
    if (strstr(uptr2->alias, c) != NULL)
      found = true;
    else
      uptr2 = uptr2->next;
  }
  uptr1 = uptr2;
  if (!found) {
    ioobj.sstrcr("Player not found!");
    ioobj.waitcr();
    return;
  }
  display_stats(*uptr1, 0L);
  ioobj.cr();
  ioobj.sstr("Edit this player? ");
  if (!yesno())
    return;
  do {
    ioobj.sstrcr("1.  Agility              2. Strength               3.  Luck");
    ioobj.sstrcr("4.  Intelligence         5. Charisma               6. Sector");
    ioobj.sstrcr("7.  Race                 8. Gold                   9. Armysize");
    ioobj.sstrcr("10. Alignment           11. Bank gold             12. Armor");
    ioobj.sstrcr("13. Weapon              14. Dead                  15. Enteredtoday");
    ioobj.sstrcr("16. Experience          17. Levels");
    ioobj.sstrcr("Spells:");
    ioobj.sstrcr("18. Teleporter          19. Mapper                20. Destroy monsters");
    ioobj.sstrcr("21. Descastle           22. Magweapon             23. Magwarriors");
    ioobj.sstrcr("24. Kill                25. Steal castle");
    ioobj.sstr("choice? ");
	strcpy(c,"");
    ioobj.gstr(c, 2L);
    stringtonum(c, &choice);
    if (choice < 1 || choice > 25) {
      ioobj.sstrcr("Invalid choice.  edit aborted");
      ioobj.waitcr();
    } else {
      switch (choice) {

      case 1:
	ioobj.sstr("Change to what? (max is 20) ");
	strcpy(c,"");
	ioobj.gstr(c, 2L);
	stringtonum(c, &int_);
	if ((unsigned long)int_ > 20)
	  ioobj.sstrcr("invalid choice");
	else
	  uptr1->agi = int_;
	break;

      case 2:
	ioobj.sstr("Change to what? (max is 20) ");
	strcpy(c,"");
	ioobj.gstr(c, 2L);
	stringtonum(c, &int_);
	if ((unsigned long)int_ > 20)
	  ioobj.sstrcr("invalid choice");
	else
	  uptr1->str = int_;
	break;

      case 3:
	ioobj.sstr("Change to what? (max is 20) ");
	strcpy(c,"");
	ioobj.gstr(c, 2L);
	stringtonum(c, &int_);
	if ((unsigned long)int_ > 20)
	  ioobj.sstrcr("invalid choice");
	else
	  uptr1->luck = int_;
	break;

      case 4:
	ioobj.sstr("Change to what? (max is 20) ");
	strcpy(c,"");
	ioobj.gstr(c, 2L);
	stringtonum(c, &int_);
	if ((unsigned long)int_ > 20)
	  ioobj.sstrcr("invalid choice");
	else
	  uptr1->int_ = int_;
	break;

      case 5:
	ioobj.sstr("Change to what? (max is 20) ");
	strcpy(c,"");
	ioobj.gstr(c, 2L);
	stringtonum(c, &int_);
	if ((unsigned long)int_ > 20)
	  ioobj.sstrcr("invalid choice");
	else
	  uptr1->chrs = int_;
	break;

      case 6:
	ioobj.sstr("Change to what? ");
	strcpy(c,"");
	ioobj.gstr(c, 4L);
	stringtonum(c, &int_);
	if ((unsigned long)int_ > 4096)
	  ioobj.sstrcr("invalid choice");
	else
	  uptr1->sector = int_;
	break;

      case 7:
	ioobj.sstrcr("the race of the indivual depends highly on his alignment.");
	ioobj.sstrcr("the good races are 1-6, and the evil, 7-12.  if you enter an incorrect");
	ioobj.sstrcr("race, it will royally screw up the fight calculations.  be warned.");
	ioobj.sstr("Change to what? (max is 12) ");
	strcpy(c,"");
	ioobj.gstr(c, 2L);
	stringtonum(c, &int_);
	if ((unsigned long)int_ > 12)
	  ioobj.sstrcr("invalid choice");
	else
	  uptr1->race = int_;
	break;

      case 8:
	ioobj.sstr("Change to what? (no max) ");
	strcpy(c,"");
	ioobj.gstr(c, 10L);
	stringtonum(c, &intl);
	if (intl < 0)
	  ioobj.sstrcr("invalid choice");
	else
	  uptr1->gold = intl;
	break;

      case 9:
	ioobj.sstr("Change to what? (no max) ");
	strcpy(c,"");
	ioobj.gstr(c, 10L);
	stringtonum(c, &intl);
	if (intl < 0)
	  ioobj.sstrcr("invalid choice");
	else
	  uptr1->armysize = intl;
	break;

      case 10:
	ioobj.sstr("Are you sure you want to reset the alignment flag? ");
	if (yesno())
	  uptr1->alignment = !uptr1->alignment;
	break;

      case 11:
	ioobj.sstr("Change to what? (no max) ");
	strcpy(c,"");
	ioobj.gstr(c, 10L);
	stringtonum(c, &intl);
	if (intl < 0)
	  ioobj.sstrcr("invalid choice");
	else
	  uptr1->bank = intl;
	break;

      case 12:
	ioobj.sstr("Change to what? (max is 20) ");
	strcpy(c,"");
	ioobj.gstr(c, 2L);
	stringtonum(c, &int_);
	if ((unsigned long)int_ > 20)
	  ioobj.sstrcr("invalid choice");
	else
	  uptr1->armor = int_;
	break;

      case 13:
	ioobj.sstr("Change to what? (max is 20) ");
	strcpy(c,"");
	ioobj.gstr(c, 2L);
	stringtonum(c, &int_);
	if ((unsigned long)int_ > 20)
	  ioobj.sstrcr("invalid choice");
	else
	  uptr1->weapon = int_;
	break;

      case 14:
	ioobj.sstr("Are you sure you want to reset the dead flag? ");
	if (yesno())
	  uptr1->dead = !uptr1->dead;
	break;

      case 15:
	/* blank case */
	break;

      case 16:
	ioobj.sstr("Change to what? (no max) ");
	strcpy(c,"");
	ioobj.gstr(c, 10L);
	stringtonum(c, &intl);
	if (intl < 0)
	  ioobj.sstrcr("invalid choice");
	else
	  uptr1->experience = intl;
	break;

      case 17:
	ioobj.sstr("Change to what? (max 50) ");
	strcpy(c,"");
	ioobj.gstr(c, 2L);
	stringtonum(c, &int_);
	if ((unsigned long)int_ > 50)
	  ioobj.sstrcr("invalid choice");
	else
	  uptr1->level = int_;
	break;

      case 18:
	ioobj.sstr("Change to what? (max is 100) ");
	strcpy(c,"");
	ioobj.gstr(c, 2L);
	stringtonum(c, &int_);
	if ((unsigned long)int_ > 100)
	  ioobj.sstrcr("invalid choice");
	else
	  uptr1->teleport = int_;
	break;

      case 19:
	ioobj.sstr("Change to what? (max is 100) ");
	strcpy(c,"");
	ioobj.gstr(c, 2L);
	stringtonum(c, &int_);
	if ((unsigned long)int_ > 100)
	  ioobj.sstrcr("invalid choice");
	else
	  uptr1->map = int_;
	break;

      case 20:
	ioobj.sstr("Change to what? (max is 100) ");
	strcpy(c,"");
	ioobj.gstr(c, 2L);
	stringtonum(c, &int_);
	if ((unsigned long)int_ > 100)
	  ioobj.sstrcr("invalid choice");
	else
	  uptr1->dmons = int_;
	break;

      case 21:
	ioobj.sstr("Change to what? (max is 100) ");
	strcpy(c,"");
	ioobj.gstr(c, 2L);
	stringtonum(c, &int_);
	if ((unsigned long)int_ > 100)
	  ioobj.sstrcr("invalid choice");
	else
	  uptr1->descas = int_;
	break;

      case 22:
	ioobj.sstr("Change to what? (max is 100) ");
	strcpy(c,"");
	ioobj.gstr(c, 2L);
	stringtonum(c, &int_);
	if ((unsigned long)int_ > 100)
	  ioobj.sstrcr("invalid choice");
	else
	  uptr1->mweapon = int_;
	break;

      case 23:
	ioobj.sstr("Change to what? (max is 100) ");
	strcpy(c,"");
	ioobj.gstr(c, 2L);
	stringtonum(c, &int_);
	if ((unsigned long)int_ > 100)
	  ioobj.sstrcr("invalid choice");
	else
	  uptr1->mwarriors = int_;
	break;

      case 24:
	ioobj.sstr("Change to what? (max is 100) ");
	strcpy(c,"");
	ioobj.gstr(c, 2L);
	stringtonum(c, &int_);
	if ((unsigned long)int_ > 100)
	  ioobj.sstrcr("invalid choice");
	else
	  uptr1->killer = int_;
	break;

      case 25:
	ioobj.sstr("Change to what? (max is 100) ");
	strcpy(c,"");
	ioobj.gstr(c, 2L);
	stringtonum(c, &int_);
	if ((unsigned long)int_ > 10)
	  ioobj.sstrcr("invalid choice");
	else
	  uptr1->steal = int_;
	break;

      default:
	ioobj.sstrcr("Invalid choice.  Edit aborted.");
	break;
      }
    }
    ioobj.waitcr();
    display_stats(*uptr1, 0L);
    ioobj.cr();
    ioobj.cr();
    ioobj.sstr("Continue editing? ");
    if (!yesno())
      done = true;
  } while (!done);
}




boolean find_player_in_sector(long sector, Player **player)
{
  Player *gptr;
  boolean found;

  gptr = players;
  found = false;
  while (gptr != NULL && !found) {
    if (gptr->sector == sector) {
      found = true;
      *player = gptr;
    } else
      gptr = gptr->next;
  }
  return found;
}


boolean find_player_by_name(char *playername, Player **player)
{
  Player *uptr;
  boolean found;

  uptr = players;
  found = false;
  while (uptr != NULL && !found) {
    if (!strcmp(uptr->name, playername)) {
      found = true;
      *player = uptr;
    } else
      uptr = uptr->next;
  }
  return found;
}

boolean find_player_by_alias(char *name, Player **uptr)
{
  Player *gptr;
  boolean found;

  gptr = players;
  found = false;
  while (gptr != NULL && !found) {
    if (!strcmp(gptr->alias, name)) {
      found = true;
      *uptr = gptr;
    } else
      gptr = gptr->next;
  }
  return found;
}



void get_armor(long number, char *armor, long *worth)
{
  const double baseprice = 3000.0;
  double y;

  // adjust for difficulty
  y = (baseprice * number) * theoptions.difficulty;

  // now change to exponential scale (for expensive items)
  if (number > 10)
  	y += pow(3.0,(double)number-10);

  *worth=(long)y;

  switch (number) {

  case 2:
    strcpy(armor, "Cloth");
    break;

  case 3:
    strcpy(armor, "Leather");
    break;

  case 4:
    strcpy(armor, "Chain Mail");
    break;

  case 5:
    strcpy(armor, "Link Mail");
    break;

  case 6:
    strcpy(armor, "Breastplate");
    break;

  case 7:
    strcpy(armor, "Plate");
    break;

  case 8:
    strcpy(armor, "Plate + 1");
    break;

  case 9:
    strcpy(armor, "Plate + 2");
    break;

  case 10:
    strcpy(armor, "Anti-Penetration Plate");
    break;

  case 11:
    strcpy(armor, "Hidden Armor");
    break;

  case 12:
    strcpy(armor, "Dragon Mail");
    break;

  case 13:
    strcpy(armor, "Flaming Mail");
    break;

  case 14:
    strcpy(armor, "Elfin Mail");
    break;

  case 15:
    strcpy(armor, "Dwarven Gem Mail");
    break;

  case 16:
    strcpy(armor, "Droud Sheath");
    break;

  case 17:
    strcpy(armor, "Demon Skin");
    break;

  case 18:
    strcpy(armor, "Demi-God Plate");
    break;

  case 19:
    strcpy(armor, "Satan's Shroud");
    break;

  case 20:
    strcpy(armor, "Avatar Plate");
    break;

  default:
  case 1: 
    strcpy(armor, "Bare Hands");
    *worth = 0;
    break;
  }
}


void get_weapon(long number, char *weapon, long *worth)
{
  const double baseprice = 3000.0;
  double y;

  // adjust for difficulty
  y = (baseprice * number) * theoptions.difficulty;

  // now change to exponential scale (for expensive items)
  if (number > 10)
  	y += pow(3.0,(double)number-10);

  *worth=(long)y;



  switch (number) {

  case 2:
    strcpy(weapon, "Clubs");
    break;

  case 3:
    strcpy(weapon, "Daggers");
    break;

  case 4:
    strcpy(weapon, "Shortswords");
    break;

  case 5:
    strcpy(weapon, "Swords");
    break;

  case 6:
    strcpy(weapon, "Longswords");
    break;

  case 7:
    strcpy(weapon, "Two Handed Swords");
    break;

  case 8:
    strcpy(weapon, "Longswords + 1");
    break;

  case 9:
    strcpy(weapon, "Two handed Swords + 1");
    break;

  case 10:
    strcpy(weapon, "Swords of Penetration");
    break;

  case 11:
    strcpy(weapon, "Swords of Swinging");
    break;

  case 12:
    strcpy(weapon, "Swords of Speed");
    break;

  case 13:
    strcpy(weapon, "Battle Axes of Cleaving");
    break;

  case 14:
    strcpy(weapon, "Faerie Blades");
    break;

  case 15:
    strcpy(weapon, "Battle Axes of Blood");
    break;

  case 16:
    strcpy(weapon, "Hellfire Blades");
    break;

  case 17:
    strcpy(weapon, "Reaver Staves");
    break;

  case 18:
    strcpy(weapon, "Swords of True Death");
    break;

  case 19:
    strcpy(weapon, "Demi-Blades");
    break;

  case 20:
    strcpy(weapon, "Blades of the Avatar");
    break;

  default:
  case 1:
    strcpy(weapon, "Bare Hands");
    *worth = 0;
    break;
  }
}

boolean can_play(char *playername, Castle **castles)
{
  boolean Result;
  time_t	now;
  struct tm now_info;
  struct tm last_played_info;
  boolean playedtoday;
  Player *uptr;


  playedtoday = false;
  time(&now);
  memcpy(&now_info,localtime(&now),sizeof(struct tm));
  if (find_player_by_name(playername, &uptr)) {
    memcpy(&last_played_info,localtime(&uptr->lastlogon),sizeof(struct tm));
    check_player(uptr, castles);
    if (now_info.tm_yday ==  last_played_info.tm_yday && uptr->timesplayed 
    	>= theoptions.entries && (int)user.u_acl() < theoptions.sysopacl) 
    {
	    ioobj.sstrcr("You have already played as many times as possible today.");
	    ioobj.sstrcr("You will be returned to the bbs.");
	    playedtoday = true;
	    ioobj.waitcr();
    }
    else if (now_info.tm_mday != last_played_info.tm_mday) 
    	uptr->timesplayed = 0;
    uptr->entrydate = now;
    uptr->lastlogon = uptr->entrydate;
    if (uptr->allianceleader == true && uptr->alliance == 0)
      uptr->allianceleader = false;
  } else {
    rollplayer();
    if (!find_player_by_name(playername, &uptr))
      ioobj.sstrcr("couldn't find the User!!!");
  }
  Result = playedtoday;
  if (!playedtoday)
    check_castles(uptr);
  return Result;
}


void get_players(void)
{
  FILE *playerfile;
  Player player;
  char STR1[256];

  sprintf(STR1, "%s/Princes", CONFDIR);
  playerfile = ioobj.bopen(STR1, "rb");
  if (playerfile == NULL)
    {
	rollrogues();
	get_players();
    }
  // check for trashed user file
  if (!feof(playerfile)) {
    while (!feof(playerfile)) 
    {
      if (fread(&player, sizeof(Player), 1, playerfile) > 0)
	      addplayer(player);
    }
  } 
  else 
  {	// reset game if file empty
    reset_game(false, false);
  }
  ioobj.bclose(playerfile);
}  


void give_reward(Player **player)
{
  long tmp;
  char STR2[256], STR3[256],weaponn[50];

  ioobj.clear_scr();
  (*player)->castaken++;
  if ((*player)->castaken >= 16) {
    ioobj.sstrcr("A blue mage appears in front of you");
    ioobj.sstrcr("You have taken the last keeper castle.  ");
    ioobj.sstrcr("We have given you, through these tests, everything that we may in order to");
    ioobj.sstrcr("Help you succeed in your uniting of mitara.");
    ioobj.sstrcr("We may help you no more.");
    ioobj.sstrcr("We wish you luck on your journey to greatness.");
    ioobj.sstrcr("With that, the mage disappears.");
  } else {
    ioobj.sstrcr(
      "After the defeat of the castle, a great being in a blue robe appears in front of you.");
    ioobj.sstrcr("He is very tall, and has a blue tinge to his face.  He's obviously a ");
    ioobj.sstrcr("mage of no small standing.");
    ioobj.sstrcr("He speaks:");
    ioobj.sstrcr("\"We are the keepers.  We are the lords of this world.\"");
    ioobj.sstrcr("\"This has been a test.  You have passed.\"");
    ioobj.sstrcr("\"You will now gain your reward.\"");
    ioobj.sstrcr("He then begins a small chant, to be joined by others in his strange band.");
    ioobj.sstrcr("Funny, but you didn't notice them before.  At the end of that thought,");
    ioobj.sstrcr("You find yourself surrounded by mist.");
    ioobj.sstrcr("The voice sounds distant, but you can recognize the voice.");
    ioobj.sstrcr("It is the blue mage.");
    ioobj.sstrcr("He continues:");
    tmp = abs(rand() % 5);
    switch (tmp) {

    case 0:
      (*player)->str += abs(rand() % 3);
      ioobj.sstrcr("\"We have increased your strength.\"");
      break;

    case 1:
      (*player)->int_ += abs(rand() % 3);
      ioobj.sstrcr("\"We have increased your intelligence.\"");
      break;

    case 2:
      (*player)->luck += abs(rand() % 3);
      ioobj.sstrcr("\"We have increased your luck.\"");
      break;

    case 3:
      (*player)->chrs += abs(rand() % 3);
      ioobj.sstrcr("\"We have increased your charisma.\"");
      break;

    case 4:
      (*player)->agi += abs(rand() % 3);
      ioobj.sstrcr("\"We have increased your agility.\"");
      break;
    }
    tmp = abs(rand() % 15);
    if (tmp < 1 && (*player)->race % 6 != 0 && (*player)->race != 0) {
      ioobj.sstrcr("You begin to feel strange.");
      ioobj.sstrcr("You black out, only to wake up in another form.");
      ioobj.sstrcr("You are of another race!");
      if ((*player)->alignment)
	(*player)->race++;
      else
	(*player)->race++;
    }
    ioobj.sstrcr("The chant increases in speed until you suddenly find yourself");
    ioobj.sstrcr("Back with your army.");
    ioobj.sstrcr("Objects then start teleporting to right in front of you.");
    tmp = abs(rand() % 500);
    if (tmp < 25) {
      (*player)->weapon++;
      if ((*player)->weapon > 20)
	(*player)->weapon = 20;
        get_weapon((*player)->weapon, weaponn, &tmp);
      sprintf(STR3,"A great pile of %s appears.",weaponn);
      ioobj.sstrcr(STR3);
    } else if (tmp < 50) {
      (*player)->armor++;
      if ((*player)->armor > 20)
	(*player)->armor = 20;
        get_armor((*player)->armor, weaponn, &tmp);
      sprintf(STR3,"A great pile of %s appears.",weaponn);
      ioobj.sstrcr(STR3);
    }
    tmp = abs(rand() & 7);
    switch (tmp) {

    case 0:
      tmp = abs(rand() % 25);
      (*player)->teleport += tmp;
      sprintf(STR3, "You find %ld teleport scrolls.", tmp);
      ioobj.sstrcr(STR3);
      break;

    case 1:
      tmp = abs(rand() % 25);
      (*player)->map += tmp;
      sprintf(STR2, "You find %ld mapper scrolls.", tmp);
      ioobj.sstrcr(STR2);
      break;

    case 2:
      tmp = abs(rand() % 10);
      (*player)->dmons += tmp;
      sprintf(STR3, "You find %ld destroy monsters scrolls.", tmp);
      ioobj.sstrcr(STR3);
      break;

    case 3:
      tmp = abs(rand() & 1);
      (*player)->killer += tmp;
      sprintf(STR2, "You find %ld kill scrolls.", tmp);
      ioobj.sstrcr(STR2);
      break;

    case 4:
      tmp = abs(rand() % 5);
      (*player)->descas += tmp;
      sprintf(STR3, "You find %ld destroy castle scrolls.", tmp);
      ioobj.sstrcr(STR3);
      break;

    case 5:
      tmp = abs(rand() % 25);
      (*player)->mweapon += tmp;
      sprintf(STR2, "You find %ld magic weapon scrolls.", tmp);
      ioobj.sstrcr(STR2);
      break;

    case 6:
      tmp = abs(rand() & 1);
      (*player)->steal += tmp;
      sprintf(STR3, "You find %ld steal castle scrolls.", tmp);
      ioobj.sstrcr(STR3);
      break;
    }
  }
  ioobj.waitcr();
}


void list_players(Player *players)
{
  Player *uptr, *player;
  boolean done;
  char c[256];
  boolean found;

  ioobj.clear_scr();
  if (!find_player_by_name(playername, &player))
    ioobj.sstrcr("error!");
  found = false;
  ioobj.sstr("Would you like a single person's stats, or the whole list?  (p/w) ");
	strcpy(c,"");
  ioobj.gstr(c, 1L);
  if (uncase(c[0]) == 'p') {
    ioobj.sstr("Enter characters to search for: ");
	strcpy(c,"");
    ioobj.gstr(c, 31L);
    uptr = players;
    while (!found && uptr != NULL) {
      if (search(uptr->alias, c))
	found = true;
      else
	uptr = uptr->next;
    }
    if (found &&
	((uptr->alliance == player->alliance &&
	  uptr->alliance != 0) || !strcmp(uptr->alias, player->alias))) {
      display_stats(*uptr, 0L);
      return;
    }
    if (found)
      display_stats(*uptr, 1L);
    else {
      ioobj.sstrcr("not found!");
      ioobj.waitcr();
    }
    return;
  }
  uptr = players;
  if (!find_player_by_name(playername, &player))
    ioobj.sstrcr("Error!");
  done = false;
  while (uptr != NULL && !done) {
    if ((uptr->alliance == player->alliance &&
	 uptr->alliance != 0) || !strcmp(uptr->alias, player->alias)) {
      display_stats(*uptr, 0L);
      ioobj.cr();
      ioobj.sstr("Continue list? ");
      if (!yesno())
	done = true;
    } else {
      display_stats(*uptr, 1L);
      ioobj.cr();
      ioobj.sstr("Continue list? ");
      if (!yesno())
	done = true;
    }
    uptr = uptr->next;
  }
}



boolean monsfight(Player *player, long monsters, long *nummonsters)
{
  char c[256];
  long t;
  long tmp;
  char monsname[32];
  long offset, mmen, playerlosses, monslosses, a, tmp1, tmp2, totalmonsdead,
       totalplayerlosses;
  boolean tmpmen, tmpweapon, done, flee, chase, changed;
  char STR2[256], STR3[256];

  totalmonsdead = 0;
  totalplayerlosses = 0;
  mmen = 0;
  tmpmen = false;
  tmpweapon = false;
  changed = false;
  done = false;
  flee = false;
  offset = 0;
  chase = false;
  ioobj.clear_scr();
  ioobj.sstrcr("There are monsters in this sector! ");
  ioobj.sstrcr("and they're attacking you!");
  get_monster_name(monsters, monsname);
  ioobj.cr();
  ioobj.sstrcr("Prepare for battle!");
  if (player->armysize <= 0) {
    ioobj.clear_scr();
    ioobj.sstrcr("The monsters have ambushed you away from your troops!");
    ioobj.sstrcr("because of your defenseless position, you are quickly killed.");
    ioobj.sstrcr("and eaten.  Human on a spit, a monsters' favorite delicacy.");
    done = true;
    flee = true;
    quit = true;
    player->dead = true;
    player->killed = player->armysize;
    player->armysize = 1;
    strcpy(player->killedby, monsname);
    ioobj.waitcr();
  }
  if (*nummonsters <= 0)
    *nummonsters = 531;
  while (!done) {   /*while*/
    monsters = labs(monsters);
    sprintf(STR3, "You are up against %ld %s",*nummonsters,monsname);
    ioobj.sstrcr(STR3);
    ioobj.cr();
    ioobj.cr();
    if (player->alignment == false)
      offset = 6;
    sprintf(STR3, "You have %ld warriors", player->armysize);
    ioobj.sstrcr(STR3);
    ioobj.cr();
    playerlosses = *nummonsters * monsters / 30;
    if (playerlosses >= player->armysize)
      playerlosses = player->armysize;
    ioobj.cr();
    tmp1 = playerlosses;
    if (tmpmen) {
      if (tmp1 / 2 > mmen) {
	tmp1 = mmen;
	tmp2 = tmp1 + (tmp1 - mmen);
      } else
	tmp2 = 0;
      ioobj.sstrcr("Sire, your advisors agree that you will lose ");
      sprintf(STR3, "%ld skeletons and ", tmp1);
      ioobj.sstrcr(STR3);
      sprintf(STR3, "%ld warriors.", tmp2);
      ioobj.sstrcr(STR3);
    } else {
      ioobj.sstrcr("Sire, your advisors agree that you will lose");
      sprintf(STR3, "%ld warriors.", playerlosses);
      ioobj.sstrcr(STR3);
    }
    ioobj.cr();
    if (chase)
      chase = false;
    if (abs(rand() % 50) < 5) {
      chase = true;
    }
    ioobj.sstrcr("You may run, attack, or cast a  spell. ");
    ioobj.sstr("your choice? ");
	strcpy(c,"");
    ioobj.gstr(c, 1);
    uncase(c[0]);
    if (c[0] == 'r' && chase)
      ioobj.sstrcr("The monsters chase you!");
    if (c[0] == 'r' && !chase) {
      if (tmpmen)
	ioobj.sstrcr("All of your skeletons dissolve into the ground..");
      if (tmpweapon) {
	player->weapon /= 5;
	ioobj.sstrcr("Your weapons stop glowing.");
      }
      done = true;
    } else if (c[0] == 'c') {
      changed = true;
      if (player->mweapon <= 0 && player->mwarriors <= 0 &&
	  player->dmons <= 0)
	ioobj.sstrcr("You do not have any fight spells.");
      else {
	ioobj.sstrcr("You may use the following: ");
	ioobj.sstrcr("0. none");
	if (player->dmons > 0)
	  ioobj.sstrcr("1. Destroy monsters");
	if (player->mweapon > 0)
	  ioobj.sstrcr("2. Magic weapons");
	if (player->mwarriors > 0)
	  ioobj.sstrcr("3. Magic warriors");
	ioobj.sstr("Your choice? ");
	strcpy(c,"");
	ioobj.gstr(c, 1L);
	if (c[0] == '0')
	  ioobj.sstrcr("Spell aborted.");
	else if (c[0] == '1') {
	  player->dmons--;
	  if (abs(rand() % 100) < 5) {
	    ioobj.sstrcr("Your mages bend to the task, but to no avail.");
	    ioobj.sstrcr("The spell fizzles out before it can take effect.");
	  } else {
	    monslosses = *nummonsters;
	    totalmonsdead = *nummonsters;
	    ioobj.sstrcr("Your mages bend to the task...and succeed!");
	    if (abs(rand() % 5) > 1) {
	      ioobj.sstrcr("A greater demon comes up through the ground..");
	      ioobj.sstrcr("Your mages shout as one: \"foul demon, by our power we command");
	      ioobj.sstrcr("you to destroy yon monsters\".  The demon just grins.  ");
	      ioobj.sstrcr("then, he disappears, only to appear in the body of the");
	      ioobj.sstrcr("monsters.  the battle is fast and furious, but the monsters");
	      ioobj.sstrcr("never stood a chance.  The demon returns, dripping with blood.");
	      ioobj.sstrcr("your mages again say as one: \"begone, demon!\"");
	      ioobj.sstrcr("the demon disappears.");
	      ioobj.sstrcr("You have destroyed the monsters.  congratulations. ");
	      done = true;
	      tmp = totalmonsdead * labs(monsters - 10) / 12 +
		    totalplayerlosses * abs(rand() % 5);
	      tmp = tmp / (player->armysize / 20000 + 1) % 50000L;
	      tmp = labs(tmp / 5);
	      sprintf(STR3, "Your warriors found %ld gold pieces in the monster's lair.", tmp);
	      ioobj.sstrcr(STR3);
	      tmp2 = totalmonsdead * labs(monsters - 10) / player->level;
	      tmp2 /= 10;
	      player->experience += tmp2;
	      sprintf(STR2,
		"You have gained %ld experience points from the encounter.", tmp2);
	      ioobj.sstrcr(STR2);
	      *nummonsters = 0;
	      player->gold += tmp;
	      monsters = 0;
	    } else {
	      ioobj.sstrcr("But, before you can command the demon, the demon breaks free!");
	      tmp2 = abs(rand() % player->armysize);
	      sprintf(STR3, "The demon decimates %ld of your men.", tmp2);
	      ioobj.sstrcr(STR3);
	      player->armysize -= tmp2;
	      ioobj.sstrcr("Demons are a nasty business!");
	    }
	  }
	} else if (c[0] == '2') {
	  if (tmpweapon)
	    ioobj.sstrcr(
	      "I am sorry, your highness, but another magic weapon scroll would do no good.");
	  else if (player->mweapon <= 0)
	    ioobj.sstrcr("What?");
	  else {
	    player->mweapon--;
	    if (abs(rand() % 100) < 5) {
	      ioobj.sstrcr("Your mages bend to the task, but to no avail.");
	      ioobj.sstrcr("The spell fizzles out before it can take effect.");
	      ioobj.sstrcr("I guess you'll have to fight this round without spells.");
	    } else {
	      tmpweapon = true;
	      player->weapon *= 5;
	      ioobj.sstrcr("Your journeyman mages bend to the task.  ");
	      ioobj.sstrcr("They succeed!");
	      ioobj.sstrcr("Your weapons are glowing crimson red!");
	    }
	  }
	} else if (c[0] == '3') {
	  if (player->mwarriors <= 0)
	    ioobj.sstrcr("what?");
	  else {
	    player->mwarriors--;
	    if (abs(rand() % 100) < 5) {
	      ioobj.sstrcr("Your mages bend to the task, but to no avail.");
	      ioobj.sstrcr("The spell fizzles out before it can take effect.");
	    } else {
	      tmpmen = true;
	      tmp = abs(rand() % 30000);
	      mmen += tmp;
	      ioobj.sstrcr("Your journeyman mages bend to the task.  ");
	      ioobj.sstrcr("They succeed!");
	      sprintf(STR3, "%ld skeletons dig themselves from", tmp);
	      ioobj.sstrcr(STR3);
	      ioobj.sstrcr("the ground, and join your troops.");
	    }
	  }
	}
      }
    } else {
      changed = true;
      playerlosses = *nummonsters * monsters / 31;
      if (playerlosses >= player->armysize)
	playerlosses = player->armysize;
      if (playerlosses <= 0) {
	if (!tmpmen)
	  playerlosses = labs(playerlosses);
	else
	  playerlosses = 0;
      }
      if (tmpmen) {
	if (playerlosses > mmen) {
	  tmp1 = mmen;
	  tmp2 = playerlosses - mmen;
	} else {
	  tmp1 = playerlosses;
	  tmp2 = 0;
	}
      } else
	tmp2 = playerlosses;
      totalplayerlosses += tmp2;
      if (!tmpmen)
	mmen = 0;
      a = player->armysize + mmen;
      monslosses = labs((long)floor((player->str - 12) * 0.02 * a +
		  (player->chrs - 12) * 0.005 * a + player->level *
		    0.03 * a + (player->int_ - 12) * 0.005 * a +
		  lrand48() % a * 0.1 + (a - *nummonsters) * 0.03 +
		  (player->race - offset - 2) * 0.01 * a +
		  (player->armor - 2) * 0.005 * a + (player->weapon - 2) * 0.005 *
		    a + 0.5) / (monsters / 10 + 1));
      if (monslosses > *nummonsters)
	monslosses = *nummonsters;
      totalmonsdead += monslosses;
      if (tmp2 >= player->armysize || player->armysize <= 1) {
	ioobj.sstrcr("Your army was killed in the battle.");
	ioobj.sstrcr("The monsters chased you down, and took great joy in ");
	ioobj.sstrcr("ripping you to shreds, and feeding you to their children.");
	ioobj.sstrcr("You will now be returned to the bbs. ");
	ioobj.sstrcr("You can play again tomorrow. ");
	if (tmpmen)
	  ioobj.sstrcr("All of your skeletons dissolve into the ground..");
	if (tmpweapon) {
	  player->weapon /= 5;
	  ioobj.sstrcr("Your weapons stop glowing.");
	}
	done = true;
	flee = true;
	quit = true;
	player->dead = true;
	player->killed = totalplayerlosses;
	player->armysize = 1;
	strcpy(player->killedby, monsname);
      }
      if (monslosses >= *nummonsters && !flee) {
	monslosses = *nummonsters;
	ioobj.sstrcr("You have destroyed the monsters.  congratulations. ");
	done = true;
	tmp = totalmonsdead * labs(monsters - 10) / 6 +
	      totalplayerlosses * abs(rand() % 5);
	tmp = tmp / (player->armysize / 30000 + 1) % 50000L;
	t = totalmonsdead * labs(monsters - 10) / (player->level + 2);
	player->experience += t;
	sprintf(STR2, "You gained %ld experience points from the battle.", t);
	ioobj.sstrcr(STR2);
	sprintf(STR2, "Your warriors found %ld gold pieces in the monster's lair.", tmp);
	ioobj.sstrcr(STR2);
	*nummonsters = 0;
	player->gold += tmp;
	monsters = 0;
      }
      if (!flee) {   
	ioobj.sstr("Your army suffered the loss of ");
	sprintf(STR2, "%ld warriors. ", tmp2);
	ioobj.sstrcr(STR2);
	if (tmpmen) {
	  sprintf(STR3, "You also lost %ld skeletons.", tmp1);
	  ioobj.sstrcr(STR3);
	  if (done)
	    ioobj.sstrcr("All of the remaining skeletons dissolve into the ground..");
	}
	if (tmpweapon && done) {
	  ioobj.sstrcr("Your weapons return to normal..");
	  player->weapon /= 5;
	}
	sprintf(STR3, "There were %ld monsters killed.", monslosses);
	ioobj.sstrcr(STR3);
	if (done) {
	  sprintf(STR2, "You lost %ld men in the entire battle.", totalplayerlosses);
	  ioobj.sstrcr(STR2);
	}
	player->armysize -= playerlosses;
	*nummonsters -= monslosses;
	ioobj.cr();
	ioobj.cr();
      }
    }
    ioobj.waitcr();
  }
  if (changed) {
    check_for_level(player);
    display_stats(*player, 0L);
  } else
    ioobj.clear_scr();
  return flee;

  /*else*/
}  /*function*/

boolean playerfight( Player *attacker, Player *defender, boolean standing)
{
  char c[256];
  boolean flee;
  long offset1, offset2;
  long t;
  boolean done;
  long a, b;
  long goldfound, totlosses;
  boolean tmparmor, tmpweapon, tmpmen;
  long attackerlosses, defenderlosses, mmen, tmp, tmp1, tmp2, defenderdead;
  char STR2[72];
  char STR3[256];
  char STR4[50];
  char STR5[256];

  flee = false;
  totlosses = 0;
  tmparmor = false;
  tmpweapon = false;
  tmpmen = false;
  done = false;
  defenderdead = 0;
  mmen = 0;
  offset1 = 0;
  offset2 = 0;
  if (defender->armysize < 1) {
    ioobj.clear_scr();
    ioobj.sstrcr("You have found the bones of another army.  ");
    ioobj.sstrcr("the battle must have been furious to cause such destruction.  ");
    ioobj.sstrcr("may they rest in peace.");
    done = true;
    ioobj.waitcr();
  } else if (defender->armysize == 1 && !defender->dead) {
    ioobj.clear_scr();
    ioobj.sstrcr("You have found a prince away from his troops!");
    ioobj.sstrcr("Having pity on the man, you have him beheaded.");
    ioobj.sstrcr("He will trouble you no more.");
    if (defender->gold > 0) {
      sprintf(STR3, "You find %ld gold pieces on him, which you add to your purse", defender->gold);
      ioobj.sstrcr(STR3);
      defender->gold = 0;
      attacker->gold += defender->gold;
    }
    strcpy(defender->killedby, attacker->alias);
    defender->dead = true;
    done = true;
    ioobj.waitcr();
  } else if (attacker->armysize <= 1) {
    ioobj.clear_scr();
    ioobj.sstrcr("The ghosts of another army have attacked you!");
    ioobj.sstrcr("but, because you had no warriors with you, you were not able to fight");
    ioobj.sstrcr("off the attackers.  Their ghostly swords rip you to ribbons.  ");
    ioobj.sstrcr("perhaps in your next life, you'll deem to bring your warriors . ");
    attacker->gold = 0;
    done = true;
    flee = true;
    ioobj.waitcr();
  }
  while (!done) {
    ioobj.clear_scr();
    if (standing) {
      sprintf(STR2, "You have found a standing army left by %s",
	      defender->alias);
      ioobj.sstrcr(STR2);
    } else {
      sprintf(STR4, "Your opponent is %s", defender->alias);
      ioobj.sstrcr(STR4);
    }
    sprintf(STR4,"with %ld warriors.",defender->armysize);
    ioobj.sstrcr(STR4);
    sprintf(STR3, "You have %ld warriors.", attacker->armysize);
    ioobj.sstrcr(STR3);
    ioobj.cr();
    if (!attacker->alignment)
      offset1 = 6;
    if (!defender->alignment)
      offset2 = 6;
    a = attacker->armysize + mmen;
    b = defender->armysize;
    attackerlosses = labs((long)floor((defender->str - 12) * 0.02 * b +
			      (defender->chrs - 12) * 0.005 * b +
			      (defender->int_ - 12) * 0.005 * b + 0.5));
    attackerlosses += labs((long)floor(
			     lrand48() % b * 0.1 + (b - a) * 0.03 +
			     (defender->race - offset2 - 2) * 0.01 * b +
			     (defender->armor - 2) * 0.005 * b +
			     (defender->weapon - 2) * 0.005 * b * 1.15 + 0.5));
    attackerlosses += labs((long)floor(defender->level * 0.02 * b + 0.5));
    tmp1 = attackerlosses;
    if (tmpmen) {
      if (tmp1 > mmen) {
	tmp1 = mmen;
	tmp2 = tmp1 + (tmp1 - mmen);
      } else
	tmp2 = 0;
      if (attacker->male)
	ioobj.sstrcr("Prince, your advisors agree that you will lose ");
      else
	ioobj.sstrcr("Princess, your advisors agree that you will lose ");
      sprintf(STR3, "%ld skeletons and ", tmp1);
      ioobj.sstrcr(STR3);
      sprintf(STR3, "%ld warriors.", tmp2);
      ioobj.sstrcr(STR3);
    } else {
      if (attacker->male)
	ioobj.sstrcr("Prince, your advisors agree that you will lose ");
      else
	ioobj.sstrcr("Princess, your advisors agree that you will lose ");
      sprintf(STR3, "%ld warriors.", attackerlosses);
      ioobj.sstrcr(STR3);
    }
    ioobj.cr();
    ioobj.sstrcr("You may run, attack, or cast a spell. ");
    ioobj.sstr("your choice? ");
	strcpy(c,"");
    ioobj.gstr(c, 1);
    uncase(c[0]);
    if (c[0] == 'r') {
      ioobj.cr();
      ioobj.sstrcr("Attack aborted");
      if (tmpmen)
	ioobj.sstrcr("All of your skeletons dissolve into the ground..");
      if (tmpweapon) {
	attacker->weapon /= 5;
	ioobj.sstrcr("Your weapons stop glowing.");
      }
      if (tmparmor) {
	attacker->armor /= 5;
	ioobj.sstrcr("Your armor returns to normal..");
      }
      defender->killed = defenderlosses;
      ioobj.cr();
      currentsector++;
      flee = true;
      done = true;
    } else if (c[0] == 'c') {
      if (attacker->mweapon <= 0 && attacker->mwarriors <= 0)
	ioobj.sstrcr("You do not have any fight spells.");
      else {
	ioobj.sstrcr("You may use the following: ");
	ioobj.sstrcr("0. none");
	if (attacker->mweapon > 0)
	  ioobj.sstrcr("1. Magic weapon spell");
	if (attacker->mwarriors > 0)
	  ioobj.sstrcr("2. Magic warriors");
	ioobj.sstr("Your choice? ");
	strcpy(c,"");
	ioobj.gstr(c, 1L);
	if (c[0] == '0')
	  ioobj.sstrcr("Spell aborted.");
	else if (c[0] == '1') {
	  if (attacker->mweapon <= 0)
	    ioobj.sstrcr("what?");
	  else if (tmpweapon)
	    ioobj.sstrcr("Another magic weapon spell would do us no good sire.");
	  else {
	    attacker->mweapon--;
	    if (abs(rand() % 100) < 5) {
	      ioobj.sstrcr("Your mages bend to the task, but to no avail.");
	      ioobj.sstrcr("The spell fizzles out before it can take effect.");
	    } else {
	      tmpweapon = true;
	      attacker->weapon *= 5;
	      ioobj.sstrcr("Your journeyman mages bend to the task.  ");
	      ioobj.sstrcr("They succeed!");
	      ioobj.sstrcr("Your weapons are glowing crimson red!");
	    }
	  }
	} else if (c[0] == '2') {
	  if (attacker->mwarriors <= 0)
	    ioobj.sstrcr("what?");
	  else {
	    attacker->mwarriors--;
	    if (abs(rand() % 100) < 5) {
	      ioobj.sstrcr("Your mages bend to the task, but to no avail.");
	      ioobj.sstrcr("The spell fizzles out before it can take effect.");
	    } else {
	      tmpmen = true;
	      tmp = abs(rand() % 30000);
	      mmen += tmp;
	      ioobj.sstrcr("Your journeyman mages bend to the task.  ");
	      ioobj.sstrcr("They succeed!");
	      sprintf(STR3, "%ld skeletons dig themselves from", tmp);
	      ioobj.sstrcr(STR3);
	      ioobj.sstrcr("the ground, and join your troops.");
	    }
	  }
	}
      }
    } else {
      defenderlosses = labs(
	  (long)floor((attacker->str - 12) * 0.02 * a +
		      (attacker->chrs - 12) * 0.005 * a +
		      (attacker->int_ - 12) * 0.005 * a + 0.5));
      defenderlosses += labs((long)floor(attacker->level * 0.01 * a +
		lrand48() % a * 0.1 + (a - b) * 0.03 +
		(attacker->race - offset1 - 2) * 0.01 * a +
		(attacker->armor - 2) * 0.005 * a +
		(attacker->weapon - 2) * 0.005 * a + 0.5));
      if (defenderlosses > defender->armysize)
	defenderlosses = defender->armysize;
      defenderdead += defenderlosses;
      attackerlosses = labs((long)floor((defender->str - 12) * 0.02 * b +
				(defender->chrs - 12) * 0.005 * b +
				(defender->int_ - 12) * 0.005 * b +
				defender->level * 0.03 * b + 0.5));
      attackerlosses +=
	labs((long)floor(lrand48() % b * 0.1 + (b - a) * 0.03 +
			 (defender->race - offset2 - 2) * 0.01 * b +
			 (defender->armor - 2) * 0.005 * b +
			 (defender->weapon - 2) * 0.005 * b + 0.5));
      if (tmpmen) {
	if (attackerlosses > mmen) {
	  tmp1 = mmen;
	  tmp2 = attackerlosses + attackerlosses - mmen;
	} else {
	  tmp1 = attackerlosses;
	  tmp2 = 0;
	}
      } else
	tmp2 = attackerlosses;
      totlosses += tmp2;
      if (tmp2 >= attacker->armysize || attacker->armysize <= 1) {
	ioobj.sstrcr("You and your army were massacred by the defending army.");
	ioobj.sstrcr("You will now be returned to the bbs. ");
	ioobj.sstrcr("You can play again tomorrow. ");
	quit = true;
	done = true;
	flee = true;
	attacker->dead = true;
	if (!standing) {
	  if (attacker->weapon > defender->weapon) {
	    ioobj.sstrcr("Your opponent took the weapons from your body.");
	    ioobj.sstrcr(
	      "with no use for his old weapons, he throws them down beside your remains");
	    tmp = defender->weapon;
	    defender->weapon = attacker->weapon;
	    attacker->weapon = tmp;
	    switchw(*attacker, *defender);
	  } else
	    ioobj.sstrcr("Your opponent laughs at your puny weapons.  he murmurs: what toys!");
	  if (attacker->armor > defender->armor) {
	    ioobj.sstrcr("Your opponent took the armor from your body.");
	    ioobj.sstrcr(
	      "with no use for his old armor, he throws it down beside your remains");
	    tmp = defender->armor;
	    defender->armor = attacker->armor;
	    attacker->armor = tmp;
	    switcha(*attacker, *defender);
	  } else {
	    ioobj.sstrcr("Your opponent wonders what brought you to buy such cheap armor.");
	    ioobj.sstrcr("but, since you are not talking, he doesn't wonder long.");
	  }
	}
	ioobj.sstrcr("Your opponent takes all of the gold on your person. ");
	attacker->killed = attacker->armysize;
	defender->gold += attacker->gold;
	defender->goldfound = attacker->gold;
	attacker->gold = 0;
	attacker->armysize = 1;
	strcpy(attacker->killedby, defender->alias);
	if (defender->armysize < defenderlosses)
	  defender->armysize = labs((long)floor(defender->armysize * 0.9 + 0.5));
	else
	  defender->armysize -= defenderlosses;
	if (tmpmen)
	  ioobj.sstrcr("All of your skeletons dissolve into the ground..");
	if (tmpweapon) {
	  attacker->weapon /= 5;
	  ioobj.sstrcr("Your weapons stop glowing.");
	}
      }
      if (defenderlosses >= defender->armysize || defender->armysize <= 1) {
	ioobj.sstrcr("You have destroyed your opponent's army.");
	if (!standing) {
	  if (defender->incastle) {
	    ioobj.sstrcr("but, your opponent is hiding in his castle.");
	    ioobj.sstrcr("You must assault the castle to kill him.");
	  } else
	    defender->dead = true;
	  if (!defender->incastle) {
	    if (defender->weapon > attacker->weapon &&
		defender->alliance != 100) {
	      ioobj.sstrcr("You find an excellent weapon on the body");
	      ioobj.sstrcr("of your foe.  you throw your old weapon at his feet,");
	      ioobj.sstrcr("and happily grab his fine weapon.");
	      tmp = defender->weapon;
	      defender->weapon = attacker->weapon;
	      attacker->weapon = tmp;
	      switchw(*defender, *attacker);
	    } else
	      ioobj.sstrcr("Your opponent's weapons were destroyed in the battle");
	    if (defender->armor > attacker->armor &&
		defender->alliance != 100) {
	      ioobj.sstrcr("after defeating your foe, you find that his armor");
	      ioobj.sstrcr(
		"is not too badly beaten up.  in fact, it is much better than what");
	      ioobj.sstrcr(
		"you currently have.  Since he will no longer be needing it, you shed your");
	      ioobj.sstrcr("old armor, and don your new armor.   It fits great!");
	      tmp = defender->armor;
	      defender->armor = attacker->armor;
	      attacker->armor = tmp;
	      switcha(*defender, *attacker);
	    } else
	      ioobj.sstrcr("Your opponent's armor was destroyed in the battle");
	  }
	}
	done = true;
	ioobj.cr();
	ioobj.sstr("Your army suffered the loss of ");
	sprintf(STR3, "%ld warriors. ", tmp2);
	ioobj.sstrcr(STR3);
	if (tmpmen)
	  ioobj.sstrcr("All of your skeletons dissolve into the ground..");
	if (tmpweapon) {
	  attacker->weapon /= 5;
	  ioobj.sstrcr("Your weapons stop glowing.");
	}
	defender->killed = defender->armysize;
	if (!(standing || defender->incastle))
	  strcpy(defender->killedby, attacker->alias);
	goldfound = defenderdead * 2 + lrand48() % 10000;
	if (goldfound < 0)
	  goldfound = 500;
	if (!standing)
	  t = labs(defender->gold);
	else
	  t = labs(goldfound);
	sprintf(STR3, "You found %ld gold pieces among the dead.",t);
	ioobj.sstrcr(STR3);
	attacker->experience += defenderdead * 5;
        attacker->gold += t;
	sprintf(STR5, "You gained %ld experience points from the encounter.",
		defenderdead*5);
	ioobj.sstrcr(STR5);
	sprintf(STR3, "You lost %ld men in the entire battle.", totlosses);
	ioobj.sstrcr(STR3);
	attacker->armysize -= tmp2;
	defender->armysize = 1;
	defenderlosses = 0;
      }
      if (!flee && !done) {
	if (tmpmen) {
	  sprintf(STR5, "You lost %ld skeletons in the battle", tmp1);
	  ioobj.sstrcr(STR5);
	  if (tmp1 >= mmen)
	    tmpmen = false;
	}
	ioobj.sstr("Your army suffered the loss of ");
	sprintf(STR5, "%ld warriors in this melee. ", tmp2);
	ioobj.sstrcr(STR5);
	sprintf(STR3, "You have lost %ld men in the battle so far.", totlosses);
	ioobj.sstrcr(STR3);
	ioobj.cr();
	sprintf(STR3, "But, you destroyed %ld of his warriors.", defenderlosses);
	ioobj.sstrcr(STR3);
	attacker->armysize -= tmp2;
	mmen -= tmp1;
	defender->armysize -= defenderlosses;
	ioobj.cr();
	ioobj.cr();
      }
    }
    ioobj.waitcr();
  }  /*while*/
  display_stats(*attacker, 0L);
  check_for_level(attacker);
  return flee;

  /*else*/
}  /*function*/

char *race(int type)
{

  switch (type) {

  case 0:
    return("Toad");
    break;

  case 1:
    return("Halfling");
    break;

  case 2:
    return("Dwarf");
    break;

  case 3:
    return("Human");
    break;

  case 4:
    return("Elf");
    break;

  case 5:
    return("Solar");
    break;

  case 6:
    return("Silvon");
    break;

  case 7:
    return("Orc");
    break;

  case 8:
    return("Dark dwarf");
    break;

  case 9:
    return("Human");
    break;

  case 10:
    return("Drow");
    break;

  case 11:
    return("Daemon");
    break;

  case 12:
    return("Dark lord");
    break;

  default:
    return("Stoner");
  }
}



void reroll_player(Player **player)
{
  char a[32];
  boolean done;
  char c[256], s[256];
  Castle *gptr;
  char y[256];
  char oldname[32];
  Player *WITH;


  ioobj.clear_scr();
  if (rerolledtoday) {
    ioobj.sstrcr("You have already rerolled today.  ");
    ioobj.sstrcr("You must wait another day to reroll again.");
  } else {
    ioobj.cr();
    ioobj.sstrcr("You may only reroll once per day.");
    ioobj.sstrcr("All castles currently owned will go to the new character.");
    ioobj.sstr("Are you sure you want to reroll? ");
	strcpy(y,"");
    ioobj.gstr(y, 1L);
    if (yesno()) {
      WITH = *player;
      rerolledtoday = true;
      strcpy(oldname, WITH->alias);
      WITH->sector = abs(rand() % (boardsize - 1)) + 1;
      WITH->armor = 1;
      WITH->weapon = 1;
      WITH->incastle = false;
      WITH->castaken = 0;
      WITH->alliance = 0;
      WITH->teleport = 0;
      WITH->level = 1;
      WITH->experience = 0;
      WITH->map = 0;
      WITH->dmons = 0;
      WITH->descas = 0;
      WITH->mweapon = 0;
      WITH->killer = 0;
      WITH->himsg = 0;
      WITH->mwarriors = 0;
      WITH->steal = 0;
      WITH->armysize = abs(rand() % 8000) + 2000;
      WITH->gold = (int)fabs(WITH->armysize * 6 + abs(rand() % 45000L) + 15000);
      WITH->dead = false;
      WITH->bank = 0;
      strcpy(WITH->alliancename, "none");
      WITH->allianceleader = false;
      strcpy(WITH->killedby, "-");
      WITH->str = abs(rand() % 10) + 10;
      WITH->int_ = abs(rand() % 10) + 10;
      WITH->luck = abs(rand() % 10) + 10;
      WITH->chrs = abs(rand() % 10) + 10;
      WITH->agi = abs(rand() % 10) + 10;
      WITH->killed = 0;
      /* set entrydate to now */
      time(&WITH->entrydate);
      ioobj.sstr("Are you male or female? (m/[f]) ");
	strcpy(s,"");
      ioobj.gstr(s, 2);
      if (uncase(s[0]) == 'm')
	WITH->male = true;
      else
	WITH->male = false;
      strcpy(WITH->name, playername);
      done = false;
      ioobj.cr();
      ioobj.sstr("Would you like to keep the same name? ");
      if (!yesno()) {
	ioobj.cr();
	ioobj.sstrcr("Your name may be up to 30 characters in length.");
	ioobj.cr();
	while (!done) {
	  ioobj.sstrcr("                 1-------10--------20--------30");
	  ioobj.sstr(  "Prince/Princess |");
	strcpy(a,"");
	  ioobj.gstr(a, 31L);
	  if (strlen(a) < 3) {
	    done = false;
	    ioobj.sstrcr("I'm sorry, but that name is already taken.  please choose another");
	  } else {
	    done = true;
	    strcpy(WITH->alias, a);
	  }
	}
      }
      gptr = castles;
      while (gptr != NULL) {
	if (!strcmp(gptr->alias, oldname)) {
	  strcpy(gptr->alias, WITH->alias);
	  gptr->armor = 1;
	  gptr->weapon = 1;
	}
	gptr = gptr->next;
      }
      ioobj.sstr("Is your character good or evil? (g/e) ");
	strcpy(s,"");
      ioobj.gstr(s, 2);
      if (uncase(s[0]) == 'e')
	WITH->alignment = false;
      else
	WITH->alignment = true;
      if (WITH->alignment) {
	done = false;
	while (!done) {
	  ioobj.sstrcr("You may pick any of the following races: ");
	  ioobj.sstrcr("1.  Halfling");
	  ioobj.sstrcr("2.  Dwarf");
	  ioobj.sstrcr("3.  Human");
	  ioobj.sstrcr("4.  Elf");
	  ioobj.sstr("your choice? ");
	strcpy(c,"");
	  ioobj.gstr(c, 1L);
	  if (c[0] <= '0' || c[0] >= '5')
	    continue;
	  done = true;
	  switch (c[0]) {

	  case '1':
	    WITH->race = 1;
	    break;

	  case '2':
	    WITH->race = 2;
	    break;

	  case '3':
	    WITH->race = 3;
	    break;

	  case '4':
	    WITH->race = 4;
	    break;

	  default:
	    ioobj.sstrcr("something is really screwy..");
	    break;
	  }
	}
      } else {
	done = false;
	while (!done) {
	  ioobj.sstrcr("You may pick any of the following races: ");
	  ioobj.sstrcr("1.  Orc");
	  ioobj.sstrcr("2.  Dark dwarf");
	  ioobj.sstrcr("3.  Human");
	  ioobj.sstrcr("4.  Drow");
	  ioobj.sstr("your choice? ");
	strcpy(c,"");
	  ioobj.gstr(c, 2);
	  if (c[0] <= '0' || c[0] >= '5')
	    continue;
	  done = true;
	  switch (c[0]) {

	  case '1':
	    WITH->race = 7;
	    break;

	  case '2':
	    WITH->race = 8;
	    break;

	  case '3':
	    WITH->race = 9;
	    break;

	  case '4':
	    WITH->race = 10;
	    break;

	  default:
	    ioobj.sstrcr("something is really screwy..");
	    break;
	  }
	}
      }
    }
  }
  ioobj.waitcr();
}  /*procedure*/



void rollplayer(void)
{
  char a[32];
  boolean done;
  char c[256], s[256];
  Player player;
  Castle *gptr;
  Player *uptr;


  ioobj.clear_scr();
  ioobj.cr();
  ioobj.cr();
  ioobj.sstrcr("I can't find you in the playerfile. ");
  ioobj.cr();
  ioobj.sstr("Would you like me to roll a character for you? ");
  if (!yesno()) {
    remove_busy();
    exit_game(0);
  }
  ioobj.sstrcr("You must answer a few questions, and then you'll be a");
  ioobj.sstrcr("contender for the throne of thaniphir.");
  player.sector = abs(rand() % (boardsize - 1)) + 1;
  player.armor = 1;
  player.weapon = 1;
  player.alliance = 0;
  player.teleport = 0;
  player.level = 1;
  player.experience = 0;
  player.incastle = false;
  player.castaken = 0;
  player.himsg = 0;
  player.map = 0;
  player.timesplayed = 0;
  player.dmons = 0;
  player.descas = 0;
  player.mwarriors = 0;
  player.mweapon = 0;
  player.steal = 0;
  player.killer = 0;
  player.armysize = abs(rand() % 8000) + 2000;
  player.gold = (int)fabs(player.armysize * 6 + abs(rand() % 35000L) + 40000L);
  player.dead = false;
  player.goldfound = 0;
  player.bank = 0;
  strcpy(player.alliancename, "none");
  player.allianceleader = false;
  strcpy(player.killedby, "-");
  player.str = abs(rand() % 10) + 10;
  player.int_ = abs(rand() % 10) + 10;
  player.luck = abs(rand() % 10) + 10;
  player.chrs = abs(rand() % 10) + 10;
  player.agi = abs(rand() % 10) + 10;
  player.killed = 0;
  time(&player.entrydate);
  strcpy(player.name, playername);
  done = false;
  a[0] = 0;
  if (!find_castle_by_o_a(user.user_alias(),&gptr))
  {
  sprintf(c,"Your alias within the BBS is %s",user.user_alias());
  ioobj.sstrcr(c);
  ioobj.sstr("Would you like to use that alias as your alias in the game?  ");
  if (yesno())
  {
  	strcpy(a,user.user_alias());
	strcpy(player.alias, a);
  }
  }
  if (strlen(a) == 0)
  {
  ioobj.sstrcr("Please enter a name to be known by in the BattleField.");
  ioobj.cr();
  ioobj.sstrcr("Your name may be up to 30 characters in length.");
  ioobj.cr();
  while (!done) {
    ioobj.sstrcr("                 1-------10--------20--------30");
    ioobj.sstr(  "Prince/Princess |");
	strcpy(a,"");
    ioobj.gstr(a, 31L);
    if (find_castle_by_o_a(a, &gptr) || strlen(a) < 3) {
      done = false;
      ioobj.sstrcr("I'm sorry, but that name is already taken.  Please choose another");
    } else {
      done = true;
      strcpy(player.alias, a);
    }
  }
  }
  ioobj.sstr("Are you male or female? (m/[f]) ");
	strcpy(s,"");
  ioobj.gstr(s, 2);
  if (uncase(s[0]) == 'm')
    player.male = true;
  else
    player.male = false;
  ioobj.cr();
  ioobj.sstr("Is your character good or evil? ([g]/e) ");
	strcpy(s,"");
  ioobj.gstr(s, 2);
  if (uncase(s[0]) == 'e')
    player.alignment = false;
  else
    player.alignment = true;
  if (player.alignment) {
    done = false;
    while (!done) {
      ioobj.sstrcr("You may pick any of the following races: ");
      ioobj.sstrcr("1.  Halfling");
      ioobj.sstrcr("2.  Dwarf");
      ioobj.sstrcr("3.  Human");
      ioobj.sstrcr("4.  Elf");
      ioobj.sstr("Your choice? ");
	strcpy(c,"");
      ioobj.gstr(c, 2);
      if (c[0] <= '0' || c[0] >= '5')
	continue;
      done = true;
      switch (c[0]) {

      case '1':
	player.race = 1;
	break;

      case '2':
	player.race = 2;
	break;

      case '3':
	player.race = 3;
	break;

      case '4':
	player.race = 4;
	break;

      default:
	ioobj.sstrcr("something is really screwy..");
	break;
      }
    }
  } else {
    done = false;
    while (!done) {
      ioobj.sstrcr("You may pick any of the following races: ");
      ioobj.sstrcr("1.  Orc");
      ioobj.sstrcr("2.  Dark dwarf");
      ioobj.sstrcr("3.  Human");
      ioobj.sstrcr("4.  Drow");
      ioobj.sstr("Your choice? ");
	strcpy(s,"");
      ioobj.gstr(s, 1L);
      sprintf(c, "%c", uncase(s[0]));
      if (c[0] <= '0' || c[0] >= '5')
	continue;
      done = true;
      switch (c[0]) {

      case '1':
	player.race = 7;
	break;

      case '2':
	player.race = 8;
	break;

      case '3':
	player.race = 9;
	break;

      case '4':
	player.race = 10;
	break;

      default:
	ioobj.sstrcr("something is really screwy..");
	break;
      }
    }
  }
  addplayer(player);
  give_castle(&castles, 0L);
  if (!find_player_by_name(playername, &uptr))
  {
    ioobj.sstrcr("Add of player failed!  Exiting!");
    exit_game(1);
  }
  // place him in the same sector as his castle
  if (find_castle_by_o_a(uptr->alias, &gptr)) 
  	uptr->sector = gptr->sector;
  else
  	uptr->sector = 1;
}  

void subtract_level(Player *player)
{
  long level;
  double num;
  char STR1[256];


  level = 1;
  num = 450.0;
  while (level < player->level - 1) {
    level++;
    num *= 1.5;
  }
  if (1 >= player->level)
    return;
  ioobj.clear_scr();
  ioobj.sstrcr("As you fall towards hades, Lucifer appears in front of you.");
  ioobj.sstrcr("before you leave, slime, the gods would have a word with you.");
  ioobj.sstrcr("Zeus appears before you:");
  ioobj.sstrcr("Lowly creature, we strive to help you in your mission.  Yet ");
  ioobj.sstrcr("you get yourself killed.  For this failure, we are taking back one");
  ioobj.sstrcr("level.  Perhaps this lesson will teach you to succeed in the future.");
  ioobj.sstrcr("then, with an angry expression on his face, zeus pops from in front of you.");
  player->level = level;
  player->experience = (long)floor(num + 0.5);
  sprintf(STR1, "You are now level %ld", level);
  ioobj.sstrcr(STR1);
  ioobj.waitcr();
  ioobj.clear_scr();
}

void switchw(Player taker, Player giver)
{
  Castle *cptr;

  cptr = castles;
  while (cptr != NULL) {
    if (!strcmp(cptr->alias, taker.alias))
      cptr->weapon = taker.weapon;
    if (!strcmp(cptr->alias, giver.alias))
      cptr->weapon = giver.weapon;
    cptr = cptr->next;
  }
}


void switcha(Player taker, Player giver)
{
  Castle *cptr;

  cptr = castles;
  while (cptr != NULL) {
    if (!strcmp(cptr->alias, taker.alias))
      cptr->armor = taker.armor;
    if (!strcmp(cptr->alias, giver.alias))
      cptr->armor = giver.armor;
    cptr = cptr->next;
  }
}









/* End. */
#endif // _PLAYER_C_








