#ifndef _BF_C_
#define _BF_C_

#define MAIN
#include "bf.h"

main()
{
  int x;
  time_t now;		// current time
  char tmpstr[256];
  Menu menu;		// current menu
  MenuItem *result;	// result of menu run
  char curmenu[MENU_NAME_LEN];		// current menu
  char prevmenu[MENU_NAME_LEN];		// previous menu
  char menustack[MENU_STACK_SIZE][MENU_NAME_LEN];	// menu stack
  int  stacktop;	// top of menu stack
  struct stat buf;	// file status
  struct tm then_date;	// date of last run
  struct tm now_date;	// date of current run
  int  timesup;		// time expired?
  int  watch;

  // banner 
  ioobj.sstrcr("Starting BattleField..\r\n");

  // intercept signals -- up to sigpipe
  for (x=1; x<SIGPIPE+1; x++)
  	signal(x,&getout);

  user.get(NULL,0);	// read user record


  if (doorinfo.read_doorsys() != 0)
  {
  	ioobj.sstrcr("The BattleField may only be played through the BBS.");
  	ioobj.sstrcr("Please enter the game through the BBS.");
	ioobj.waitcr();
	exit(1);
  }

  // initialize globals (for now)
  resettourney = false;
  gottime = false;
  enteredchurch = 0;
  castles = NULL;
  players = NULL;
  havedata = false;
  villages = NULL;
  alliances = NULL;
  teleporters = NULL;
  scrolls = NULL;
  armies = NULL;
  outside = true;
  incastle = false;
  inmountains = false;
  enteredbank = false;
  rerolledtoday = false;
  justentered = true;
  quit = false;
  timesup = false;

  /* set random seed */
  srand(time(NULL));

  // init user's terminal
  ioobj.term_mode(1);	/* turn on non-blocking i/o */

  // init other things 
  init_options();

  // modify user's time left in game (if necessary)
  // if < 1 session available, limit session length
  if (doorinfo.info.minsremaining < theoptions.timelimit)
  	user.change_tl(doorinfo.info.minsremaining,0);
  // if user has more time than allowed, limit time
  else if (user.u_timelimit() > (unsigned)theoptions.timelimit)
  	user.change_tl(theoptions.timelimit,0);
  
  // check whether it's time to move the rogues
  time(&now);
  memcpy(&now_date,localtime(&now),sizeof(struct tm));
  memcpy(&then_date,localtime(&theoptions.date),sizeof(struct tm));
  if (now_date.tm_mday != then_date.tm_mday)	// different day?
  {
  	theoptions.date = now;
	move_castles = 1;	// move castles, villages and rogues
	theoptions.daysingame++;
	if (theoptions.daysingame > theoptions.daystorun)
	{
		resettourney++;	// tournament expired
		theoptions.daysingame = 0;	
	}
  }


  // set lock file 
  if (set_busy())
  {
	ioobj.sstrcr("I'm sorry, but someone else is playing BattleField at this time.");
	ioobj.cr();
	ioobj.sstrcr("Please try again later.");
	ioobj.waitcr();
	exit(0);		// not an error
  }

  // display welcome file
  sprintf(tmpstr,"%s/BattleField Welcome",CONFDIR);
  if (stat(tmpstr,&buf) >= 0)
  {
	  ioobj.display_file(tmpstr,1,getenv("TERM"),1);
  }
  // display victories file (if available)
  sprintf(tmpstr,"%s/BattleField Victories",CONFDIR);
  if (stat(tmpstr,&buf) >= 0)
  {
	  ioobj.display_file(tmpstr,1,getenv("TERM"),1);
  }

  // get name of this user
  strcpy(playername,ioobj.username());

  check_for_battlefield();   /* create configuration files */

  // read configuration files
  get_sectors(sectors);
  get_messages(&scrolls);
  get_armies(&armies);
  get_players();
  get_villages(&villages);
  get_castles(&castles);
  get_alliances(&alliances);
  get_teleporters(&teleporters);

  // move castles as necessary
  if (move_castles) {
    ioobj.sstrcr("Updating villages..");
    update_villages(&villages);
    ioobj.sstrcr("It is now time to move the Magi.  ");
    ioobj.sstrcr("I am sorry for the time delay, but for entertainment");
    ioobj.sstr("would you like to watch their activities? ");
    watch = (yesno());
    move_em(&castles, watch);
    move_rem(watch);
  }

  // get game info for player 
  quit = can_play(playername, &castles);   

  havedata = true;		// flag that things need to be saved

  // get this person
  if (!find_player_by_name(playername, &player))
  {
	sprintf(tmpstr,"bf: Unable to find player %s",playername);
	ioobj.ap_log(tmpstr);
	exit(1);
  }
  // standard prices (random)
  mercprice = 3 + (abs(rand()) % 2 );
  if (mercprice <= 0)
    mercprice = 2;

  // show the user their character 
  display_stats(*player, 0L);

  // check for tournament expiration
  if (resettourney) {
    ioobj.sstrcr("The current tournament has expired.");
    ioobj.sstrcr("Writing reports, please wait..");
    high_scores(true, true);
    reset_game(false, false);
  }
  else
  {
     sprintf(tmpstr,"There are %d days left in the current tournament.", 
     	theoptions.daystorun - theoptions.daysingame);
     ioobj.sstrcr(tmpstr);
     ioobj.waitcr();
  	
  }
  // standard entry stuff
  if (!quit) {
    ioobj.sstrcr("15000 gold pieces were added to your purse.");
    player->gold += 15000;
    ioobj.waitcr();
    player->timesplayed++;
    if (theoptions.entries - player->timesplayed == 0)
    	sprintf(tmpstr,"This is your last entry.");
    else
	    sprintf(tmpstr, "You have %ld more %s left today in the battlefield", theoptions.entries -  player->timesplayed, theoptions.entries - player->timesplayed > 1?"entries":"entry");
      ioobj.sstrcr(tmpstr);
    ioobj.cr();
    ioobj.waitcr();
    ioobj.sstrcr("Difficulty: 1 - Easy, 10 - VERY difficult.");
    ioobj.cr();
    sprintf(tmpstr,"Current Game Difficulty: %d",theoptions.difficulty);
    ioobj.sstrcr(tmpstr);
    ioobj.waitcr();
  }

  // current location
  currentsector = player->sector;

  // init menu 
  strcpy(curmenu,"bf/main");
  strcpy(prevmenu,"bf/main");
  if (menu.build("bf/main",1) != 0)
  {
  	ioobj.ap_log("bf: unable to open main menu");
	exit(1);
  }
  stacktop = 0;

  while (!quit) {
    display_header();   // add header and check for any events

    // get player	 (just in case)
    if (!find_player_by_name(playername, &player))
      exit_game(0);

    // get a castle owned by the player
    find_castle_by_o_a(player->alias, &cptr);

    // find any villages in sector
    find_village_in_sector(currentsector, &vptr);

    // if not already quitting, quit if player has died
    if (!quit)	
      quit = player->dead;


    if (!quit) 
    {
      if (result = menu.run(), result == NULL)
      	continue;
      switch (result->com_type) {

// -1-10 bbs/menu functions
      default:	
      case -1:		// time expired
      	quit++;
	timesup++;
	break;

      case 0:		// dummy command
      	continue;
	break;

      case 1:		// quit game
	ioobj.sstr("Are you sure you want to quit? ");
	if (yesno())
	  quit = true;
	break;

      case 2: // transfer to new menu 
	strcpy(prevmenu,curmenu);
	// get new menu name
	strcpy(curmenu,result->misc);
	if (menu.build(curmenu,1) != 0)
	{
		sprintf(tmpstr,"Unable to open menu %s." ,result->misc);
		menu.ap_log(tmpstr);
		// get new menu name
		strcpy(curmenu,prevmenu);
		if (menu.build(curmenu,1) != 0)
		{
			sprintf(tmpstr,"PANIC: Unable to open menu %s.",prevmenu);
			menu.er_log(tmpstr);
		}
	}
	else
	{
		// get new menu name
		strcpy(menustack[stacktop++],prevmenu);
	}
	break;

      case 3:             // exit to previous menu
	if (stacktop > 0)
	{
		strcpy(prevmenu,curmenu);
		strcpy(curmenu,menustack[--stacktop]);
		if (menu.build(curmenu,1) != 0)
		{
			sprintf(tmpstr,"Unable to open menu %s.",result->misc);
			menu.ap_log(tmpstr);
			// get last menu
			strcpy(curmenu,prevmenu);
			if (menu.build(curmenu,1) != 0)
			{
				sprintf(tmpstr,"PANIC: Unable to open menu %s.",prevmenu);
				menu.er_log(tmpstr);
			}
		}
		// reset to outdoors menu
		incastle = false;
		exited = true;
		outside = true;
	}
	break;

      case 6:	// display a file, paged (absolute path)
        menu.display_file(result->misc,1,getenv("TERM"),1);
	break;

      case 7:		// display high scores (to screen)
	high_scores(false, false);
	break;


// 11-25 town functions

      case 11:		// buy spells from mage guild in town
	mage_guild(false, &player);
	break;

      case 12:		// buy mercenaries in town
	mercenaries(false, mercprice);
	break;

      case 13:		// enter scribes guild in town
	scribes_guild(&scrolls, &player, true);
	break;

      case 14:		// buy some weapons in town
	buy_weapons(1L);
	break;

// 15-19 are used within the rocat menu system for embedded menu commands
// They're processed prior to command selection, hence they're not available

      case 20:		// buy armor in town 
	buy_armor(1L);
	break;

      case 21:		// enter church
	cathedral(true);
	break;

      case 22:		// go to the bank
	bank();
	break;

      case 23:		// enter village
	if (!find_village_in_sector(currentsector, &vptr)) {
	  ioobj.sstrcr("there is no village to enter.");
	  ioobj.waitcr();
	} else {
		incastle = false;
		exited = false;
		outside = false;
		/* transfer to village menu */
		strcpy(prevmenu,curmenu);
		// get new menu name
		strcpy(curmenu,result->misc);
		if (menu.build(curmenu,1) != 0)
		{
			sprintf(tmpstr,"Unable to open menu %s." ,result->misc);
			menu.ap_log(tmpstr);
			// get new menu name
			strcpy(curmenu,prevmenu);
			if (menu.build(curmenu,1) != 0)
			{
				sprintf(tmpstr,"PANIC: Unable to open menu %s.",prevmenu);
				menu.er_log(tmpstr);
			}
		}
		else
		{
			// get new menu name
			strcpy(menustack[stacktop++],prevmenu);
		}
	}
	break;

      case 24:		// buy a castle
	buy_castle();
	break;

      case 25:		// enter bar - get some rumors
	rumors();
	break;

// 26-40 castle functions

      case 26:		// buy spells from mage guild in castle
	mage_guild(true, &player);
	break;

      case 27:		// enter castle (that you own)
	if (!find_castle_in_sector(currentsector, &cptr)) {
	  ioobj.sstrcr("There is no castle to enter.");
	  ioobj.waitcr();
	} else if (strcmp(player->alias, cptr->alias) &&
		   (player->alliance != cptr->alliance ||
		    player->alliance == 0)) {
	  ioobj.sstrcr("You don't own this castle, and are not of the same alliance. ");
	  ioobj.sstrcr("You must conquer the castle to enter. ");
	  ioobj.cr();
	  ioobj.waitcr();
	} else {
		incastle = true;
		exited = false;
		outside = false;
		/* transfer to new menu */
		strcpy(prevmenu,curmenu);
		// get new menu name
		strcpy(curmenu,result->misc);
		if (menu.build(curmenu,1) != 0)
		{
			sprintf(tmpstr,"Unable to open menu %s." ,result->misc);
			menu.ap_log(tmpstr);
			// get new menu name
			strcpy(curmenu,prevmenu);
			if (menu.build(curmenu,1) != 0)
			{
				sprintf(tmpstr,"PANIC: Unable to open menu %s.",prevmenu);
				menu.er_log(tmpstr);
			}
		}
		else
		{
			// get new menu name
			strcpy(menustack[stacktop++],prevmenu);
		}
	}
	break;

      case 28:		// enter scribes guild in castle
	scribes_guild(&scrolls, &player, false);
	break;

      case 29:		// fortify your castle
	fortify_castle();
	break;

      case 30:		// buy weapons in castle
	buy_weapons(2L);
	break;

      case 31:		// buy armor in castle
	buy_armor(2L);
	break;

      case 32:		// buy some mercs in a castle
	mercenaries(true, mercprice);
	break;

      case 33:		// take men from your castle to your army
	take_men();
	break;

      case 34:		// teleport from one castle to another
	teleport();
	break;

      case 36:		// change a castle name
	change_castle_name();
	break;

      case 37:		// enter cathedral in castle
	cathedral(false);
	break;

      case 38:		// attack a castle
	quit = attack_castle();
	break;

      case 39:		// destroy a castle that you own
	destroy_castle();
	break;

      case 40:		// go to the bank
	bank();
	break;






// 41-50 alliance functions

      case 41:		// quit an alliance
	quit_alliance();
	break;

      case 42:		// change alliance password
	new_password(&player);
	break;

      case 43:		// kick a person out of your alliance
	kick_out(player);
	break;

      case 44:		// list the alliances
	list_alliances(players);
	break;

      case 45:		// disband your alliance
	disband_alliance();
	break;

      case 46:		// create a new alliance
	new_alliance();
	break;

      case 47:		// join an alliance
	join_alliance();
	break;

      case 48:		// lend (give) stuff to an alliance member
	lend();
	break;



// 51-60 misc/user functions
      case 51:		// reroll yourself
	reroll_player(&player);
	break;

      case 52:		// cast a non-battle spell
	do_spell(&player);
	break;

      case 53:		// station an army in a sector
	station_army(&player);
	break;

      case 54:		// change your name
	change_player_name();
	break;

      case 55:		// list the player in the game
	list_players(players);
	break;

      case 56:		// display your stats
	display_stats(*player, 0L);
	break;



// 61-70 movement

      case 61:		// go north-west
	nw();
	break;

      case 62:		// go north
	n();
	break;

      case 63:		// go north-east
	ne();
	break;

      case 64:		// go east
	e();
	break;

      case 65:		// go south-east
	se();
	break;

      case 66:		// go south
	south();
	break;

      case 67:		// go south-west
	sw();
	break;

      case 68:		// go west
	w();
	break;

// 71-80 sysop

      case 71:		// edit a player (sysop)
	edit_player();
	break;

      case 72:		// delete a castle (sysop)
	delete_castle();
	break;

      case 73:		// delete a player (sysop)
	delete_player();
	break;

      case 74:		// reset the game (sysop)
	reset_game(false, false);
	break;

      }
    }
    if (!quit)
      quit = player->dead;
    if (quit)
      continue;
    /* get time */
  }
  if (timesup)
    ioobj.sstrcr("Your time is up.");
  ioobj.cr();
  ioobj.cr();
  if (find_castle_in_sector(currentsector, &cptr) && !player->dead &&
      !strcmp(player->alias, cptr->alias)) {
    ioobj.sstr("Would you like to stay in your castle? ");
    if (yesno())
    {
      // move all possible men of their army into the castle
      switch (cptr->castype) {

      case 0:
	max = 20000;
	break;

      case 1:
	max = 50000L;
	break;

      case 2:
	max = 80000L;
	break;

      case 3:
	max = 100000L;
	break;

      default:
	max = 0;
	break;
      }
      if (cptr->defend < max) {
	if (cptr->defend + player->armysize > max) {
	  player->armysize += cptr->defend - max;
	  cptr->defend = max;
	} else {
	  cptr->defend += player->armysize;
	  player->armysize = 1;
	}
      }
      player->incastle = true;
    }
    ioobj.waitcr();
  }
  ioobj.sstrcr("Leaving the BattleField..");
  // knock off level(s) if they're dead.
  if (player->dead)
    subtract_level(player);
  if (theoptions.scores)
    high_scores(true, false);
  remove_busy();	// remove lock file
  save_game();		// save game
  save_options();	// write out options
  ioobj.term_mode(0);	/* turn on non-blocking i/o */
  exit(0);
}



#endif // _BF_C_
