#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include "areas.h"
#include "status.h"
#include "varlist.h"

int date_ok;

char *busy_strings[] = { 
  "initializing",
  "waiting for call", 
  "logging in",
  "online",
  "chatting",
  "door",
  "paging",
  "shutting down"
};

char *months[12] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug",
                     "Sep", "Oct", "Nov", "Dec" 
};

char *long_months[12] = { "January", "February", "March", "April", "May", 
                          "June", "July", "August", "September", "October",
                          "November", "December" 
};

char *days[7] = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };

char *long_days[7] = { "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday",
                       "Friday", "Saturday" 
};

extern int ansi, areanum, areas, area_read, sort_changed;
extern int protocol_num, protocols;
extern struct area_t area[MAXAREAS];
extern struct protocol_t protocol[MAXPROTOCOLS];
extern varlist list;
extern char yes_key, no_key, mark_key, quit_key, cont_key;
extern struct file_t *first_file;
extern struct status_t *status_p;

extern void kill_filelist();
extern void dprintf(char *, ...);
extern void kill_marks();

void busy(int b)
{
  list.add_sys("busy", busy_strings[b]);
  status_p -> busy = b;
}

char *format_user(char *s)
{
  static char tmp[40];
  int t, u = 0, spaced = 1;
  char c;
   
  for(t = 0;t <= strlen(s) && t < 40;t++) {
    c = s[t];
    if(c == ' ') {
      if(!spaced)
        tmp[u++] = c;
      spaced = 1;
    } 
    else {
      if(isalpha(c))
	if(spaced)
          c = toupper(c);
        else
          c = tolower(c);
	 
      tmp[u++] = c;
      spaced = 0;
    }
  }

  if(u  > 1 && tmp[u - 2] == ' ')
    tmp[u - 2] = 0;
   
  return tmp;   
}

char *format_date(int secs)
{
  static char buf[100];
  char *fmt;
  struct tm *time_p;
  int t, blen = 0;
  time_t caltime;

  buf[0] = 0;
  
  caltime = (time_t)secs; 
  time_p = localtime(&caltime);
   
  fmt = string("datefmt");

  for(t = 0;t < strlen(fmt);t++) {
    if(fmt[t] == 'd')  
      blen += sprintf(buf + blen, "%2d", time_p -> tm_mday);
    else if(fmt[t] == 'y')
      blen += sprintf(buf + blen, "%d", time_p -> tm_year + 1900);
    else if(fmt[t] == 'm')
      blen += sprintf(buf + blen, "%2d", time_p -> tm_mon + 1);
    else if(fmt[t] == 'M')
      blen += sprintf(buf + blen, "%s", months[time_p -> tm_mon]);
    else if(fmt[t] == 'l')
      blen += sprintf(buf + blen, "%s", long_months[time_p -> tm_mon]);
    else if(fmt[t] == 'w')
      blen += sprintf(buf + blen, "%s", days[time_p -> tm_wday]);
    else if(fmt[t] == 'W')
      blen += sprintf(buf + blen, "%s", long_days[time_p -> tm_wday]);
    else 
      buf[blen++] = fmt[t];
  }
   
  return buf;
}

int unformat_date(char *s)
{
  char *fmt, buf[5];
  int t, val[3], v = 0, b;
  struct tm date;
  time_t result;
  
  fmt = string("datefmt");
  buf[4] = 0;
  
  for(t = 0;s[t];t++) {
    if(!isdigit(s[t]))
      continue;
    
    b = 0;
    do {
      buf[b++] = s[t++];
    } while(s[t] && isdigit(s[t]) && b < 4);
    
    if(b == 5 || v == 3) {
      date_ok = 1;
      return 0;
    }
    
    buf[b] = 0;
    val[v++] = atoi(buf);
  }

  if(v != 3) {
    date_ok = 1;
    return 0;
  }
  
  date.tm_sec = 0;
  date.tm_min = 0;
  date.tm_hour = 2;
  
  v = 0;
  
  while(*fmt) {
    if(*fmt == 'd') {
      date.tm_mday = val[v++];  
//      dprintf(">day = %d\n", date.tm_mday);
      if(date.tm_mday < 1 || date.tm_mday > 31) {
        date_ok = 1;
        return 0;
      }
    }
   
    if(*fmt == 'y') {
      date.tm_year = val[v++];
//      dprintf(">year = %d\n", date.tm_year);
      if(date.tm_year < 70) // 2000-2069
        date.tm_year += 100;
      else if(date.tm_year >= 70 && date.tm_year < 100) // 1970-99
        ;
      else if(date.tm_year >= 1970) // 1970-?
        date.tm_year -= 1900;
      else { // 100-1969
        date_ok = 1;
        return 0;
      }
    }
   
    if(*fmt == 'm' || *fmt == 'M' || *fmt == 'l') {
      date.tm_mon = val[v++] - 1;
//      dprintf(">month = %d\n", date.tm_mon);
      if(date.tm_mon < 0 || date.tm_mon > 11) {
        date_ok = 1;
        return 0;
      }
    }
    
    fmt++;
  }

  result = mktime(&date);
    
  date_ok = 0;
  return result;
}

char *initials(char *user)
{
  int t, i;
  static char init[8];
  char *name;
   
  name = string(user);
   
  for(i = 0, t = 0;t < strlen(name) && i < 8;t++) {
    if(isupper(name[t]))
      init[i++] = name[t];
  }
   
  init[i] = 0;
   
  return i == 0 ? "X" : init;
}

variable::~variable()
{
  if(left != NULL)
    delete left;
   
  if(right != NULL)
    delete right;

  delete name;

  if(type == STRING)
    delete s;
}

variable::variable(char *a, int b)
{
  name = new char [strlen(a) + 1];
  strcpy(name, a);
  i = b;

  type = NUMERIC;
  left = right = NULL;
  save = 1;
  check_magic();
  if(magic)
    sync_num();
}

variable::variable(char *a, char *b)
{
  name = new char [strlen(a) + 1];
  strcpy(name, a);
  s = new char [strlen(b) + 1];
  strcpy(s, b);

  type = STRING;
  left = right = NULL;
  save = 1;
  check_magic();
  if(magic)
    sync_string();
}

int variable::operator=(int a)
{
  if(type == STRING)
    delete s;

  i = a;
  type = NUMERIC;

  if(magic)
    sync_num();
   
  return i;
}

char *variable::operator=(char *a)
{
  if(type == STRING)
    delete s;

  s = new char [strlen(a) + 1];
  strcpy(s, a);
  type = STRING;

  if(magic)
    sync_string();
   
  return s;
}

char *variable::get_s()
{
  if(!magic)
    return s;
  else if(magic == V_DATE) {  
    char *tmp;
    int today = (int)time(NULL);
    tmp = format_date(today);
    delete s;
    s = new char[strlen(tmp) + 1];
    strcpy(s, tmp);
  }
  else if(magic == V_RED)
    return ansi ? "\033[0;31m" : "";
  else if(magic == V_BRED)
    return ansi ? "\033[1;31m" : "";
  else if(magic == V_BLUE)
    return ansi ? "\033[0;34m" : "";
  else if(magic == V_BBLUE)
    return ansi ? "\033[1;34m" : "";
  else if(magic == V_CYAN)
    return ansi ? "\033[0;36m" : "";
  else if(magic == V_BCYAN)
    return ansi ? "\033[1;36m" : "";
  else if(magic == V_GREEN)
    return ansi ? "\033[0;32m" : "";
  else if(magic == V_BGREEN)
    return ansi ? "\033[1;32m" : "";
  else if(magic == V_PURPLE)
    return ansi ? "\033[0;35m" : "";
  else if(magic == V_BPURPLE)
    return ansi ? "\033[1;35m" : "";
  else if(magic == V_BLACK)
    return ansi ? "\033[0;30m" : "";
  else if(magic == V_BROWN)
    return ansi ? "\033[0;33m" : "";
  else if(magic == V_YELLOW)
    return ansi ? "\033[1;33m" : "";
  else if(magic == V_DGREY)
    return ansi ? "\033[1;30m" : ""; // Okay, technically spoken dark grey
  else if(magic == V_GREY)           // is bright black, so sue me.
    return ansi ? "\033[0;37m" : "";
  else if(magic == V_WHITE)
    return ansi ? "\033[1;37m" : "";
  else
    return s;
}

void variable::check_magic()
{
  magic = 0;
 
  if(!strcmp(name, "ansi"))
    magic = V_ANSI;  
  else if(!strcmp(name, "user")) 
    magic = V_USER;
  else if(!strcmp(name, "areanum"))
    magic = V_AREANUM;
  else if(!strcmp(name, "touser"))
    magic = V_TOUSER;
  else if(!strcmp(name, "date"))
    magic = V_DATE;
  else if(!strcmp(name, "nick"))
    magic = V_NICK;
  else if(!strcmp(name, "red"))
    magic = V_RED;
  else if(!strcmp(name, "bred"))
    magic = V_BRED;
  else if(!strcmp(name, "blue"))
    magic = V_BLUE;
  else if(!strcmp(name, "bblue"))
    magic = V_BBLUE;
  else if(!strcmp(name, "cyan"))
    magic = V_CYAN;
  else if(!strcmp(name, "bcyan"))
    magic = V_BCYAN;
  else if(!strcmp(name, "green"))
    magic = V_GREEN;
  else if(!strcmp(name, "bgreen"))
    magic = V_BGREEN;
  else if(!strcmp(name, "purple"))
    magic = V_PURPLE;
  else if(!strcmp(name, "bpurple"))
    magic = V_BPURPLE;
  else if(!strcmp(name, "black"))
    magic = V_BLACK;
  else if(!strcmp(name, "brown"))
    magic = V_BROWN;
  else if(!strcmp(name, "yellow"))
    magic = V_YELLOW;
  else if(!strcmp(name, "darkgrey") || !strcmp(name, "darkgray"))
    magic = V_DGREY;
  else if(!strcmp(name, "grey") || !strcmp(name, "gray"))
    magic = V_GREY;
  else if(!strcmp(name, "white"))
    magic = V_WHITE;
  else if(!strcmp(name, "yeskey"))
    magic = V_YESKEY;
  else if(!strcmp(name, "nokey"))
    magic = V_NOKEY;
  else if(!strcmp(name, "markkey"))
    magic = V_MARKKEY;
  else if(!strcmp(name, "quitkey"))
    magic = V_QUITKEY;
  else if(!strcmp(name, "contkey"))
    magic = V_CONTKEY;
  else if(!strcmp(name, "protocol"))
    magic = V_PROTOCOL;
  else if(!strcmp(name, "areatag"))
    magic = V_AREATAG;
  else if(!strcmp(name, "today"))
    magic = V_TODAY;
  else if(!strcmp(name, "filesort"))
    magic = V_FILESORT;
}

int variable::get_i()
{
  if(!magic)
    return i;
  else if(magic == V_TODAY)
    return (int)time(NULL);
  else
    return i;
}

void variable::sync_num()
{
  switch(magic) {
  case V_ANSI:
    ansi = i;
  break;
     
  case V_AREANUM:
    if(areanum == i)
      return;
    
    kill_filelist();
    areanum = i; 
    *list["areaname"] = i < areas ? area[i].name : "none";
    //list.add_sys("areatype", area[i].type == NATIVE ? "native" : "sunsite");
    if(area[i].type == AREA_NATIVE)
      list.add_sys("areatype", "native");
    else if(area[i].type == AREA_SUNSITE)
      list.add_sys("areatype", "sunsite");
    else if(area[i].type == AREA_UNIX)
      list.add_sys("areatype", "unix");

    area_read = -1;
  break;
  
  default:
  break;
  } 
}

void variable::sync_string()
{
  int t;
  char *tmp;
   
  switch(magic) {  
  case V_USER:
  case V_TOUSER:
     tmp = format_user(s);
     delete s;
     s = new char [strlen(tmp) + 1];
     strcpy(s, tmp);
  break;

  case V_NICK:
    if(strlen(s) > 16)
      s[16] = 0; 
    for(t = 0;t < strlen(s);t++) 
      if(s[t] == ' ')
        s[t] = '_';
  break;
     
  case V_YESKEY:
    yes_key = tolower(*s);
  break;
     
  case V_NOKEY:
    no_key = tolower(*s);
  break;
     
  case V_MARKKEY:
    mark_key = tolower(*s);
  break;
  
  case V_QUITKEY:
    quit_key = tolower(*s);
  break;
     
  case V_CONTKEY:
    cont_key = tolower(*s);   
  break;

  case V_PROTOCOL:
    for(t = 0;t < protocols;t++)
      if(!strcmp(protocol[t].name, s)) {
	protocol_num = t; 
	break;
      }
  break;

  case V_AREATAG:
    for(t = 0;t < areas;t++) {
      if(!strcmp(area[t].tag, s)) {  
        list.add_sys("areanum", t);
	areanum = t;
	break;
      }
    }
  break;
     
/* It seemed like a good idea at the time...
  case V_PASSWD:
    tmp = new char[14];
    strcpy(tmp, crypt(s, "BB"));
    delete s;
    s = tmp;
  break;
*/

  case V_FILESORT:
    sort_changed = 1; // File areas will be resorted if filesort is 
  break;              // set to the same value. Oh, well.	
       
  default:
  break;
  }
}

varlist::varlist()
{
  base = NULL;
  count = 0;
}

variable *varlist::add_sys(char *name, char *string)
{
  variable *tmp;
  tmp = add(name, string);
  tmp -> save = 0;
  return tmp;
}

variable *varlist::add_sys(char *name, int n)
{
  variable *tmp;
  tmp = add(name, n);
  tmp -> save = 0;
  return tmp;
}

variable *varlist::add(char *name, char *string)
{
  variable *tmp = base, *link;
  int cmp;

  if(count == 0) {
    base = new variable(name, string);
    count = 1;
    return base;
  }

  count++;

  for(;;) {
    cmp = strcmp(tmp -> name, name);
    if(cmp == 0) {
      *tmp = string;  
      return tmp;
    }

    link = cmp < 0 ? tmp -> left : tmp -> right;
    if(!link)
      break;

    tmp = link;
  }

  if(cmp < 0)
    return tmp -> left = new variable(name, string);
  else
    return tmp -> right = new variable(name, string);
}

variable *varlist::add(char *name, int num)
{
  variable *tmp = base, *link;
  int cmp;

  if(count == 0) {
    base = new variable(name, num);
    count = 1;
    return base;
  }

  count++;

  for(;;) {
    cmp = strcmp(tmp -> name, name);
    if(cmp == 0) {
      *tmp = num;
      return tmp;
    }
    link = cmp < 0 ? tmp -> left : tmp -> right;
    if(!link)
      break;

    tmp = link;
  }

  if(cmp < 0)
    return tmp -> left = new variable(name, num);
  else
    return tmp -> right = new variable(name, num);
}

variable *varlist::operator[](char *name)
{
  variable *tmp = base, *link;
  int cmp;

  for(;;) {
    cmp = strcmp(tmp -> name, name);
    if(cmp == 0)
      return tmp;

    link = cmp < 0 ? tmp -> left : tmp -> right;
    if(!link)
      return NULL;

    tmp = link;
  }

}

varlist::~varlist()
{
  delete base;
}
