#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "tokens.h"

char token[1024];

inline int isop(char c)
{
  return c == '<' || c == '>' || c == '=' || c == '!';
}

inline int istext(char c)
{
  return (isgraph(c) && !isop(c));  
}

int read_token(FILE *f)
{
  int c, type, tl = 0;
   
  do {
    c = fgetc(f);
    if(c == EOF) 
      return TOKEN_EOF;
    if(c == '\n')
      return TOKEN_EOL;
  } while (isspace(c));
   
  if(isdigit(c))
    type = TOKEN_NUM;
  else if(c == '\"')
    type = TOKEN_STRING;
  else if(c == '#')
    type = TOKEN_COMMENT;
  else if(c == '[')
    type = TOKEN_LABEL;
  else if(isop(c))
    type = TOKEN_OPERATOR;
  else
    type = TOKEN_TEXT;
   
  if(type != TOKEN_STRING && type != TOKEN_LABEL)
    token[tl++] = c;
   
  switch(type) {
    case TOKEN_NUM:
      do {
	c = fgetc(f);
	token[tl++] = c;
      } while(istext(c));
      ungetc(c, f);
      token[--tl] = 0;
    break;
     
    case TOKEN_STRING:
      do {
	c = fgetc(f);
        token[tl++] = c;
      } while(c != '\"' && c != '\n' && c != EOF);
      token[--tl] = 0;
    break; 
     
    case TOKEN_TEXT:
      do {
        c = fgetc(f);
        token[tl++] = c;
      } while(istext(c));
      token[--tl] = 0;
      ungetc(c, f);
    break;

    case TOKEN_LABEL:
      do {
	c = fgetc(f);
	token[tl++] = c;
      } while(c != ']' && c != EOF);
      token[--tl] = 0;
    break;

    case TOKEN_OPERATOR:
      do { 
        c = fgetc(f);
	token[tl++] = c;
      } while(isop(c));
      ungetc(c, f);
      token[--tl] = 0;
    break;
     
    case TOKEN_COMMENT:
      skip_line(f);
    break;
  };
//fprintf(stderr, "[%s]", token);

  if(type == TOKEN_STRING)
    type = TOKEN_TEXT;
  return type;
}

int read_word(FILE *f)
{
  int t = 0, c;
   
  do {
    c = fgetc(f);
    if(c == EOF) 
      return TOKEN_EOF;
    if(c == '\n')
      return TOKEN_EOL;
  } while (isspace(c));

  token[t++] = c;
   
  do {
    c = fgetc(f);
    token[t++] = c;
  } while(!isspace(c));
  
  token[t - 1] = 0;
  return 0;
}

void skip_line(FILE *f)
{
  int c;
   
  do {
    c = fgetc(f);
  } while(c != '\n' && c != EOF); 
}

int read_line(FILE *f)
{
  int type;
   
  do {  
    type = read_token(f);
  } while(type == TOKEN_COMMENT || type == TOKEN_EOL);

  return type;
}
