#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

static char *lock = NULL;
int locked = 0;

static char *lockfile(char *file)
{   
  int t;
   
  if(lock)
    free(lock);
  
  lock = (char *)malloc(strlen(file) + 10);
  sprintf(lock, "lock/%s", file);

  for(t = 5;t < strlen(lock);t++)
    if(lock[t] == '/')
      lock[t] = '_';

  return lock;
}

int bb_lock(char *file)
{
  int ret;
  char *tmp;
   
  tmp = lockfile(file);
   
  for(;;) {
    ret = open(tmp, O_RDWR | O_CREAT | O_EXCL, 0660);
    if(ret != -1)
      break;
     
    if(errno != EEXIST)
      return 1;
     
    usleep(100 * 1000);
  }
   
  locked = 1;
  close(ret); 
  return 0;
}

void bb_unlock()
{
  unlink(lock);
  locked = 0;
}

void kill_locks()
{
  if(locked)
    bb_unlock();
}

