#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QUdpSocket>
#include <QSystemTrayIcon>
#include <QSettings>

namespace Ui {
class MainWindow;
}

class PortDialog;
class CocoaInitializer;
class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow( QWidget *parent = 0);
    ~MainWindow();
    void setPort(quint16 p);
    void setUnseenNotifications(int i);
private slots:
    void on_actionListen_toggled(bool arg1);
    void processReadyRead();
    void iconActivated(QSystemTrayIcon::ActivationReason reason);
    void on_actionChoose_Port_triggered();
    void on_actionQuit_triggered();
#ifdef Q_OS_MAC
    void onSetupDockEventMonitor();

signals:
    void setupDockEventMonitor();
#endif

protected:
    void closeEvent(QCloseEvent *event);

private:
    Ui::MainWindow *ui;
    quint16 port;
    QUdpSocket *udpsocket;
    void receiveLog();
    bool listening = false;
    PortDialog *pdialog;
    void addItem(QString item);
    void createTrayIcon();
    QSystemTrayIcon *sysTrayIcon;
    QSettings *settings;
    CocoaInitializer *initializer;
    int unseenNotifications;
};

#endif // MAINWINDOW_H
