/* terminal.h - header file for terminal handling routines
 *
 * $Id: terminal.h,v 1.1.1.1 1999/12/02 20:03:07 ivarch Exp $
 */

#ifndef _MC_TERMINAL_H
#define _MC_TERMINAL_H

#define KEY_NONE	-1		/* no key pressed */
#define KEY_UNKNOWN	-2		/* unknown key */
#define KEY_DOWN        0402            /* Down-arrow */
#define KEY_UP          0403		/* Up-arrow */
#define KEY_LEFT        0404		/* Left-arrow */
#define KEY_RIGHT       0405            /* Right-arrow */
#define KEY_HOME        0406            /* Home key (upward+left arrow) */
#define KEY_DC          0512            /* Delete character */
#define KEY_NPAGE       0522            /* Next page */
#define KEY_PPAGE       0523            /* Previous page */
#define KEY_END		0550		/* End */

extern int t_rows;			/* number of rows terminal has */
extern int t_cols;			/* number of columns terminal has */
extern char t_clearscreen;		/* clear-screen-now flag */
extern char t_quit_input;		/* quit-input-now flag */


void t_abswrite (char *);		/* write string direct to screen */
void t_bored (int);			/* display boredom character */
void t_canon_off (void);		/* canonical input mode off */
void t_canon_on (void);			/* canonical input mode on */
void t_centre (char *);			/* centre a line of text */
void t_clear (void);			/* clear the screen */
void t_clrtoeol (void);			/* clear to end of line */
void t_echo_off (void);			/* local echo off */
void t_echo_on (void);			/* local echo on */
int  t_getch (void);			/* read character */
int  t_getchar (int);			/* read character with timeout */
void t_goto (int, int);			/* go to (x,y) */
int  t_init (char *);			/* initialise terminal */
int  t_input (char *, char *, int);	/* read a line of input */
void t_lineout (char *, int);		/* output a line */
void t_scrollup (void);			/* scroll screen up one line */
void t_write (char *);			/* write string */

void t_sighandler (void);		/* install SIGWINCH handler */
void t_checksize (void);		/* check terminal hasn't resized */

void t_outattr (int);			/* (internal) do attribute expansion */

#endif	/* _MC_TERMINAL_H */

/* EOF */
