/* mstring.h - BBS attribute string functions
 *
 *   mstripattr - strip attributes from string
 *   mstrlen    - return number of printable characters in string
 *   mstrindex  - return index of "n"th printable character in string
 *   mstrtol    - convert 8-digit hexadecimal string to a long integer
 *   mnexttrib  - return index of next attribute character, or -1 if none
 *   mtribval   - return value of trib, and change index to char just after
 *   mstrdelete - remove a chunk of a string
 *   mstrinsert - insert into a string
 *   mstripbs   - strip backspaces from string
 *   mstrncat   - safely append a string to another string
 *   mstrtoansi - convert attributes in string to ANSI colour codes
 *   mtagexpand - expand a special tag line if necessary
 *   mstrsince  - return a string describing elapsed time
 *   mstrtoansi_colours - switch colour processing on or off
 *
 * $Id: mstring.h,v 1.4 2001/10/22 13:25:23 ivarch Exp $
 */

#ifndef _MT_MSTRING_H
#define _MT_MSTRING_H

#define miscntl(c) ((c==26)||(c==27)||(c==28)||(c==29)||(c==30)||(c==31))

#define MTR_INVALID		0		/* invalid attribute */
#define MTR_BOLD		0x0010		/* bold on */
#define MTR_UNDERLINE		0x0020		/* underline on */
#define MTR_STANDOUT		0x0040		/* standout on */
#define MTR_REVERSE		0x0080		/* reverse on */
#define MTR_FLASH		0x0100		/* flash on */

#define MTR_BOLD_OFF		0x0200		/* bold off */
#define MTR_UNDERLINE_OFF	0x0400		/* underline off */
#define MTR_STANDOUT_OFF	0x0800		/* standout off */
#define MTR_REVERSE_OFF		0x1000		/* reverse off */
#define MTR_FLASH_OFF		0x2000		/* flash off */

#define MTR_ALL_OFF		0x3F00		/* all attributes off */

#define MTR_FORE_COLOUR		0x4000		/* set foreground colour */
#define MTR_BACK_COLOUR		0x8000		/* set background colour */

#define MTR_COLOUR_MASK		0x000F		/* colour extraction mask */

#define MTR_COL_DEFAULT		9		/* default */
#define MTR_COL_BLACK		0		/* black */
#define MTR_COL_RED		1		/* red */
#define MTR_COL_GREEN		2		/* green */
#define MTR_COL_YELLOW		3		/* yellow */
#define MTR_COL_BLUE		4		/* blue */
#define MTR_COL_MAGENTA		5		/* magenta */
#define MTR_COL_CYAN		6		/* cyan */
#define MTR_COL_WHITE		7		/* white */


void mstripattr (char *);
int  mstrlen (char *);
int  mstrindex (char *, int);
long mstrtol (char *);
int  mnexttrib (char *, int);
long mtribval (char *, int *);
void mstrdelete (char *, int, int);
void mstrinsert (char *, char *, int *, long);
void mstripbs (char *);
int  mstrncat (char *, char *, int *);
void mstrtoansi (char *, long);
void mtagexpand (char *, long, int, int, int);
char * mstrsince (long);
void mstrtoansi_colours (int);

#endif	/* _MT_MSTRING_H */

/* EOF */
