/* action.c - take action on menu item selection
 *
 * $Id: action.c,v 1.3 2001/11/13 10:23:52 ivarch Exp $
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif	/* HAVE_CONFIG_H */
#include <stdlib.h>
#include <string.h>
#include "hook.h"
#include "mstring.h"
#include "terminal.h"
#include "viewmenu.h"
#include "viewfile.h"


/* Perform the action in menu entry "e".
 */
void menuview_action (menudata_t data, menuentry_t * e) {
  char a[2];

  menuview_wipe_footer (data);
  strncpy (data->buf, (e->title) ? e->title : "", 1000);
  if (mstrlen (data->buf) >= t_cols) {
    data->buf[mstrindex (data->buf, t_cols - 1)] = 0;
  }
  t_goto ((t_cols - mstrlen (data->buf)) / 2, t_rows - 1);
  t_write (data->buf);
  t_write ("\035a\035CA\035Ca");

  strcpy (data->buf, data->keypath);
  a[0] = e->key;
  a[1] = 0;
  strcat (data->buf, a);

  if (e->viewfile) {
    if (e->viewalways) {
      if (e->status & MENU_STATUS_HIDETITLE) {
        if (menuview_viewalways (data, e->viewfile, "")) return;
      } else {
        if (menuview_viewalways (data, e->viewfile, e->title)) return;
      }
    } else {
      if (e->status & MENU_STATUS_HIDETITLE) {
        if (menuview_viewfile (data, e->viewfile, "")) return;
      } else {
        if (menuview_viewfile (data, e->viewfile, e->title)) return;
      }
    }
  }

  if (e->status & MENU_STATUS_XRATED) {
    if (bbs_hook (HOOK_XRATED_ITEM, data, e)) return;
  }

  if (e->logfile) bbs_hook (HOOK_LOG_ACTION, data, e);

  bbs_hook (HOOK_SET_KEYPATH, data->buf, 0);
  setenv ("MONO_KEYPATH", data->buf, 1);

  setenv ("MCONV_USER", current_user, 1);
  setenv ("MVIEW_USER", current_user, 1);
  setenv ("MONO_ACCOUNT", current_user, 1);
  setenv ("ACCOUNT", current_user, 1);

  switch (e->type) {
    case MENU_ENTRY_MENU:			/* M - menu */
      read_menu (e->filename, data->ldbfile,
                 data->buf, e->title, MENUFLAG_SUB
                 | ((e->status & MENU_STATUS_HIDETITLE) ?
                    MENUFLAG_HIDETITLE : 0)
                );
      break;
    case MENU_ENTRY_COMMENTFILE:		/* C - comment file */
    case MENU_ENTRY_FORMATTED:			/* F - formatted file */
    case MENU_ENTRY_READONLY:			/* R - readonly file */
    case MENU_ENTRY_UNFORMATTED:		/* U - unformatted file */
    case MENU_ENTRY_VTANSI:			/* V - VT/ANSI file */
      menuview_read (data, e);
      break;
    case MENU_ENTRY_EXECUTABLE:			/* X - executable */
      t_goto (0, t_rows - 1);
      menuview_execute (data, e);
      break;
    case MENU_ENTRY_SPOOLED:			/* S - spooled output */
      menuview_spooled (data, e);
      break;
    case MENU_ENTRY_TELNET:			/* T - telnet connection */
      t_goto (0, t_rows - 1);
      menuview_telnet (data, e);
      break;
    case MENU_ENTRY_ANIMATION:			/* A - animation */
      menuview_animation (data, e);
      break;
    case MENU_ENTRY_BINARY:			/* B - binary file */
      bbs_hook (HOOK_MENU_BIN, data, e);
      break;
    case MENU_ENTRY_LISTED:			/* L - listed directory */
      menuview_listed_status = e->status;
      read_menu (e->filename, data->ldbfile,
                 data->buf, e->title, MENUFLAG_SUB | MENUFLAG_LISTED
                 | ((e->status & MENU_STATUS_HIDETITLE) ?
                    MENUFLAG_HIDETITLE : 0)
                );
      break;
    default:
      bbs_hook (HOOK_MENU_ACTION, data, e);
      break;
  }

  bbs_hook (HOOK_SET_KEYPATH, data->keypath, 0);
  setenv ("MONO_KEYPATH", data->keypath, 1);
}

/* EOF */
