/* size.c - terminal resizing function
 *
 * $Id: size.c,v 1.1.1.1 1999/12/02 20:01:17 ivarch Exp $
 */

#include <stdlib.h>
#include "Internal.h"


/* Resize terminal "vt" to "cols" columns by "rows" rows. On failure, returns
 * nonzero and attempts to restore the original state of "vt".
 *
 * Note that the terminal is not reinitialised, so if the screen is made
 * larger it will almost certainly contain some garbage. Also, if the number
 * of columns is changed, the location of text from line 2 downwards will
 * change.
 */
int vt100_resize (vt_info vt, int cols, int rows) {
  unsigned char * newtext;
  unsigned short * newattrs;

  if (!vt) return (1);
  if ((rows < 1) || (cols < 1)) return (1);

  newtext = realloc (vt->text, rows * cols);
  if (!newtext) return (1);
  vt->text = newtext;

  newattrs = realloc (vt->attrs, rows * cols * sizeof (unsigned short));
  if (!newattrs) {
    newtext = realloc (vt->text, vt->rows * vt->cols);
    if (newtext) vt->text = newtext;
    return (1);
  }
  vt->attrs = newattrs;

  if (vt->x > cols) vt->x = cols;
  if (vt->y > rows) vt->y = rows;

  vt->rows = rows;
  vt->cols = cols;

  return (0);
}

/* EOF */
