/* process.c - process a stream of data.
 *
 * $Id: process.c,v 1.2 2000/08/08 15:50:21 ivarch Exp $
 */

#include <stdio.h>
#include "actions.h"


/* Process a stream of data "fptr", converting from type "in" to type "out";
 * the guest flag is "g" (for menu code), if "a" is set the anonymity flag is
 * set (for BBS attribute file), "w" is the screen width, and "h" is
 * the screen height.
 *
 * Returns nonzero on error; the error is not reported.
 */
int process_stream (FILE * fptr, char * file, char * ldbfile, int in, int out, char g, char a, int w, int h) {
  switch (in) {
    case MT_INPUT_ANSI : return (mtrib_ansi (fptr, w, h));
    case MT_INPUT_FILE : return (mtrib_file (fptr, out, a, w));
    case MT_INPUT_MENU : return (mtrib_menu (fptr, file, ldbfile, out, g, w));
    case MT_INPUT_UNBUF: return (mtrib_stream (fptr, out, w));
    default: return (1);
  }
}

/* EOF */
