/* goto.c - deal with absolute cursor positioning
 *
 * $Id: goto.c,v 1.1.1.1 1999/12/02 20:00:29 ivarch Exp $
 */

#include <stdio.h>
#include "vt100.h"


/* Deal with absolute cursor positioning by sending enough blank lines to
 * stdout to simulate moving down the relevant number of rows.
 */
void mtrib_ansi_goto (vt_info vt) {
  int x, y, new_x, new_y, rows, cols;

  vt100_get_pos (vt, &x, &y);
  vt100_get_newpos (vt, &new_x, &new_y);
  vt100_get_size (vt, &rows, &cols);

  if (new_y > rows) new_y = rows;

  for (; y < new_y; y ++) printf ("\n");
}

/* EOF */
