/* deliver.c - deliver a message
 *
 * $Id: deliver.c,v 1.4 2001/11/02 15:37:04 ivarch Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <pwd.h>
#include "lock.h"
#include "bbs.h"
#include "u2u.h"

#ifndef O_SYNC	/* FreeBSD kludge */
#ifdef O_FSYNC
#define O_SYNC O_FSYNC
#endif
#endif	/* O_SYNC */

extern time_t u2u__last_checked;

int log_truncate (int, int, long, long, int);


/* Deliver a message to "recipients".
 */
void u2u_deliver (char * recipients) {
  char * orig_recips;
  struct passwd * z;
  char * nameline;
  char tbuf[256];
  char buf[1024];
  char fbuf[1024];
  struct tm * p;
  char * user;
  FILE * fptr = NULL;
  FILE * iptr;
  char * a;
  char * x;
  time_t t;
  int fd, n, i;

  orig_recips = recipients;

  strcpy (buf, current_user);
  strcat (buf, " ");
  strcat (buf, recipients);

  recipients = strdup (buf);			/* make a copy of the string */

  t = time (0);
  p = gmtime (&t);
  strftime (tbuf, sizeof (tbuf) - 1, "%a %b %d %H:%M:%S %Y", p);

  nameline = getenv ("MVIEW_NAMELINE");

  if (!nameline) {
    z = getpwuid (getuid ());
    if (z) nameline = z->pw_gecos;
    if (nameline) {
      a = strchr (nameline, ',');
      if (a) a[0] = 0;
    }
  }

  user = " ";
  x = recipients;

  while (user) {

    if (!strcmp (user, " ")) {			/* deliver to log file */
      strcpy (fbuf, cf_str ("u2ulog"));
      fd = open (fbuf, O_CREAT | O_SYNC | O_RDWR);
    } else {					/* deliver to a user */
      sprintf (fbuf, "%s/%s", cf_str ("u2u"), user);
      fd = open (fbuf, O_SYNC | O_RDWR);
    }

    if (fd >= 0) {
      fchmod (fd, S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP);
      fptr = fdopen (fd, "a");
    }

    if ((fd < 0) || (!fptr)) {
      if (fd >= 0) close (fd);
      user = strtok (x, " ");
      x = 0;
      continue;
    }

    my_flock (fbuf, fd, LOCK_EX);

    fseek (fptr, 0, SEEK_END);

    fprintf (fptr, "Message: %08lX             (%s)\n"
                   "From: %s (%s)\n"
                   "To: %s\n"
                   "\n",
                   t, tbuf, nameline, current_user, orig_recips);

    fflush (fptr);

    iptr = fopen (u2u_create_file (orig_recips), "r");

    i = 0;
    while ((iptr) && !feof (iptr) && !ferror (iptr)) {
      buf[0] = 0;
      fgets (buf, sizeof (buf) - 1, iptr);
      a = strchr (buf, '\n');
      if (a) *a = 0;

      n = 0;
      while ((buf[n] == ' ') || (buf[n] == 9)) n ++;

      if (buf[n] == 0) {		/* strip trailing blank lines */
        i ++;
      } else {
        for ( ; i > 0; i --) fprintf (fptr, "\n");
        if (isupper (buf[0])) {		/* prefix Blah: with ]a */
          n = 1;
          while (islower (buf[n])) n ++;
          if (buf[n] == ':') {
            if (strncmp (buf, "Subject:", 8) != 0) fprintf (fptr, "\035a");
          }
        }
        fprintf (fptr, "%s\n", buf);
        fflush (fptr);
      }
    }

    if (iptr) fclose (iptr);

    fprintf (fptr, "\n");		/* always end with a blank line */
    fflush (fptr);
    fclose (fptr);

    if (!strcmp (user, " ")) {			/* delivering to log file */
      log_truncate (fd, -1, cf_int ("u2ulgsz") * 1024,
                            cf_int ("u2ulgsz") * 100, 1);
    }

    fsync (fd);
    my_flock (fbuf, fd, LOCK_UN);
    close (fd);

    user = strtok (x, " ");
    x = 0;
  }

  free (recipients);

  u2u__last_checked = time (0) + 1;
}

/* EOF */
