#
# Rules for all phony targets.
#
# $Id: unreal.mk,v 1.9 2001/11/13 16:56:06 ivarch Exp $

.PHONY: all dep depend depclean make check clean distclean dist doc index install uninstall install-bbs
all: $(alltarg)

make:
	echo > $(srcdir)/autoconf/make/filelist.mk
	echo > $(srcdir)/autoconf/make/modules.mk
	cd $(srcdir); sh autoconf/scripts/makemake.sh autoconf/make/filelist.mk autoconf/make/modules.mk
	sh ./config.status
	
dep depend: $(alldep)
	echo '#' > $(srcdir)/autoconf/make/depend.mk
	echo '# Dependencies.' >> $(srcdir)/autoconf/make/depend.mk
	echo '#' >> $(srcdir)/autoconf/make/depend.mk
	echo >> $(srcdir)/autoconf/make/depend.mk
	cat $(alldep) >> $(srcdir)/autoconf/make/depend.mk
	sh ./config.status

clean:
	rm -f $(allobj)

depclean:
	rm -f $(alldep)

distclean: clean depclean
	rm -f $(alltarg) src/include/config.h
	rm -rf $(package)-$(version).tar* $(package)-$(version)
	rm -f *.html config.*
	rm Makefile

doc: $(srcdir)/doc/mconv.info $(srcdir)/doc/mconv.html

dist: doc
	rm -rf $(package)-$(version)
	mkdir $(package)-$(version)
	cp -dprf Makefile $(distfiles) $(package)-$(version)
	cd $(package)-$(version); $(MAKE) distclean
	chmod 644 `find $(package)-$(version) -type f -print`
	chmod 755 `find $(package)-$(version) -type d -print`
	chmod 755 `find $(package)-$(version)/autoconf/scripts`
	chmod 755 $(package)-$(version)/configure
	rm -rf DUMMY `find $(package)-$(version) -type d -name CVS`
	tar cf $(package)-$(version).tar $(package)-$(version)
	rm -rf $(package)-$(version)
	$(DO_GZIP) $(package)-$(version).tar

index:
	perl $(srcdir)/autoconf/scripts/index.pl $(srcdir)/src

check:
	./mview -m $(srcdir)/.index.mn

install: all doc
	test -z "$(RPM_BUILD_ROOT)" && sh $(srcdir)/autoconf/scripts/group.sh @GROUP@ || true
	$(INSTALL) -m 755 mconv  "$(RPM_BUILD_ROOT)/$(bindir)/mconv"
	$(INSTALL) -m 755 mview  "$(RPM_BUILD_ROOT)/$(bindir)/mview"
	$(INSTALL) -m 755 mtrunc "$(RPM_BUILD_ROOT)/$(bindir)/mtrunc"
	$(INSTALL) -m 755 mtime  "$(RPM_BUILD_ROOT)/$(bindir)/mtime"
	$(INSTALL) -m 755 mte    "$(RPM_BUILD_ROOT)/$(bindir)/mte"
	test -n "$(RPM_BUILD_ROOT)" || $(INSTALL) -g @GROUP@ -m 2755 mbbs "$(bindir)/mbbs"
	test -n "$(RPM_BUILD_ROOT)" || $(INSTALL) -g @GROUP@ -m 2755 mgid "$(bindir)/mgid"
	test -z "$(RPM_BUILD_ROOT)" || $(INSTALL) -m 755 mbbs "$(RPM_BUILD_ROOT)/$(bindir)/mbbs"
	test -z "$(RPM_BUILD_ROOT)" || $(INSTALL) -m 755 mgid "$(RPM_BUILD_ROOT)/$(bindir)/mgid"
	$(INSTALL) -m 644 $(srcdir)/doc/mconv.1    "$(RPM_BUILD_ROOT)/$(mandir)/man1/mconv.1"
	$(INSTALL) -m 644 $(srcdir)/doc/mview.1    "$(RPM_BUILD_ROOT)/$(mandir)/man1/mview.1"
	$(INSTALL) -m 644 $(srcdir)/doc/mbbs.1     "$(RPM_BUILD_ROOT)/$(mandir)/man1/mbbs.1"
	$(INSTALL) -m 644 $(srcdir)/doc/mgid.1     "$(RPM_BUILD_ROOT)/$(mandir)/man1/mgid.1"
	$(INSTALL) -m 644 $(srcdir)/doc/mtime.1    "$(RPM_BUILD_ROOT)/$(mandir)/man1/mtime.1"
	$(INSTALL) -m 644 $(srcdir)/doc/mtrunc.1   "$(RPM_BUILD_ROOT)/$(mandir)/man1/mtrunc.1"
	$(INSTALL) -m 644 $(srcdir)/doc/mte.1      "$(RPM_BUILD_ROOT)/$(mandir)/man1/mte.1"
	$(INSTALL) -m 644 $(srcdir)/doc/mconv.info "$(RPM_BUILD_ROOT)/$(infodir)/mconv.info"
	$(DO_GZIP) "$(RPM_BUILD_ROOT)/$(mandir)/man1/mconv.1"  || true
	$(DO_GZIP) "$(RPM_BUILD_ROOT)/$(mandir)/man1/mview.1"  || true
	$(DO_GZIP) "$(RPM_BUILD_ROOT)/$(mandir)/man1/mbbs.1"   || true
	$(DO_GZIP) "$(RPM_BUILD_ROOT)/$(mandir)/man1/mgid.1"   || true
	$(DO_GZIP) "$(RPM_BUILD_ROOT)/$(mandir)/man1/mtime.1"  || true
	$(DO_GZIP) "$(RPM_BUILD_ROOT)/$(mandir)/man1/mtrunc.1" || true
	$(DO_GZIP) "$(RPM_BUILD_ROOT)/$(mandir)/man1/mte.1"    || true
	$(DO_GZIP) "$(RPM_BUILD_ROOT)/$(infodir)/mconv.info"   || true
	test -e "$(RPM_BUILD_ROOT)/$(etcdir)/bbsrc" \
	  || sed "s,/usr/share/mconv,$(datadir)/mconv," < "$(srcdir)/extra/bbsrc" \
	  >> "$(RPM_BUILD_ROOT)/$(etcdir)/bbsrc"
	chmod 640 "$(RPM_BUILD_ROOT)/$(etcdir)/bbsrc"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(etcdir)/bbsrc"
	@echo
	@echo "You can now do 'make install-bbs' to install the BBS files."
	@echo "This will install the BBS files under $(datadir)/mconv."
	@echo

uninstall:
	$(UNINSTALL) "$(RPM_BUILD_ROOT)/$(bindir)/mconv"
	$(UNINSTALL) "$(RPM_BUILD_ROOT)/$(bindir)/mview"
	$(UNINSTALL) "$(RPM_BUILD_ROOT)/$(bindir)/mbbs"
	$(UNINSTALL) "$(RPM_BUILD_ROOT)/$(bindir)/mgid"
	$(UNINSTALL) "$(RPM_BUILD_ROOT)/$(bindir)/mtrunc"
	$(UNINSTALL) "$(RPM_BUILD_ROOT)/$(bindir)/mtime"
	$(UNINSTALL) "$(RPM_BUILD_ROOT)/$(bindir)/mte"
	$(UNINSTALL) "$(RPM_BUILD_ROOT)/$(mandir)/man1/mconv.1"
	$(UNINSTALL) "$(RPM_BUILD_ROOT)/$(mandir)/man1/mview.1"
	$(UNINSTALL) "$(RPM_BUILD_ROOT)/$(mandir)/man1/mbbs.1"
	$(UNINSTALL) "$(RPM_BUILD_ROOT)/$(mandir)/man1/mgid.1"
	$(UNINSTALL) "$(RPM_BUILD_ROOT)/$(mandir)/man1/mtime.1"
	$(UNINSTALL) "$(RPM_BUILD_ROOT)/$(mandir)/man1/mtrunc.1"
	$(UNINSTALL) "$(RPM_BUILD_ROOT)/$(mandir)/man1/mte.1"
	$(UNINSTALL) "$(RPM_BUILD_ROOT)/$(infodir)/mconv.info"
	$(UNINSTALL) "$(RPM_BUILD_ROOT)/$(mandir)/man1/mconv.1.gz"
	$(UNINSTALL) "$(RPM_BUILD_ROOT)/$(mandir)/man1/mview.1.gz"
	$(UNINSTALL) "$(RPM_BUILD_ROOT)/$(mandir)/man1/mbbs.1.gz"
	$(UNINSTALL) "$(RPM_BUILD_ROOT)/$(mandir)/man1/mgid.1.gz"
	$(UNINSTALL) "$(RPM_BUILD_ROOT)/$(mandir)/man1/mtime.1.gz"
	$(UNINSTALL) "$(RPM_BUILD_ROOT)/$(mandir)/man1/mtrunc.1.gz"
	$(UNINSTALL) "$(RPM_BUILD_ROOT)/$(mandir)/man1/mte.1.gz"
	$(UNINSTALL) "$(RPM_BUILD_ROOT)/$(infodir)/mconv.info.gz"

install-bbs:
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv" \
	  || mkdir "$(RPM_BUILD_ROOT)/$(datadir)/mconv"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys" \
	  || mkdir "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/listdirs" \
	  || mkdir "$(RPM_BUILD_ROOT)/$(datadir)/mconv/listdirs"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/udb" \
	  || mkdir "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/udb"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/ldb" \
	  || mkdir "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/ldb"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log" \
	  || mkdir "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/list" \
	  || mkdir "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/list"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/status" \
	  || mkdir "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/status"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/u2u" \
	  || mkdir "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/u2u"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/friends" \
	  || mkdir "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/friends"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/help" \
	  || mkdir "$(RPM_BUILD_ROOT)/$(datadir)/mconv/help"
	chmod 755 "$(RPM_BUILD_ROOT)/$(datadir)/mconv"
	chmod 750 "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys"
	chmod 750 "$(RPM_BUILD_ROOT)/$(datadir)/mconv/listdirs"
	chmod 770 "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/udb"
	chmod 770 "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/ldb"
	chmod 750 "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log"
	chmod 750 "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/list"
	chmod 770 "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/status"
	chmod 770 "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/u2u"
	chmod 770 "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/friends"
	chmod 750 "$(RPM_BUILD_ROOT)/$(datadir)/mconv/help"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log/add.log" \
	  || touch "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log/add.log"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log/del.log" \
	  || touch "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log/del.log"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log/edit.log" \
	  || touch "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log/edit.log"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log/mail.log" \
	  || touch "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log/mail.log"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log/run.log" \
	  || touch "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log/run.log"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log/client.log" \
	  || touch "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log/client.log"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log/u2u.log" \
	  || touch "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log/u2u.log"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/paths" \
	  || touch "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/paths"
	chmod 660 "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log/add.log"
	chmod 660 "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log/del.log"
	chmod 660 "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log/edit.log"
	chmod 660 "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log/mail.log"
	chmod 660 "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log/run.log"
	chmod 660 "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log/client.log"
	chmod 660 "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log/u2u.log"
	chmod 640 "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/paths"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/index.mn" \
	  || $(INSTALL) -m 640 $(srcdir)/extra/mainmenu.mn \
	                "$(RPM_BUILD_ROOT)/$(datadir)/mconv/index.mn"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/motd.cm" \
	  || $(INSTALL) -m 640 $(srcdir)/extra/motd.cm \
	                "$(RPM_BUILD_ROOT)/$(datadir)/mconv/motd.cm"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log/index.mn" \
	  || $(INSTALL) -m 640 $(srcdir)/extra/logmenu.mn \
	                "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/log/index.mn"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/list/admin" \
	  || $(INSTALL) -m 640 $(srcdir)/extra/adminlist \
	                "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/list/admin"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/udb/guest" \
	  || $(INSTALL) -m 660 $(srcdir)/extra/guestudb \
	                "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/udb/guest"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/xwarn.ro" \
	  || $(INSTALL) -m 640 $(srcdir)/extra/xwarn.ro \
	                "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/xwarn.ro"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/options.mn" \
	  || $(INSTALL) -m 640 $(srcdir)/extra/options.mn \
	                "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/options.mn"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/escape.mn" \
	  || $(INSTALL) -m 640 $(srcdir)/extra/escape.mn \
	                "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/escape.mn"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/help/help.mn" \
	  || $(INSTALL) -m 640 $(srcdir)/extra/help/*.* \
	                "$(RPM_BUILD_ROOT)/$(datadir)/mconv/help/"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/sys"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/listdirs"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/sys/udb"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/sys/ldb"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/sys/log"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/sys/list"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/sys/status"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/sys/u2u"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/sys/friends"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/help"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/index.mn"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/motd.cm"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/sys/log/index.mn"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/sys/list/admin"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/sys/udb/guest"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/sys/xwarn.ro"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/sys/options.mn"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/sys/escape.mn"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/sys/log/add.log"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/sys/log/del.log"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/sys/log/edit.log"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/sys/log/mail.log"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/sys/log/run.log"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/sys/log/client.log"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/sys/log/u2u.log"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/sys/paths"
	test -n "$(RPM_BUILD_ROOT)" || chgrp @GROUP@ "$(datadir)/mconv/help/"*
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/ldb/guest" \
	  || ln -s /dev/null "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/ldb/guest"
	test -e "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/friends/guest" \
	  || ln -s /dev/null "$(RPM_BUILD_ROOT)/$(datadir)/mconv/sys/friends/guest"
