import time
import os
import traceback
import string
from Utils import *

DefaultTimeout = 300

# Characters deleted from standard readline() text prompts:
BadChars = {}
for Ord in range(32):
    if Ord != 10 and Ord != 13:
        BadChars[chr(Ord)] = 1
for Ord in range(128, 256):
    BadChars[chr(Ord)] = 1

class TimeoutError:
    pass

Escape = chr(27)

class ANSI:
    # Foreground:
    Red = Escape + "[0;31m"
    BoldRed = Escape + "[1;31m"
    Green = Escape + "[0;32m"
    BoldGreen = Escape + "[1;32m"
    Yellow = Escape + "[0;33m"
    BoldYellow = Escape + "[1;33m"
    Blue = Escape + "[0;34m"
    BoldBlue = Escape + "[1;34m"
    Purple = Escape + "[0;35m"
    BoldPurple = Escape + "[1;35m"
    Cyan = Escape + "[0;36m"
    BoldCyan = Escape + "[1;36m"
    White = Escape + "[0;37m"
    BoldWhite = Escape + "[1;37m"
    Default = Escape + "[0;37m"
    # Background:
    BlackBack = Escape + "[40m"
    RedBack = Escape + "[41m"
    GreenBack = Escape + "[42m"
    YellowBack = Escape + "[43m"
    BlueBack = Escape + "[44m"
    PurpleBack = Escape + "[45m"
    CyanBack = Escape + "[46m"
    WhiteBack = Escape + "[47m"
    DefaultBack = Escape + "[40m"
    # Special:
    Reset = Escape + "[0m"
    BoldOn = Escape + "[1m"
    BoldOff = Escape + "[22m"



class Door:
    """
    A simple base class for creating BBS doors.  It works (hopefully) with telnet connections,
    as well as real live COM ports.  
    """
    # Color codes:
    NoANSITranslator ={"@@":"@",
                       }
    ANSITranslator = {"@w":ANSI.White,
                      "@r":ANSI.Red,
                      "@g":ANSI.Green,
                      "@y":ANSI.Yellow,
                      "@b":ANSI.Blue,
                      "@p":ANSI.Purple,
                      "@c":ANSI.Cyan,
                      "@W":ANSI.BoldWhite,
                      "@R":ANSI.BoldRed,
                      "@G":ANSI.BoldGreen,
                      "@Y":ANSI.BoldYellow,
                      "@B":ANSI.BoldBlue,
                      "@P":ANSI.BoldPurple,
                      "@C":ANSI.BoldCyan,
                      "@0":ANSI.Reset, # zero
                      }
                      
    def __init__(self, Session):
        self.Session = Session
        if self.Session:
            self.Socket = self.Session.request
            self.GetKey = self.GetKeySocket
            self.GetLine = self.GetLineSocket
            self.Send = self.SendSocket
        else:
            self.GetKey = self.GetKeyLocal
            self.GetLine = self.GetLineLocal
            self.Send = self.SendLocal
        self.KeepRunning = 1
        self.ClientText = ""
        if self.Session and self.Session.User and self.Session.User.ANSI:
            self.Translator = self.ANSITranslator
        else:
            self.Translator = self.NoANSITranslator
    def Write(self, Str):
        Str = self.FormatStr(Str)
        self.Send(Str)
    def FormatStr(self, Str):
        "Insert ANSI codes, if applicable, to a marked-up string"
        AtPos = Str.find("@")
        while AtPos!=-1:
            if AtPos == len(Str)-1:
                break
            Code = Str[AtPos:AtPos+2]
            Str = Str[:AtPos] + self.Translator.get(Code, "") + Str[AtPos+2:]
            AtPos = Str.find("@", AtPos + 1)
        return Str
            
    def GetKeyLocal(self, Echo = 1):
        Key = sys.stdin.read(1)
        return Key
    def GetKeySocket(self, Echo = 1, Timeout = DefaultTimeout):
        Start = time.clock()
        while 1:
            try:
                Text = self.Socket.recv(1)
                if Echo:
                    self.Socket.send(Text) # echo
                return Text
            except:
                time.sleep(0.1) # Don't crush the CPU liek bug.
                Elapsed = time.clock() - Start
                if Elapsed > Timeout:
                    raise TimeoutError
                    #return None
    def Run(self):
        "Main method - override this with your door's code"
        pass
    def Flush(self):
        self.ClientText = ""
    def GetLineLocal(self):
        return sys.stdin.readline()
    def GetLineSocket(self, Timeout = DefaultTimeout):
        "readline() method for our socket.  Handle backspacing, strip nasty characters"
        Start = time.clock()
        while 1:
            try:
                Text = self.Socket.recv(1024)
                for Char in Text:
                    if Char == 9: # backspace
                        self.ClientText = self.ClientText[:-1]
                        self.Socket.send(Char)
                    elif not BadChars.has_key(Char):
                        self.ClientText += Char
                        self.Socket.send(Char)
                #self.ClientText += Text
                #self.Socket.send(Text) # echo
            except:
                Text = ""
            if not Text:
                time.sleep(0.1) # Don't crush the CPU
                Elapsed = time.clock() - Start
                if Elapsed > Timeout:
                    raise TimeoutError
            Pos = self.ClientText.find("\r\n")
            if Pos!=-1:
                Line = self.ClientText[:Pos]
                self.ClientText = self.ClientText[Pos+2:]
                return Line
            Pos = self.ClientText.find("\n")
            if Pos!=-1:
                Line = self.ClientText[:Pos]
                self.ClientText = self.ClientText[Pos+1:]
                return Line
    def SendSocket(self, Text):
        if not Text:
            return
        self.Socket.send(Text)
    def SendLocal(self, Text):
        print Text,

        