"""
Dumple, an internet-capable door server.
"""
import os
import sys
import traceback
import SocketServer
import threading
import DropFile
import COMPortServer
import PipeRunner
import COMRunner
from Utils import *
import time
import Global
import imp
import User
import BigBrother
from xml.dom.minidom import parse, parseString
import DoorDB
##import win32com
##import pythoncom

class Constants:
    Version = "0.01"
    DefaultPort = 8000
    COMName = "Python.DumpleBBS"

sys.path.append(os.path.abspath("Plugins"))

class DumpleConfig:
    def __init__(self):
        self.Config = {}
        self.LoadConfig()
    def LoadConfig(self):
        self.LoadDefaultConfig()
        # Read configuration from "config.xml", if it's present:
        try:
            self.LoadConfigInternal()
        except:
            print "Error loading Dumple configuration from config.xml.  Traceback follows:"
            traceback.print_exc()
    def LoadDefaultConfig(self):
        self.Config["SystemName"] = "New BBS"
        self.Config["SysopName"] = "John Smith"
        self.Config["SysopFirstName"] = "John"
        self.Config["SysopLastName"] = "Smith"
        self.Config["MaxConnections"] = 10
        self.Config["Port"] = 8000
        self.Config["COMPorts"] = {}
    def LoadConfigInternal(self):
        DOM = parse("Config.xml")
        Dumple = DOM.getElementsByTagName("Dumple")[0]
        self.LoadConfigItem(Dumple, "SystemName", "SystemName")
        self.LoadConfigItem(Dumple, "SysopName", "SysopName")
        self.LoadConfigItem(Dumple, "SysopFirstName", "SysopFirstName")
        self.LoadConfigItem(Dumple, "SysopLastName", "SysopLastName")
        # Read max-connections as an integer:
        self.LoadConfigItem(Dumple, "MaxConnections", "MaxConnections", 10)
        try:
            self.Config["MaxConnections"] = int(self.Config["MaxConnections"])
        except:
            self.Config["MaxConnections"] = 10
        # Read port as an integer:
        self.LoadConfigItem(Dumple, "BBSPort", "Port", 8000)
        try:
            self.Config["Port"] = int(self.Config["Port"])
        except:
            self.Config["Port"] = 8000
        # Read COM port redirections:
        self.Config["COMPorts"] = {}
        Nodes = Dumple.getElementsByTagName("COMRedirect")
        for Node in Nodes:
            self.LoadCOMPortRedirection(Node)
    def LoadCOMPortRedirection(self, RedirectNode):
        COMNode = RedirectNode.getElementsByTagName("COM")[0]
        COMPort = int(GetXMLText(COMNode))
        PortNode = RedirectNode.getElementsByTagName("Port")[0]
        PortNumber = int(GetXMLText(PortNode))
        self.Config["COMPorts"][COMPort] = PortNumber
    def LoadConfigItem(self, Node, TagName, AttributeName, Default = None):
        Nodes = Node.getElementsByTagName(TagName)
        if not Nodes:
            self.Config[AttributeName] = Default
            return
        Text = GetXMLText(Nodes[0])
        self.Config[AttributeName] = Text


DumpleServer = None
_Dict = {}

##class DumpleServerCOMWrapper:
##    _reg_clsid_ = "{BA0854D8-2D3B-4CBB-B8D4-0283FCE1D657}"
##    _reg_desc_ = "Dumple TCP/IP BBS Server Version 0.1"
##    _reg_progid_ = Constants.COMName # "Python.DumpleBBS"
##    _reg_class_spec = "Dumple.DumpleServerCOMWrapper" #Constants.COMName # "Python.DumpleBBS"
##    _public_methods_ = ["GetSessionCount", "Foo"]
##    _readonly_attrs_ = ["Version"]
##    _public_attrs_ = ["Version"]
##    _reg_clsctx_ = pythoncom.CLSCTX_LOCAL_SERVER
##    Version = "0.1"
##    def GetSessionCount(self):
##        return _Dict.get("testkey", None)
##        global DumpleServer
##        if not DumpleServer:
##            return None
##        return DumpleServer.COMGetMessageCount()
##    def Foo(self):
##        return "foo"

class DumpleServerClass(SocketServer.ThreadingMixIn, SocketServer.TCPServer):
    """
    The BBS server.  Creates one DumpleSession object for each user connection.  Does bookkeeping
    to allocate slots in games (one player at a time on many doors). 
    """
    Version = "0.1"
    def __init__(self, Config, *args, **kw):
        self.Config = Config
        _Dict["testkey"] = "Doidy" ####
        Global.DumpleServer = self
        self.Sessions = [] # dynamic list of current sessions
        self.DoorNodes = {}
        self.COMPortToSession = {}
        self.Config = {}
        self.FOSSILSessions = {}
        self.NextSessionID = 1
        self.HomeDir = os.path.abspath(os.getcwd())
        SocketServer.TCPServer.__init__(self, *args, **kw)
        self.Config = Config
        
    def COMGetSessionCount(self):
        return str(len(self.Sessions))
    def GetSessionID(self):
        ID = self.NextSessionID
        self.NextSessionID += 1
        return ID
    def verify_request(self, request, client_address):
        """
        Return TRUE if we should proceed with this request.  (We return FALSE if there are no available
        connection slots)
        """
        print "VR"
        if len(self.Sessions) >= self.Config["MaxConnections"]:
            Log("Too many puppies!")
            return 0
        Log("New connection a-ok!")
        return 1
        
    def EndSession(self, Session):
        if not Session:
            return
        try:
            self.Sessions.remove(Session)
        except:
            pass
        if Session.COMPort:
            try:
                self.FreeCOMPort(Session.COMPort)
            except:
                pass
    def ReserveCOMPort(self, Session):
        for COM in self.Config["COMPorts"].keys():
            if not self.COMPortToSession.has_key(COM):
                Session.COMPort = COM
                self.COMPortToSession[COM] = Session
                return COM
        return None
    def FreeCOMPort(self, Port):
        try:
            del self.COMPortToSession[Port]
        except:
            pass
    def ClaimDoorNode(self, Door, Session):
        "Returns TRUE if we successfully reserved a slot on the door for this session"
        Count = Door.NodeCount
        if Count <= 0:
            # Unlimited nodes; ignore the claim
            return 0
        # Don't allow them to request a node if they're ALREADY LOGGED IN to the door:
        for Index in range(Count):
            Key = (Door.ID, Index)
            OtherSession = self.DoorNodes.get(Key, None)
            if OtherSession and (OtherSession.User) and (OtherSession.User == Session.User):
                Session.request.send("You are already playing %s!\r\n"%Door)
                return  None
        for Index in range(Count):
            Key = (Door.ID, Index)
            if not self.DoorNodes.get(Key, None):
                self.DoorNodes[Key] = Session
                Log("Session %s claims node %s on door %s"%(Session, Index, Door))
                return Index
        Log("The door '%s' is full, so %s cannot play (yet)"%(Door, Session))
        return None
    def ReleaseDoorNode(self, Door, Session):
        "Frees a slot on the specified door"
        Count = Door.NodeCount
        if Count <= 0:
            return
        for Index in range(Count):
            Key = (Door.ID, Index)
            if self.DoorNodes.get(Key, None) == Session:
                self.DoorNodes[Key] = None
        return
        
    def DebugPrintStatus(self, File):
        File.write("-------\\\\\\\\\\\n")
        File.write("DumpleServer status at %s\n"%time.asctime())
        File.write("--------\nSessions:\n")
        for Session in self.Sessions:
            File.write("%s\n"%Session)
        File.write("------\nDoors:\n")
        for Door in Global.DoorDatabase.GetDoorList():
            if Door.NodeCount <= 0:
                File.write("%s (unlimited nodes)\n"%(Door, NodesLeft))
            else:
                NodeStr = ""
                InUse = 0
                for Index in range(Door.NodeCount):
                    Session = self.DoorNodes.get((Door.ID, Index))
                    if Session:
                        InUse += 1
                        NodeStr += "  Node %s used by %s\n"%(Index, Session)
                FreeCount = Door.NodeCount - InUse
                NodesLeft = "%s (%s of %s nodes active, %s nodes free)\n"%(Door, InUse, Door.NodeCount, FreeCount)
                File.write(NodesLeft)
                File.write(NodeStr)
        File.write("-------/////\n")
    def GetHomeDir(self):
        return self.HomeDir
    def GetDoorNodeNumber(self, Door, TargetSession):
        for Index in range(Door.NodeCount):
            Session = self.DoorNodes.get((Door.ID, Index))
            if Session == TargetSession:
                return Index
        return None
    def ClaimFOSSILNode(self, Session):
        for Index in range(1,256):
            if self.FOSSILSessions.get(Index, None) == None:
                self.FOSSILSessions[Index] = Session
                return Index
        return None
    def ReleaseFOSSILNode(self, Session, Node):
        Holder = self.FOSSILSessions.get(Node)
        if Holder != Session:
            Log("WARNING: Session %s trying to release fossil node %s, held by %s"%(Session, Node, Holder))
        else:
            del self.FOSSILSessions[Node]

        
   
class HandlerState:
    SelectGame = 0
    PlayGame = 1
    Done = 2
    GetUserName = 3
    ConfirmNewUser = 4
    NewUserPassword = 5
    GetUserPassword = 6

def LogError(Text = ""):
    StrList = traceback.format_exception(*sys.exc_info())
    Str = "'<<<<<\n"
    if Text:
        Str += str(Text) + "\n"
    for Bit in StrList:
        Str += Bit
    Str += ">>>>>\n"    
    print Str
    Log(Str)
    
class DumpleSession(SocketServer.BaseRequestHandler):
    """
    Request handler for the DumpleServer - this object is also called the "session", since one is created
    for each user connection.  This object is deliberately very simple, handing off all the real work to
    plugins and other doors.  
    """
    def __init__(self, *args, **kw):
        self.SocketReader = None
        self.ReaderThread = None
        self.GameStdin = None
        self.GameStdout = None
        self.User = None
        self.Done = 0
        self.COMPort = None
        self.DoorFailed = 0
        self.LogoffFlag = 0
        self.COMHandler = None
        self.DoorStack = []
        self.FOSSILNode = None
        self.ConnectTime = time.time()
        SocketServer.BaseRequestHandler.__init__(self, *args, **kw)
    def GetActionName(self):
        if self.CurrentDoor:
            return self.CurrentDoor.Name
        else:
            return ""
    def GetUserName(self):
        if self.User:
            return self.User.Name
        else:
            return "nobody"
    def __str__(self):
        if self.User:
            return "<Session %s for '%s'>"%(self.ID, self.User.Name)
        return "<Userless session %s>"%self.ID
    def handle(self, *args, **kw):
        self.ID = self.server.GetSessionID()
        self.HomeDir = self.server.GetHomeDir()
        self.server.Sessions.append(self)
        # Cheat for testing:
        #self.User = UserDict.GetUserByID(1) #%%%
        try:
            self.HandleInternal()
        except:
            Str = traceback.format_exception(*sys.exc_info())
            Log(Str)
        self.server.EndSession(self)
    def HandleInternal(self, *args, **kw):
        self.request.setblocking(0)
        self.CurrentDoor = None
        self.DoorStack = []
        while (not self.Done):
            if not self.User:
                self.CurrentDoor = Global.DoorDatabase.LoginDoor
            if not self.CurrentDoor:
                self.CurrentDoor = Global.DoorDatabase.DefaultDoor
            NextDoor = self.CurrentDoor
            StartTime = time.clock()
            self.DoorFailed
            Log("Session %s now Running door: '%s'"%(self, self.CurrentDoor.Name))
            try:
                self.RunDoor(NextDoor)
            except:
                LogError("Error encountered running door '%s'"%self.CurrentDoor.Name)
                self.DoorFailed = 1
            # If login failed, then break:
            if (NextDoor == Global.DoorDatabase.LoginDoor) and not self.User:
                break
            if self.DoorFailed:            
                if (NextDoor == Global.DoorDatabase.LoginDoor):
                    break
                if (NextDoor == Global.DoorDatabase.DefaultDoor):
                    break
            self.CurrentDoor = None
        # Shut down connection:
        pass
    def RunDoor(self, Door, NodeReserve = 1):
        if NodeReserve:
            Result = self.server.ClaimDoorNode(Door, self)
            if Result == None:
                self.request.send("Sorry - %s is currently full."%Door.Name)
                self.DoorFailed = 1
                return
        Log(">>>Session %s starts door '%s'"%(self, Door))
        StartTime = time.time()
        self.DoorStack.append(Door)
        Dir = os.getcwd()
        self.CurrentDoor = Door
        try:
            self.RunDoorInternal(Door)
        except:
            self.DoorFailed = 1
            LogError()
        EndTime = time.time()
        Log("<<<Session %s completes door '%s'; %.2f elapsed"%(self, Door, EndTime - StartTime))
        if self.User:
            UserName = self.User.Name
        else:
            UserName = "Nobody"
        try:
            Global.BigBrother.RecordNewRun(Door.Name, UserName, StartTime, EndTime)
        except:
            LogError()
        if NodeReserve:
            self.server.ReleaseDoorNode(Door, self)
        os.chdir(Dir)
        self.DoorStack.remove(Door)
    def RunDoorInternal(self, Door):
        os.chdir(self.HomeDir)
        Dir = Door.GetDir()
        if Dir:
            Log("To dir:%s"%Dir)
            os.chdir(Dir)
        self.COMPort = None
        if Door.ExecutionType == DoorDB.ExecutionTypes.Plugin:
            self.RunPluginDoor(Door)
        elif Door.ExecutionType == DoorDB.ExecutionTypes.FOSSIL:
            self.RunFossilDoor(Door)
        elif Door.ExecutionType == DoorDB.ExecutionTypes.Pipes:
            self.RunPipesDoor(Door)
        elif Door.ExecutionType == DoorDB.ExecutionTypes.COM:
            self.RunCOMDoor(Door)
        else:
            Log("ERROR: Unknown execution type '%s' for door %s"%(Door.ExecutionType, Door))
    def RunPipesDoor(self, Door):
        self.BuildDropFile(Door)
        Helper = PipeRunner.PipeRunner(self, Door)
        Helper.Run()
    def RunPluginDoor(self, Door):
        self.BuildDropFile(Door)
        File = None
        try:
            (File, Path, Description) = imp.find_module(Door.PluginModuleName)
            Module = imp.load_module(Door.Name, File, Path, Description)
        except:
            LogError("Unable to import module '%s'"%Door.PluginModuleName)
            if File:
                File.close()
            self.DoorFailed = 1
            return
        File.close()
        # Import succeeded.  Now get the function:
        Function = getattr(Module, Door.PluginFunctionName, None)
        if not Function:
            raise ValueError, "Could not find plugin function %s.%s"%(Door.PluginModuleName, Door.PluginFunctionName)
            self.DoorFailed = 1
            return
        apply(Function, (self,))
        return
    def GetCommandLine(self, Door):
        Command = Door.GetCommand()
        NodeStr = "%NODE%"
        if Command.find(NodeStr)!=-1:
            NodeNumber = self.server.GetDoorNodeNumber(Door, self) + 1
            Command = Command.replace(NodeStr, str(NodeNumber))
        return Command
    def BuildDropFile(self, Door):
        # Have the server remind us what our door number is.  (Use "1", if we didn't reserve a slot)
        NodeNumber = self.server.GetDoorNodeNumber(Door, self)
        if NodeNumber!=None:
             NodeNumber = NodeNumber + 1
        else:
            NodeNumber = 1
        DropFile.BuildDropFile(Door.DropFileType, self.User, self, NodeNumber)
    def RunFossilDoor(self, Door):
        FreeFossilNode = 0
        if self.FOSSILNode == None:
            self.FOSSILNode = self.server.ClaimFOSSILNode(self)
            if self.FOSSILNode == None:
                LogError("Error: No more FOSSIL nodes available!!")
                self.request.send("Error: No more FOSSIL nodes available!!\r\n")
                self.DoorFailed = 1
                return
            FreeFossilNode = 1
        try:
            self.BuildDropFile(Door)
            Command = self.GetCommandLine(Door) #Door.GetCommand()
            Log("Session %s starting FOSSILNode %s"%(self, self.FOSSILNode))
            # Note: We'd rather not use door32.sys, since we don't want to worry about two threads overwriting
            # each other's files.            
            #DropFile.WriteDoor32SysDropFile(self.request.fileno(), self.FOSSILNode, self.User)
            # Note: We can't run nf.bat twice in the same window...so we spawn a new
            # window.  Hacky?  Yes.  But it works!  Note: For debugging purposes, remove the "exit" at the
            # end of nfdumple.bat.
            Command = r"start /wait /min %s\netf081\NFDumple.bat /N%d /H%d %s"%(self.server.GetHomeDir(), self.FOSSILNode, self.request.fileno(), Command)
            #Command = r"%s\netf081\NF.bat /N%d /H%d %s"%(self.server.GetHomeDir(), self.FOSSILNode, self.request.fileno(), Command)            
            #Command = r"d:\research\dumple\netf081\nf.bat " + Command #%%%
            Log("%s starts door %s with command: '%s'"%(self, Door, Command))
            os.system(Command)
            #Bits = Command.split()
            #os.spawnv(os.P_WAIT, Bits[0], Bits)
        except:
            LogError()
            self.DoorFailed = 1
        if FreeFossilNode:
            self.server.ReleaseFOSSILNode(self, self.FOSSILNode)
            self.FOSSILNode = None
    def RunCOMDoor(self, Door):
        # Run a door, using COM-port redirection.
        # (The commercial product com/IP can do this)
        self.COMPort = self.server.ReserveCOMPort(self)
        if not self.COMPort:
            self.request.send("All COM ports busy - try again later!\n")
            time.sleep(0.5)
            self.DoorFailed = 1
            return
        try:
            self.BuildDropFile(Door)
            Runner = COMRunner.COMRunner(self, Door)
            Runner.Run()
        except:
            LogError("COM Door failed!")
        self.server.FreeCOMPort(self.COMPort)
        return
    def GetUserDict(self):
        return Global.UserDict
    def GetDoorList(self):
        return Global.DoorDatabase.GetDoorList()
    def Logoff(self):
        self.Done = 1

Global.COMServers = []
def COMPortServerInit():
    global COMServer
    print Global.DumpleServer
    Tuples = Global.DumpleServer.Config["COMPorts"].items()
    for (COMPort, PortNumber) in Tuples:
        Server = COMPortServer.COMPortServer(("", PortNumber), COMPortServer.COMPortHandler)
        Server.COMPort = COMPort
        Global.COMServers.append(Server)
        print "Created COM server for COM port %s to TCP port %s"%(COMPort, PortNumber)
        TheThread = threading.Thread(None, target=Server.serve_forever)
        TheThread.setDaemon(1)
        TheThread.start()

##def RegisterServer():
##    #import ni, win32com.server.register
##    print "Registering..."
##    import win32com.server.register
##    win32com.server.register.UseCommandLine(DumpleServerCOMWrapper)
##    print "Registered."

def RunServer():
    global DumpleServer
    print "Dumple BBS server version %s Active"%Constants.Version
    # Initialize stuff:
    Global.HomeDir = os.path.abspath(os.getcwd())
    Global.UserDict = User.UserDictClass()
    Global.BigBrother = BigBrother.BigBrother()
    Global.BigBrother.GetWeeklyStats()    
    Global.SysLog = open("Syslog.txt", "wa")    
    # Activate COM port servers (relevant only if we're using COM redirection rather than FOSSIL drivers)
    Config = DumpleConfig()
    Port = Config.Config["Port"]
    DumpleServer = DumpleServerClass(Config.Config, ("", Port), DumpleSession)
    Global.DumpleServer = DumpleServer 
    print "Server object created!", Global.DumpleServer
    print Global.DumpleServer.Config
    COMPortServerInit()
    # Activate the primary server:
    Global.DumpleServer.serve_forever()

##def COMTest():
##    "Test the Dumple server as a COM client"
##    import win32com.client
##    #Dict = win32com.client.dynamic.Dispatch("Python.Dictionary")
##    BBS = win32com.client.dynamic.Dispatch(Constants.COMName)
##    print "BBS:", BBS
##    print "VERSION:", BBS.Version
##    print "Sessions:", BBS.GetSessionCount()
##    print BBS.Config
    

if __name__ == "__main__":
    if len(sys.argv)<2:
        Command = "run"
    else:
        Command = sys.argv[1].lower()
    if Command == "register":
        pass #RegisterServer()
    elif Command == "run":
        RunServer()
    elif Command == "com":
        pass #COMTest()
    else:
        print """Unknown command - Valid options are "run", "register"."""
