"""
Dumple, the mega-door server.
"""
import os
import sys
import traceback
import SocketServer
import threading
import DropFile

class Constants:
    Version = "0.01"
    DefaultPort = 8001

class DropFileTypes:
    """
    Doors generally expect to see a 'drop-file' with the user name and other handy info.
    """
    NoDrop = None
    Droplet = 0 # our own teeny format
    DoorSys = 1

class ExecutionTypes:
    "How are we wrapping the door?"
    Pipes = 0
    COM = 1

class GameClass:
    "A game, such as Operation Overkill"
    def __init__(self):
        self.Name = None #req'd
        self.Version = None
        self.DropFileType = DropFileTypes.NoDrop
        self.Dir = None  
        self.DropFileDir = None
        self.RunCommand = None #req'd
        self.ExecutionType = ExecutionTypes.Pipes
    def GetDir(self):
        Dir = self.Dir
        if Dir==None:
            Dir = ""
        return os.path.abspath(Dir)
    def GetCommand(self):
        return self.RunCommand
    
TestGame = GameClass()
TestGame.Name = "Number guess"
TestGame.Dir = "Number"
TestGame.RunCommand = "python Door.py"
TestGame.ExecutionType = ExecutionTypes.Pipes

class SessionClass:
    "An active session of a game, such as Tradewars"
    def __init__(self, Game):
        self.Thread = None
        self.Game = Game

class DumpleServer(SocketServer.TCPServer):
    def __init__(self, *args, **kw):
        self.Games = []
        self.Sessions = []
        self.LoadConfig()
        self.LoadGames()
        SocketServer.TCPServer.__init__(self, *args, **kw)
    def LoadConfig(self):
        pass
    def LoadGames(self):
        self.Games = [TestGame]
    def GetGameDict(self):
        Dict = {}
        Letters = "abcdefghijklmnopqrstuvwxyz"
        Index = 0
        for Game in self.Games:
            Dict[Letters[Index]] = Game
            Index += 1
        return Dict

class HandlerState:
    SelectGame = 0
    PlayGame = 1
    Done = 2
    
class DumpleHandler(SocketServer.BaseRequestHandler):
    def __init__(self, *args, **kw):
        SocketServer.BaseRequestHandler.__init__(self, *args, **kw)
        self.Session = None
        self.SocketReader = None
        self.ReaderThread = None
        self.GameStdin = None
        self.GameStdout = None
    def handle(self, *args, **kw):
        s = self.request # Our socket
        self.AccumText = ""
        self.SocketReader = SocketReaderThread(self.request)
        self.SocketReader.start()
        while (1):
            Text = self.SocketReader.GetText()
            if Text:
                print Text
        
class SocketReaderThread(threading.Thread):
    "Socket reader thread - for non-blocking i/o"
    def __init__(self, Socket, **kw):
        threading.Thread.__init__(self,**kw)
        self.Socket = Socket
        self.Text = ""
        self.KeepRunning = 1
        self.StringLock = threading.Lock()
        self.setDaemon(1)
    def run(self):
        "* Subthread function"
        print "Socket thread activated.  You can count on me, boss."
        while (1):
            Str = self.Socket.recv(1)
            if Str:
                self.StringLock.acquire()
                self.Text = self.Text + Str
                self.StringLock.release()
            if not self.KeepRunning:
                del self.StringLock
                break
    def GetText(self):
        self.StringLock.acquire()
        Str = self.Text
        self.Text = ""
        self.StringLock.release()
        return Str
    def Kill(self):
        self.KeepRunning = 0

if __name__ == "__main__":
    Server = DumpleServer(("", Constants.DefaultPort), DumpleHandler)
    print "Listening on:", 8001
    Server.serve_forever()
        