import Dumple
import DoorDB
import Global

def BuildDropFile(Type, User, Session, Node = 1):
    if Session.COMPort:
        COM = Session.COMPort
    else:
        COM = 1
    if Type == DoorDB.DropFileTypes.DoorSys:
        FilePath = "DOOR.SYS"
        WriteDoorSysDropFile(FilePath, User, COM, Node)
    elif Type == DoorDB.DropFileTypes.CallInfoBBS:
        FilePath = "CALLINFO.BBS"
        WriteCallinfoBBSDropFile(FilePath, User, COM, Node)
    elif Type == DoorDB.DropFileTypes.DORINFO:
        FilePath = "DORINFO1.DEF"
        WriteDORINFODropFile(FilePath, User, COM, Node)
    # %%% Other drop file formats here...

def WriteDORINFODropFile(Path, User, COM, Node):
    File = open(Path, "w")
    CRLF = "\r\n"
    SysName = Global.DumpleServer.Config["SystemName"]
    File.write(SysName+CRLF)
    Name = Global.DumpleServer.Config["SysopFirstName"]
    File.write(Name+CRLF)
    Name = Global.DumpleServer.Config["SysopLastName"]
    File.write(Name+CRLF)
    File.write(("COM%d"%COM) + CRLF)
    File.write("9600 BAUD,N,8,1" + CRLF)
    File.write("0" + CRLF)
    File.write(User.Name + CRLF) # first name
    File.write("" + CRLF) # last name
    File.write("Parts Unknown"+CRLF)
    if User.ANSI:
        File.write("1"+CRLF)
    else:
        File.write("0"+CRLF)
    File.write("30" + CRLF) # access level
    File.write("60" + CRLF) # time left
    File.close()
####Wild Thoughts BBS <-- BBS name.
####Vixen             <-- Sysop's first name.
####Thefox            <-- Sysop's last name (or blank if none).
####COM0              <-- Comm port (or COM0 for local).
####0 BAUD,N,8,1      <-- Baud (0 for local), parity, databits, stop bits.
####0                 <-- ???
####Jill              <-- Caller's first name.
####Brown             <-- Caller's last name (or blank if none).
####Sydney            <-- Caller's location.
####1                 <-- ANSI flag (see below).
####5                 <-- Access level.
####63                <-- Time remaining in minutes.
    
    
    
def WriteCallinfoBBSDropFile(Path, User, COM, Node):
    # Note: This may not be correct; docs were incomplete!
    File = open(Path, "w")
    CRLF = "\r\n"
    File.write(User.Name + CRLF)
    File.write("5" + CRLF) # 5: console/other speed (3 is 9600 baud)
    File.write("" + CRLF) # caller city
    File.write("30" + CRLF) # security level (5 problem user, 30 normal, 100 sysop)
    File.write("546" + CRLF) # Time left (546 is max, don't ask me why)
    File.write("COLOR" + CRLF) # COLOR or MONO, for ansi
    File.write(User.Password + CRLF)
    File.write(("%d"%User.ID) + CRLF) # Userlog number (?)
    File.write("1" + CRLF) # minutes used
    File.write("" + CRLF) # ?
    File.write("" + CRLF) # ?
    File.write("" + CRLF) # ?
    File.write("" + CRLF) # ?
    File.write("" + CRLF) # ?
    File.write("" + CRLF) # ?
    File.write("" + CRLF) # ?
    File.write("555-1212" + CRLF) # phone#
    File.write("" + CRLF) # some sort of date?
    File.write("NOVICE" + CRLF) # EXPERT/NOVICE
    File.write("" + CRLF) # xfer protocol
    File.write("" + CRLF) # some sort of date?
    File.write("5" + CRLF) # times logged on
    File.write("25" + CRLF) # lines per screen
    File.write("1" + CRLF) # last message read
    File.write("1" + CRLF) # upload count
    File.write("1" + CRLF) # download count
    File.write("8  { Databits }" + CRLF) # raw string, req'd
    File.write("REMOTE" + CRLF) # REMOTE / LOCAL
    File.write(("COM%d"%COM) + CRLF)
    File.write("5" + CRLF) # speed (again!!)
    File.write("FALSE" + CRLF) # ?
    File.write("Normal Connection" + CRLF) # Req'd?
    File.write("" + CRLF) # some sort of date?
    File.write("0" + CRLF) # task number
    File.write("1" + CRLF) # door number
    File.close()

def WriteDoor32SysDropFile(Handle, Node, User):
    File = open("Door32.sys", "w")
    EndLine = "\n"
    File.write("2"+EndLine) # comm type: telnet
    File.write(("%d"%Handle)+EndLine) # comm or socket handle
    File.write("38400"+EndLine) # baud rate
    File.write("Dumple"+EndLine) # BBS soft
    File.write(str(User.ID)+EndLine) # User record position (1-based)
    File.write(User.Name+EndLine) # real name
    File.write(User.Alias+EndLine) # alias
    File.write("50"+EndLine) # security level
    File.write("50"+EndLine) # time left
    File.write("1"+EndLine) # emulation: 0 ascii, 1 ansi
    File.write(("%d"%Node)+EndLine) # node number
    File.close()
    
##0                            Line 1 : Comm type (0=local, 1=serial, 2=telnet)
##0                            Line 2 : Comm or socket handle
##38400                        Line 3 : Baud rate
##Mystic 1.07                  Line 4 : BBSID (software name and version)
##1                            Line 5 : User record position (1-based)
##James Coyle                  Line 6 : User's real name
##g00r00                       Line 7 : User's handle/alias
##255                          Line 8 : User's security level
##58                           Line 9 : User's time left (in minutes)
##1                            Line 10: Emulation *See Below
##1                            Line 11: Current node number
    
    
def WriteDoorSysDropFile(FilePath, User = None, COM = 0, NodeNumber = 1):
    EndLine = "\n"
    File = open(FilePath, "w")
    File.write(("COM%d:"%COM) + EndLine) # comport or COM0:
    File.write("38400" + EndLine)
    File.write("8" + EndLine)
    File.write(("%d"%NodeNumber) + EndLine) # Node number
    File.write("19200" + EndLine)
    File.write("Y" + EndLine) #screen display
    File.write("Y" + EndLine) #printer toggle
    File.write("Y" + EndLine) #page bell
    File.write("Y" + EndLine) # caller alarm
    if User:
        Name = User.Name
    else:
        Name = "BadBadtzMaru"
    File.write(Name + EndLine) #user full name
    File.write("Somewhere, USA" + EndLine) # calling from
    File.write("555-1212" + EndLine) # home phone
    File.write("555-1212" + EndLine) # work phone
    if User:
        Password = User.Password
    else:
        Password = "Password"
    File.write(Password + EndLine) # password
    File.write("50" + EndLine) # security level
    File.write("50" + EndLine) # times on
    File.write("03/14/99" + EndLine) # last date called (MM/DD/YY)
    File.write("3600" + EndLine) # seconds remaining
    File.write("60" + EndLine) # minutes remaining
    File.write("GR" + EndLine) # graphics mode
    File.write("23" + EndLine) # page len
    File.write("Y" + EndLine) # expert mode
    File.write("1,2,3" + EndLine) # conferences
    File.write("1" + EndLine) # source conference
    File.write("01/01/50" + EndLine) # expiration date
    File.write(("%d"%User.ID) + EndLine) # userfile record number
    File.write("Z" + EndLine) # default protocol
    File.write("0" + EndLine) # total uploads
    File.write("0" + EndLine) # total downloads
    File.write("0" + EndLine) # daily download K total
    File.write("9999" + EndLine) # daily download K limit
    File.write("02/28/76" + EndLine) # birthday
    File.write("" + EndLine) # MAIN directory
    File.write("" + EndLine) # GEN directory
    File.write("Python" + EndLine) # Sysop name directory
    if User:
        Alias = User.Alias
    else:
        Alias = "BadBadtzMaru"
    File.write(Alias + EndLine) # Alias name
    File.write("" + EndLine) # event time
    File.write("Y" + EndLine) # error-correcting connection?
    File.write("N" + EndLine) # ANSI, using NG?
    File.write("Y" + EndLine) # Record locking?
    File.write("14" + EndLine) # default color
    File.write("10" + EndLine) # time credits
    File.write("10/10/99" + EndLine) # new file scan date
    File.write("01:23" + EndLine) # time this call
    File.write("01:23" + EndLine) # time last call
    File.write("99" + EndLine) # Max files per day
    File.write("0" + EndLine) # Files today
    File.write("0" + EndLine) # Total upload K
    File.write("0" + EndLine) # Total download K
    File.write("Cheese" + EndLine) # comment
    File.write("10" + EndLine) # Total doors
    File.write("10" + EndLine) # Total messages
    File.close()


##10               *<-- Time Credits In Minutes (positive/negative)     (rc)
##07/07/90          <-- Last New Files Scan Date          (mm/dd/yy)    (rc)
##14:32             <-- Time of This Call                 (hh:mm)       (rc)
##07:30             <-- Time of Last Call                 (hh:mm)       (rc)
##6                 <-- Maximum daily files available                   (rc)
##3                *<-- Files d/led so far today                        (rc)
##23456            *<-- Total "K" Bytes Uploaded                        (rc)
##76329            *<-- Total "K" Bytes Downloaded                      (rc)
##A File Sucker     <-- User Comment                                    (rc)
##10                <-- Total Doors Opened                              (rc)
##10283             <-- Total Messages Left                             (rc)





if __name__=="__main__":
    WriteDoorSysDropFile("Door.sys")

##COM1:             <-- Comm Port - COM0: = LOCAL MODE
##2400              <-- Baud Rate - 300 to 38400
##8                 <-- Parity - 7 or 8
##1                 <-- Node Number - 1 to 99                    (Default to 1)
##19200             <-- DTE Rate. Actual BPS rate to use. (kg)
##Y                 <-- Screen Display - Y=On  N=Off             (Default to Y)
##Y                 <-- Printer Toggle - Y=On  N=Off             (Default to Y)
##Y                 <-- Page Bell      - Y=On  N=Off             (Default to Y)
##Y                 <-- Caller Alarm   - Y=On  N=Off             (Default to Y)
##Rick Greer        <-- User Full Name
##Lewisville, Tx.   <-- Calling From
##214 221-7814      <-- Home Phone
##214 221-7814      <-- Work/Data Phone
##PASSWORD          <-- Password
##110              *<-- Security Level
##1456              <-- Total Times On
##03/14/88          <-- Last Date Called
##7560              <-- Seconds Remaining THIS call (for those that particular)
##126               <-- Minutes Remaining THIS call
##GR                <-- Graphics Mode - GR=Graph, NG=Non-Graph, 7E=7,E Caller
##23                <-- Page Length
##Y                 <-- User Mode - Y = Expert, N = Novice
##1,2,3,4,5,6,7     <-- Conferences/Forums Registered In  (ABCDEFG)
##7                 <-- Conference Exited To DOOR From    (G)
##01/01/99          <-- User Expiration Date              (mm/dd/yy)
##1                 <-- User File's Record Number
##Y                 <-- Default Protocol - X, C, Y, G, I, N, Etc.
##0                *<-- Total Uploads
##0                *<-- Total Downloads
##0                *<-- Daily Download "K" Total
##999999            <-- Daily Download Max. "K" Limit
##10/22/88          <-- Caller's Birthdate                              (kg)
##G:\GAP\MAIN       <-- Path to the MAIN directory (where User File is) (kg)
##G:\GAP\GEN        <-- Path to the GEN directory                       (kg)
##Michael           <-- Sysop's Name (name BBS refers to Sysop as)      (kg)
##Stud              <-- Alias name                                      (rc)
##00:05             <-- Event time                        (hh:mm)       (rc)
##Y                 <-- If its an error correcting connection (Y/N)     (rc)
##N                 <-- ANSI supported & caller using NG mode (Y/N)     (rc)
##Y                 <-- Use Record Locking                    (Y/N)     (rc)
##14                <-- BBS Default Color (Standard IBM color code, ie, 1-15) (rc)
##10               *<-- Time Credits In Minutes (positive/negative)     (rc)
##07/07/90          <-- Last New Files Scan Date          (mm/dd/yy)    (rc)
##14:32             <-- Time of This Call                 (hh:mm)       (rc)
##07:30             <-- Time of Last Call                 (hh:mm)       (rc)
##6                 <-- Maximum daily files available                   (rc)
##3                *<-- Files d/led so far today                        (rc)
##23456            *<-- Total "K" Bytes Uploaded                        (rc)
##76329            *<-- Total "K" Bytes Downloaded                      (rc)
##A File Sucker     <-- User Comment                                    (rc)
##10                <-- Total Doors Opened                              (rc)
##10283             <-- Total Messages Left                             (rc)
