import traceback
import os
import sys
import Global
from Utils import *

class COMRunner:
    def __init__(self, Session, Door):
        self.Session = Session
        self.COMPort = self.Session.COMPort
        self.Door = Door
        self.Handler = None
    def SpawnProcess(self):
        Command = self.Session.GetCommandLine(self.Door) #self.Door.GetCommand()
        Log("From this directory: '%s'"%os.getcwd())
        Log("Run this command: '%s'"%Command)
        Bits = Command.split()
        ProcessID = os.spawnl(os.P_NOWAIT, Bits[0], *Bits) #os.system(Command)
        self.Watcher = Watcher(ProcessID)
        self.Watcher.Watch()
        #self.Watcher = threading.Thread(None, target = lambda ProcessID=ProcessID: os.waitpid(ProcessID))
        #self.Watcher.start()
    def Run(self):
##        Log("COMRunner: Send init string")
##        File = open("COM%d"%self.COMPort, "w")
##        File.write("AT S1001=1 S1002=1 S1003=7 S1005=0 S1008=23 &D2")
##        File.close()
        Log("COMRunner: Spawn process")
        self.SpawnProcess()
        Log("COMRunner: claim handler")
        self.ClaimHandler()
        if not self.Handler:
            self.Session.DoorFailed = 1
            return
        Log("COMRunner: start main loop")
        while (1):
            if not self.Watcher.Alive: #isAlive():
                Log("COM child process is complete.  Returning")
                return 
            Idle = 1
            ###
            ServerText = ""
            try:
                ServerText = self.Handler.request.recv(1024)
                Idle = 0
            except:
                pass
            if ServerText:
                #Log(">>SERVER>>"+ServerText)
                self.Session.request.send(ServerText)
            ###
            ClientText = ""
            try:
                ClientText = self.Session.request.recv(1024)
                Idle = 0
            except:
                pass
            if ClientText:
                #Log("<<Client<<"+ClientText)
                self.Handler.request.send(ClientText)
            if Idle:
                time.sleep(0.1)
    def ClaimHandler(self):
        StartTime = time.clock()
        OurServer = None
        print Global.COMServers
        for Server in Global.COMServers:
            print Server.COMPort,type(Server.COMPort)
            print self.COMPort, type(self.COMPort)
            
            if Server.COMPort == self.COMPort:
                OurServer = Server
                break
        if not OurServer:
            Log("** Bogus com port has no handler: %s"%self.COMPort)
            time.sleep(10)
            return # Bogus com port!
        while (1):
            self.Handler = OurServer.ClaimHandler(self)
            if self.Handler:
                break
            print ".",
            time.sleep(0.5)
            if time.clock() - StartTime > 8:
                Log("Error - COMRunner couldn't acquire a handler!")
                return
        
