#! /usr/bin/perl -w

# Enthral SVN: $Id: update.pl 118 2009-08-07 04:34:35Z frank $
# Source: $HeadURL: http://svn.enthralbbs.com/trunk/update.pl $
# $LastChangedDate: 2009-08-07 00:34:35 -0400 (Fri, 07 Aug 2009) $
# $LastChangedRevision: 118 $
# $LastChangedBy: frank $

# Enthral BBS perl updater script.  Written by Frank Linhares
# For more info on the Enthral bbs project please visit
# http://enthralbbs.com
#
# This perl script will attempt to automatically update your current Enthral
# alpha to the latest version via svn as well as change any instances of the
# default sysop and bbs name for you.  The script will then run
# ./configure && make clean && make for you as well as compile snoop and stats.
#
# WARNING.  This script was originally created for my own personal use.
# I am not responsible for anything that it might cause to your Enthral
# system.  While I have done my best to ensure that the script functions as
# promised, things may go wrong from time to time.  Please ensure you make
# a complete backup of your system before attempting to use this.
#
# Usage:
#
# ./update.pl
#
# Enter in your Sysop name and your BBS name.

# Standard variables and system requests

use File::Find;
use Cwd;
use File::Copy;
use strict;

my $enthralsvn = "http://svn.enthralbbs.com/trunk";
my $origsysop = "Mercyful Fate";
my $trunk = getcwd;

# Capture User Input

system("clear");
print "Welcome to the Enthral BBS auto updater script.\n\n";
print "This script will ask you for your Sysop Name and BBS Name and then\n";
print "update your src to the latest build via svn, replace all instances of\n";
print "the deafult sysop and bbs name and run configure, make clean, and\n";
print "make for you.  It will also compile snoop and stats.\n\n";
print "This script assumes that you have already compiled husky's smapi library\n";
print "and have the libsmapilnx.a library in your trunk path.\n\n";
print "WARNING.  This script was originally created for my own personal use.\n";
print "I am not responsible for anything that it might cause to your Enthral\n";
print "system.  While I have done my best to ensure that the script functions as\n";
print "promised, things may go wrong from time to time.  Please ensure you make\n";
print "a complete backup of your system before attempting to use this.\n\n";
print "Are you ready to continue? (y/n): ";

if (<STDIN> =~ /^[yY]/)

{
print "\nSysop Name : ";
my $sysop = <>;
chomp ( $sysop );

# Run SVN
chdir "../";
print "\nChecking SVN for any updates.\n";
sleep 1;
system("svn --username svn co $enthralsvn") == 0 or die "SVN update failed ($?): $!";
print "\nSVN check out succesfull. On to Sysop and BBS name replace.\n";
sleep 1;
chdir "trunk/ini/";
my $dir = getcwd;

# Replace Sysop Name in source

print "\nSearching for: $origsysop\nReplacing with: $sysop\n\n";
sleep 1;
find(\&wanted,$dir);

print "\nFinished\n";
sleep 1;

sub wanted{
#       (-f $_ && -w $_ && -T $_) or return;
        /\.ini$/ or return;
        my $file=$_;
        my $found = 0; # If the string was found in $file
        print "Searching $file.\n";
        open(INFILE,$file) or (print "Could not open $file for reading: $!\n" and return);
        my @text=<INFILE>;
        close(INFILE);
        for(my $x=0;$x<=$#text;$x++){
                $text[$x]=~s/$origsysop/$sysop/g and $found = 1 and
                        print " -Found in $file (line ".($x+1).")\n";
        }
        if($found){
                open(OUTFILE,">$file") or (print "Unable to open $file for writing: $!\n\t$file must be changed manually\n." and return);
                foreach(@text){
                        print OUTFILE $_;
                }
                close(OUTFILE);
        }
}

sleep 1;

# run Configure
chdir $trunk;
print "\nRunning configure\n";
sleep 1;
system "./configure";

# run make clean
print "\nRunning make clean\n";
sleep 1;
system "make clean";

# run make
print "\nRunning make\n";
sleep 1;
system "make";

# compile stats
chdir "src/stats";
print "\nCompiling Stats\n";
system "g++ -o stats main.cpp process2.cpp userdat.cpp";
sleep 1;
print "\nStats compile succsessful\n";

# compile snoop
chdir "../snoop";
print "\nCompiling Snoop\n";
system "g++ -o snoop snoop.cpp";
sleep 1;
print "\nSnoop compile succsessful\n";

print "\nEnthral update and compalation complete.\n\n";
}