/***************************************************************************
 *   Copyright (C) 2004-2009 by Michael Griffin                            *
 *   mrmisticismo@hotmail.com                                              *
 *                                                                         *
 *   Purpose: Some Basic Message I/O Fuctions                              *
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

// Enthral SVN: $Id: msgs.cpp 118 2009-08-07 04:34:35Z frank $
// Source: $HeadURL: http://svn.enthralbbs.com/trunk/src/msgs.cpp $
// $LastChangedDate: 2009-08-07 00:34:35 -0400 (Fri, 07 Aug 2009) $
// $LastChangedRevision: 118 $
// $LastChangedBy: frank $

# include <stdio.h>
# include <string>

# include <cstring> //gcc 4.3
# include <cstdlib> // gcc 4.3

# include "struct.h"
# include "msgapi.h"
# include "msgs.h"
# include "conio.h"
# include "language.h"
# include "msg_area.h"

using namespace std;


int msgs::read_emaillist(EmailIdx *em, int recno) {

    int x = 0;
    std::string path = DATAPATH;
    path += "email.dat";

    FILE *fptr = fopen(path.c_str(),"rb+");
    if(fptr == NULL) {
        fptr = fopen(path.c_str(), "wb");
        if(fptr == NULL) {
            perror("Error unable to read email.dat, check permissions!");
            return x;
        }
    }

    if(fseek(fptr,(int)recno*sizeof(EmailIdx),SEEK_SET)==0)
        x=fread(em,sizeof(EmailIdx),1,fptr);

    fclose(fptr);
    return(x);
}

int msgs::save_emaillist(EmailIdx *em, int recno) {

    std::string path = DATAPATH;
    path += "email.dat";

    int x = 0;
    FILE *stream = fopen(path.c_str(),"rb+");
    if(stream == NULL) {
        stream = fopen(path.c_str(), "wb");
        if(stream == NULL) {
           perror("Error unable to write email.dat, check permissions!");
            return x;
        }
    }
    if(fseek(stream,(int)recno*sizeof(EmailIdx),SEEK_SET)==0)
        x = fwrite(em,sizeof(EmailIdx),1,stream);
    fclose(stream);
    return x;
}


int msgs::mbaselist_lockSet(int onoff) {

/*
    std::string path = LOCKPATH;
    path += "mbaselist.lck";

    if (!onoff) {
        remove((char *)path.c_str());
        return TRUE;
    }

    //While lock file missing, create, or loop until it disapears.
    FILE *stream;
    while(1) {
        stream = fopen(path.c_str(),"rb+");
        if(stream == NULL) {
            stream = fopen(path.c_str(), "wb");
            if(stream == NULL) {
                printf("Error mbaselist.lck!");
                return FALSE;
            }
            else {
                fclose(stream);
                return TRUE;
            }
        }
        fclose(stream);
        usleep(10*20000);
    }
    */
}


int msgs::read_mbaselist(mb_list_rec *mr, int rec) {

    int x = 0;
    std::string path = DATAPATH;

    // Sysop Sysop Access vs User Access to Message Areas.
    if (isSysop == TRUE) {
        path += "forums.dat";
    }
    else {
        path += "forums2.dat";
    }

    mbaselist_lockSet(TRUE);
    FILE *fptr = fopen(path.c_str(),"rb+");
    if(fptr == NULL) {
        fptr = fopen(path.c_str(), "wb");
        if(fptr == NULL) {
           perror("Error unable to read forums.dat, check permissions!");
             mbaselist_lockSet(FALSE);
            return x;
        }
    }

    if(fseek(fptr,(int)rec*sizeof(mb_list_rec),SEEK_SET)==0)
        x=fread(mr,sizeof(mb_list_rec),1,fptr);

    fclose(fptr);
    mbaselist_lockSet(FALSE);
    return(x);
}

int msgs::save_mbasetemp(mb_list_rec *mr, int rec) {

    FILE *fptr;
    int x = 0;

    std::string path = DATAPATH;

    // Sysop Sysop Access vs User Access to Message Areas.
    if (isSysop == TRUE) {
        path += "forums.tmp";
    }
    else {
        path += "forums2.tmp";
    }

    mbaselist_lockSet(TRUE);
    fptr=fopen(path.c_str(),"rb+");
    if(fptr==NULL) {
        fptr=fopen(path.c_str(),"wb");
        if(fptr==NULL) {
            perror("Error unable to write forums.tmp, check permissions!");
            mbaselist_lockSet(FALSE);
            return x;
        }
    }

    if(fseek(fptr,(int)rec*sizeof(mb_list_rec),SEEK_SET)==0)
        x=fwrite(mr,sizeof(mb_list_rec),1,fptr);

    fclose(fptr);
    mbaselist_lockSet(FALSE);
    return(x);
}

void msgs::purgeForums2() {

    mbaselist_lockSet(TRUE);
    std::string path = DATAPATH;
    path += "forums2.dat";
    remove((char *)path.c_str());
    mbaselist_lockSet(FALSE);

}

int msgs::save_mbaselist(mb_list_rec *mr, int rec, int force2) {

    std::string path = DATAPATH;

    //force2 will force create from Forum Editor Normal User View of Msg Areas.
    if ((force2 == TRUE) || (isSysop == FALSE)) {
         path += "forums2.dat";
    }
    else {
        path += "forums.dat";
    }
    mbaselist_lockSet(TRUE);
    int x = 0;
    FILE *stream = fopen(path.c_str(),"rb+");
    if(stream == NULL) {
        stream = fopen(path.c_str(), "wb");
        if(stream == NULL) {
            perror("Error unable to write forums.dat, check permissions!");
             mbaselist_lockSet(FALSE);
            return x;
        }
    }
    if(fseek(stream,(int)rec*sizeof(mb_list_rec),SEEK_SET)==0)
        x = fwrite(mr,sizeof(mb_list_rec),1,stream);
    fclose(stream);
     mbaselist_lockSet(FALSE);
    return x;
}

// Count Areas
int msgs::msg_count() {

    int i = 0;
    mb_list_rec mb;

    while(read_mbaselist(&mb,i)) {
        ++i;
    }
    ++i;
    if(i < 1)   i = -1;
    else i--;
    return(i);
}

void msgs::save_msgbase(mb_list_rec *mb) {

    struct _minf m;
    HAREA harea;
    HMSG hmsg;

    char path[255];
    sprintf(path,"%s%s", mb->mbpath, mb->mbfile);

    m.req_version = 0;
    m.def_zone = 1;

    if(MsgOpenApi(&m) == 0 ){
        harea = MsgOpenArea((byte *)path, MSGAREA_CRIFNEC, mb->Type | MSGTYPE_ECHO);
        if(harea != NULL){
            hmsg = MsgOpenMsg(harea, MOPEN_CREATE,0);
            if(hmsg != NULL) MsgCloseMsg(hmsg);
            else printf("\r\nUnable to create message area.");
            MsgCloseArea(harea);
        }
        else printf("\r\nUnable to open %s", path);
        MsgCloseApi();
    }
}

int msgs::msg_find(char *tfile) {

    string temp1, temp2;
    mb_list_rec mb;
    temp1 = (tfile);

    int idx = 0;
    while(read_mbaselist(&mb,idx)){
        temp2 = (mb.mbfile);
        if(temp1 == temp2) return(idx);
        idx++;
    }
    return(-1);
}

int msgs::jlr_lockSet(int onoff) {

    std::string path = LOCKPATH;
    path += "ljr.lck";

    if (!onoff) {
        remove((char *)path.c_str());
        return TRUE;
    }

    //While lock file missing, loop untill it disapears.
    FILE *stream;
    while(1) {
        stream = fopen(path.c_str(),"rb+");
        if(stream == NULL) {   // Lock File Missing
            stream = fopen(path.c_str(), "wb");
            if(stream == NULL) {
                printf("Error jlr.lck!");
                return FALSE;
            }
            else {
                fclose(stream);
                return TRUE;    // Created Lock File
            }
        }
        fclose(stream);
        usleep(10*20000);
    }
}

int msgs::readlr(LastRead *lr, int idx, mb_list_rec *mb) {

    char path[1024]={0};
    //printf("%s%s.jlr", mb->mbpath, mb->mbfile);
    sprintf(path,"%s%s.jlr", mb->mbpath, mb->mbfile);
    jlr_lockSet(TRUE);

    int x = 0;
    FILE *stream;

    stream = fopen(path,"rb+");
    if(stream == NULL) {
        jlr_lockSet(FALSE);
        return (0);
    }
    else fclose(stream);

    stream = fopen(path, "rb");
    if(fseek(stream,(int)idx*sizeof(LastRead),SEEK_SET)==0)
        x = fread(lr,sizeof(LastRead),1,stream);
    fclose(stream);
    jlr_lockSet(FALSE);
    return (x);
}


int msgs::writelr(LastRead *lr, int idx, mb_list_rec *mb) {

    char path[1024]={0};
    sprintf(path,"%s%s.jlr", mb->mbpath, mb->mbfile);
    jlr_lockSet(TRUE);

    FILE *stream;
    int x = 0;

    stream=fopen(path,"rb+");
    if(stream == NULL){
        stream=fopen(path, "wb");
        if(stream == NULL) {
            write(0,path,sizeof(path));
            jlr_lockSet(FALSE);
            sleep(3);
            return 0;
        }
    }
    if(fseek(stream,(int)idx*sizeof(LastRead),SEEK_SET)==0)
        x = fwrite(lr,sizeof(LastRead),1,stream);
    fclose(stream);
    jlr_lockSet(FALSE);
    return (x);
}

unsigned
long msgs::JamAreaGetLast(long usernum, mb_list_rec *mb) {

    LastRead lr;
    memset(&lr,0,sizeof(LastRead));

    if (!readlr(&lr,usernum,mb)) { }

    return (lr.LastReadMsg);
}

void msgs::JamAreaSetLast(long usernum, long msgnum, mb_list_rec *mb) {

    LastRead lr;
    memset(&lr,0,sizeof(LastRead));

    //readlr(&lr,usernum,mb);

    lr.LastReadMsg = msgnum;
    if (!writelr(&lr,usernum,mb)) {}
}


// Counts all Active Mesages excluding Purged!!
unsigned long msgs::CountEmailMsgs(unsigned long mbnum) {

     return 0;
}
/*
// Counts all Active Mesages excluding Purged!!
unsigned long msgs::CountEmailMsgs(unsigned long mbnum) {

    MSGA         *AHandle = NULL;
    MSGH         *mh      = NULL;

    mb_list_rec   mr;
    char path[81] = {0};
    unsigned long totmsg = 0;

    if(!read_mbaselist(&mr,0)){
        return 0;
    }
    sprintf(path,"%s%s",mr.mbpath, mr.mbfile);

    if (AHandle != NULL) {
        MsgCloseArea(AHandle);
        AHandle = NULL;
    }
    AHandle = MsgOpenArea((byte *)path, MSGAREA_CRIFNEC, mr.Type);
    if (AHandle == NULL) {
        totmsg = 0;
    }

    if (MI.high_msg < 1) {
        if (AHandle != NULL) {
            MsgCloseArea(AHandle);
            AHandle = NULL;
        }
        return FALSE;
    }

    lr = GetLastRead(0);
    if (lr > 1) thisuser->lastmsg = lr;
    else thisuser->lastmsg = 1;

    while(thisuser->lastmsg < MI.high_msg){

        if (thisuser->lastmsg < 1) thisuser->lastmsg = 1;
        if(thisuser->lastmsg > MI.high_msg) {
            CloseMsgArea();
            return FALSE;
        }


        mh = MsgOpenMsg(AHandle, MOPEN_RW, thisuser->lastmsg);
        if(mh == NULL) {
            if(AHandle != NULL) {
                MsgCloseArea(AHandle);
                AHandle = NULL;
            }
            return FALSE;
        }



        GetMsg();


        if (strcmp(thisuser->handle,xmsg.To) == 0) {
            ++totmsg;

        }

        MsgCloseMsg(mh);
        ++thisuser->lastmsg;

    }

    if(AHandle != NULL) {
        MsgCloseArea(AHandle);
        AHandle = NULL;
    }
    return totmsg;
}
*/

// Counts all Active Mesages
unsigned long msgs::CountMsgs(unsigned long mbnum) {

    MSGA         *AHandle = NULL;
    mb_list_rec   mr;
    char path[81] = {0};
    unsigned long totmsg = 0;

    if(!read_mbaselist(&mr,mbnum)){
        return 0;
    }
    sprintf(path,"%s%s",mr.mbpath, mr.mbfile);

    if (AHandle != NULL) {
        MsgCloseArea(AHandle);
        AHandle = NULL;
    }
    AHandle = MsgOpenArea((byte *)path, MSGAREA_CRIFNEC, mr.Type);
    if (AHandle == NULL) {
        totmsg = 0;
        return totmsg;
    }

    totmsg = MsgHighMsg(AHandle);
    --totmsg;
    MsgCloseArea(AHandle);
    AHandle = NULL;

    return totmsg;
}


// Counts Active New Mesages
unsigned long msgs::CountNewEmailMsgs(unsigned long mbnum, UserRec *usr) {

    SESSION       s(usr); // Pass User Incase there are MCI Codes for User Info.
    mb_list_rec mr;
    read_mbaselist(&mr,0);

    unsigned long cnt;

    cnt = CountMsgs(0);
    if (cnt == -1) cnt = 0;
    else ++cnt;

    unsigned long lr = JamAreaGetLast(usr->idx,&mr);

    //s.elog ("1. Messages Scan %s,Total #%ld, LR #%ld",mr.mbdisplay,cnt,lr);

    if (lr == -1)   lr = 0;
    else
    if (lr > cnt )  lr = cnt;
    else
    if (lr != 0)  --lr;

    if (cnt == 0)   lr = 0;

    //s.elog ("2. Messages Scan %s,Total #%ld, LR #%ld",mr.mbdisplay,cnt,lr);
    lr = cnt-lr;
    //s.elog ("3. Messages for %s, Total #%ld, LR #%ld",mr.mbdisplay,cnt,lr);
    return lr;
}

// Counts Active New Mesages
unsigned long msgs::CountNewMsgs(unsigned long mbnum, UserRec *usr) {

    SESSION       s(usr); // Pass User Incase there are MCI Codes for User Info.
//    s.errlog2("cnt 1");

    mb_list_rec mr;
    read_mbaselist(&mr,mbnum);

//    s.errlog2("cnt 2");

    unsigned long cnt;

//    s.errlog2("cnt 3, mbnum, %ld",mbnum);
    cnt = CountMsgs(mbnum);
    if (cnt == -1) cnt = 0;
    else ++cnt;

//    s.errlog2("cnt 4, mbnum, %ld",mbnum);
    unsigned long lr = JamAreaGetLast(usr->idx,&mr);

    //s.elog ("1. Messages Scan %s,Total #%ld, LR #%ld",mr.mbdisplay,cnt,lr);

    if (lr == -1)   lr = 0;
    else
    if (lr > cnt )  lr = cnt;
    else
    if (lr != 0)  --lr;

    if (cnt == 0)   lr = 0;

//    s.errlog2("cnt 5");

    //s.elog ("2. Messages Scan %s,Total #%ld, LR #%ld",mr.mbdisplay,cnt,lr);
    lr = cnt-lr;

 //   s.errlog2("cnt 6");
    //s.elog ("3. Messages for %s, Total #%ld, LR #%ld",mr.mbdisplay,cnt,lr);
    return lr;

}

// Counts all Active New Mesages for All Total new waiting per user.
unsigned long msgs::CountAllNewMsgs(UserRec *usr) {

    unsigned long i = 1, cnt = 0;  // Skip Email!
    mb_list_rec mb;
    SESSION       s(usr); // Pass User Incase there are MCI Codes for User Info.

    while(read_mbaselist(&mb,i)) {
        cnt += CountNewMsgs(i,usr);
        ++i;
    }
    ++i;
    if (cnt == -1) cnt = 0;
    return(cnt);
}

// Counts all Active New Mesages for All Total new waiting per user.
unsigned long msgs::CountCurrentNewMsgs(UserRec *usr) {

    unsigned long cnt = 0;  // Skip Email!
    mb_list_rec mb;
    SESSION       s(usr); // Pass User Incase there are MCI Codes for User Info.

//    s.errlog2("CCNM cnt 1");
    read_mbaselist(&mb,CURRENT_MAREA);

//    s.errlog2("CCNM cnt 2");
    cnt = CountNewMsgs(CURRENT_MAREA,usr);

 //   s.errlog2("CCNM cnt 3");

    if (cnt == -1) cnt = 0;
    return(cnt);
}



// Counts all Active New Mesages for All Total new waiting per user.
unsigned long msgs::CountAllNewEmailMsgs(UserRec *usr) {

    unsigned long cnt = 0;
    mb_list_rec mb;
    SESSION       s(usr);

    read_mbaselist(&mb,0);
    cnt = CountNewEmailMsgs(0,usr);
    if (cnt == -1) cnt = 0;
    return(cnt);
}

// New User, Reset all Last Reads.
void msgs::resetlastread(UserRec *usr) {

    unsigned long i = 0;
    mb_list_rec mb;

    while(read_mbaselist(&mb,i)) {
        JamAreaSetLast(usr->idx, 0, &mb);
        ++i;
    }
}

// Message Area Listing - Add Later into Normal MCI Code Parsing!!!
void msgs::ParseMArea(UserRec *usr, std::string &temp) {

    mb_list_rec  mb;      // Message Base # and Name
    SESSION       s(usr); // Pass User Incase there are MCI Codes for User Info.

    int c = 0;
    //std::string temp = "";
    std::string path  = "";
    std::string temp3 = "";
    temp.erase();


    FILE *inStream;
    int  idx = 1;
    int  cnt = 0;
    int  i   = 0;
    int  basenum = 0;
    long lr  = 0;

    char MCI[3]={0};
    char temp2[100]={0};
    int  space  = 0;
    int  foundr = FALSE;
    int  foundl = FALSE;
    int  reset  = FALSE;
    int  dont   = FALSE;

    std::string ans  = "";
    std::string ans1 = "";
    std::string ans2 = "";
    std::string ans3 = "";
    std::string ans4 = "";

    // Prefetch ansi's
    path = ANSIPATH;
    path += "mareamid1.ans";
    if ((inStream = fopen(path.c_str(), "r+")) ==  NULL) {
        return;
    }
    while (c != EOF) {
        c = getc(inStream);
        if (c != EOF) ans1 += c;
    }
    fclose(inStream);
    c = '\0';
    path = ANSIPATH;
    path += "mareamid2.ans";
    if ((inStream = fopen(path.c_str(), "r+")) ==  NULL) {
        return;
    }
    while (c != EOF) {
        c = getc(inStream);
        if (c != EOF) ans2 += c;
    }
    fclose(inStream);
    c = '\0';
    path = ANSIPATH;
    path += "mareamid3.ans";
    if ((inStream = fopen(path.c_str(), "r+")) ==  NULL) {
        return;
    }
    while (c != EOF) {
        c = getc(inStream);
        if (c != EOF) ans3 += c;
    }
    fclose(inStream);
    c = '\0';
    path = ANSIPATH;
    path += "mareamid4.ans";
    if ((inStream = fopen(path.c_str(), "r+")) ==  NULL) {
        return;
    }
    while (c != EOF) {
        c = getc(inStream);
        if (c != EOF) ans4 += c;
    }
    fclose(inStream);

    int area_cnt = 1;
    basenum = msg_count();

    while(read_mbaselist(&mb,idx)) {

        ++idx;


        reset = FALSE;
        temp3.erase();

        if (CURRENT_MAREA == idx-1)
            ans = ans2; // Display HighLight None.
        else
            ans = ans1; // Dispaly Normal None

        // Used to display Areas with new message as #3
        if (dont) {
RESTART:
            temp3.erase();
            if (CURRENT_MAREA == idx-1)
                ans = ans4; // Dispaly HighLight New
            else
                ans = ans3; // Dispaly Normal New
        }

        i = 0;
        c = 0;
        do {
            memset(&MCI,0,sizeof(MCI));
            c = ans[i];
            if (c == '\0') break;

            // Check for Spacing MCI Code
            switch (c) {
              case '{' : // Left Justify
                MCI[0] = ans[++i];
                MCI[1] = ans[++i];
                space = atoi(MCI);

                if (space != 0) {
                    foundl = TRUE;
                }
                else {
                    temp3 += c;
                    temp3 += MCI;
                }
                break;

              case '}' : // Right Justify
                MCI[0] = ans[++i];
                MCI[1] = ans[++i];
                space = atoi(MCI);

                if (space != 0) {
                    foundr = TRUE;
                }
                else {
                    temp3 += c;
                    temp3 += MCI;
                }
                break;

              case '|' : // Pipe Codes
                MCI[0] = ans[++i];
                MCI[1] = ans[++i];
                if (strcmp(MCI,"M#") == 0) {
                    sprintf(temp2,"%i",area_cnt);
                    if (foundl) {
                        s.lspacing(temp2,space);
                        foundl = FALSE;
                    }
                    else if (foundr) {
                        s.rspacing(temp2,space);
                        foundr = FALSE;
                    }
                    temp3 += temp2;
                }
                else if (strcmp(MCI,"MA") == 0) {
                    sprintf(temp2,"%s",mb.mbdisplay);
                    if (foundl) {
                        s.lspacing(temp2,space);
                        foundl = FALSE;
                    }
                    else if (foundr) {
                        s.rspacing(temp2,space);
                        foundr = FALSE;
                    }
                    temp3 += temp2;
                }
                else if (strcmp(MCI,"MT") == 0) {
                    cnt = CountMsgs(idx-1);
                    if (cnt == -1) cnt = 0;
                    else ++cnt;
                    sprintf(temp2,"%i",cnt);
                    if (foundl) {
                        s.lspacing(temp2,space);
                        foundl = FALSE;
                    }
                    else if (foundr) {
                        s.rspacing(temp2,space);
                        foundr = FALSE;
                    }
                    temp3 += temp2;
                }
                else if (strcmp(MCI,"MN") == 0) {
                    // Count how many unread messages
                    cnt = CountMsgs(idx-1);
                    if (cnt == -1) cnt = 0;
                    else ++cnt;

                    lr = JamAreaGetLast(usr->idx,&mb);
                    if (lr == -1)   lr = 0;
                    if (lr > cnt )  lr = cnt;
                    else if (lr != 0) --lr;
                    if (cnt == 0)   lr = 0;

                    // Re-Process and Reset to Correct Mid Ansi
                    if (cnt-lr >= 1 && reset == FALSE && (ans != ans2 || ans != ans4)) {
                        reset = TRUE;
                        goto RESTART;
                    }

                    sprintf(temp2,"%ld",cnt-lr);
                    if (foundl) {
                        s.lspacing(temp2,space);
                        foundl = FALSE;
                    }
                    else if (foundr) {
                        s.rspacing(temp2,space);
                        foundr = FALSE;
                    }
                    temp3 += temp2;
                }
                else {
                    temp3 += c;
                    temp3 += MCI;
                }
                break;

              case '\n' :
            //  temp3 += '\r';
                break;

              default :
                temp3 += c;
                break;
            }
            ++i;

        }
        while (c != '\0');

        temp3 += "\r";
        temp += temp3;
        temp3.erase();
        ++area_cnt;

    }
    // Update Clear Screen

}

