/***************************************************************************
 *   Copyright (C) 2004-2009 by Michael Griffin                            *
 *   mrmisticismo@hotmail.com                                              *
 *                                                                         *
 *   Purpose:                                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

// Enthral SVN: $Id: msg_read.h 110 2009-06-02 02:41:35Z frank $
// Source: $HeadURL: http://svn.enthralbbs.com/trunk/src/msg_read.h $
// $LastChangedDate: 2009-06-01 22:41:35 -0400 (Mon, 01 Jun 2009) $
// $LastChangedRevision: 110 $
// $LastChangedBy: frank $

# ifndef MSG_READ_H
# define MSG_READ_H

# include <time.h>

# include "struct.h"
# include "msg_api.h"
# include "users.h"

# include <string>

typedef struct msgread_ini {

    int iTop;
    int iBot;

    char sVIEW[80];

    char sPAGENUM[80];
    char sPAGETOTAL[80];

    char sMOREUP[80];
    char sMOREUP_CHAR[80];

    char sMOREDOWN[80];
    char sMOREDOWN_CHAR[80];

    char sMOREMSG_ON[80];
    char sMOREMSG_WORD_ON[80];

    char sMOREMSG_OFF[80];
    char sMOREMSG_WORD_OFF[80];

    char sTEXT_COLOR[10];
    char sQUOTE_COLOR[10];

    char sSYS_COLOR[10];
    char sORIGIN_COLOR[10];
    char sANSI_FILE[10];
    char sANSI_HELP[10];
    char sTHEME_NAME[20];
    char sMENU_PROMPT[20];
    char sMENU_PROMPT2[20];

    char sEOM_ON[20];
    char sEOM_WORD_ON[80];

    char sNXT_ON[20];
    char sNXT_WORD_ON[80];

    // Message Read .ini File
    int  msg_exists();
    void msg_create();
    void msg_chkpar(std::string &data);
    void msg_check(std::string cfgdata);
    int  msg_parse(int idx = 0);

}msgread_ini;

class msg_read : private msg_api,
						 msgread_ini,
                         users {
    private:

    int  tTop,
         tBot,
	     firstscan;

    unsigned
    long Views;

    unsigned
    long MsgsLeft;
    unsigned
    long CurMsgs;
    unsigned
    long TotMsgs;

    int opscan; // Email SysOp Scan. Overwrite and view all messages.

    public:
    msg_read();
    void start(UserRec *user);

    // Change Ansi Themes
    int change_theme(int idx=0);

    // Parsing the Message Header
    void ansi_file(char *filename);

    // Process both Normal and email/netmail message reading.
	int  ReadMsg(unsigned long mbnum, int showit, int newmsg, int email=FALSE);

    // Use this for quick message find lateron!
    int  ScanPosters(unsigned long marea);

    int  NewScanEmailMsgs(int newmsg,unsigned long marea);
    int  ScanEmailMessages(unsigned long marea);
    int  ReadEmailMessages(unsigned long marea);

    int  NewScanMsgs(int newmsg,unsigned long marea);
    int  ScanMessages(unsigned long marea);
	int  ReadMessages(unsigned long marea);

    /// Original Gryphon test.

    void MsgScanArea(unsigned long marea);
    int  ReadOrScanMsgs(int ros, int multi);
    int  NextTenMsgs(int email);

    ///
	void JumpToMessage();
	void IgnoreTheRest(unsigned long marea);
	void DelCurMsg(unsigned long mbnum, unsigned long msgnum);
	int  NextAreaScan();

    int  verify_username(char *text, char *name);

    void read_usersig();
    void write_usersig();
    void SetupUserSig();

	void DoPostEmail(int Reply);
	void DoPost(int mbnum, int Reply);
	void SetupMsgPost();
	void DoEdit(int mbnum);
	void EditMessage();
	char *ParseTitleScan(int boxsize);
	void TitleScan(int newscan);
    // Main Message System Reader

    // Email Reader
    int  StartEmailReader(int newmsg, int sysopscan = FALSE);

    // Normal Message Area Reader
    int  StartReader(int newmsg, int allareas = FALSE);

};


# endif
