/***************************************************************************
 *   Copyright (C) 2004-2009 by Michael Griffin                            *
 *   mrmisticismo@hotmail.com                                              *
 *                                                                         *
 *   Purpose:                                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

// Enthral SVN: $Id: msg_read.cpp 120 2009-08-07 05:18:01Z frank $
// Source: $HeadURL: http://svn.enthralbbs.com/trunk/src/msg_read.cpp $
// $LastChangedDate: 2009-08-07 01:18:01 -0400 (Fri, 07 Aug 2009) $
// $LastChangedRevision: 120 $
// $LastChangedBy: frank $

# include <stdio.h>
# include <time.h>
# include <ctype.h>

# include <cstring> // gcc 4.3
# include <cstdlib> // gcc 4.3

# include <string>
# include <fstream>

# include "struct.h"
# include "msgs.h"
# include "conio.h"
# include "users.h"

# include "msg_read.h"
# include "menu_func.h"
# include "msg_fse.h"
# include "msg_api.h"

// WIP
# include "msg_title.h"
# include "msg_email.h"

# include "user_list.h"

using namespace std;

/*
Make sure to put checks in for these max sizes.

#define XMSG_FROM_SIZE  36
#define XMSG_TO_SIZE    36
#define XMSG_SUBJ_SIZE  72

*/
int msgread_ini::msg_exists() {

    iTop = 0;
    iBot = 0;

    strcpy(sVIEW,"");
    strcpy(sPAGENUM,"");
    strcpy(sPAGETOTAL,"");
    strcpy(sMOREUP,"");
    strcpy(sMOREUP_CHAR,"");
    strcpy(sMOREDOWN,"");
    strcpy(sMOREDOWN_CHAR,"");
    strcpy(sMOREMSG_ON,"");
    strcpy(sMOREMSG_WORD_ON,"");
    strcpy(sMOREMSG_OFF,"");
    strcpy(sMOREMSG_WORD_OFF,"");

    strcpy(sTEXT_COLOR,"");
    strcpy(sQUOTE_COLOR,"");
    strcpy(sSYS_COLOR,"");
    strcpy(sORIGIN_COLOR,"");
    strcpy(sANSI_FILE,"");
    strcpy(sANSI_HELP,"");
    strcpy(sTHEME_NAME,"");
    strcpy(sMENU_PROMPT,"");
    strcpy(sMENU_PROMPT2,"");

    strcpy(sEOM_ON,"");
    strcpy(sEOM_WORD_ON,"");

    strcpy(sNXT_ON,"");
    strcpy(sNXT_WORD_ON,"");

    std::string path = INIPATH;
    path += "msgread.ini";

    FILE *stream;
    stream = fopen(path.c_str(),"rb+");
    if(stream == NULL) {
        perror("Error unable to read msgread.ini, check permissions!");
        return false; }
    fclose(stream);
    return true;
}

void msgread_ini::msg_create() {

    std::string name = INIPATH;
    name += "msgread.ini";

    ofstream outStream2;
    outStream2.open( name.c_str(), ofstream::out | ofstream::trunc );
    if (!outStream2.is_open()) {
        printf( "\nError Creating: %s \n", name.c_str());
        return;
    }
    outStream2 << "# Default File Created by Program." << endl;
    outStream2.close();
    return;
}

void msgread_ini::msg_chkpar(std::string &data) {

    std::string temp1;
    int st1 = -1;
    int st2 = -1;
    signed int  ct = -1;

    st1 = data.find('"', 0);
    st2 = data.find('"', st1+1);
    ++st1;
    temp1 = data.substr(st1,st2);
    ct = st2 - st1;
    if (temp1.length() > ct)
        temp1.erase(ct,temp1.length());
    data = temp1;
}

void msgread_ini::msg_check(std::string cfgdata) {

    int id1;
    std::string temp = cfgdata;
    if (temp[0] == '#') return;
    else
    if (temp.find("set VIEW_TYPE ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sVIEW,(char *)temp.c_str());
    }
    else
    if (temp.find("set THEME_NAME ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sTHEME_NAME,(char *)temp.c_str());
    }
    else
    if (temp.find("set ANSI_FILE ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sANSI_FILE,(char *)temp.c_str());
    }
    else
    if (temp.find("set ANSI_HELP ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sANSI_HELP,(char *)temp.c_str());
    }
    else
    if (temp.find("set MENU_PROMPT ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sMENU_PROMPT,(char *)temp.c_str());
    }
    else
    if (temp.find("set MENU_PROMPT2 ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sMENU_PROMPT2,(char *)temp.c_str());
    }
    else
    if (temp.find("set TOP ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        id1 = atoi(temp.c_str());
        iTop = id1;
    }
    else
    if (temp.find("set BOT ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        id1 = atoi(temp.c_str());
        iBot = id1;
    }
    else
    if (temp.find("set PAGENUM ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sPAGENUM,(char *)temp.c_str());
    }
    else
    if (temp.find("set PAGETOTAL ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sPAGETOTAL,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREUP ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sMOREUP,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREUP_CHAR ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sMOREUP_CHAR,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREDOWN ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sMOREDOWN,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREDOWN_CHAR ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sMOREDOWN_CHAR,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREMSG_ON ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sMOREMSG_ON,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREMSG_WORD_ON ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sMOREMSG_WORD_ON,(char *)temp.c_str());
    }
    else
    if (temp.find("set EOM_ON ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sEOM_ON,(char *)temp.c_str());
    }
    else
    if (temp.find("set EOM_WORD_ON ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sEOM_WORD_ON,(char *)temp.c_str());
    }
    else
    if (temp.find("set NXT_ON ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sNXT_ON,(char *)temp.c_str());
    }
    else
    if (temp.find("set NXT_WORD_ON ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sNXT_WORD_ON,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREMSG_OFF ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sMOREMSG_OFF,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREMSG_WORD_OFF ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sMOREMSG_WORD_OFF,(char *)temp.c_str());
    }
    else
    if (temp.find("set TEXT_COLOR ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sTEXT_COLOR,(char *)temp.c_str());
    }
    else
    if (temp.find("set QUOTE_COLOR ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sQUOTE_COLOR,(char *)temp.c_str());
    }
    else
    if (temp.find("set SYS_COLOR ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sSYS_COLOR,(char *)temp.c_str());
    }
    else
    if (temp.find("set ORIGIN_COLOR ", 0) !=
            std::string::npos) {
        msg_chkpar(temp);
        strcpy(sORIGIN_COLOR,(char *)temp.c_str());
    }
}

int msgread_ini::msg_parse(int idx) {

    if (!msg_exists())
        msg_create();

    char name[255]={0};
    char name2[255]={0};

    sprintf(name,"%smsgread.ini",INIPATH);
    sprintf(name2,"%smsgread%i.ini",INIPATH,idx);

    if (idx != 0) strcpy(name,name2);

    // Check if Theme Exists, if not return FALSE.
    FILE *stream;
    stream = fopen(name,"rb+");
    if(stream == NULL) { // File is not Present
        return FALSE;
    }
    else {
        fclose(stream);
    }

    ifstream inStream;
    inStream.open( name );
    if (!inStream.is_open()) {
        //printf("Couldn't Open Config File: %s\n", name);
        perror("Error unable to parse msgread.ini, check permissions!");
        return FALSE;
    }

    std::string cfgdata;
    for (;;) {
        std::getline(inStream,cfgdata,'\n');
        msg_check(cfgdata);
        if(inStream.eof()) break;
    }
    inStream.close();
    return TRUE;
}


msg_read::msg_read() {

    mh      = NULL;
    AHandle = NULL;
    tTop    = 1;
    tBot    = 1;
    Views   = 0;
    opscan  = FALSE;
}


void msg_read::start(UserRec *user) {

    thisuser = user;

    // Check What Theme user has selected.
    if (msg_parse(thisuser->readertheme) == FALSE)
        msg_parse();

    tTop = iTop;
    tBot = iBot;
}

int msg_read::change_theme(int idx) {

    // Check What Theme user has selected.
    if (msg_parse(idx) == FALSE)
        return FALSE;

    thisuser->readertheme = idx;

    // Save User Settings.
    UserRec usr;
    usr = *thisuser;
    users _usr;
    _usr.users_write(&usr,usr.idx);

    tTop = iTop;
    tBot = iBot;
    return TRUE;
}

void msg_read::ansi_file(char *filename) {

    std::string path = ANSIPATH;
    path += filename;
    path += ".ans";

    char MCI[3]     = {0};   // Holds MCI Codes to Parse
    char sTemp[255] = {0};
    int  space = 0, foundr = 0 , foundl = 0;
//    int  c = 0;
    std::string buff;
    unsigned long cnt = 0,cnt2 = 0;

    // Buffer in Ansi
    /*
    FILE *inStream;
    if ((inStream = fopen(path.c_str(), "r+")) ==  NULL) {
        return;
    }
    do {
        c = getc(inStream);
        if  (c != EOF) buff += c;
    } while (c != EOF);
    fclose(inStream);
*/
    readinAnsi(filename, buff);

    sprintf(sTemp,"%s", (char *)mHead.curmsg);
    cnt  = atoi(sTemp);
    CurMsgs = cnt;

    sprintf(sTemp,"%s", (char *)mHead.totmsg);
    cnt2 = atoi(sTemp);
    TotMsgs = cnt2;
    if (cnt > cnt2) cnt = cnt2;
   // sprintf(sTemp,"%ld", cnt2-cnt);
    MsgsLeft = cnt2-cnt;

    int id1 = 0;
    do {
        // parse justify spacing right / left passing in string before
        // replacing mci code. to Properly Space Output Ansi.
        id1 = buff.find("%", 0);
        if (id1 == -1) break;
        memset(&MCI,0,sizeof(MCI));
        space = 0;
        // Check if MCI Code is Justified then Process this.
        if (buff[id1+3] == '{') { // Left Justify
            //elog("left justify: %c%c",buff[id1+4],buff[id1+5]);
            MCI[0] = buff[id1+4]; // Get first Digit
            MCI[1] = buff[id1+5]; // Get Second Digit
            space  = atoi(MCI);
            foundr = FALSE;
            foundl = TRUE;
        }
        else
        if (buff[id1+3] == '}') { // Right Justify
            //elog("right justify: %c%c",buff[id1+4],buff[id1+5]);
            MCI[0] = buff[id1+4]; // Get first Digit
            MCI[1] = buff[id1+5]; // Get Second Digit
            space  = atoi(MCI);
            //elog("right justify: %i",space);
            foundl = FALSE;
            foundr = TRUE;
        }
        // Now Get MCI Code
        MCI[0] = buff[id1+1]; // Get first Digit
        MCI[1] = buff[id1+2]; // Get Second Digit

        memset(&sTemp,0,sizeof(sTemp));
        // Insert MCI Parsing here so we can reaplace full result with propering spacing.


        if (strcmp(MCI,"TI") == 0)    {
            sprintf(sTemp,"%s", (char *)mHead.time); }
        else
        if (strcmp(MCI,"FM") == 0) {
            sprintf(sTemp,"%s", (char *)mHead.from); }
        else
        if (strcmp(MCI,"TO") == 0) {
            sprintf(sTemp,"%s", (char *)mHead.to); }
        else
        if (strcmp(MCI,"FL") == 0) {
            sprintf(sTemp,"%s", (char *)mHead.flags); }
        else
        if (strcmp(MCI,"MA") == 0) {
            sprintf(sTemp,"%s", (char *)mHead.area); }
        else
        if (strcmp(MCI,"SU") == 0) {
            sprintf(sTemp,"%s", (char *)mHead.subj); }
        else
        if (strcmp(MCI,"CM") == 0) {
            sprintf(sTemp,"%s", (char *)mHead.curmsg); }
        else
        if (strcmp(MCI,"HM") == 0) {
            sprintf(sTemp,"%s", (char *)mHead.totmsg); }
        else
        if (strcmp(MCI,"ML") == 0) {
            sprintf(sTemp,"%ld", cnt2-cnt);
        }
        else
        if (strcmp(MCI,"TH") == 0) {
            sprintf(sTemp,"#%i. %s",thisuser->readertheme+1,sTHEME_NAME); }

        // MCI Translation .
        if (foundl == TRUE) {
            lspacing(sTemp,space);
        }
        else
        if (foundr == TRUE) {
           rspacing(sTemp,space);
        }

        //If we Parsed Justify, then Erase that MCI Code as well.
        (space != 0) ?
            buff.replace(id1,6,sTemp):
            buff.replace(id1,3,sTemp);
    }
    while (1);
    //elog("Finished Parsing MCI Codes...");
    pipe2ansi((char *)buff.c_str());
}



int msg_read::ReadMsg(unsigned long marea, int showit, int newmsg, int email) {

    //errlog2("ReadMsg");
    unsigned long lr = 0;
    if(!OpenMsgArea(marea)){
        return FALSE;
    }

    // On first scan, get last read, else just go by lastmsg!
    if (newmsg && firstscan) {
        lr = GetLastRead(thisuser->idx);
        if (lr > 1) thisuser->lastmsg = lr;
        else thisuser->lastmsg = 1;
        firstscan = FALSE;
    }

    if (thisuser->lastmsg < 1) thisuser->lastmsg = 1;

    //Not sure if this is a valid check here!
    if(thisuser->lastmsg > MI.high_msg) {
        CloseMsgArea();
        return FALSE;
    }

    mh = MsgOpenMsg(AHandle, MOPEN_RW, thisuser->lastmsg);
    if(mh == NULL) {
        CloseMsgArea();
        return FALSE;
    }

    GetMsg();
    if (showit) {

        if (email == TRUE && strcmp(thisuser->handle,MI.To) == 0) {
            MsgSetupTxt();  // Normal Message Reader
        }
        else if (email == TRUE && strcmp(thisuser->handle,MI.To) != 0 && opscan == FALSE) {
            // Blank, don't populate header or message!
        }
        else if (email == FALSE) {
            MsgSetupTxt();  // Normal Message Reader (No Email)
            ++Views;
        }
        else {
            MsgSetupTxt();  // Normal Message Reader (No Email) / Or Sysop Email Read.
            if (opscan != TRUE) ++Views;
        }

    }
    else {
        SetupMsgHdr(); // Title Scan
    }

    // Make Sure Late Read is always set as first message.
    if ((newmsg == TRUE) && (showit == TRUE)) {
        lr = GetLastRead(thisuser->idx);
    }
    // Don't set last Read to lower number if scanning backwards!
    if (thisuser->lastmsg >= lr && (newmsg) && (showit)) {
        SetLastRead(thisuser->idx,thisuser->lastmsg+1);
    }
    MsgCloseMsg(mh);
    CloseMsgArea();
    return TRUE;
}



/*
int msg_read::ReadMsg(unsigned long mbnum, unsigned long  msgnum, int showit)
{
    int retval=TRUE;

    if (AHandle != NULL) {
        CloseMsgArea();
    }
    if(!OpenMsgArea(mbnum)) {
        //if(showit)
        //language(1318);
        retval=FALSE;
    }
    if((msgnum < 1) || (msgnum > MI.high_msg)) {
        retval=FALSE;
    }

    if(retval) {
        mh= MsgOpenMsg(AHandle, MOPEN_RW,msgnum);
        if(mh != NULL){
            GetMsg();
            if(showit) {
                MsgSetupTxt();  // Normal Message Reader
            }
            SetLastRead(thisuser->idx,msgnum);
        }
        else {
            retval=FALSE;
        }
    }
    if (AHandle != NULL) {
        CloseMsgArea();
    }
    return retval;
}
*/

void msg_read::MsgScanArea(unsigned long marea)
{
    char from[41],subj[41];
    int done=FALSE,count=0;
    unsigned long LastRead=1L;
    char timestr[81];
    time_t tmt;
    struct tm *mtm;

    if(!OpenMsgArea(marea)){
        printf("Unable to read message base %s",marea);
        return;
    }
    CloseMsgArea();
    //language(1489);
    //language(1490);

    while(ReadMsg(marea,LastRead,FALSE)){
        ++LastRead;
        GetMsg();
        Add2MsgInfo();
        tmt = stampToTimeT(&MI.date_written);
        mtm=localtime(&tmt);
        strftime(timestr,81,"%m/%d",mtm);
        strcpy(from,MI.From);

        pipe2ansi(from);
        strcpy(subj,MI.Subj);

        pipe2ansi(subj);

        //mcistrset(from,20);
        //mcistrset(subj,40);

        pipe2ansi(timestr);

        //int2A(1,MI.cur_msg);
        //char2A(2,timestr);
        //char2A(3,from);
        //char2A(4,subj);
        //language(1492);
        count++;
        if(count>23){
            count=0;
            //if(ync()=='N')  done=TRUE;
            if (getkey(true) == 'N') done = TRUE;
        }
    }
    //mci("~SM~SP");
    pipe2ansi((char *)":");
}

int msg_read::ReadOrScanMsgs(int ros, int multi)
{
    int retval=TRUE;

    int total_mbases;
    total_mbases = _msgf.msg_count();

    do{

        if(ros) retval=ReadMsg(thisuser->lastmbarea,thisuser->lastmsg,TRUE);
        else    NextTenMsgs(thisuser->lastmbarea);
        if(!retval && multi && thisuser->lastmbarea < total_mbases){
            thisuser->lastmbarea++;
            if(OpenMsgArea(thisuser->lastmbarea)){
                CloseMsgArea();
                thisuser->lastmsg=1L;
                thisuser->lastmsg=GetLastRead(thisuser->idx);
                //language(1250);
                }
            else
                thisuser->lastmbarea--;
            }

        }while(!retval && (thisuser->lastmbarea < total_mbases-1) && multi);

    if(!retval && multi){
        thisuser->lastmbarea--;
        }

    return retval;
}

int msg_read::NextTenMsgs(int email)
{
    char sLine[1024]={0};

    int i,retval=TRUE;

    if(!OpenMsgArea(thisuser->lastmbarea)){
        printf("\nThis message area is unavailable.");
        retval=FALSE;
        return retval;
    }
    CloseMsgArea();

    // language(1075);
    // language(1076);
    i = thisuser->lastmsg+10;

    std::string output;
    int total_emails = 0;  // Setup a count of total emails here!
    int page = 0, total_pages = 1;

    output += "|CS|11 Message Scan";
    output += "|CR|15--------------------------------------------------------------";
    sprintf(sLine,"|CR |07Total Messages|08: |11%d |07Page|08: |03%.2d|07 / |03%.2d|CR|CR",total_emails,page+1,total_pages);
    output += sLine;
    sprintf(sLine,"|13%03s |09%02s |11%20s |03%20s |07%30s|CR","New","#","From", "Subject","Date/Time");
    output += sLine;
    output += "----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----|CR";
    pipe2ansi((char *)output.c_str());

    while(thisuser->lastmsg < i && thisuser->lastmsg < MI.high_msg){

        ReadMsg(thisuser->lastmbarea,FALSE,FALSE,email);
        //GetMsgInfo(); // Newly Testing for populating MI.high_msg properly.
        if (strcmp(thisuser->handle,MI.To) == 0) {
            sprintf(sLine,"|13%03s |09%02ld |11%20s |03%20s |07%30s|CR","*",thisuser->lastmsg,MI.From, MI.Subj, mHead.time);
            pipe2ansi(sLine);
            //int2A(2,thisuser.lastmsg);
            //putline(thisuser->lastmsg);
        }
        else {
            // Add 1 more to total if we skip one, so page always has same amount!
            ++i;

        }
        thisuser->lastmsg++;

    }
    //mci("~SM");
    pipe2ansi((char *)"|CR|PA");
    return retval;

}

int msg_read::ScanPosters(unsigned long marea)  {

    if(!OpenMsgArea(marea)){
        return FALSE;
    }

    mh = MsgOpenMsg(AHandle, MOPEN_RW, thisuser->lastmsg);
    if(mh == NULL) {
        CloseMsgArea();
        return FALSE;
    }
    SetupMsgHdr();
    CloseMsgArea();
    return TRUE;
}


// These Email Fucntions are for Email and Netmail!
int msg_read::NewScanEmailMsgs(int newmsg,unsigned long marea) {

    return (ReadMsg(marea, TRUE, newmsg, TRUE));
}

int msg_read::ScanEmailMessages(unsigned long marea) {

    return (NewScanEmailMsgs(TRUE, marea));
}

int msg_read::ReadEmailMessages(unsigned long marea) {

    return (NewScanEmailMsgs(FALSE, marea));
}


int msg_read::NewScanMsgs(int newmsg,unsigned long marea) {

    return (ReadMsg(marea, TRUE, newmsg));
}

int msg_read::ScanMessages(unsigned long marea) {

    return (NewScanMsgs(TRUE, marea));
}

int msg_read::ReadMessages(unsigned long marea) {

    return (NewScanMsgs(FALSE, marea));
}

void msg_read::JumpToMessage() {

    char choice[100]={0};
    std::string AnsiString = "";
    char szTmp[3]={0};
    char szReplace[10]= {0};
    int  id1 = 0;

    _lang.lang_get(choice,25);
    AnsiString = choice;
    id1 = AnsiString.find("|HM",0);
    if (id1 != -1) {
        szTmp[0] = AnsiString[id1+1];
        szTmp[1] = AnsiString[id1+2];
        if(!OpenMsgArea(thisuser->lastmbarea)) {
            return;
        }
        CloseMsgArea();
        //OpenMsgArea(thisuser->lastmbarea);
        sprintf(szReplace,"%i",MI.high_msg);
        AnsiString.replace(id1,3,szReplace);
    }

    int len = strlen(szReplace)+1;
    strcpy(choice,AnsiString.c_str());
    inputfield(choice,len);
    pipe2ansi(choice);
    getline(choice,len);

    if (atoi(choice) <= MI.high_msg)
        thisuser->lastmsg = atoi(choice);
    if (thisuser->lastmsg == 0) thisuser->lastmsg = 1;

}

void msg_read::IgnoreTheRest(unsigned long marea) {

    if(!OpenMsgArea(marea)){
        return;
    }
    GetMsgInfo(); // Newly Testing for populating MI.high_msg properly.
    CloseMsgArea();
    SetLastRead(thisuser->idx,MI.high_msg+1);

}

void msg_read::DelCurMsg(unsigned long mbnum, unsigned long msgnum) {

    char text[100]={0};
    unsigned char ch;
    int idx;

    _lang.lang_get(text,28);
    int len = 3;
    inputfield(text,len);
    pipe2ansi(text);
    ch = getkey(true);
    putkey(ch);

    if (toupper(ch) == 'Y') {
        if (mbnum == 0) { // Email is always first directory.
            // If Email let sending or poster delete.
            if ((strcmp(thisuser->handle,mHead.from) == 0) || (strcmp(thisuser->handle,mHead.to) == 0) || (isSysop == TRUE)) {
                //continue;
            }
            else {
                // Then user can't remove this message, add Security check
                // later on for sysop / cosysop
                memset(&text,0,sizeof(text));
                _lang.lang_get(text,21);
                pipe2ansi(text);
                return;
            }
        }
        else
        if (strcmp(thisuser->handle,mHead.from) != 0) {
            // Then user can't remove this message, add Security check
            // later on for sysop / cosysop
            memset(&text,0,sizeof(text));
            _lang.lang_get(text,21);
            pipe2ansi(text);
            return;
        }
    }
    else
        return;

    //OpenMsgArea(mbnum);
    if(!OpenMsgArea(mbnum)){
        return;
    }
    MsgKillMsg(AHandle,msgnum);
    CloseMsgArea();

    // Reset Evenyone's Last Read Pointer if it's Greater Then message num = -1!
    users _usr;
    int iTotal = _usr.idx_count();
    for (int iCnt = 0; iCnt != iTotal; iCnt++) {
        idx = GetLastRead(iCnt);
        // Last Read, >= Deleted Message, set Last Read Down
        if (idx >= msgnum) {
            --idx;
        }
        SetLastRead(iCnt,idx);
    }
    // Write History.
    hist_update(HIST_DELETES,thisuser);
}

int msg_read::NextAreaScan() {

    int total;
    total = _msgf.msg_count();
    //printf("\nNextArea: total %i, lastmbarea %i",  total, thisuser->lastmbarea);
    if(thisuser->lastmbarea < (total-1)) {

        ++thisuser->lastmbarea;
        CURRENT_MAREA = thisuser->lastmbarea;
        firstscan = TRUE;
        return TRUE;
    }
    return FALSE;
}

int msg_read::verify_username(char *text, char *name) {

    UserRec u;
    UserIdx index;
    memset(&u,0,sizeof(UserRec));
    memset(&index,0,sizeof(UserIdx));

    unsigned long usernum;
    usernum = atoi(name); // Check if User Number was entered.
    if (usernum != 0) {
        if (idx_read(&index,usernum-1)) {
            //elog("User # found: %i, %s",usernum, index.handle);
            strcpy(u.handle,index.handle);

            // Redisplay prompt
            pipe2ansi(text);
            putline(u.handle);  // Also Ask to verify this is correct.
            return TRUE;
        }
        else {
            //elog("User # NOT found: %i, %s",usernum, name);
            return FALSE;
        }
    }
    else
    if(idx_match(name)) {
        strcpy(u.handle,name);
        //elog("User Name found: %i, %s",usernum, name);
        return TRUE;
    }
    else {
        //elog("User Name NOT found: %i, %s",usernum, name);
        return FALSE;
    }
}


void msg_read::read_usersig() {

    std::string data;
    char usersig[255]={0};
    sprintf(usersig,"%s%i.sig",USRSIG,thisuser->idx);
    ifstream ins;
    ins.open( usersig );
    if (!ins.is_open()) {
        errlog((char *)"read_usersig(); error, can't find file");
        return;
    }

    buff.erase();
    for (;;) {
        if (ins.eof()) break;
        std::getline(ins,data,'\r');
        buff += data;

        if (ins.eof()) break;
        buff += '\r';
    }
    ins.close();

    // remove ending \r
    //buff = buff.substr(0,buff.size()-1 );
    return;
}


void msg_read::write_usersig() {

    char usersig[255]={0};
    sprintf(usersig,"%s%i.sig",USRSIG,thisuser->idx);

    // Clear or Remove Sig and Return if Blank.
    if (buff == "") {
        remove(usersig);
        return;
    }

    ofstream ostr;
    ostr.open( usersig, ofstream::out | ofstream::trunc );
    if (!ostr.is_open()) {
        errlog((char *)"write_usersig(); error, can't find file");
        return;
    }

    ostr << buff;
    buff.erase();
    ostr.close();
}

void msg_read::SetupUserSig() {

    int  exists = FALSE, save=FALSE;
    std::string tmp;
    char text[1024]={0};

    MsgHead     mHLocal; // Message Header Infor to pass to FSE / Quoter.
    msg_readll  mLinkll; // Message Text;

    memset(&mHLocal,0,sizeof(MsgHead));

    // Check if Exists already in usersig folder.
    char usersig[255]={0};
    sprintf(usersig,"%s%i.sig",USRSIG,thisuser->idx);
    FILE *stream=fopen(usersig,"rb+");
    if(stream != NULL){
        exists = TRUE;
        fclose(stream);
    }

    buff.erase();
    msg_fse _msge(thisuser); // INIT FSE

    strcpy(mHLocal.to,"all");
    strcpy(mHLocal.from,thisuser->handle);
    strcpy(mHLocal.subj,"Edit Auto Signature");
    strcpy(mHLocal.area,"Internal Editor");

    if (exists == TRUE) {
        // Send Original Message for Quoter to FSE.
        read_usersig();
        mLinkll.PutBufferSig((char *)buff.c_str());
        save = _msge.poll_chr(FALSE, TRUE, &mHLocal, &mLinkll);
    }
    else {
        // Start Fresh
        save = _msge.poll_chr(FALSE, FALSE, &mHLocal);
    }

    // Aborted.
    if (!save) {
        _lang.lang_get(text,35);
        pipe2ansi(text);
        return;
    }

    // Get the Buffer back from FSE on Completed Message.
    buff = _msge.buffer;
    write_usersig();

    _lang.lang_get(text,34);
    pipe2ansi(text);
}

void msg_read::DoPostEmail(int Reply) {

    struct tm *tm;
    time_t timet;
    char rep[51]={0}, text[100]={0};
    int  save, idx;
    std::string tmp;

    char to[21]   = {0};
    char from[21] = {0};
    char subj[61] = {0};

    UserIdx uidx;

    // Message Header Infor to pass to FSE / Quoter.
    MsgHead mHLocal;



    if(!OpenMsgArea(0)){
        return;
    }
    CloseMsgArea();

    xmsg.orig.zone  = mr.aka.zone;
    xmsg.orig.net   = mr.aka.net;
    xmsg.orig.node  = mr.aka.node;
    xmsg.orig.point = mr.aka.point;

    time(&timet);
    tm = localtime(&timet);
    xmsg.date_written = *timeTToStamp(timet);
    xmsg.date_arrived = *timeTToStamp(timet);

    xmsg.attr=0;
    xmsg.attr |= MSGLOCAL;

    if (Reply) {
        strcpy(to,mHead.from);
    }
    else {

        // Get To from User Listing.
        usr_list _ulist;
        _ulist.SetupEmailList(thisuser);
        idx = _ulist.StartList();

        memset(&uidx,0,sizeof(UserIdx));
        if (idx != EOF) idx_read(&uidx,idx);
        else {
            return; // Aborted!
        }
    }

    // Display header.
    ansiPrintf((char *)"askemail");

    // Get TO:
    _lang.lang_get(text,47);
    int len = 20;
    inputfield(text,len);
    pipe2ansi(text);
    if (!Reply) {
        strcpy(to,uidx.handle);
    }
    pipe2ansi(to);
    //getline(to,sizeof(to),to);

    // Get SUBJECT:
    _lang.lang_get(text,48);
    len = 60;
    inputfield(text,len);
    pipe2ansi(text);

    // Mesasge Reply, Data Alreadt in mHead for Current Message.
    if (Reply) {
        strcpy(subj,mHead.subj);
        // Add Re: to First Replies Only!
        std::string sRe;
        if (subj != 0) {
            if (subj[0] != 'R' && subj[1] != 'e' && subj[2] != ':') {
                sRe = "Re: ";
                sRe += subj;
                strcpy(subj,(char *)sRe.c_str());
            }
            getline(subj,len,subj);
        }
        else getline(subj,len);
    }
    else {
        getline(subj,len);
    }

    // Blank Subject Return!
    if (strcmp(subj,"") == 0) {
        return;
    }

    // Get From:
    strcpy(from, thisuser->handle);
    buff.erase();

    // Get Current (Mesage Area)
    msgs _msgf;
    _msgf.read_mbaselist(&mr, 0);

    if(mr.Kind == NETMAIL){
        //get_address(&xmsg);  Disable for Now
        xmsg.attr |= MSGPRIVATE;
        xmsg.attr |= MSGCRASH;
    }

    *rep = '\0';
    if (Reply) {
        GetMsgID(rep);
        strrepl(rep,50,"MSGID","REPLY");
        MakeCtrlHdr(rep);
    }
    else MakeCtrlHdr(rep);


    // Setup Mesasge Header Information
    // To Pass to FSE / Message Quoter.
    strcpy(mHLocal.to,to);
    strcpy(mHLocal.from,from);
    strcpy(mHLocal.subj,subj);
    strcpy(mHLocal.area,(const char *)mr.mbdisplay);

    // If were in reply, send current Message text to FSE for Quoting!
    msg_fse _msge(thisuser); // INIT
    if (Reply) {
        // Send Original Message for Quoter to FSE.
        save = _msge.poll_chr(Reply, FALSE, &mHLocal, &mLink);
    }
    else {
        // Start Fresh
        save = _msge.poll_chr(Reply, FALSE, &mHLocal);
    }
    if (!save) {
        _lang.lang_get(text,35);
        pipe2ansi(text);
        return;
    }

    // Get the Buffer back from FSE on Completed Message.
    buff = _msge.buffer;

    // Now append user signature.
    tmp = buff;
    buff.erase();

    read_usersig();

    // Process Sig if exists.
    read_usersig();
    if (buff.size() > 1) {
        tmp += "\r";
        buff.erase(buff.size()-1,1);
        tmp += buff;
    }

    tmp += buff;
    buff = tmp;

    //Add System Tag && Origin Line - Only add to NETMAIL! lateron.
    /*
    if (mr.Kind != LOCAL) {
        if (mr.aka.point != 0) {
            sprintf(faddr," (%d:%d/%d.%d)",
                mr.aka.zone, mr.aka.net, mr.aka.node, mr.aka.point);
        }
        else {
            sprintf(faddr," (%d:%d/%d) ",
                mr.aka.zone, mr.aka.net, mr.aka.node);
        }
        buff += "\r--- ";
        buff += BBSVERSION;
        buff += " ";
        buff += OSSYSTEM;
        buff += "\r * Origin: ";
        buff += mr.OriginLine;
        buff += faddr;
    }
    */

    strcpy((char*)xmsg.from, mHLocal.from);
    strcpy((char*)xmsg.to,   mHLocal.to);
    strcpy((char*)xmsg.subj, mHLocal.subj);

    SaveMsg(0,0,TRUE);

    _lang.lang_get(text,34);
    pipe2ansi(text);

    hist_update(HIST_EMAILS,thisuser);
}

void msg_read::DoPost(int mbnum, int Reply) {

    struct tm *tm;
    time_t timet;
    char rep[51]={0}, text[100]={0};
    int  save;
    char faddr[81]={0};
    std::string tmp;

    char to[21]   = {0};
    char from[21] = {0};
    char subj[61] = {0};


    // Message Header Infor to pass to FSE / Quoter.
    MsgHead mHLocal;
    if(!OpenMsgArea(mbnum)){
        pipe2ansi("unable to post to message area!");
        return;
    }
    CloseMsgArea();

    xmsg.orig.zone  = mr.aka.zone;
    xmsg.orig.net   = mr.aka.net;
    xmsg.orig.node  = mr.aka.node;
    xmsg.orig.point = mr.aka.point;

    time(&timet);
    tm = localtime(&timet);
    xmsg.date_written = *timeTToStamp(timet);
    xmsg.date_arrived = *timeTToStamp(timet);

    xmsg.attr=0;
    xmsg.attr |= MSGLOCAL;

    // Get Current (Mesage Area)
    msgs _msgf;
    _msgf.read_mbaselist(&mr, thisuser->lastmbarea);

    // Test if Sysop Base, then only sysop may post!
    if (strcmp(mr.mbfile,"system") == 0 || strcmp(mr.mbfile,"notice") == 0) {
        if (isSysop == FALSE) {
            pipe2ansi((char *)"|CR Sorry, only Sysop's may post to this area!");
            sleep(1);
            return;
        }
    }

    *rep = '\0';
    if (Reply) {
        GetMsgID(rep);
        strrepl(rep,50,"MSGID","REPLY");
        MakeCtrlHdr(rep);
    }
    else MakeCtrlHdr(rep);

    if(mr.Kind == NETMAIL){
        //get_address(&xmsg);  Disable for Now
        xmsg.attr |= MSGPRIVATE;
        xmsg.attr |= MSGCRASH;
    }

    // Get TO:
    _lang.lang_get(text,20);
    int len = 20;
    inputfield(text,len);
    pipe2ansi(text);

    if (Reply) {
        strcpy(to,mHead.from);
        getline(to,len,to);
    }
    else {
        strcpy(to,"all");
        getline(to,len,to);
    }

    // Get SUBJECT:
    _lang.lang_get(text,19);
    len = 60;
    inputfield(text,len);
    pipe2ansi(text);

    // Mesasge Reply, Data Alreadt in mHead for Current Message.
    if (Reply) {
        strcpy(subj,mHead.subj);
        // Add Re: to First Replies Only!
        std::string sRe;
        if (subj != 0) {
            if (subj[0] != 'R' && subj[1] != 'e' && subj[2] != ':') {
                sRe = "Re: ";
                sRe += subj;
                strcpy(subj,(char *)sRe.c_str());
            }
            getline(subj,len,subj);
        }
        else getline(subj,len);
    }
    else {
        getline(subj,len);
    }

    // Blank Subject Return!
    if (strcmp(subj,"") == 0) return;

    // Get From:
    strcpy(from, thisuser->handle);
    buff.erase();

    // Setup Mesasge Header Information
    // To Pass to FSE / Message Quoter.
    strcpy(mHLocal.to,to);
    strcpy(mHLocal.from,from);
    strcpy(mHLocal.subj,subj);
    strcpy(mHLocal.area,(const char *)mr.mbdisplay);

    // If were in reply, send current Message text to FSE for Quoting!
    //elog ("just in message editor");
    msg_fse _msge(thisuser); // INIT
    if (Reply) {
        // Send Original Message for Quoter to FSE.
        save = _msge.poll_chr(Reply, FALSE, &mHLocal, &mLink);
    }
    else {
        // Start Fresh
        save = _msge.poll_chr(Reply, FALSE, &mHLocal);
    }
    if (!save) {
        _lang.lang_get(text,35);
        pipe2ansi(text);
        return;
    }

    // Get the Buffer back from FSE on Completed Message.
    buff = _msge.buffer;

    // Now append user signature.
   // buff += "\r";
    tmp = buff;
    buff.erase();

    // Process Sig if exists.
    read_usersig();
    if (buff.size() > 1) {
        tmp += "\r";
        buff.erase(buff.size()-1,1);
        tmp += buff;

        // WE have echomail, add \r after sig
         if (mr.Kind != LOCAL && mr.Kind != EMAIL) {
             tmp += "\r";
        }
    }

    buff = tmp;

    //Add System Tag && Origin Line
    if (mr.Kind != LOCAL && mr.Kind != EMAIL) {
        if (mr.aka.point != 0) {
            sprintf(faddr," (%d:%d/%d.%d)",
                mr.aka.zone, mr.aka.net, mr.aka.node, mr.aka.point);
        }
        else {
            sprintf(faddr," (%d:%d/%d) ",
                mr.aka.zone, mr.aka.net, mr.aka.node);
        }

        buff += "\r--- ";
        buff += BBSVERSION;
        buff += " ";
        buff += OSSYSTEM;
        buff += "\r * Origin: ";
        buff += mr.OriginLine;
        buff += faddr;
    }

    strcpy((char*)xmsg.from, mHLocal.from);
    strcpy((char*)xmsg.to,   mHLocal.to);
    strcpy((char*)xmsg.subj, mHLocal.subj);

    memset(&text,0,sizeof(text));
    SaveMsg(mbnum,0,TRUE);

    //elog ("print saving");
    _lang.lang_get(text,34);
    pipe2ansi(text);

    // Write History.
    if (Reply) hist_update(HIST_REPLIES,thisuser);
    else hist_update(HIST_POSTS,thisuser);

    // Local Posts or Echomail
    if (mr.Kind != LOCAL && mr.Kind != EMAIL) {
        hist_update(HIST_POSTS,thisuser);
    }
    else hist_update(HIST_LOCAL,thisuser);
}

void msg_read::SetupMsgPost() {

    DoPost(thisuser->lastmbarea,FALSE);
}

void msg_read::DoEdit(int mbnum) {

    struct tm *tm;
    time_t timet;
    char rep[100]    = {0};
    char faddr[100]  = {0};
    char tag[100]    = {0};
    char origin[100] = {0};
    char text[100]   = {0};

    int  save;
    unsigned
    char ch;

    //OpenMsgArea(mbnum);
    if(!OpenMsgArea(mbnum)){
        return;
    }
    CloseMsgArea();

    xmsg.orig.zone  = mr.aka.zone;
    xmsg.orig.net   = mr.aka.net;
    xmsg.orig.node  = mr.aka.node;
    xmsg.orig.point = mr.aka.point;

    time(&timet);
    tm = localtime(&timet);
    xmsg.date_written = *timeTToStamp(timet);
    xmsg.date_arrived = *timeTToStamp(timet);

    xmsg.attr=0;
    xmsg.attr |= MSGLOCAL;

    if(mr.Kind == NETMAIL){
        //get_address(&xmsg);  Disable for Now
        xmsg.attr |= MSGPRIVATE;
        xmsg.attr |= MSGCRASH;
    }

    *rep = '\0';
    MakeCtrlHdr(rep);

    strcpy((char*)xmsg.from, mHead.from);
    strcpy((char*)xmsg.to, mHead.to);
    strcpy((char*)xmsg.subj, mHead.subj);

    // Setup System Tag && Origin Line
    if (mr.Kind != LOCAL) {
        if (mr.aka.point != 0) {
            sprintf(faddr," (%d:%d/%d.%d)",
                mr.aka.zone, mr.aka.net, mr.aka.node, mr.aka.point);
        }
        else {
            sprintf(faddr," (%d:%d/%d) ",
                mr.aka.zone, mr.aka.net, mr.aka.node);
        }
        sprintf(tag,"--- %s %s",BBSVERSION,OSSYSTEM);
        sprintf(origin," * Origin: %s%s",mr.OriginLine,faddr);
    }


    buff.erase();

    mLink.cleartags(tag,origin);
    mLink.line_total();

   // putline ("\nout!!!");
    msg_fse _msge(thisuser);

    save = _msge.poll_chr(FALSE, TRUE, &mHead, &mLink);
    if (!save) {
        _lang.lang_get(text,35);
        pipe2ansi(text);
        return;
    }
    else { // Ask Here to save Edited Changes!
        _lang.lang_get(text,33);
        int len = 3;
        inputfield(text,len);
        pipe2ansi(text);
        ch = getkey(true);
        putkey(ch);

        if (toupper(ch) != 'Y') {
            return;
        }
    }

    // Save New Message, then Kill Original, Overwrite Doesn't Work!
    buff = _msge.buffer;
    buff += "\r"; buff += tag;
    buff += "\r"; buff += origin;
    SaveMsg(mbnum,thisuser->lastmsg,TRUE);

    //OpenMsgArea(mbnum);
    if(!OpenMsgArea(mbnum)){
        return;
    }
    MsgKillMsg(AHandle,thisuser->lastmsg);
    CloseMsgArea();

    _lang.lang_get(text,34);
    pipe2ansi(text);

    // Setup loging defaults, set users loging date time etc..
    hist_update(HIST_EDITS,thisuser);
}

void msg_read::EditMessage() {

    char text[100]={0};
    unsigned char ch;

    _lang.lang_get(text,31);
    int len = 3;
    inputfield(text,len);
    pipe2ansi(text);
    ch = getkey(true);
    putkey(ch);

    if (toupper(ch) == 'Y') {
        if (strcmp(thisuser->handle,mHead.from) != 0) {
            // User Didn't Write Original Message...
            // Then user can't edit this message, add Security check
            // later on for sysop / cosysop Access to users messages.
            memset(&text,0,sizeof(text));
            _lang.lang_get(text,32);
            pipe2ansi(text);
            return;
        }
    }
    else return;
    DoEdit(thisuser->lastmbarea);
}

// Title Scan Ansi Parsing
char *msg_read::ParseTitleScan(int boxsize) {

    static char   result[2000];
    int            c = 0;
    std::string    temp = "";
    std::string    path = "";

    FILE           *inStream;
    int            i   = 0;

    char           MCI[3]={0};
    char           temp2[100]={0};
    int            space  = 0;
    int            foundr = FALSE;
    int            foundl = FALSE;

    std::string    ans  = "";
    std::string    ans1 = "";
    std::string    ans2 = "";

    memset(&result,0,sizeof(result));

    // Prefetch ansi's
    path = ANSIPATH;
    path += "mtitlemid1.ans";
    if ((inStream = fopen(path.c_str(), "r+")) ==  NULL) {
        pipe2ansi((char *)"|CRMissing Ansi Template mtitlemid1 |15.|DE.|DE.|DE");
        return result;
    }
    while (c != EOF) {
        c = getc(inStream);
        if (c != EOF) ans1 += c;
    }
    fclose(inStream);
    c = '\0';
    path = ANSIPATH;
    path += "mtitlemid2.ans";
    if ((inStream = fopen(path.c_str(), "r+")) ==  NULL) {
        pipe2ansi((char *)"|CRMissing Ansi Template mtitlemid2 |15.|DE.|DE.|DE");
        return result;
    }
    while (c != EOF) {
        c = getc(inStream);
        if (c != EOF) ans2 += c;
    }
    fclose(inStream);

    //if (boxsize == idx-1)
        ans = ans2;
    //else
        //ans = ans1;

        i = 0;
        c = 0;
        do {
            memset(&MCI,0,sizeof(MCI));
            c = ans[i];
            if (c == '\0') break;

            // Check for Spacing MCI Code
            switch (c) {
              case '{' : // Left Justify
                MCI[0] = ans[++i];
                MCI[1] = ans[++i];
                space = atoi(MCI);

                if (space != 0) {
                    foundl = TRUE;
                }
                else {
                    temp += c;
                    temp += MCI;
                }
                break;

              case '}' : // Right Justify
                MCI[0] = ans[++i];
                MCI[1] = ans[++i];
                space = atoi(MCI);

                if (space != 0) {
                    foundr = TRUE;
                }
                else {
                    temp += c;
                    temp += MCI;
                }
                break;

              case '|' : // Pipe Codes
                MCI[0] = ans[++i];
                MCI[1] = ans[++i];
                if (strcmp(MCI,"M#") == 0) {
                    sprintf(temp2,"%s",mHead.curmsg);
                    if (foundl) {
                        lspacing(temp2,space);
                        foundl = FALSE;
                    }
                    else if (foundr) {
                        rspacing(temp2,space);
                        foundr = FALSE;
                    }
                    temp += temp2;
                }
                else if (strcmp(MCI,"MS") == 0) {
                    sprintf(temp2,"%s",mHead.subj);
                    if (foundl) {
                        lspacing(temp2,space);
                        foundl = FALSE;
                    }
                    else if (foundr) {
                        rspacing(temp2,space);
                        foundr = FALSE;
                    }
                    temp += temp2;
                }
                else if (strcmp(MCI,"MF") == 0) {
                    sprintf(temp2,"%s",mHead.from);
                    if (foundl) {
                        lspacing(temp2,space);
                        foundl = FALSE;
                    }
                    else if (foundr) {
                        rspacing(temp2,space);
                        foundr = FALSE;
                    }
                    temp += temp2;
                }
                else if (strcmp(MCI,"MT") == 0) {
                    sprintf(temp2,"%s",mHead.to);
                    if (foundl) {
                        lspacing(temp2,space);
                        foundl = FALSE;
                    }
                    else if (foundr) {
                        rspacing(temp2,space);
                        foundr = FALSE;
                    }
                    temp += temp2;
                }
                else {
                    temp += c;
                    temp += MCI;
                }
                break;

              case '\n' :
                temp += '\r';
                break;

              default :
                temp += c;
                break;
            }
            ++i;
        }
        while (c != '\0');

        temp += '\r';
        strcpy(result,temp.c_str());
        return result;
}

// Main Message Reader Title Scan
void msg_read::TitleScan(int newscan) {

    msg_title      _msgt;
    int            boxsize;
    int            Page = 1;
    int            TotPages;
    int            iNum;
    int            cnt;
    char           Line[2000]={0};
    int            ret = TRUE;
    std::string    sLine = "";

    //if (newscan) firstscan = TRUE;
    _msgt.SetupTitleScan();
    boxsize = _msgt.tBot - _msgt.tTop;

    ansiPrintf((char *)"mtitle");

    // Get a count of Total Messages
    //OpenMsgArea(thisuser->lastmbarea);
    if(!OpenMsgArea(thisuser->lastmbarea)){
        return;
    }
    CloseMsgArea();
    iNum = atoi(mHead.totmsg);

    TotPages = iNum / boxsize;

    if (iNum % boxsize)
        ++TotPages;

RE_FRESH:
    // Loop through and get all messages that will fit in Message Box.
    for (cnt = 0; boxsize != cnt; cnt++) {
        // Read first Message Depending on NewScan or Not.
        memset(&mHead,0,sizeof(mHead));
        if (!ReadMsg(thisuser->lastmbarea, FALSE, newscan)) break;
        strcpy(Line,ParseTitleScan(boxsize));
        sLine += Line;
        //mLink.Lines = 0;
        //mLink.dispose();
        thisuser->lastmsg += 1;
    }

RE_DISPLAY:

    ret = _msgt.StartTitleScan((char *)sLine.c_str(), Page, TotPages, iNum);

    switch (ret) {
        case 1: // Next Page
            // If not on last Page, goto next Page!
            if (Page != TotPages) ++Page;
            else {
                goto RE_DISPLAY;
            }
            sLine = "";
            break;
        case 2: // Prev Page
            // Were at 1st Page and can't go lower.
            if (Page == 1) goto RE_DISPLAY;
            else {
                thisuser->lastmsg -= boxsize*2;
                if (thisuser->lastmsg <= 1) {
                    thisuser->lastmsg = 1;
                }
                // Fix for Last Entry Listing where box isn't full!
                if (boxsize != cnt)
                    thisuser->lastmsg += cnt;
                --Page;
            }
            sLine = "";
            break;
        case 3: // Start Reading
            break;
        case 4: // Done
            thisuser->lastmsg = 1;
            //putline((char *)"\ndone!");
            return;
    }
    goto RE_FRESH;
}




int msg_read::StartEmailReader(int newmsg, int sysopscan) {


    std::string AnsiString;
    char        mString[1024]   ={0};
    char        szReplace[100]  ={0};
    char        text[1024]      ={0};

    //int         firstscan       = TRUE;
    int         rtnval          = TRUE;
    int         done            = FALSE;
    int         getdone         = FALSE;
    int         same            = FALSE;
    int         firstread       = TRUE;
    int         more            = FALSE;
    int         showmore        = FALSE;
    int         fbthreading     = TRUE;  // Froward or Backward Message Reading.

    int             id1;
    int             cont;
    unsigned char   ch;
    unsigned int    count;
    std::string     _output;
    char            outBuffer[1024]={0};
    menu_func       _mnuf;
    msgs            _msgf;

    int             idx;
    int             aCoordX;
    int             bCoordX;

    if (sysopscan) opscan = TRUE;
    else opscan = FALSE;


    /* WIP Email title Scan!
    thisuser->lastmsg = 1;
    NextTenMsgs(TRUE);
    return FALSE;
    */

    // Startup Message Reader Link List for Holding Message Lines
    mLink.initReader(sTEXT_COLOR, sQUOTE_COLOR, sSYS_COLOR, sORIGIN_COLOR);
    mLink.Top = tTop;
    mLink.Bot = tBot;
    mLink.add_to_list("");
    mLink.move_up();

    _mnuf.menu_setuser(thisuser);

    // History Stats.
    Views = 0;
    thisuser->lastmsg = 0; // Always reset Lastmsg to 0!

    if(!OpenMsgArea(thisuser->lastmbarea)){
        return FALSE;
    }

    GetMsgInfo();
    CloseMsgArea();
    sprintf(szReplace,"%i",MI.high_msg);

    // Check if were doing a New Scan, or user is selecting starting #
    if (newmsg == TRUE) {  // Starting Current or Multi NewScan
        //pipe2ansi("NewMsg");
        firstscan = TRUE;

        // Scanning Mesasge Base. ...
        _lang.lang_get(text,49);
        AnsiString = text;
        pipe2ansi((char*)AnsiString.c_str());

        // No Messages Found in this Area.
        if (MI.high_msg < 1) {
            memset(&text,0,sizeof(text));
            _lang.lang_get(text,50);
            AnsiString = text;
            pipe2ansi((char*)AnsiString.c_str());
            return FALSE;
        }
    }
    else { // Start scanning from message # user selects

        firstscan = FALSE;

        _lang.lang_get(text,49);
        AnsiString = text;

        // No Messages Found in this Area.
        if (MI.high_msg < 1) {
            _lang.lang_get(text,44);
            AnsiString = text;
            pipe2ansi((char*)AnsiString.c_str());
            return FALSE;
        }


        /// Will add a Email Title Scan here!!
        /*
        id1 = AnsiString.find("|HM",0);
        if (id1 != -1) {
            szTmp[0] = AnsiString[id1+1];
            szTmp[1] = AnsiString[id1+2];
            //OpenMsgArea(thisuser->lastmbarea);
            //sprintf(szReplace,"%i",MI.high_msg);
            AnsiString.replace(id1,3,szReplace);
            //if (AHandle != NULL) CloseMsgArea();
        } */

        thisuser->lastmsg = 1;

    }

    // Run through Main Reader Loop until exit from user
    while (done == FALSE) {

        memset(&mHead,0, sizeof(MsgHead));
        same = TRUE;

        memset(&szReplace,0,sizeof(szReplace));
        memset(&text,0,sizeof(text));
        AnsiString.erase();

        if (newmsg == TRUE) {
            cont = ScanEmailMessages(thisuser->lastmbarea);
        }
        else {
            cont = ReadEmailMessages(thisuser->lastmbarea);
        }

        //
        // Done
        //
        if (cont == FALSE) {

            // Display End of NewScan.
            _msgf.read_mbaselist(&mr, thisuser->lastmbarea);

            if (newmsg == TRUE) {
                _lang.lang_get(text,50);
            }
            else {
                _lang.lang_get(text,36);
            }

            AnsiString = text;
            pipe2ansi((char*)AnsiString.c_str());

            //thisuser->lastmbarea = CURRENT_MAREA;

            mLink.Lines = 0;
            mLink.dispose_list();

            same = FALSE;
            done = TRUE;
            break;
        }

        /// Start Message Reader Loop -------------------------------------- >>>>>>>


        // Make sure Screen is Cleared before starting to read
        // Helps with Homecursor optimizations.

        if (firstread == TRUE) {
            firstread = FALSE;
            pipe2ansi((char *)"|CS");
        }

        // If not correct user, skip msg init, and passthrough to next message!
        if (strcmp(thisuser->handle,MI.To) != 0 && sysopscan == FALSE) {
            goto skipproc1;
        }

        /// Here is the Full Screen Reader
        if (sVIEW[0] != 'S') {
            // Draw Message Inside of Box
            ansi_file(sANSI_FILE);  // Display Reader Ansi
            mLink.box_start(thisuser->lastmbarea);
        }
        else {
            /// Here is the Old School Scrolling Reader.
            // figure out text range by subtracting size of message header.
            getxy();
            bCoordX = ansi_getx();
            ansi_file(sANSI_FILE);
            getxy();
            aCoordX = ansi_getx();
            pipe2ansi((char *)"|CR");

            // Get the size of the Mesage Header
            mLink.headerrows = aCoordX - bCoordX;
            ++mLink.headerrows;

            //pipe2ansi(" mLink.box_scroll_reader(); ");
            mLink.box_scroll_reader(); /// locking up in here..  mlink
        }

/// ///////////////////////////////////////////////////////////////////////////////////////////////////////////
/// It's ok if we exit here!!

        // Now loop Though and Parse Extras then Start Menu Input System.
        while(done == FALSE && same == TRUE) {

            _output.erase();
            more = FALSE;
            showmore = FALSE;

            // If theme changes, reset the top and bottom
            mLink.Top = tTop;
            mLink.Bot = tBot;

            /// full screen message reader
            if (sVIEW[0] != 'S') {
                // Pre-Clear to leave no shadow effect.
                more = FALSE;
                showmore = FALSE;

                sprintf(outBuffer,"%s%s",sMOREMSG_OFF,sMOREMSG_WORD_OFF);
                pipe2ansi(outBuffer);

                //if (mLink.line_count() > 0) more = true;
                if (mLink.Page < mLink.TotPages) more = TRUE;

                // If There is only one page, we don't need to dispaly the More...
                if (mLink.Page == mLink.TotPages && mLink.Page != 1) {

                    // Were on the Very Last Page of the Message
                    sprintf(outBuffer,"%s%s",sMOREMSG_OFF,sMOREMSG_WORD_OFF);
                    _output += outBuffer;

                    // Disaply End of Message Instead of Showing Up Arrow!
                    sprintf(outBuffer,"%s%s",sEOM_ON,sEOM_WORD_ON);
                    _output += outBuffer;
                }
                // Normal Process Checking  if there is a page above or below for MORE!
                else {

                    // Show Down Arrow More!
                    if (more) {
                        sprintf(outBuffer,"%s\x19",sMOREDOWN);
                        showmore = TRUE;
                    }
                    else {
                        sprintf(outBuffer,"%s ",sMOREDOWN);
                    }
                    _output += outBuffer;

                    // Show up Arrow More
                    if (mLink.Page > 1) {
                        sprintf(outBuffer,"%s\x18",sMOREUP);
                        showmore = TRUE;
                    }
                    else {
                        sprintf(outBuffer,"%s ",sMOREUP);
                    }
                    _output += outBuffer;

                    if (showmore)
                        sprintf(outBuffer,"%s%s",sMOREMSG_ON,sMOREMSG_WORD_ON);
                    else {
                        // Next Message
                        // Were on the Only Page
                        sprintf(outBuffer,"%s%s",sMOREMSG_OFF,sMOREMSG_WORD_OFF);
                        _output += outBuffer;

                        // Disaply Next / End of Message
                        sprintf(outBuffer,"%s%s",sNXT_ON,sNXT_WORD_ON);
                        _output += outBuffer;
                    }
                    _output += outBuffer;
                }


                // Show Current/Total Pages
                sprintf(outBuffer,"%s%.2d",sPAGENUM,mLink.Page);
                _output += outBuffer;
                sprintf(outBuffer,"%s%.2d",sPAGETOTAL,mLink.TotPages);
                _output += outBuffer;
            //-------------------------------------------------------
                pipe2ansi((char *)_output.c_str());

                // If more, Select Menu Prompt with PGDN as Default
                // Otherwise Select Prompt with Next as Default!


                // Make Msgp2 Prompt Optional, Use if exists!
                // Also Let user Toggle on / off
                if (_mnuf.cmdexist(sMENU_PROMPT2,0)) {
                    if (more) {
                        _mnuf._curmenu.clear();
                        _mnuf._curmenu = sMENU_PROMPT2;
                    }
                    else {
                        _mnuf._curmenu.clear();
                        _mnuf._curmenu = sMENU_PROMPT;
                    }
                }
                else {
                    _mnuf._curmenu.clear();
                    _mnuf._curmenu = sMENU_PROMPT;
                }

            }
            else {
            /// scrolling message menu system
            //if (sVIEW[0] == 'S') {
                _mnuf._premenu.clear();
                _mnuf._premenu = _mnuf._curmenu;
                _mnuf._curmenu.clear();
                _mnuf._curmenu = sMENU_PROMPT;

                _mnuf.MsgsLeft = MsgsLeft;
                _mnuf.CurMsgs = CurMsgs;
                _mnuf.TotMsgs = TotMsgs;

            /// End of.
            }

            /// Parse MEssage Reader Prompt, then get Input for Commands ----------->>>>
            //errlog2("EmailReader 1 - Readin()");

            ///
            /// Fix this lateron! We shouldn't re-read the menu file each time
            /// We can set a special flag to re-read the x/y Cords but not reload the menu!!
            /// (Maybe Here or in Menu_Proc where Bars is called.
            ///
            _mnuf._premenu.clear();
            _mnuf.menu_readin();

skipproc1:  // this is fro jumping past Message INIT Code, and skipping to next message.

            //_mnuf.menu_proc(mString);

            // If skipproc is first we will need to load a fresh menu.

            //errlog2("EmailReader 2 - B4 Skipproc1");

            // if Email Skip Prompt if not current user
            if ((strcmp(thisuser->handle,MI.To) != 0) && (sysopscan == FALSE)) {
                if (fbthreading == TRUE)
                    sprintf(mString,"!+");
                else
                    sprintf(mString,"!-");
            }
            else {
                _mnuf.menu_proc(mString);
            }

            ch = mString[1];    //mString[0] should = !
            // For Menu CmdKey Input
            if (mString[0] == '!')    {
                    switch (toupper(ch)) {

                        case '+': // Next Message

                            /// Only Gets here when Message Poster is already not the Current User!
                            //firstscan = FALSE;
                            fbthreading = TRUE;
                            count = MI.high_msg;

                            if (thisuser->lastmsg <= count) {
                                ++thisuser->lastmsg;
                            }

                            count = MI.high_msg;

                            if (thisuser->lastmsg > MI.high_msg) {
                                // No More Messages
                                _msgf.read_mbaselist(&mr, 0);
                                memset(&text,0,sizeof(text));
                                _lang.lang_get(text,50);
                                AnsiString = text;
                                id1 = AnsiString.find("|MA",0);
                                if (id1 != -1) {
                                    if(!OpenMsgArea(0)){

                                        mLink.Lines = 0;
                                        mLink.dispose();
                                        same = FALSE;
                                        done = FALSE;
                                        return FALSE;
                                    }
                                    GetMsgInfo();
                                    CloseMsgArea();
                                    sprintf(szReplace,"%s",mr.mbdisplay);
                                    AnsiString.replace(id1,3,szReplace);

                                }
                                pipe2ansi((char*)AnsiString.c_str());
                                //thisuser->lastmbarea = CURRENT_MAREA;
                                done = TRUE;
                            }

                            mLink.Lines = 0;
                            mLink.dispose();
                            same = FALSE;

                            break;

                        case 'U': // Page UP
                            mLink.box_pgup();
                            break;

                        case 'D': // Page Down
                            mLink.box_pgdn();
                            break;

                        case '-': // Previous Message
                            fbthreading = FALSE;
                            mLink.Lines = 0;
                            if (thisuser->lastmsg > 1) {
                               --thisuser->lastmsg;
                            }
                            else {
                                fbthreading = TRUE;
                                break;
                            }

                            mLink.dispose();
                            same = FALSE;
                            break;

                        case 'P': // Post a New Message
                            DoPostEmail(FALSE);
                            mLink.Lines = 0;
                            mLink.dispose();
                            same = FALSE; // Refresh Message
                            pipe2ansi((char *)"|CS");
                            break;

                        case 'R': // Reply to a Message
                            DoPostEmail(TRUE);
                            mLink.Lines = 0;
                            mLink.dispose();
                            same = FALSE; // Refresh Message
                            pipe2ansi((char *)"|CS");
                            break;

                        case 'A': // Show Message Again
                            mLink.Lines = 0;
                            mLink.dispose();
                            same = FALSE;
                            break;

                        case 'Q': // Quit Message Reading
                            rtnval = FALSE;
                            done = TRUE;
                            mLink.Lines = 0;
                            mLink.dispose_list();
                            same = FALSE;

                            if (newmsg) { // Scan Completed
                                //_msgf.read_mbaselist(&mr, thisuser->lastmbarea);
                                _lang.lang_get(text,50);
                                AnsiString = text;
                                pipe2ansi((char*)AnsiString.c_str());
                            }
                            break;

                        case 'K': // Kill Current Message
                            DelCurMsg(thisuser->lastmbarea, thisuser->lastmsg);
                            mLink.Lines = 0;
                            mLink.dispose();
                            same = FALSE;
                            pipe2ansi((char *)"|CS");
                            break;

                        case '?': // Help Screen with Commands
                            mLink.clearBox();
                            ansiPrintf(sANSI_HELP);
                            getkey(TRUE);
                            mLink.Lines = 0;
                            mLink.dispose();
                            same = FALSE;
                            pipe2ansi((char *)"|CS");
                            break;


                        case ']': // Next Theme
                            mLink.Lines = 0;
                            mLink.dispose();
                            same = FALSE;
                            idx = thisuser->readertheme;
                            ++idx;
                            id1 = change_theme(idx);
                            // Reset Colors and Ansi to new Theme
                            if (id1 == TRUE) {
                                mLink.initReader(sTEXT_COLOR, sQUOTE_COLOR, sSYS_COLOR, sORIGIN_COLOR);
                                mLink.Top = tTop;
                                mLink.Bot = tBot;
                                pipe2ansi((char *)"|CS|CR|07FYI: |15You've switched Message Reader Themes.|CR|CR|PA");
                                _mnuf._premenu.clear();
                                _mnuf.menu_readin();       // Load up new prompts for new theme.

                            }
                            else {
                                // Reset Theme Back
                                change_theme(thisuser->readertheme);
                                pipe2ansi((char *)"|CS|CR|07FYI: |15You've hit the highest theme available. |CR|CR|PA");
                                _mnuf._premenu.clear();
                            }
                            pipe2ansi((char *)"|CS");
                            same = FALSE;
                            break;

                        case '[': // Previous Theme
                            mLink.Lines = 0;
                            mLink.dispose();
                            same = FALSE;
                            idx = thisuser->readertheme;
                            if (idx != 0) {
                                --idx;
                            }
                            else {
                                pipe2ansi((char *)"|CS|CR|07FYI: |15You've hit the lowest theme available. |CR|CR|PA");
                                pipe2ansi((char *)"|CS");
                                _mnuf._premenu.clear();
                                same = FALSE;
                                break;
                            }

                            id1 = change_theme(idx);
                            change_theme(thisuser->readertheme);

                            // Reset Colors and Ansi to new Theme
                            if (id1 == TRUE) {
                                mLink.initReader(sTEXT_COLOR, sQUOTE_COLOR, sSYS_COLOR, sORIGIN_COLOR);
                                mLink.Top = tTop;
                                mLink.Bot = tBot;
                                pipe2ansi((char *)"|CS|CR|07FYI: |15You've switched Message Reader Themes.|CR|CR|PA");
                                _mnuf._premenu.clear();
                                _mnuf.menu_readin();       // Load up new prompts for new theme.
                            }
                            else {
                                change_theme(thisuser->readertheme);
                                pipe2ansi((char *)"|CS|CR|07FYI: |15You've hit the lowest theme available. |CR|CR|PA");
                                _mnuf._premenu.clear();
                            }
                            pipe2ansi((char *)"|CS");
                            same = FALSE;
                            break;

                        case 'S' : // Setup User Sig
                            SetupUserSig();
                            same = FALSE;
                            mLink.Lines = 0;
                            mLink.dispose();
                            pipe2ansi((char *)"|CS");
                            break;

                        default :
                            break;

                    } // end of case

                }

                else {  // For Escaped Key Input is passed as Escped Key From Menu System
                    // If EscPassing is Turned on in the Menu.
                    ch = mString[0];
                    switch (toupper(ch)) {
                        case 'A':
                            // Scroll Up 1 Line ( forced to paeg up / down for now)
                            // Don't care much for single scrolling, anoying online!
                            // Page is much nicer and faster ;)
                            mLink.box_pgup();
                            break;

                        case 'B': // Scroll down 1 Line ( forced to paeg up / down for now)
                            mLink.box_pgdn();
                            break;

                        default :
                            break;
                    }
                }
        }
    }
    // Update History.
    hist_update(HIST_VIEWS,thisuser,Views);
    return rtnval;
}

// Main Message System Reader
// This Handles FullSCreen and Scrolling, Normal, Echo, and Email Reading.
int msg_read::StartReader(int newmsg, int allareas) {

    std::string AnsiString;
    char        mString[1024]   ={0};
    char        choice[1024]    ={0};
    char        szReplace[100]  ={0};
    char        szTmp[100]      ={0};
    char        text[1024]      ={0};

    int         rtnval          = TRUE;
    int         done            = FALSE;
    int         getdone         = FALSE;
    int         same            = FALSE;
    int         firstread       = TRUE;
    int         more            = FALSE;
    int         showmore        = FALSE;
    int         origarea        = 0;

    int             id1;
    int             len;
    int             cont;
    unsigned char   ch;
    unsigned int    count;
    std::string     _output;
    char            outBuffer[1024]={0};

    //errlog2((char *)" *** Start READER! 1");

    menu_func       _mnuf;
    msgs            _msgf;

    int             idx;
    int             aCoordX;
    int             bCoordX;


    // Startup Message Reader Link List for Holding Message Lines
    mLink.initReader(sTEXT_COLOR, sQUOTE_COLOR, sSYS_COLOR, sORIGIN_COLOR);
    mLink.Top = tTop;
    mLink.Bot = tBot;


    //errlog2((char *)" *** Start READER! 2");

    // Prep Not needed anymore.
    //mLink.add_to_list("");
    //mLink.move_up();

    opscan = FALSE;
    // History Stats.
    Views = 0;
    thisuser->lastmsg = 0; // Always reset Lastmsg to 0!


    //if End of area Scan, check for next area!
    //We need to start the multi-scan on the first message area!
    if (allareas == TRUE) {
        origarea = thisuser->lastmbarea;
        thisuser->lastmbarea = 1;
        CURRENT_MAREA = 1;
    }

    if(!OpenMsgArea(thisuser->lastmbarea)){
        return FALSE;
    }
    GetMsgInfo(); // Newly Testing for populating MI.high_msg properly.
    CloseMsgArea();
    sprintf(szReplace,"%i",MI.high_msg);


    // Check if were doing a New Scan, or user is selecting starting #
    if (newmsg == TRUE) {  // Starting Current or Multi NewScan
        firstscan = TRUE;
        _lang.lang_get(text,23);
        AnsiString = text;
        pipe2ansi((char*)AnsiString.c_str());

        // No Messages Found in this Area.
        /*
        if (MI.high_msg < 1) {
            memset(&text,0,sizeof(text));
            _lang.lang_get(text,36);
            AnsiString = text;
            pipe2ansi((char*)AnsiString.c_str());
            return FALSE;
        }*/

    }
    else { // Start scanning from message # user selects
        firstscan = FALSE;
        _lang.lang_get(text,24);
        AnsiString = text;

        // No Messages Found in this Area.
        if (MI.high_msg < 1) {
            _lang.lang_get(text,44);
            AnsiString = text;
            pipe2ansi((char*)AnsiString.c_str());
            return FALSE;
        }

        id1 = AnsiString.find("|HM",0);
        if (id1 != -1) {
            szTmp[0] = AnsiString[id1+1];
            szTmp[1] = AnsiString[id1+2];
            AnsiString.replace(id1,3,szReplace);
        }

        len = strlen(szReplace)+1; // len = 3;
        sprintf(choice,"%s",(char *)AnsiString.c_str());
        inputfield(choice,len);
        pipe2ansi(choice);

        getline(choice,len);
        thisuser->lastmsg = atoi(choice);
        if (thisuser->lastmsg == 0) thisuser->lastmsg = 1;
    }

    // Run through Main Reader Loop until exit from user
    while (done == FALSE) {

RESET:

        memset(&mHead,0, sizeof(MsgHead));
        same = TRUE;

        memset(&szReplace,0,sizeof(szReplace));
        memset(&text,0,sizeof(text));
        AnsiString.erase();

        //errlog2((char *)"SCAN/READ  Mesasge 1! Area# %i",thisuser->lastmbarea);

        if (newmsg == TRUE) {
            cont = ScanMessages(thisuser->lastmbarea);
        }
        else {
            cont = ReadMessages(thisuser->lastmbarea);
        }

        //errlog2((char *)"SCAN/READ  Mesasge 2! Area# %i",thisuser->lastmbarea);

        //
        // Done in Current Aarea, Flip to Next Area in Scan or Exit.
        //
        if (cont == FALSE || thisuser->lastmsg > MI.high_msg) {

            //errlog2((char *)"SCAN/READ  Mesasge 3.1! Area# %i - Cont FALSE!",thisuser->lastmbarea);


            // Display End of NewScan.
            _msgf.read_mbaselist(&mr, thisuser->lastmbarea);
            _lang.lang_get(text,36);
            AnsiString = text;
            pipe2ansi((char*)AnsiString.c_str());


            //if End of area Scan, check for next area! in all area scan
            if (allareas == TRUE) {
                //  printf("\n0 . CURRENT_MAREA %i, thisuser->lastmbarea %i",CURRENT_MAREA,thisuser->lastmbarea);
                if (NextAreaScan() == FALSE) {
                    //CURRENT_MAREA = origarea;
                    //thisuser->lastmbarea = origarea;
                    mLink.Lines = 0;
                    mLink.dispose_list();
                    same = FALSE;
                    done = TRUE;

                    // Before exiting system, go back to original area!
                    thisuser->lastmbarea = origarea;
                    CURRENT_MAREA = thisuser->lastmbarea;
                   // printf("\n1 . CURRENT_MAREA %i, thisuser->lastmbarea %i",CURRENT_MAREA,thisuser->lastmbarea);
                    break;
                }

                if(!OpenMsgArea(thisuser->lastmbarea)){
                   // printf("\nOpenMarea Failed!");
                    return FALSE;
                }
                GetMsgInfo(); // Newly Testing for populating MI.high_msg properly.
                CloseMsgArea();

                _lang.lang_get(text,23);
                AnsiString = text;
                CURRENT_MAREA = thisuser->lastmbarea;   // Set MCI Code to Correct Area!
                pipe2ansi((char*)AnsiString.c_str());

                thisuser->lastmsg = 1;
                firstscan = TRUE;
                goto RESET;
            }
            // End of Current Area New Scan / Read
            else  {

                mLink.Lines = 0;
                mLink.dispose_list();
                same = FALSE;
                done = TRUE;
                break;
            }
        }

        //errlog2((char *)"SCAN/READ Mesasge 3.2 before init reader.");

        /// Start Message Reader Loop -------------------------------------- >>>>>>>
        // Reset Message Handler if Area was Not Closed.

        // Make sure Screen is Cleared before starting to read
        // Helps with Homecursor optimizations.
        if (firstread == TRUE) {

            // Work In progress, Add 1 to MCI Code, otherwise it's messages Left, not total New!
            // New Messaegs Found, Check if We Want to Read, Bypass, Ignore.
            /*
            if (newmsg == TRUE) {
                //memset(&text,0,sizeof(text));
                //_lang.lang_get(text,60);

                start_session(thisuser);
                //pipe2ansi(text);
                ansiPrintf((char *)"newfound");

                getdone = FALSE;
                do{
                    ch = getkey(true);
                    switch(toupper(ch)) {
                        case 10:
                            putline((char *)"<CR>");
                            getdone = TRUE;
                            break;

                        case 'B':
                            putkey('B');
                            count = MI.high_msg;
                            thisuser->lastmsg = count+1;
                            same = FALSE;
                            _mnuf.choice = 0;
                            getdone = TRUE;
                            break;

                        case 'I':
                            putkey('I');
                            IgnoreTheRest(thisuser->lastmbarea);
                            count = MI.high_msg;
                            thisuser->lastmsg = count+1;
                            _mnuf.choice = 0;
                            same = FALSE;
                            getdone = TRUE;
                            break;

                        case 'Q':
                            putkey('Q');
                            return FALSE;
                            break;

                        default:
                            break;
                    }
                } while (getdone == FALSE);

            } */


            firstread = FALSE;
            pipe2ansi((char *)"|CS");
        }

        //errlog2((char *)"SCAN/READ Mesasge 4 before init reader.");


        /// Here is the Full Screen Reader
        if (sVIEW[0] != 'S') {
            // Start the entry, display of the Message inside the reader.
            ansi_file(sANSI_FILE);  // Display Reader Ansi
            // Draw Message Inside of Box

            //errlog2((char *)"box_start reader!");
            mLink.box_start(thisuser->lastmbarea);
        }
        else {
            /// Here is the Old School Scrolling Reader.
            // figure out text range by subtracting size of message header.
            getxy();
            bCoordX = ansi_getx();
            ansi_file(sANSI_FILE);
            getxy();
            aCoordX = ansi_getx();
            pipe2ansi((char *)"|CR");

            // Get the size of the Mesage Header
            mLink.headerrows = aCoordX - bCoordX;
            ++mLink.headerrows;

            //pipe2ansi(" mLink.box_scroll_reader(); ");
            //errlog2((char *)"box_scroll_reader!");
            mLink.box_scroll_reader(); /// locking up in here..  mlink
        }

        // Now loop Though and Parse Extras then Start Menu Input System.
        while(done == FALSE && same == TRUE) {

            _output.erase();
            more = FALSE;
            showmore = FALSE;

            // If theme changes, reset the top and bottom
            mLink.Top = tTop;
            mLink.Bot = tBot;

            /// full screen message reader
            if (sVIEW[0] != 'S') {
                // Pre-Clear to leave no shadow effect.
                more = FALSE;
                showmore = FALSE;

                sprintf(outBuffer,"%s%s",sMOREMSG_OFF,sMOREMSG_WORD_OFF);
                pipe2ansi(outBuffer);

                //if (mLink.line_count() > 0) more = true;
                if (mLink.Page < mLink.TotPages) more = TRUE;

                // If There is only one page, we don't need to dispaly the More...
                if (mLink.Page == mLink.TotPages && mLink.Page != 1) {

                    // Were on the Very Last Page of the Message
                    sprintf(outBuffer,"%s%s",sMOREMSG_OFF,sMOREMSG_WORD_OFF);
                    _output += outBuffer;

                    // Disaply End of Message Instead of Showing Up Arrow!
                    sprintf(outBuffer,"%s%s",sEOM_ON,sEOM_WORD_ON);
                    _output += outBuffer;
                }
                // Normal Process Checking  if there is a page above or below for MORE!
                else {

                    // Show Down Arrow More!
                    if (more) {
                        sprintf(outBuffer,"%s\x19",sMOREDOWN);
                        showmore = TRUE;
                    }
                    else {
                        sprintf(outBuffer,"%s ",sMOREDOWN);
                    }
                    _output += outBuffer;

                    // Show up Arrow More
                    if (mLink.Page > 1) {
                        sprintf(outBuffer,"%s\x18",sMOREUP);
                        showmore = TRUE;
                    }
                    else {
                        sprintf(outBuffer,"%s ",sMOREUP);
                    }
                    _output += outBuffer;

                    if (showmore)
                        sprintf(outBuffer,"%s%s",sMOREMSG_ON,sMOREMSG_WORD_ON);
                    else {
                        // Next Message
                        // Were on the Only Page
                        sprintf(outBuffer,"%s%s",sMOREMSG_OFF,sMOREMSG_WORD_OFF);
                        _output += outBuffer;

                        // Disaply Next / End of Message
                        sprintf(outBuffer,"%s%s",sNXT_ON,sNXT_WORD_ON);
                        _output += outBuffer;
                    }
                    _output += outBuffer;
                }


                // Show Current/Total Pages
                sprintf(outBuffer,"%s%.2d",sPAGENUM,mLink.Page);
                _output += outBuffer;
                sprintf(outBuffer,"%s%.2d",sPAGETOTAL,mLink.TotPages);
                _output += outBuffer;
            //-------------------------------------------------------
                pipe2ansi((char *)_output.c_str());

                // If more, Select Menu Prompt with PGDN as Default
                // Otherwise Select Prompt with Next as Default!


                // Make Msgp2 Prompt Optional, Use if exists!
                // Also Let user Toggle on / off
                if (_mnuf.cmdexist(sMENU_PROMPT2,0)) {
                    if (more) {
                        _mnuf._curmenu.clear();
                        _mnuf._curmenu = sMENU_PROMPT2;
                    }
                    else {
                        _mnuf._curmenu.clear();
                        _mnuf._curmenu = sMENU_PROMPT;
                    }
                }
                else {
                    _mnuf._curmenu.clear();
                    _mnuf._curmenu = sMENU_PROMPT;
                }

            }
            else {
            /// scrolling message menu system
            //if (sVIEW[0] == 'S') {
                _mnuf._premenu.clear(); // Reload Menu for Proper Lightbar PlaceMent!
                //_mnuf._premenu = _mnuf._curmenu;
                _mnuf._curmenu.clear();
                _mnuf._curmenu = sMENU_PROMPT;

                _mnuf.MsgsLeft = MsgsLeft;
                _mnuf.CurMsgs = CurMsgs;
                _mnuf.TotMsgs = TotMsgs;

            /// End of.
            }


            /// Parse MEssage Reader Prompt, then get Input for Commands ----------->>>>
            _mnuf.menu_readin();
            _mnuf.menu_proc(mString);

            ch = mString[1];    //mString[0] should = !
            // For Menu CmdKey Input
            if (mString[0] == '!') {

                    switch (toupper(ch)) {

                        case '+': // Next Message

                            count = MI.high_msg;
                            if(thisuser->lastmsg <= count)  {
                                ++thisuser->lastmsg;
                            }

                            mLink.Lines = 0;
                            mLink.dispose();
                            same = FALSE;
                            break;

                        case '-': // Previous Message
                            mLink.Lines = 0;
                            if (thisuser->lastmsg != 1) --thisuser->lastmsg;
                            mLink.dispose();
                            same = FALSE;
                            break;

                        case 'Q': // Quit Message Reading
                            rtnval = FALSE;
                            done = TRUE;
                            mLink.Lines = 0;
                            mLink.dispose_list();
                            same = FALSE;

                            if (newmsg) { // Scan Completed
                                _msgf.read_mbaselist(&mr, thisuser->lastmbarea);
                                _lang.lang_get(text,36);
                                AnsiString = text;
                                pipe2ansi((char*)AnsiString.c_str());
                            }
                            break;

                        case 'U': // Page UP
                            mLink.box_pgup();
                            break;

                        case 'D': // Page Down
                            mLink.box_pgdn();
                            break;

                        case 'P': // Post a New Message
                            DoPost(thisuser->lastmbarea,FALSE);
                            mLink.Lines = 0;
                            mLink.dispose();
                            same = FALSE; // Refresh Message
                            pipe2ansi((char *)"|CS");
                            _mnuf.choice = 0;
                            break;

                        case 'R': // Reply to a Message
                            DoPost(thisuser->lastmbarea,TRUE);
                            mLink.Lines = 0;
                            mLink.dispose();
                            same = FALSE; // Refresh Message
                            pipe2ansi((char *)"|CS");
                            _mnuf.choice = 0;
                            break;

                        case 'H': // Set Last Read Pointer
                            memset(&text,0,sizeof(text));
                            SetLastRead(thisuser->idx, thisuser->lastmsg+1);
                            _lang.lang_get(text,37);
                            AnsiString = text;
                            id1 = AnsiString.find("|M#",0);
                            if (id1 != -1) {
                                sprintf(szReplace,"%ld",thisuser->lastmsg);
                                AnsiString.replace(id1,3,szReplace);
                            }
                            pipe2ansi((char*)AnsiString.c_str());

                            mLink.Lines = 0;
                            mLink.dispose();
                            same = FALSE;
                            pipe2ansi((char *)"|CS");
                            _mnuf.choice = 0;
                            break;

                        case 'J': // Jump to Message #
                            JumpToMessage();
                            mLink.Lines = 0;
                            mLink.dispose();
                            same = FALSE;
                            pipe2ansi((char *)"|CS");
                            _mnuf.choice = 0;
                            break;

                        case 'I': // Ignore
                            IgnoreTheRest(thisuser->lastmbarea);
                            //done = TRUE;
                            //thisuser->lastmbarea = CURRENT_MAREA;
                            mLink.Lines = 0;
                            mLink.dispose();
                            same = FALSE;

                            count = MI.high_msg;
                            thisuser->lastmsg = count+1;

/*
                            if (newmsg) { // Scan Completed
                                _msgf.read_mbaselist(&mr, thisuser->lastmbarea);
                                _lang.lang_get(text,36);
                                AnsiString = text;
                                pipe2ansi((char*)AnsiString.c_str());
                            }
                            pipe2ansi((char *)"|CS");
                            */
                            _mnuf.choice = 0;
                            break;

                        case 'B': // Bypass The Rest

                            count = MI.high_msg;
                            thisuser->lastmsg = count+1;

                        //    done = TRUE;
                            //thisuser->lastmbarea = CURRENT_MAREA;
                            mLink.Lines = 0;
                            mLink.dispose();
                            same = FALSE;
                            _mnuf.choice = 0;
                            break;
                            /*
                            if (newmsg) { // Scan Completed
                                _msgf.read_mbaselist(&mr, thisuser->lastmbarea);
                                _lang.lang_get(text,36);
                                AnsiString = text;
                                pipe2ansi((char*)AnsiString.c_str());
                            }
                            pipe2ansi((char *)"|CS");
                            break;
                            */

                        case 'K': // Kill Current Message
                            DelCurMsg(thisuser->lastmbarea, thisuser->lastmsg);
                            mLink.Lines = 0;
                            mLink.dispose();
                            same = FALSE;
                            pipe2ansi((char *)"|CS");
                            _mnuf.choice = 0;
                            break;

                        case 'E': // Edit Current Message
                            EditMessage();
                            mLink.Lines = 0;
                            mLink.dispose();
                            same = FALSE; // Refresh Message
                            pipe2ansi((char *)"|CS");
                            _mnuf.choice = 0;
                            break;

                        case 'A': // Redisplay message Again.
                            mLink.Lines = 0;
                            mLink.dispose();
                            same = FALSE; // Refresh Message
                            _mnuf.choice = 0;
                            break;

                        case '?': // Help Screen with Commands
                            mLink.clearBox();
                            ansiPrintf(sANSI_HELP);
                            getkey(TRUE);
                            mLink.Lines = 0;
                            mLink.dispose();
                            same = FALSE;
                            pipe2ansi((char *)"|CS");
                            _mnuf.choice = 0;
                            break;


                        case ']': // Next Theme
                            mLink.Lines = 0;
                            mLink.dispose();
                            same = FALSE;
                            idx = thisuser->readertheme;
                            ++idx;
                            id1 = change_theme(idx);
                            // Reset Colors and Ansi to new Theme
                            if (id1 == TRUE) {
                                mLink.initReader(sTEXT_COLOR, sQUOTE_COLOR, sSYS_COLOR, sORIGIN_COLOR);
                                mLink.Top = tTop;
                                mLink.Bot = tBot;
                                pipe2ansi((char *)"|CS|CR|07FYI: |15You've switched Message Reader Themes.|CR|CR|PA");
                                _mnuf._premenu.clear();
                                //_mnuf.menu_reset();
                                //_mnuf.menu_readin();       // Load up new prompts for new theme.
                            }
                            else {
                                // Reset Theme Back
                                change_theme(thisuser->readertheme);
                                pipe2ansi((char *)"|CS|CR|07FYI: |15You've hit the highest theme available. |CR|CR|PA");
                                _mnuf._premenu.clear();
                                //_mnuf.menu_reset();
                                //_mnuf.menu_readin();       // Load up new prompts for new theme.
                            }
                            pipe2ansi((char *)"|CS");
                            same = FALSE;
                            break;

                        case '[': // Previous Theme
                            mLink.Lines = 0;
                            mLink.dispose();
                            same = FALSE;
                            idx = thisuser->readertheme;
                            if (idx != 0) {
                                --idx;
                            }
                            else {
                                pipe2ansi((char *)"|CS|CR|07FYI: |15You've hit the lowest theme available. |CR|CR|PA");
                                pipe2ansi((char *)"|CS");
                                _mnuf._premenu.clear();
                                //_mnuf.menu_reset();
                                //_mnuf.menu_readin();       // Load up new prompts for new theme.
                                same = FALSE;
                                break;
                            }

                            id1 = change_theme(idx);
                            change_theme(thisuser->readertheme);

                            // Reset Colors and Ansi to new Theme
                            if (id1 == TRUE) {
                                mLink.initReader(sTEXT_COLOR, sQUOTE_COLOR, sSYS_COLOR, sORIGIN_COLOR);
                                mLink.Top = tTop;
                                mLink.Bot = tBot;
                                pipe2ansi((char *)"|CS|CR|07FYI: |15You've switched Message Reader Themes.|CR|CR|PA");
                                //_mnuf.menu_reset();
                                _mnuf._premenu.clear();
                                //_mnuf.menu_readin();       // Load up new prompts for new theme.
                            }
                            else {
                                change_theme(thisuser->readertheme);
                                pipe2ansi((char *)"|CS|CR|07FYI: |15You've hit the lowest theme available. |CR|CR|PA");
                                //_mnuf.menu_reset();
                                _mnuf._premenu.clear();
                                //_mnuf.menu_readin();       // Load up new prompts for new theme.
                            }
                            pipe2ansi((char *)"|CS");
                            same = FALSE;
                            break;

                        case 'S' : // Setup User Sig
                            SetupUserSig();
                            pipe2ansi((char *)"|CS");
                            mLink.Lines = 0;
                            mLink.dispose();
                            same = FALSE;
                            _mnuf.choice = 0;
                            break;

                        default :
                            break;

                    } // end of case
                }// end of Email If!
                else {  // For Escaped Key Input is passed as Escped Key From Menu System
                    // If EscPassing is Turned on in the Menu.
                    ch = mString[0];
                    switch (toupper(ch)) {
                        case 'A':
                        // Scroll Up 1 Line ( forced to paeg up / down for now)
                        // Don't care much for single scrolling, anoying online!
                        // Page is much nicer and faster ;)
                            mLink.box_pgup();
                            break;

                        case 'B': // Scroll down 1 Line ( forced to paeg up / down for now)
                            mLink.box_pgdn();
                            break;

                        default :
                            break;
                    }
                }

        }
    }
    // Update History.
    hist_update(HIST_VIEWS,thisuser,Views);
    return rtnval;
}



