/***************************************************************************
 *   Copyright (C) 2004-2009 by Michael Griffin                            *
 *   mrmisticismo@hotmail.com                                              *
 *                                                                         *
 *   Purpose:                                                              *
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

// Enthral SVN: $Id: msg_quote.h 110 2009-06-02 02:41:35Z frank $
// Source: $HeadURL: http://svn.enthralbbs.com/trunk/src/msg_quote.h $
// $LastChangedDate: 2009-06-01 22:41:35 -0400 (Mon, 01 Jun 2009) $
// $LastChangedRevision: 110 $
// $LastChangedBy: frank $

# ifndef MSG_QUOTE_H
# define MSG_QUOTE_H

# include <time.h>

# include "struct.h"
# include "msg_api.h"


// pickup thisuser and session from msg_api


# include <string>

typedef struct msgquote_ini {

    int  iTop;
    int  iBot;
    char sPAGENUM[80];
    char sPAGETOTAL[80];
    char sMOREUP[80];
    char sMOREUP_CHAR[80];
    char sMOREDOWN[80];
    char sMOREDOWN_CHAR[80];
    char sMOREMSG_ON[80];
    char sMOREMSG_WORD_ON[80];
    char sMOREMSG_OFF[80];
    char sMOREMSG_WORD_OFF[80];
    char sINPUT_BOX[20];
    char sTEXT_COLOR[10];
    char sTEXT_HILIGHT[10];
    char sQUOTE_RANGE[20];

    // Message Read .ini File
    bool msg_exists();
    void msg_create();
    void msg_chkpar(std::string &data);
    void msg_check(std::string cfgdata);
    void msg_parse();

}msgquote_ini;


class msg_quote : private msg_api, msgquote_ini {
    private:

    int tTop;
    int tBot;

    public:
	msg_quote();
	void ParseMQuote(char *filename);
    void insert_lines(LineRec *orgLink, msg_readll *mLink);
    void setup_quoter();
    void par_qstring(char * rBuffer, msg_readll *mLink);
    void StartQuoter(LineRec *orgLink, std::string &retbuf);

};


# endif
